use strict;
use warnings;

package App::Embra::Plugin::Sitemap;
$App::Embra::Plugin::Sitemap::VERSION = '0.001'; # TRIAL
# ABSTRACT: adds a file which lists the pages in the site

use Method::Signatures;
use Template;

use App::Embra::File;
use Moo;



has 'filename' => (
    is => 'ro',
    default => 'sitemap.html',
);


has 'sitemap_file' => (
    is => 'lazy',
    default => method { App::Embra::File->new( name => $self->filename ) },
);

# not sure about this, might remove
has 'template' => (
    is => 'lazy',
    default => method { Template->new },
);

# not sure about this, might remove
has 'sitemap_template' => (
    is => 'ro',
    default => '<ul>[% FOREACH page IN pages %]<li><a href="[% page.name %]">[% page.notes.title or page.name %]</a></li>[% END %]</ul>',
);

method gather_files {
    $self->add_file( $self->sitemap_file );
}

method transform_files {
    my @html_files = grep { $_->ext eq 'html' } @{ $self->embra->files };
    my $sm;
    my $vars = { pages => \@html_files };
    $self->template->process( \ $self->sitemap_template, $vars, \$sm );
    $self->sitemap_file->content( $sm );
}

with 'App::Embra::Role::FileGatherer';
with 'App::Embra::Role::FileTransformer';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::Sitemap - adds a file which lists the pages in the site

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will add a F<sitemap.html> file to the site, with a list of links to all the HTML pages in your site.

=head1 ATTRIBUTES

=head2 filename

Name of the name to store the sitemap in. Defaults to F<sitemap.html>.

=head2 sitemap_file

The L<App::Embra::File> for the sitemap. It will be created automatically with the name given in L</filename>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
