=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsPivotTablesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_pivot_tables_delete_pivot_table_field
#
# Delete pivot field into into pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $pivot_field_type The fields area type. (required)
# @param PivotTableFieldRequest $request Dto that conrains field indexes (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => 'The fields area type.',
        required => '1',
    },
    'request' => {
        data_type => 'PivotTableFieldRequest',
        description => 'Dto that conrains field indexes',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_pivot_table_field' } = { 
    	summary => 'Delete pivot field into into pivot table',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_delete_pivot_table_field {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_delete_pivot_table_field");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_table
#
# Delete worksheet pivot table by index
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_table' } = { 
    	summary => 'Delete worksheet pivot table by index',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_table");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_worksheet_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_table_filter
#
# delete  pivot filter for piovt table             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $field_index  (required)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_table_filter' } = { 
    	summary => 'delete  pivot filter for piovt table             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_table_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_pivot_tables_delete_worksheet_pivot_table_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{fieldIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'field_index'}) {
        my $_base_variable = "{" . "fieldIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'field_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_table_filters
#
# delete all pivot filters for piovt table
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_table_filters' } = { 
    	summary => 'delete all pivot filters for piovt table',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_table_filters {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_delete_worksheet_pivot_table_filters");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_delete_worksheet_pivot_tables
#
# Delete worksheet pivot tables
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_delete_worksheet_pivot_tables' } = { 
    	summary => 'Delete worksheet pivot tables',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_delete_worksheet_pivot_tables {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_delete_worksheet_pivot_tables");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_delete_worksheet_pivot_tables");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_pivot_table_field
#
# Get pivot field into into pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param int $pivot_field_index The field index in the base fields. (required)
# @param string $pivot_field_type The fields area type. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'pivot_field_index' => {
        data_type => 'int',
        description => 'The field index in the base fields.',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => 'The fields area type.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_pivot_table_field' } = { 
    	summary => 'Get pivot field into into pivot table',
        params => $params,
        returns => 'PivotFieldResponse',
        };
}
# @return PivotFieldResponse
#
sub cells_pivot_tables_get_pivot_table_field {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_index' is set
    unless (exists $args{'pivot_field_index'}) {
      croak("Missing the required parameter 'pivot_field_index' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_get_pivot_table_field");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_index'}) {
        $query_params->{'pivotFieldIndex'} = $self->{api_client}->to_query_value($args{'pivot_field_index'});
    }

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotFieldResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_table
#
# Get worksheet pivottable info by index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivottable_index  (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivottable_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_table' } = { 
    	summary => 'Get worksheet pivottable info by index.',
        params => $params,
        returns => 'PivotTableResponse',
        };
}
# @return PivotTableResponse
#
sub cells_pivot_tables_get_worksheet_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_table");
    }

    # verify the required parameter 'pivottable_index' is set
    unless (exists $args{'pivottable_index'}) {
      croak("Missing the required parameter 'pivottable_index' when calling cells_pivot_tables_get_worksheet_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivottableIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivottable_index'}) {
        my $_base_variable = "{" . "pivottableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivottable_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotTableResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_table_filter
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $filter_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'filter_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_table_filter' } = { 
    	summary => '',
        params => $params,
        returns => 'PivotFilterResponse',
        };
}
# @return PivotFilterResponse
#
sub cells_pivot_tables_get_worksheet_pivot_table_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'filter_index' is set
    unless (exists $args{'filter_index'}) {
      croak("Missing the required parameter 'filter_index' when calling cells_pivot_tables_get_worksheet_pivot_table_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{filterIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'filter_index'}) {
        my $_base_variable = "{" . "filterIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'filter_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotFilterResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_table_filters
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_table_filters' } = { 
    	summary => '',
        params => $params,
        returns => 'PivotFiltersResponse',
        };
}
# @return PivotFiltersResponse
#
sub cells_pivot_tables_get_worksheet_pivot_table_filters {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_table_filters");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_get_worksheet_pivot_table_filters");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotFiltersResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_get_worksheet_pivot_tables
#
# Get worksheet pivottables info.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_get_worksheet_pivot_tables' } = { 
    	summary => 'Get worksheet pivottables info.',
        params => $params,
        returns => 'PivotTablesResponse',
        };
}
# @return PivotTablesResponse
#
sub cells_pivot_tables_get_worksheet_pivot_tables {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_get_worksheet_pivot_tables");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_get_worksheet_pivot_tables");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotTablesResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_cell_style
#
# Update cell style for pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param int $column  (required)
# @param int $row  (required)
# @param Style $style Style dto in request body. (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto in request body.',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_cell_style' } = { 
    	summary => 'Update cell style for pivot table',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_post_pivot_table_cell_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'column' is set
    unless (exists $args{'column'}) {
      croak("Missing the required parameter 'column' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # verify the required parameter 'row' is set
    unless (exists $args{'row'}) {
      croak("Missing the required parameter 'row' when calling cells_pivot_tables_post_pivot_table_cell_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Format';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_field_hide_item
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param string $pivot_field_type  (required)
# @param int $field_index  (required)
# @param int $item_index  (required)
# @param boolean $is_hide  (required)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'item_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'is_hide' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_field_hide_item' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_post_pivot_table_field_hide_item {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'item_index' is set
    unless (exists $args{'item_index'}) {
      croak("Missing the required parameter 'item_index' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # verify the required parameter 'is_hide' is set
    unless (exists $args{'is_hide'}) {
      croak("Missing the required parameter 'is_hide' when calling cells_pivot_tables_post_pivot_table_field_hide_item");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Hide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'item_index'}) {
        $query_params->{'itemIndex'} = $self->{api_client}->to_query_value($args{'item_index'});
    }

    # query params
    if ( exists $args{'is_hide'}) {
        $query_params->{'isHide'} = $self->{api_client}->to_query_value($args{'is_hide'});
    }

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_field_move_to
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $field_index  (required)
# @param string $from  (required)
# @param string $to  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'from' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'to' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_field_move_to' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_post_pivot_table_field_move_to {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'from' is set
    unless (exists $args{'from'}) {
      croak("Missing the required parameter 'from' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # verify the required parameter 'to' is set
    unless (exists $args{'to'}) {
      croak("Missing the required parameter 'to' when calling cells_pivot_tables_post_pivot_table_field_move_to");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if ( exists $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_pivot_table_style
#
# Update style for pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param Style $style Style dto in request body. (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'style' => {
        data_type => 'Style',
        description => 'Style dto in request body.',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_pivot_table_style' } = { 
    	summary => 'Update style for pivot table',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_post_pivot_table_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_pivot_table_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_pivot_table_style");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_pivot_table_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/FormatAll';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'style'}) {
        $_body_data = $args{'style'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_worksheet_pivot_table_calculate
#
# Calculates pivottable's data to cells.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_worksheet_pivot_table_calculate' } = { 
    	summary => 'Calculates pivottable&#39;s data to cells.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_post_worksheet_pivot_table_calculate {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_worksheet_pivot_table_calculate");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_worksheet_pivot_table_calculate");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_worksheet_pivot_table_calculate");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Calculate';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_post_worksheet_pivot_table_move
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param int $row  (optional)
# @param int $column  (optional)
# @param string $dest_cell_name  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'dest_cell_name' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_post_worksheet_pivot_table_move' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_post_worksheet_pivot_table_move {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_post_worksheet_pivot_table_move");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_post_worksheet_pivot_table_move");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_post_worksheet_pivot_table_move");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'dest_cell_name'}) {
        $query_params->{'destCellName'} = $self->{api_client}->to_query_value($args{'dest_cell_name'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_put_pivot_table_field
#
# Add pivot field into into pivot table
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param int $pivot_table_index Pivot table index (required)
# @param string $pivot_field_type The fields area type. (required)
# @param PivotTableFieldRequest $request Dto that conrains field indexes (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => 'Pivot table index',
        required => '1',
    },
    'pivot_field_type' => {
        data_type => 'string',
        description => 'The fields area type.',
        required => '1',
    },
    'request' => {
        data_type => 'PivotTableFieldRequest',
        description => 'Dto that conrains field indexes',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_put_pivot_table_field' } = { 
    	summary => 'Add pivot field into into pivot table',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_put_pivot_table_field {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # verify the required parameter 'pivot_field_type' is set
    unless (exists $args{'pivot_field_type'}) {
      croak("Missing the required parameter 'pivot_field_type' when calling cells_pivot_tables_put_pivot_table_field");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'pivot_field_type'}) {
        $query_params->{'pivotFieldType'} = $self->{api_client}->to_query_value($args{'pivot_field_type'});
    }

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_put_worksheet_pivot_table
#
# Add a pivot table into worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param CreatePivotTableRequest $request CreatePivotTableRequest dto in request body. (optional)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
# @param string $source_data The data for the new PivotTable cache. (optional)
# @param string $dest_cell_name The cell in the upper-left corner of the PivotTable report&#39;s destination range. (optional)
# @param string $table_name The name of the new PivotTable report. (optional)
# @param boolean $use_same_source Indicates whether using same data source when another existing pivot table has used this data source. If the property is true, it will save memory. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'request' => {
        data_type => 'CreatePivotTableRequest',
        description => 'CreatePivotTableRequest dto in request body.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    'source_data' => {
        data_type => 'string',
        description => 'The data for the new PivotTable cache.',
        required => '0',
    },
    'dest_cell_name' => {
        data_type => 'string',
        description => 'The cell in the upper-left corner of the PivotTable report&#39;s destination range.',
        required => '0',
    },
    'table_name' => {
        data_type => 'string',
        description => 'The name of the new PivotTable report.',
        required => '0',
    },
    'use_same_source' => {
        data_type => 'boolean',
        description => 'Indicates whether using same data source when another existing pivot table has used this data source. If the property is true, it will save memory.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_put_worksheet_pivot_table' } = { 
    	summary => 'Add a pivot table into worksheet.',
        params => $params,
        returns => 'PivotTableResponse',
        };
}
# @return PivotTableResponse
#
sub cells_pivot_tables_put_worksheet_pivot_table {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_put_worksheet_pivot_table");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_put_worksheet_pivot_table");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'source_data'}) {
        $query_params->{'sourceData'} = $self->{api_client}->to_query_value($args{'source_data'});
    }

    # query params
    if ( exists $args{'dest_cell_name'}) {
        $query_params->{'destCellName'} = $self->{api_client}->to_query_value($args{'dest_cell_name'});
    }

    # query params
    if ( exists $args{'table_name'}) {
        $query_params->{'tableName'} = $self->{api_client}->to_query_value($args{'table_name'});
    }

    # query params
    if ( exists $args{'use_same_source'}) {
        $query_params->{'useSameSource'} = $self->{api_client}->to_query_value($args{'use_same_source'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('PivotTableResponse', $response);
    return $_response_object;
}

#
# cells_pivot_tables_put_worksheet_pivot_table_filter
#
# Add pivot filter for piovt table index
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $pivot_table_index  (required)
# @param PivotFilter $filter  (optional)
# @param boolean $need_re_calculate  (optional, default to false)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'pivot_table_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'filter' => {
        data_type => 'PivotFilter',
        description => '',
        required => '0',
    },
    'need_re_calculate' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_pivot_tables_put_worksheet_pivot_table_filter' } = { 
    	summary => 'Add pivot filter for piovt table index',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_pivot_tables_put_worksheet_pivot_table_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_pivot_tables_put_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_pivot_tables_put_worksheet_pivot_table_filter");
    }

    # verify the required parameter 'pivot_table_index' is set
    unless (exists $args{'pivot_table_index'}) {
      croak("Missing the required parameter 'pivot_table_index' when calling cells_pivot_tables_put_worksheet_pivot_table_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'need_re_calculate'}) {
        $query_params->{'needReCalculate'} = $self->{api_client}->to_query_value($args{'need_re_calculate'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'pivot_table_index'}) {
        my $_base_variable = "{" . "pivotTableIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'pivot_table_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'filter'}) {
        $_body_data = $args{'filter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

1;
