=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsChartAreaApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_chart_area_get_chart_area
#
# Get chart area info.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_chart_area_get_chart_area' } = { 
    	summary => 'Get chart area info.',
        params => $params,
        returns => 'ChartAreaResponse',
        };
}
# @return ChartAreaResponse
#
sub cells_chart_area_get_chart_area {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_chart_area_get_chart_area");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_chart_area_get_chart_area");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_chart_area_get_chart_area");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ChartAreaResponse', $response);
    return $_response_object;
}

#
# cells_chart_area_get_chart_area_border
#
# Get chart area border info.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_chart_area_get_chart_area_border' } = { 
    	summary => 'Get chart area border info.',
        params => $params,
        returns => 'LineResponse',
        };
}
# @return LineResponse
#
sub cells_chart_area_get_chart_area_border {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_chart_area_get_chart_area_border");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_chart_area_get_chart_area_border");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_chart_area_get_chart_area_border");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/border';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LineResponse', $response);
    return $_response_object;
}

#
# cells_chart_area_get_chart_area_fill_format
#
# Get chart area fill format info.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $chart_index The chart index. (required)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'chart_index' => {
        data_type => 'int',
        description => 'The chart index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_chart_area_get_chart_area_fill_format' } = { 
    	summary => 'Get chart area fill format info.',
        params => $params,
        returns => 'FillFormatResponse',
        };
}
# @return FillFormatResponse
#
sub cells_chart_area_get_chart_area_fill_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_chart_area_get_chart_area_fill_format");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_chart_area_get_chart_area_fill_format");
    }

    # verify the required parameter 'chart_index' is set
    unless (exists $args{'chart_index'}) {
      croak("Missing the required parameter 'chart_index' when calling cells_chart_area_get_chart_area_fill_format");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/fillFormat';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'chart_index'}) {
        my $_base_variable = "{" . "chartIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'chart_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FillFormatResponse', $response);
    return $_response_object;
}

1;
