/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nis_db.h"
#include "db_private.h"

entry_obj *
__clone_entry (const entry_obj *src)
{
  unsigned char *addr;
  size_t size;
  XDR xdrs;
  entry_obj *res;

  if (src == NULL)
    return NULL;

  size = xdr_sizeof ((xdrproc_t) __nisdb_xdr_entry_obj, (caddr_t) src);
  if ((addr = calloc (1, size)) == NULL)
    return NULL;

  if ((res = calloc (1, sizeof (entry_obj))) == NULL)
    {
      free (addr);
      return NULL;
    }

  xdrmem_create (&xdrs, addr, size, XDR_ENCODE);
  if (!__nisdb_xdr_entry_obj (&xdrs, src))
    {
      xdr_destroy (&xdrs);
      free (addr);
      return NULL;
    }
  xdr_destroy (&xdrs);
  xdrmem_create (&xdrs, addr, size, XDR_DECODE);
  if (!__nisdb_xdr_entry_obj (&xdrs, res))
    {
      xdr_destroy (&xdrs);
      free (addr);
      return NULL;
    }
  xdr_destroy (&xdrs);
  free (addr);

  return res;
}

table_obj *
__clone_table (const table_obj *src)
{
  unsigned char *addr;
  size_t size;
  XDR xdrs;
  table_obj *res;

  if (src == NULL)
    return NULL;

  size = xdr_sizeof ((xdrproc_t) __nisdb_xdr_table_obj, (caddr_t) src);
  if ((addr = calloc (1, size)) == NULL)
    return NULL;

  if ((res = calloc (1, sizeof (table_obj))) == NULL)
    {
      free (addr);
      return NULL;
    }

  xdrmem_create (&xdrs, addr, size, XDR_ENCODE);
  if (!__nisdb_xdr_table_obj (&xdrs, src))
    {
      xdr_destroy (&xdrs);
      free (addr);
      return NULL;
    }
  xdr_destroy (&xdrs);

  xdrmem_create (&xdrs, addr, size, XDR_DECODE);
  if (!__nisdb_xdr_table_obj (&xdrs, res))
    {
      xdr_destroy (&xdrs);
      free (addr);
      return NULL;
    }
  xdr_destroy (&xdrs);

  free (addr);

  return res;
}
