/*
 * Common definitions for depmod
 *
 * Copyright 1994, 1995, 1996, 1997 Jacques Gelinas <jack@solucorp.qc.ca>
 * Additional modifications: Bjrn Ekwall <bj0rn@blox.se> February 1999
 *
 * This file is part of the Linux modutils.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _DEPMOD_H
#define _DEPMOD_H

class MODULE;
struct SYMBOL{
	SYMBOL *next;	/* List connected via hashing */
	MODULE *module;	/* Module declaring this symbol */
	const char *name;
	unsigned short hashval;
	char defined;	/* The definition has been seen */
};

enum SYM_STATUS {
	SYM_DEFINED,	/* We have found a module that knows about it */
	SYM_NEED	/* Required by another module */
};

struct LIST_SYMBOL {
	LIST_SYMBOL *next;
	SYMBOL alloc[1];
	/* Structure will be extended at runtime */
};

class MODULES;

class SYMBOLS {
	SYMBOL *hash[2048];
	struct {
		LIST_SYMBOL *cur;
		int nb;
		SYMBOL *ptacc;
		SYMBOL *lastacc;
	} sym;

public:
	SYMBOLS (void);
	SYMBOL *add (const char *name,
		 MODULE *module,
		 SYM_STATUS status);
	void resolve(SYMBOL *sym);

protected:
	void allocsym (void);

public:
	void dump (FILE *fout);
	int findforce (char **tb, int maxtb);
};

struct MODULE {
	char *name;
	struct {	/* Defined + required symbols for this module */
		SYMBOL **tb;
		int nb;
	} pub, ext;
};

class MODULES {
	MODULE *tbmod;
	int nbmod;
	char *base;
	int base_len;

    public:
	MODULES (void);
	void resolve(SYMBOLS & syms);
	int loadobj (SYMBOLS&syms, const char *objname);
	void prtdepend (FILE *fout,
		 int skipchars,
		 int verbose,
		 int quiet,
		 int showerror);
	MODULE *setdummy (const char *name);

    private:
	void setmod (MODULE *mod,
		 SYMBOL *tbpub[],
		 int nbpub,
		 SYMBOL *tbext[],
		 int nbext);

    public:
	void showall (FILE *fout);
	int showload (FILE *fout);
	void showundef (SYMBOL *undef, FILE *fout);
};

#endif /* _DEPMOD_H */
