/*
 * Common definitions for depmod
 *
 * Copyright 1994, 1995, 1996, 1997 Jacques Gelinas <jack@solucorp.qc.ca>
 * Additional modifications: Bjrn Ekwall <bj0rn@blox.se> February 1999
 *
 * This file is part of the Linux modutils.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _DEPMOD_H
#define _DEPMOD_H

class MODULE;
struct SYMBOL{
	SYMBOL *next;	/* List connected via hashing */
	MODULE *module;	/* Module declaring this symbol */
	char *name;
	char need;	/* Required by another module */
	char defined;	/* The definition has been seen */
	char seen;	/* Defined before being seen */
	char force;	/* Forced definition by multi pass link */
	char is_common;	/* ??? */
	char is_dup;	/* The symbol is already defined by another module */
};

enum SYM_STATUS {
	SYM_NOTUSED,	/* Required by a module that doesn't use it itself */
	SYM_DEFINED,	/* We have found a module that knows about it */
	SYM_NEED	/* Required by another module */
};

struct LIST_SYMBOL {
	LIST_SYMBOL *next;
	SYMBOL alloc[1];
	/* Structure will be extended at runtime */
};

struct LIST_TEXTE {
	LIST_TEXTE *next;
	char alloc[1];
	/* Structure will be extended at runtime */
};
	
class MODULES;

class SYMBOLS {
	SYMBOL *hash[2048];
	struct {
		LIST_SYMBOL *cur;
		int nb;
		SYMBOL *ptacc;
		SYMBOL *lastacc;
	} sym;
	/*~PROTOBEG~ SYMBOLS */
public:
	SYMBOLS (void);
	SYMBOL *add (const char *name,
		 MODULE *module,
		 SYM_STATUS status,
		 int &module_need,
		 int is_common);
protected:
	void allocsym (void);
public:
	void dump (FILE *fout);
	int findforce (char **tb, int maxtb);
	/*~PROTOEND~ SYMBOLS */
};

struct MODULE {
	char *name;
	struct {	/* Symbole publique et externe de ce module */
		SYMBOL **tb;
		int nb;
	} pub,ext;
	char is_load;	/* Ce module doit tre inclus dans le programme */
	short lib;	/* Numro de la librairie de provenance */
};

class MODULES {
	MODULE *tbmod;
	int nbmod;
	char **tblibs;
	int nblib;
	/*~PROTOBEG~ MODULES */
    public:
	MODULES (void);
	int findundef (FILE *fout);
	int loadobj (SYMBOLS&syms, const char *objname);
	void prtdepend (FILE *fout,
		 const char *dontcare,
		 int skipchars,
		 int verbose,
		 int quiet,
		 int showerror);
	MODULE *setdummy (const char *name);
    private:
	void setmod (MODULE *mod,
		 SYMBOL *tbpub[],
		 int nbpub,
		 SYMBOL *tbext[],
		 int nbext,
		 int module_need);
    public:
	void showall (FILE *fout);
	int showload (FILE *fout);
	void showundef (SYMBOL *undef, FILE *fout);
	/*~PROTOEND~ MODULES */
};

#endif /* _DEPMOD_H */
