;; -----------------------------------------------------------------------
;;   
;;   Copyright 1999-2004 H. Peter Anvin - All Rights Reserved
;;
;;   This program is free software; you can redistribute it and/or modify
;;   it under the terms of the GNU General Public License as published by
;;   the Free Software Foundation, Inc., 53 Temple Place Ste 330,
;;   Boston MA 02111-1307, USA; either version 2 of the License, or
;;   (at your option) any later version; incorporated herein by reference.
;;
;; -----------------------------------------------------------------------
;; $Id: pxe.inc,v 1.5 2004/12/14 23:03:28 hpa Exp $

;;
;; pxe.inc
;;
;; PXE opcodes
;;

%ifndef _PXE_INC
%define _PXE_INC 1

%define PXENV_TFTP_OPEN			0020h
%define PXENV_TFTP_CLOSE		0021h
%define PXENV_TFTP_READ			0022h
%define PXENV_TFTP_READ_FILE		0023h
%define PXENV_TFTP_READ_FILE_PMODE	0024h
%define PXENV_TFTP_GET_FSIZE		0025h

%define PXENV_UDP_OPEN			0030h
%define PXENV_UDP_CLOSE			0031h
%define PXENV_UDP_READ			0032h
%define PXENV_UDP_WRITE			0033h

%define PXENV_START_UNDI		0000h
%define PXENV_UNDI_STARTUP		0001h
%define PXENV_UNDI_CLEANUP		0002h
%define PXENV_UNDI_INITIALIZE		0003h
%define PXENV_UNDI_RESET_NIC		0004h
%define PXENV_UNDI_SHUTDOWN		0005h
%define PXENV_UNDI_OPEN			0006h
%define PXENV_UNDI_CLOSE		0007h
%define PXENV_UNDI_TRANSMIT		0008h
%define PXENV_UNDI_SET_MCAST_ADDR	0009h
%define PXENV_UNDI_SET_STATION_ADDR	000Ah
%define PXENV_UNDI_SET_PACKET_FILTER	000Bh
%define PXENV_UNDI_GET_INFORMATION	000Ch
%define PXENV_UNDI_GET_STATISTICS	000Dh
%define PXENV_UNDI_CLEAR_STATISTICS	000Eh
%define PXENV_UNDI_INITIATE_DIAGS	000Fh
%define PXENV_UNDI_FORCE_INTERRUPT	0010h
%define PXENV_UNDI_GET_MCAST_ADDR	0011h
%define PXENV_UNDI_GET_NIC_TYPE		0012h
%define PXENV_UNDI_GET_IFACE_INFO	0013h
%define PXENV_UNDI_ISR			0014h
%define	PXENV_STOP_UNDI			0015h	; Overlap...?
%define PXENV_UNDI_GET_STATE		0015h	; Overlap...?

%define PXENV_UNLOAD_STACK		0070h
%define PXENV_GET_CACHED_INFO		0071h
%define PXENV_RESTART_DHCP		0072h
%define PXENV_RESTART_TFTP		0073h
%define PXENV_MODE_SWITCH		0074h
%define PXENV_START_BASE		0075h
%define PXENV_STOP_BASE			0076h

%define PXENV_EXIT_SUCCESS 0x0000 
%define PXENV_EXIT_FAILURE 0x0001  

%define PXENV_STATUS_SUCCESS 0x00 
%define PXENV_STATUS_FAILURE 0x01  
%define PXENV_STATUS_BAD_FUNC 0x02  
%define PXENV_STATUS_UNSUPPORTED 0x03  
%define PXENV_STATUS_KEEP_UNDI 0x04  
%define PXENV_STATUS_KEEP_ALL 0x05 
%define PXENV_STATUS_OUT_OF_RESOURCES 0x06  
%define PXENV_STATUS_ARP_TIMEOUT 0x11  
%define PXENV_STATUS_UDP_CLOSED 0x18 
%define PXENV_STATUS_UDP_OPEN 0x19 
%define PXENV_STATUS_TFTP_CLOSED 0x1A 
%define PXENV_STATUS_TFTP_OPEN 0x1B  
%define PXENV_STATUS_MCOPY_PROBLEM 0x20 
%define PXENV_STATUS_BIS_INTEGRITY_FAILURE 0x21 
%define PXENV_STATUS_BIS_VALIDATE_FAILURE 0x22 
%define PXENV_STATUS_BIS_INIT_FAILURE 0x23 
%define PXENV_STATUS_BIS_SHUTDOWN_FAILURE 0x24 
%define PXENV_STATUS_BIS_GBOA_FAILURE 0x25 
%define PXENV_STATUS_BIS_FREE_FAILURE 0x26 
%define PXENV_STATUS_BIS_GSI_FAILURE 0x27 
%define PXENV_STATUS_BIS_BAD_CKSUM 0x28  
%define PXENV_STATUS_TFTP_CANNOT_ARP_ADDRESS 0x30 
%define PXENV_STATUS_TFTP_OPEN_TIMEOUT 0x32

%define PXENV_STATUS_TFTP_UNKNOWN_OPCODE 0x33 
%define PXENV_STATUS_TFTP_READ_TIMEOUT 0x35 
%define PXENV_STATUS_TFTP_ERROR_OPCODE 0x36 
%define PXENV_STATUS_TFTP_CANNOT_OPEN_CONNECTION 0x38 
%define PXENV_STATUS_TFTP_CANNOT_READ_FROM_CONNECTION 0x39 
%define PXENV_STATUS_TFTP_TOO_MANY_PACKAGES 0x3A 
%define PXENV_STATUS_TFTP_FILE_NOT_FOUND 0x3B 
%define PXENV_STATUS_TFTP_ACCESS_VIOLATION 0x3C 
%define PXENV_STATUS_TFTP_NO_MCAST_ADDRESS 0x3D 
%define PXENV_STATUS_TFTP_NO_FILESIZE 0x3E 
%define PXENV_STATUS_TFTP_INVALID_PACKET_SIZE 0x3F  
%define PXENV_STATUS_DHCP_TIMEOUT 0x51 
%define PXENV_STATUS_DHCP_NO_IP_ADDRESS 0x52 
%define PXENV_STATUS_DHCP_NO_BOOTFILE_NAME 0x53 
%define PXENV_STATUS_DHCP_BAD_IP_ADDRESS 0x54  
%define PXENV_STATUS_UNDI_INVALID_FUNCTION 0x60 
%define PXENV_STATUS_UNDI_MEDIATEST_FAILED 0x61 
%define PXENV_STATUS_UNDI_CANNOT_INIT_NIC_FOR_MCAST 0x62 
%define PXENV_STATUS_UNDI_CANNOT_INITIALIZE_NIC 0x63 
%define PXENV_STATUS_UNDI_CANNOT_INITIALIZE_PHY 0x64 
%define PXENV_STATUS_UNDI_CANNOT_READ_CONFIG_DATA 0x65 
%define PXENV_STATUS_UNDI_CANNOT_READ_INIT_DATA 0x66 
%define PXENV_STATUS_UNDI_BAD_MAC_ADDRESS 0x67 
%define PXENV_STATUS_UNDI_BAD_EEPROM_CHECKSUM 0x68 
%define PXENV_STATUS_UNDI_ERROR_SETTING_ISR 0x69 
%define PXENV_STATUS_UNDI_INVALID_STATE 0x6A 
%define PXENV_STATUS_UNDI_TRANSMIT_ERROR 0x6B 
%define PXENV_STATUS_UNDI_INVALID_PARAMETER 0x6C  
%define PXENV_STATUS_BSTRAP_PROMPT_MENU 0x74 
%define PXENV_STATUS_BSTRAP_MCAST_ADDR 0x76 
%define PXENV_STATUS_BSTRAP_MISSING_LIST 0x77 
%define PXENV_STATUS_BSTRAP_NO_RESPONSE 0x78 
%define PXENV_STATUS_BSTRAP_FILE_TOO_BIG 0x79  
%define PXENV_STATUS_BINL_CANCELED_BY_KEYSTROKE 0xA0 
%define PXENV_STATUS_BINL_NO_PXE_SERVER 0xA1 
%define PXENV_STATUS_NOT_AVAILABLE_IN_PMODE 0xA2 
%define PXENV_STATUS_NOT_AVAILABLE_IN_RMODE 0xA3  
%define PXENV_STATUS_BUSD_DEVICE_NOT_SUPPORTED 0xB0  
%define PXENV_STATUS_LOADER_NO_FREE_BASE_MEMORY 0xC0 
%define PXENV_STATUS_LOADER_NO_BC_ROMID 0xC1 
%define PXENV_STATUS_LOADER_BAD_BC_ROMID 0xC2 
%define PXENV_STATUS_LOADER_BAD_BC_RUNTIME_IMAGE 0xC3 
%define PXENV_STATUS_LOADER_NO_UNDI_ROMID 0xC4 
%define PXENV_STATUS_LOADER_BAD_UNDI_ROMID 0xC5 
%define PXENV_STATUS_LOADER_BAD_UNDI_DRIVER_IMAGE 0xC6 
%define PXENV_STATUS_LOADER_NO_PXE_STRUCT 0xC8 
%define PXENV_STATUS_LOADER_NO_PXENV_STRUCT 0xC9 
%define PXENV_STATUS_LOADER_UNDI_START 0xCA 
%define PXENV_STATUS_LOADER_BC_START 0xCB 

%endif ; _PXE_INC

