/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that manipulate the headers of
 * an audit record.
 *
 * XXX - these might as well be macros.  However, there is something to be
 * said for being able to change a library and not need to recompile a
 * program...
 */

#include "audit.h"

/* p118 - delete the header from an audit record - returns 0(success)
   -1(failure) */

int aud_delete_hdr(aud_hdr_t aud_hdr_d)
{
    return __aud_delete_section(__AUD_MAGIC_HDR, aud_hdr_d);
}

/* p119 - delete indicated info item from header - returns 0(success)
   -1(failure) */

int aud_delete_hdr_info(aud_hdr_t aud_hdr_d, int item_id)
{
    return __aud_delete_section_info(__AUD_MAGIC_HDR, aud_hdr_d, item_id);
}

/* p131 - obtain descriptor for header in this record - returns
   non-negative number of headers in this record. */

int aud_get_hdr(aud_rec_t ar, int index, aud_hdr_t *aud_hdr_p)
{
    return __aud_get_section(__AUD_MAGIC_HDR, ar, index,
			     (const void **) aud_hdr_p);
}

/* p133 - get items of info from the argument header - returns
   non-negative number of items in this header. */

int aud_get_hdr_info(aud_hdr_t aud_hdr_d, int item_id,
		     const aud_info_t **aud_hdr_info_p)
{
    return __aud_get_section_info(__AUD_MAGIC_HDR, aud_hdr_d, item_id,
				  aud_hdr_info_p);
}

/* p149 - add a new header to record - returns 0(success) -1(failure) */

int aud_put_hdr(aud_rec_t ar, const aud_hdr_t *next_p, aud_hdr_t *new_p)
{
    return __aud_put_section(__AUD_MAGIC_HDR, ar,
			     (const struct __aud_section_s **) next_p,
			     (const struct __aud_section_s **) new_p);
}

/* p150 - add item to record header - returns 0(success) -1(failure) */

int aud_put_hdr_info(aud_hdr_t aud_hdr_d, int position, int item_id,
		     const aud_info_t *aud_hdr_info_p)
{
    return __aud_put_section_info(__AUD_MAGIC_HDR, aud_hdr_d, position,
				  item_id, aud_hdr_info_p);
}

/*
 * $Log$
 */
