#ifndef PIPE_H
#define PIPE_H

#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <security/_pam_macros.h>

/* Useful definitions */

#define TRUE               1
#define FALSE              0

/* Instructions that may be passed over pipe */

enum PIPEIO {
   CLEARMSGS,             /* Clear status/error messages */
   CLEARPROMPTS,          /* Clear user prompts */

   PROMPT_ECHO_ON,        /* Data is an echoed prompt (eg username) */
   PROMPT_ECHO_OFF,       /* Data is not an echoed prompt (eg password) */
   ERROR_MSG,             /* Data is an Error/status messages */
   TEXT_INFO,             /* Data is simply text to display */

   POPUP,                 /* Displays the authentication widget
			     (and window, if necessary) */
   POPDOWN,               /* Hides the authentication widget */
   HIDE_WINDOW,           /* Hides the entire toplevel window */

   QUERY_RESPONSE,        /* Data is the name of the message for which
			     this is a request.  The X side will send
			     the response (of type SEND_RESPONSE) */
   SEND_RESPONSE,         /* Data is the response of the message 
			     requested via QUERY_RESPONSE */
   QUERY_DONE,            /* Notifies X side that no more queries will be
			     made.  This must be sent for the okNotify()
			     function to return. */

   OK_NOTIFY,             /* User has finished inputting form */
   ABORT_NOTIFY,          /* ?? */

   FINAL_SUCCESS,         /* Notifies X part that authentication was
			     successful.  Typical X applications
			     should move their initialization code to
			     this section. */
   FINAL_FAIL,            /* Notifies X part that authentication
			     failed.  The typical response should be
			     to terminate the program. */

   FATAL_ERROR            /* something has gone wrong with pipe
			     infrastructure */
};

/* Used to communicate between X process and PAM process */
struct pipeio_t {
   int infd, outfd;
};

/* Method for exchanging information between PAM and X threads of
   application */

extern int outmsg(struct pipeio_t *pipeio, enum PIPEIO epipe, const void *data,
		  int len);
extern enum PIPEIO inmsg(struct pipeio_t *pipeio, void **data, int *len);

#endif /* PIPE_H */
