# hinoko crate

Rust API bindings and wrappers for
[hinoko library](https://git.kernel.org/pub/scm/libs/ieee1394/libhinoko.git/) to operate OHCI 1394
hardware via Linux FireWire character device for isochronous communication in IEEE 1394 bus.

The hinoko library version 0.8.0 is the minimum supported version for underlying library.

The hinoko crate is automatically generated by [gir tool](https://gtk-rs.org/gir/book/) provided
by [gtk-rs project](https://gtk-rs.org/). Hinoko-0.0 file from hinoko library is used for the
generation. But some functions are implemented manually.

## Usage

Add the following line to your Cargo.toml file:

```toml
[dependencies]
hinoko = "0.3.0"
```

The API documentation is available in <https://docs.rs/hinoko/>.

## License

The hinoko crate is released under [MIT license](https://spdx.org/licenses/MIT.html).

## Dependency

The hinoko crate depends on API crates provided by [gtk-rs project](https://gtk-rs.org/) for
type/object system, event loop, and dispacher.

## Features

* dox

   * Suppress detection of installed hinoko library. It's automatically enabled when generating
     documentation in docs.rs.

## Repository

The hinoko crate is maintained by Takashi Sakamoto for upstream of Linux FireWire subsystem.
The remote repository locates in <https://git.kernel.org/pub/scm/libs/ieee1394/hinoko-rs.git/>.

## Support

If finding issue, please file it in <https://github.com/takaswie/hinoko-rs/> which is the mirror of
upstream for user support and continuous integration.

## Sample programs
Some programs are available under `examples` directory.

* `fw-iso-resource`
    * demonstration to allocate and deallocate isochronous resources

* `fw-iso-rx-single`
    * demonstration to receive isochronous packets at single channel

* `fw-iso-rx-multiple`
    * demonstration to receive isochronous packets at multiple channels

* `fw-iso-tx`
    * demonstration to transmit isochronous packets at single channel
