# hinawa crate

Rust API bindings and wrappers for
[hinawa library](https://git.kernel.org/pub/scm/libs/ieee1394/libhinawa.git/) to operate 1394 OHCI
hardware via Linux FireWire character device for asynchronous communication in IEEE 1394 bus.

The hinawa library version 4.0 is the minimum supported version for underlying library.

The hinawa crate is automatically generated by [gir tool](https://gtk-rs.org/gir/book/) provided
by [gtk-rs project](https://gtk-rs.org/). Hinawa-4.0 file from hinawa library is used for the
generation. But some functions are implemented manually.

## Usage

Add the following line to your Cargo.toml file:

```toml
[dependencies]
hinawa = "0.12"
```

The API documentation is available in <https://docs.rs/hinawa/>.

## License

The hinawa crate is released under [MIT license](https://spdx.org/licenses/MIT.html).

## Dependency

The hinawa crate depends on API crates provided by [gtk-rs project](https://gtk-rs.org/) for
type/object system, event loop, and dispacher.

## Repository

The hinawa crate is maintained by Takashi Sakamoto for upstream of Linux FireWire subsystem.
The remote repository locates in <https://git.kernel.org/pub/scm/libs/ieee1394/hinawa-rs.git/>.

## Support

If finding issue, please file it in <https://github.com/alsa-project/hinawa-rs> which is the mirror
of upstream for user support and continuous integration.

## Sample programs
Some programs are available under `examples` directory.

* `read-quadlet.rs`

    * demonstration to read quadlet data from node in IEEE 1394 bus identified as `/dev/fw1`.

* `read-quadlet-async.rs`

    * demonstration of the above example with async runtime.
