/* $Id: linux_logo.h,v 1.1 1997/04/16 17:51:24 jj Exp $
 * include/asm-m68k/linux_logo.h: This is a linux logo
 *                                 to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1996 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/config.h>
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/m68k version " UTS_RELEASE

#ifdef CONFIG_MAC

#define LINUX_LOGO_COLORS 95

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
  0x02, 0x82, 0xEA, 0x42, 0xC2, 0x82, 0xE2, 0xA2,
  0xDA, 0xC2, 0x22, 0x62, 0xB2, 0x92, 0xD2, 0x8A,
  0xB2, 0xFA, 0xDA, 0x32, 0x72, 0x12, 0xF2, 0x52,
  0xF2, 0xEA, 0xFA, 0xAA, 0xCA, 0x9A, 0xE2, 0xAA,
  0x8A, 0xEA, 0xD2, 0x92, 0xEA, 0xDA, 0x2A, 0x6A,
  0xDA, 0xBA, 0xD2, 0x52, 0x7A, 0x2A, 0x5A, 0x0A,
  0x6A, 0xEA, 0xE2, 0xC6, 0x96, 0xF2, 0x3A, 0x1A,
  0xB2, 0xBA, 0xF2, 0xDA, 0x0A, 0x86, 0x4A, 0xCA,
  0x8A, 0xE2, 0xA6, 0xDA, 0x66, 0xBA, 0x92, 0xDA,
  0xA2, 0xB6, 0x76, 0x12, 0xF2, 0xFA, 0xEA, 0xAE,
  0xCE, 0x9E, 0xB2, 0x8E, 0xF2, 0xD2, 0xA2, 0x6E,
  0xBE, 0xD6, 0x7E, 0x5E, 0xC2, 0xFA, 0x3A
};

unsigned char linux_logo_green[] __initdata = {
  0x02, 0x82, 0xC2, 0x42, 0x8A, 0x56, 0xE2, 0xA2,
  0xAA, 0xC2, 0x22, 0x62, 0x86, 0x92, 0x9E, 0x6E,
  0xB2, 0xB2, 0xD2, 0x32, 0x72, 0x12, 0xD2, 0x52,
  0xF2, 0xB2, 0xC2, 0xAA, 0xCA, 0x9A, 0xA2, 0x7E,
  0x8A, 0xCA, 0x92, 0x66, 0xEA, 0xB2, 0x2A, 0x6A,
  0xA2, 0xBA, 0xD2, 0x36, 0x7A, 0x1A, 0x5A, 0x0A,
  0x4A, 0xE6, 0xAE, 0xC6, 0x96, 0xBA, 0x3A, 0x1A,
  0xAA, 0x7A, 0xCA, 0xDA, 0x02, 0x86, 0x4A, 0x8A,
  0x5E, 0xE2, 0xA6, 0xAE, 0x66, 0x82, 0x92, 0x9A,
  0x72, 0xB6, 0x76, 0x12, 0xD2, 0xFA, 0xB2, 0xAE,
  0xCE, 0x9E, 0x7A, 0x8E, 0xCA, 0x92, 0x6A, 0x6E,
  0xBE, 0xD6, 0x7E, 0x5E, 0xC6, 0xBA, 0x3E
};

unsigned char linux_logo_blue[] __initdata = {
  0x04, 0x84, 0x04, 0x44, 0x04, 0x04, 0xDC, 0xA4,
  0x0C, 0xC4, 0x1C, 0x64, 0x04, 0x8C, 0x04, 0x34,
  0xB4, 0x0C, 0xAC, 0x34, 0x74, 0x04, 0x0C, 0x4C,
  0xF4, 0x0C, 0x0C, 0xAC, 0xCC, 0x9C, 0x0C, 0x04,
  0x8C, 0x0C, 0x04, 0x04, 0xEC, 0x2C, 0x2C, 0x6C,
  0x04, 0xBC, 0xD4, 0x04, 0x7C, 0x04, 0x5C, 0x0C,
  0x04, 0xEC, 0x04, 0xC4, 0x94, 0x14, 0x3C, 0x1C,
  0xA4, 0x04, 0x24, 0xDC, 0x04, 0x84, 0x4C, 0x0C,
  0x04, 0xE4, 0xA4, 0x04, 0x64, 0x04, 0x94, 0x14,
  0x0C, 0xB4, 0x74, 0x14, 0x24, 0xFC, 0x14, 0xAC,
  0xCC, 0x9C, 0x0C, 0x8C, 0x14, 0x14, 0x04, 0x6C,
  0xBC, 0xD4, 0x7C, 0x5C, 0xD4, 0x14, 0x3C
};

unsigned char linux_logo[] __initdata = {
  0x53, 0x3D, 0x40, 0x73, 0x71, 0x3B, 0x3B, 0x71,
  0x3D, 0x54, 0x73, 0x40, 0x73, 0x3D, 0x27, 0x71,
  0x40, 0x6A, 0x7A, 0x3D, 0x3B, 0x30, 0x30, 0x62,
  0x40, 0x6A, 0x21, 0x62, 0x78, 0x29, 0x49, 0x30,
  0x6F, 0x27, 0x54, 0x3D, 0x62, 0x27, 0x54, 0x66,
  0x71, 0x6F, 0x6F, 0x6F, 0x78, 0x53, 0x29, 0x29,
  0x53, 0x70, 0x53, 0x3D, 0x40, 0x73, 0x71, 0x3B,
  0x3B, 0x71, 0x3D, 0x54, 0x73, 0x40, 0x73, 0x3D,
  0x27, 0x71, 0x40, 0x6A, 0x7A, 0x3D, 0x3B, 0x30,
  0x30, 0x62, 0x40, 0x6A, 0x21, 0x62, 0x78, 0x29,
  0x71, 0x4C, 0x6A, 0x40, 0x71, 0x62, 0x27, 0x71,
  0x54, 0x66, 0x73, 0x40, 0x73, 0x3D, 0x3D, 0x40,
  0x6A, 0x77, 0x7A, 0x71, 0x30, 0x69, 0x6F, 0x71,
  0x54, 0x73, 0x3D, 0x30, 0x49, 0x30, 0x3B, 0x62,
  0x27, 0x3D, 0x54, 0x3D, 0x71, 0x71, 0x27, 0x62,
  0x62, 0x3B, 0x62, 0x27, 0x3B, 0x69, 0x69, 0x69,
  0x69, 0x30, 0x71, 0x4C, 0x6A, 0x40, 0x71, 0x62,
  0x27, 0x71, 0x54, 0x66, 0x73, 0x40, 0x73, 0x3D,
  0x3D, 0x40, 0x6A, 0x77, 0x7A, 0x71, 0x30, 0x69,
  0x6F, 0x71, 0x54, 0x73, 0x3D, 0x30, 0x49, 0x30,
  0x40, 0x34, 0x34, 0x40, 0x27, 0x6F, 0x62, 0x3D,
  0x54, 0x66, 0x40, 0x73, 0x66, 0x66, 0x2D, 0x5D,
  0x7A, 0x5D, 0x3D, 0x6F, 0x69, 0x69, 0x30, 0x27,
  0x27, 0x27, 0x62, 0x6F, 0x30, 0x3B, 0x62, 0x27,
  0x3D, 0x54, 0x2D, 0x54, 0x27, 0x71, 0x3D, 0x27,
  0x62, 0x62, 0x62, 0x62, 0x3B, 0x30, 0x6F, 0x6F,
  0x6F, 0x71, 0x40, 0x34, 0x34, 0x40, 0x27, 0x6F,
  0x62, 0x3D, 0x54, 0x66, 0x40, 0x73, 0x66, 0x66,
  0x2D, 0x5D, 0x7A, 0x5D, 0x3D, 0x6F, 0x69, 0x69,
  0x30, 0x27, 0x27, 0x27, 0x62, 0x6F, 0x30, 0x6F,
  0x4C, 0x77, 0x6A, 0x2D, 0x3B, 0x6F, 0x3B, 0x71,
  0x54, 0x66, 0x2D, 0x73, 0x66, 0x54, 0x73, 0x73,
  0x73, 0x3D, 0x62, 0x6F, 0x69, 0x30, 0x6F, 0x27,
  0x3D, 0x3D, 0x27, 0x62, 0x62, 0x62, 0x27, 0x71,
  0x54, 0x73, 0x73, 0x54, 0x3D, 0x3D, 0x20, 0x20,
  0x20, 0x20, 0x3B, 0x62, 0x3B, 0x62, 0x71, 0x71,
  0x3D, 0x2D, 0x4C, 0x77, 0x6A, 0x66, 0x3B, 0x6F,
  0x3B, 0x71, 0x54, 0x66, 0x2D, 0x73, 0x66, 0x54,
  0x73, 0x73, 0x73, 0x3D, 0x62, 0x6F, 0x69, 0x30,
  0x6F, 0x27, 0x3D, 0x3D, 0x27, 0x62, 0x62, 0x27,
  0x4C, 0x4C, 0x5D, 0x71, 0x30, 0x30, 0x3B, 0x27,
  0x54, 0x66, 0x73, 0x66, 0x66, 0x54, 0x54, 0x3D,
  0x27, 0x62, 0x6F, 0x30, 0x30, 0x6F, 0x27, 0x3D,
  0x54, 0x54, 0x3D, 0x71, 0x3D, 0x71, 0x3D, 0x3D,
  0x66, 0x73, 0x66, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x71, 0x3D,
  0x66, 0x40, 0x4C, 0x4C, 0x5D, 0x71, 0x30, 0x30,
  0x3B, 0x27, 0x54, 0x66, 0x73, 0x66, 0x66, 0x54,
  0x54, 0x3D, 0x27, 0x62, 0x6F, 0x30, 0x30, 0x6F,
  0x27, 0x3D, 0x54, 0x54, 0x3D, 0x71, 0x71, 0x71,
  0x5D, 0x5D, 0x54, 0x62, 0x69, 0x69, 0x3B, 0x3D,
  0x66, 0x40, 0x73, 0x66, 0x54, 0x54, 0x71, 0x62,
  0x3B, 0x6F, 0x6F, 0x6F, 0x3B, 0x27, 0x3D, 0x2D,
  0x66, 0x54, 0x71, 0x71, 0x27, 0x71, 0x71, 0x3D,
  0x3D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54,
  0x73, 0x40, 0x5D, 0x5D, 0x54, 0x62, 0x69, 0x69,
  0x3B, 0x3D, 0x66, 0x40, 0x73, 0x66, 0x54, 0x54,
  0x71, 0x62, 0x3B, 0x6F, 0x6F, 0x6F, 0x3B, 0x27,
  0x3D, 0x66, 0x66, 0x54, 0x71, 0x71, 0x27, 0x71,
  0x66, 0x73, 0x3D, 0x27, 0x6F, 0x6F, 0x62, 0x54,
  0x40, 0x21, 0x5D, 0x73, 0x3D, 0x27, 0x62, 0x6F,
  0x6F, 0x3B, 0x3B, 0x62, 0x27, 0x71, 0x3D, 0x3D,
  0x3D, 0x71, 0x62, 0x62, 0x62, 0x27, 0x27, 0x71,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x4F, 0x46, 0x2A, 0x20, 0x20,
  0x20, 0x73, 0x66, 0x73, 0x3D, 0x27, 0x6F, 0x6F,
  0x62, 0x54, 0x40, 0x21, 0x5D, 0x73, 0x3D, 0x27,
  0x62, 0x6F, 0x6F, 0x3B, 0x3B, 0x62, 0x27, 0x71,
  0x3D, 0x3D, 0x3D, 0x71, 0x62, 0x27, 0x62, 0x27,
  0x3D, 0x40, 0x66, 0x27, 0x3B, 0x3B, 0x71, 0x66,
  0x7A, 0x21, 0x40, 0x54, 0x27, 0x3B, 0x6F, 0x3B,
  0x62, 0x62, 0x27, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x38, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x38,
  0x38, 0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D,
  0x6F, 0x3B, 0x62, 0x62, 0x27, 0x27, 0x27, 0x27,
  0x71, 0x3D, 0x71, 0x71, 0x71, 0x71, 0x3D, 0x3D,
  0x27, 0x40, 0x54, 0x62, 0x30, 0x30, 0x27, 0x40,
  0x7A, 0x5D, 0x54, 0x3D, 0x62, 0x30, 0x30, 0x3B,
  0x71, 0x3D, 0x71, 0x38, 0x6D, 0x6D, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x6D, 0x6D, 0x38, 0x6D, 0x6D,
  0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x30, 0x3B, 0x71, 0x3D, 0x71, 0x27, 0x71, 0x71,
  0x3D, 0x66, 0x73, 0x40, 0x73, 0x66, 0x2D, 0x66,
  0x30, 0x66, 0x71, 0x6F, 0x69, 0x6F, 0x54, 0x21,
  0x7A, 0x66, 0x3D, 0x3B, 0x6F, 0x6F, 0x3B, 0x71,
  0x54, 0x66, 0x3D, 0x4C, 0x44, 0x51, 0x44, 0x44,
  0x44, 0x38, 0x44, 0x38, 0x44, 0x38, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x38, 0x51,
  0x3B, 0x71, 0x54, 0x66, 0x3D, 0x3D, 0x3D, 0x2D,
  0x40, 0x40, 0x5D, 0x40, 0x73, 0x66, 0x66, 0x3D,
  0x69, 0x27, 0x3B, 0x30, 0x69, 0x3B, 0x73, 0x7A,
  0x21, 0x3D, 0x62, 0x3B, 0x6F, 0x3B, 0x27, 0x66,
  0x73, 0x73, 0x54, 0x4E, 0x44, 0x26, 0x26, 0x5B,
  0x26, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x38, 0x38, 0x38, 0x38, 0x38,
  0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x6D, 0x26,
  0x27, 0x66, 0x73, 0x73, 0x66, 0x2D, 0x66, 0x2D,
  0x66, 0x54, 0x54, 0x71, 0x27, 0x27, 0x27, 0x62,
  0x69, 0x3B, 0x6F, 0x6F, 0x62, 0x54, 0x40, 0x21,
  0x73, 0x27, 0x3B, 0x3B, 0x71, 0x54, 0x66, 0x66,
  0x73, 0x73, 0x2D, 0x37, 0x44, 0x51, 0x38, 0x38,
  0x44, 0x6D, 0x38, 0x6D, 0x38, 0x38, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x38, 0x6D, 0x38, 0x6D,
  0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x38, 0x6D, 0x70,
  0x2D, 0x66, 0x73, 0x66, 0x66, 0x54, 0x54, 0x54,
  0x27, 0x62, 0x6F, 0x6F, 0x6F, 0x6F, 0x3B, 0x62,
  0x3B, 0x27, 0x27, 0x27, 0x3D, 0x40, 0x21, 0x40,
  0x54, 0x62, 0x3B, 0x71, 0x73, 0x5D, 0x40, 0x73,
  0x66, 0x66, 0x2D, 0x33, 0x6D, 0x26, 0x44, 0x4F,
  0x5E, 0x5E, 0x37, 0x5E, 0x37, 0x46, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x44, 0x26, 0x26, 0x44,
  0x70, 0x38, 0x26, 0x38, 0x38, 0x44, 0x6D, 0x53,
  0x40, 0x73, 0x66, 0x2D, 0x66, 0x73, 0x66, 0x54,
  0x27, 0x6F, 0x30, 0x69, 0x30, 0x6F, 0x62, 0x62,
  0x62, 0x71, 0x3D, 0x54, 0x73, 0x5D, 0x5D, 0x66,
  0x27, 0x62, 0x71, 0x54, 0x5D, 0x5D, 0x66, 0x3D,
  0x3D, 0x73, 0x40, 0x37, 0x44, 0x44, 0x51, 0x20,
  0x6F, 0x6F, 0x62, 0x27, 0x27, 0x20, 0x20, 0x20,
  0x4F, 0x20, 0x2A, 0x2A, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x77, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x71, 0x3D, 0x73, 0x5D,
  0x40, 0x54, 0x27, 0x3B, 0x2D, 0x6D, 0x38, 0x3C,
  0x66, 0x3D, 0x54, 0x66, 0x40, 0x40, 0x73, 0x54,
  0x62, 0x6F, 0x30, 0x6F, 0x62, 0x71, 0x71, 0x71,
  0x62, 0x3D, 0x66, 0x73, 0x40, 0x5D, 0x73, 0x71,
  0x62, 0x27, 0x54, 0x73, 0x5D, 0x73, 0x27, 0x62,
  0x71, 0x40, 0x21, 0x37, 0x26, 0x51, 0x44, 0x4E,
  0x3B, 0x71, 0x2D, 0x73, 0x2D, 0x20, 0x20, 0x20,
  0x35, 0x73, 0x77, 0x4F, 0x6B, 0x20, 0x20, 0x4F,
  0x20, 0x73, 0x73, 0x73, 0x58, 0x20, 0x77, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2D, 0x40, 0x40, 0x5D,
  0x73, 0x71, 0x62, 0x27, 0x71, 0x38, 0x44, 0x49,
  0x27, 0x62, 0x3D, 0x40, 0x21, 0x40, 0x54, 0x27,
  0x3B, 0x6F, 0x3B, 0x71, 0x54, 0x66, 0x66, 0x3D,
  0x62, 0x54, 0x40, 0x21, 0x7A, 0x40, 0x3D, 0x62,
  0x62, 0x71, 0x66, 0x40, 0x66, 0x71, 0x62, 0x3B,
  0x54, 0x5D, 0x73, 0x23, 0x51, 0x26, 0x26, 0x30,
  0x3B, 0x3D, 0x66, 0x73, 0x66, 0x20, 0x20, 0x4F,
  0x58, 0x7C, 0x62, 0x34, 0x57, 0x20, 0x20, 0x20,
  0x73, 0x58, 0x49, 0x7C, 0x79, 0x73, 0x20, 0x4F,
  0x20, 0x20, 0x20, 0x20, 0x40, 0x21, 0x7A, 0x40,
  0x3D, 0x27, 0x62, 0x71, 0x49, 0x44, 0x6D, 0x78,
  0x62, 0x3B, 0x3D, 0x5D, 0x40, 0x3D, 0x3B, 0x69,
  0x49, 0x49, 0x3B, 0x71, 0x66, 0x73, 0x66, 0x54,
  0x27, 0x66, 0x5D, 0x7A, 0x21, 0x73, 0x71, 0x62,
  0x27, 0x54, 0x73, 0x66, 0x3D, 0x27, 0x62, 0x62,
  0x54, 0x73, 0x71, 0x37, 0x26, 0x5B, 0x44, 0x5B,
  0x27, 0x54, 0x40, 0x2D, 0x54, 0x20, 0x20, 0x77,
  0x78, 0x6D, 0x6D, 0x6D, 0x20, 0x20, 0x20, 0x20,
  0x79, 0x38, 0x38, 0x6D, 0x6D, 0x69, 0x2D, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x7A, 0x7A, 0x40,
  0x71, 0x62, 0x27, 0x54, 0x79, 0x26, 0x38, 0x49,
  0x3B, 0x27, 0x54, 0x2D, 0x71, 0x6F, 0x49, 0x53,
  0x78, 0x30, 0x27, 0x54, 0x40, 0x73, 0x54, 0x3D,
  0x71, 0x66, 0x5D, 0x7A, 0x21, 0x66, 0x27, 0x3B,
  0x27, 0x66, 0x73, 0x54, 0x27, 0x27, 0x27, 0x3D,
  0x3D, 0x71, 0x6F, 0x5E, 0x26, 0x79, 0x26, 0x78,
  0x5D, 0x4C, 0x4C, 0x21, 0x73, 0x20, 0x20, 0x2D,
  0x35, 0x5C, 0x46, 0x38, 0x77, 0x20, 0x4F, 0x20,
  0x51, 0x6D, 0x20, 0x2D, 0x20, 0x6D, 0x6D, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x7A, 0x21, 0x54,
  0x62, 0x3B, 0x27, 0x2D, 0x29, 0x26, 0x44, 0x70,
  0x27, 0x3D, 0x3D, 0x71, 0x6F, 0x78, 0x53, 0x29,
  0x69, 0x3D, 0x21, 0x4C, 0x4C, 0x5D, 0x66, 0x54,
  0x54, 0x73, 0x21, 0x6A, 0x21, 0x3D, 0x3B, 0x3B,
  0x71, 0x66, 0x66, 0x3D, 0x27, 0x27, 0x71, 0x3D,
  0x27, 0x6F, 0x49, 0x7E, 0x61, 0x5B, 0x44, 0x26,
  0x34, 0x34, 0x6A, 0x21, 0x73, 0x66, 0x20, 0x32,
  0x20, 0x20, 0x2D, 0x6D, 0x77, 0x2A, 0x37, 0x20,
  0x6D, 0x20, 0x20, 0x20, 0x7E, 0x38, 0x38, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x4C, 0x21, 0x3D,
  0x3B, 0x3B, 0x71, 0x73, 0x69, 0x44, 0x38, 0x71,
  0x27, 0x3D, 0x71, 0x3B, 0x49, 0x29, 0x29, 0x6F,
  0x54, 0x7A, 0x34, 0x77, 0x6A, 0x21, 0x66, 0x66,
  0x4C, 0x7A, 0x21, 0x4C, 0x21, 0x71, 0x3B, 0x3B,
  0x54, 0x73, 0x3D, 0x62, 0x3B, 0x62, 0x62, 0x62,
  0x62, 0x69, 0x29, 0x2B, 0x79, 0x79, 0x26, 0x38,
  0x47, 0x6A, 0x5D, 0x54, 0x27, 0x3D, 0x20, 0x29,
  0x57, 0x20, 0x2D, 0x61, 0x37, 0x5C, 0x20, 0x20,
  0x29, 0x20, 0x20, 0x20, 0x20, 0x29, 0x6D, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x6A, 0x21, 0x3D,
  0x3B, 0x3B, 0x54, 0x66, 0x78, 0x26, 0x26, 0x30,
  0x62, 0x62, 0x3B, 0x69, 0x78, 0x78, 0x6F, 0x66,
  0x6A, 0x64, 0x47, 0x4C, 0x5D, 0x54, 0x71, 0x71,
  0x4C, 0x5D, 0x5D, 0x21, 0x5D, 0x71, 0x3B, 0x62,
  0x54, 0x66, 0x27, 0x3B, 0x6F, 0x6F, 0x3B, 0x3B,
  0x6F, 0x49, 0x78, 0x23, 0x4A, 0x79, 0x4A, 0x6D,
  0x34, 0x21, 0x66, 0x3D, 0x62, 0x27, 0x20, 0x20,
  0x38, 0x20, 0x20, 0x52, 0x3A, 0x52, 0x63, 0x36,
  0x48, 0x4D, 0x20, 0x20, 0x20, 0x6D, 0x38, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x5D, 0x3D,
  0x3B, 0x62, 0x2D, 0x66, 0x79, 0x26, 0x51, 0x54,
  0x3B, 0x62, 0x6F, 0x49, 0x78, 0x30, 0x66, 0x34,
  0x2B, 0x2B, 0x34, 0x21, 0x66, 0x71, 0x62, 0x62,
  0x3D, 0x3D, 0x54, 0x5D, 0x40, 0x71, 0x3B, 0x3B,
  0x54, 0x54, 0x3B, 0x69, 0x30, 0x6F, 0x3B, 0x27,
  0x6F, 0x78, 0x78, 0x46, 0x26, 0x5B, 0x4A, 0x51,
  0x5D, 0x54, 0x71, 0x62, 0x3B, 0x3B, 0x20, 0x20,
  0x6D, 0x20, 0x72, 0x55, 0x3A, 0x74, 0x41, 0x39,
  0x45, 0x5A, 0x24, 0x2F, 0x6D, 0x38, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x5D, 0x40, 0x27,
  0x3B, 0x62, 0x3D, 0x54, 0x30, 0x5B, 0x26, 0x27,
  0x3B, 0x62, 0x6F, 0x78, 0x78, 0x3B, 0x21, 0x64,
  0x7B, 0x77, 0x5D, 0x54, 0x71, 0x62, 0x62, 0x3B,
  0x53, 0x62, 0x71, 0x73, 0x73, 0x27, 0x6F, 0x3B,
  0x3D, 0x3D, 0x3B, 0x49, 0x30, 0x62, 0x27, 0x27,
  0x6F, 0x78, 0x49, 0x46, 0x79, 0x53, 0x4A, 0x38,
  0x2D, 0x71, 0x62, 0x6F, 0x6F, 0x6F, 0x20, 0x20,
  0x20, 0x24, 0x52, 0x3A, 0x22, 0x41, 0x5A, 0x45,
  0x45, 0x63, 0x41, 0x22, 0x36, 0x28, 0x4D, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x73, 0x73, 0x27,
  0x6F, 0x3B, 0x3D, 0x3D, 0x49, 0x51, 0x61, 0x69,
  0x27, 0x27, 0x30, 0x78, 0x69, 0x71, 0x4C, 0x64,
  0x34, 0x5D, 0x66, 0x71, 0x62, 0x6F, 0x6F, 0x6F,
  0x79, 0x27, 0x66, 0x73, 0x66, 0x62, 0x6F, 0x6F,
  0x3D, 0x3D, 0x3B, 0x30, 0x30, 0x62, 0x3D, 0x71,
  0x6F, 0x69, 0x6F, 0x23, 0x5B, 0x4A, 0x4A, 0x38,
  0x66, 0x3D, 0x3B, 0x6F, 0x6F, 0x3B, 0x20, 0x4D,
  0x43, 0x48, 0x39, 0x55, 0x22, 0x22, 0x41, 0x45,
  0x45, 0x45, 0x45, 0x41, 0x22, 0x45, 0x5A, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x73, 0x2D, 0x62,
  0x30, 0x3B, 0x3D, 0x3D, 0x27, 0x26, 0x61, 0x27,
  0x3D, 0x27, 0x6F, 0x69, 0x6F, 0x54, 0x4C, 0x34,
  0x7A, 0x40, 0x66, 0x54, 0x62, 0x30, 0x6F, 0x3B,
  0x53, 0x7A, 0x7A, 0x73, 0x54, 0x62, 0x30, 0x3B,
  0x3D, 0x3D, 0x62, 0x30, 0x30, 0x3B, 0x71, 0x62,
  0x30, 0x30, 0x27, 0x7E, 0x70, 0x70, 0x3C, 0x6D,
  0x21, 0x66, 0x3B, 0x69, 0x3B, 0x71, 0x20, 0x72,
  0x24, 0x67, 0x22, 0x22, 0x36, 0x36, 0x45, 0x45,
  0x45, 0x22, 0x41, 0x41, 0x3F, 0x42, 0x52, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x73, 0x54, 0x62,
  0x30, 0x3B, 0x3D, 0x54, 0x62, 0x26, 0x79, 0x3B,
  0x71, 0x27, 0x30, 0x30, 0x27, 0x5D, 0x4C, 0x6A,
  0x7A, 0x7A, 0x5D, 0x54, 0x3B, 0x30, 0x6F, 0x71,
  0x27, 0x64, 0x77, 0x40, 0x71, 0x62, 0x3B, 0x62,
  0x3D, 0x54, 0x27, 0x3B, 0x6F, 0x3B, 0x27, 0x27,
  0x62, 0x3B, 0x3D, 0x23, 0x26, 0x5B, 0x3C, 0x38,
  0x5D, 0x71, 0x69, 0x69, 0x62, 0x54, 0x20, 0x50,
  0x5F, 0x48, 0x3A, 0x55, 0x41, 0x63, 0x70, 0x22,
  0x22, 0x45, 0x3F, 0x42, 0x48, 0x48, 0x45, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x71, 0x62,
  0x3B, 0x62, 0x3D, 0x54, 0x30, 0x26, 0x61, 0x71,
  0x27, 0x27, 0x62, 0x62, 0x54, 0x5D, 0x7A, 0x4C,
  0x4C, 0x4C, 0x5D, 0x71, 0x30, 0x69, 0x62, 0x54,
  0x7A, 0x64, 0x34, 0x73, 0x71, 0x27, 0x62, 0x62,
  0x71, 0x54, 0x71, 0x3B, 0x6F, 0x3B, 0x71, 0x3D,
  0x3D, 0x71, 0x2D, 0x7E, 0x79, 0x53, 0x3C, 0x38,
  0x3D, 0x6F, 0x78, 0x49, 0x71, 0x73, 0x20, 0x20,
  0x25, 0x3F, 0x3A, 0x41, 0x5A, 0x45, 0x41, 0x45,
  0x3F, 0x50, 0x24, 0x28, 0x28, 0x3F, 0x4D, 0x20,
  0x20, 0x77, 0x77, 0x20, 0x20, 0x20, 0x71, 0x27,
  0x62, 0x62, 0x71, 0x54, 0x78, 0x79, 0x38, 0x71,
  0x71, 0x3D, 0x71, 0x71, 0x66, 0x5D, 0x5D, 0x21,
  0x21, 0x21, 0x54, 0x30, 0x78, 0x69, 0x27, 0x66,
  0x7A, 0x4C, 0x40, 0x3D, 0x27, 0x62, 0x62, 0x3B,
  0x62, 0x71, 0x62, 0x30, 0x69, 0x6F, 0x71, 0x54,
  0x3D, 0x3D, 0x54, 0x23, 0x4A, 0x3C, 0x3C, 0x38,
  0x6F, 0x29, 0x53, 0x30, 0x54, 0x66, 0x20, 0x57,
  0x7C, 0x25, 0x4B, 0x3F, 0x43, 0x4B, 0x4B, 0x2C,
  0x2E, 0x2E, 0x2E, 0x24, 0x58, 0x58, 0x78, 0x20,
  0x20, 0x20, 0x34, 0x77, 0x20, 0x20, 0x20, 0x62,
  0x62, 0x3B, 0x62, 0x71, 0x29, 0x79, 0x61, 0x27,
  0x27, 0x54, 0x54, 0x71, 0x54, 0x54, 0x66, 0x54,
  0x66, 0x71, 0x6F, 0x78, 0x53, 0x69, 0x54, 0x73,
  0x73, 0x73, 0x3D, 0x27, 0x27, 0x27, 0x62, 0x3B,
  0x62, 0x71, 0x71, 0x3B, 0x6F, 0x3B, 0x27, 0x54,
  0x66, 0x3D, 0x3D, 0x37, 0x53, 0x78, 0x49, 0x38,
  0x78, 0x29, 0x78, 0x3B, 0x66, 0x73, 0x20, 0x20,
  0x7C, 0x69, 0x68, 0x68, 0x52, 0x2E, 0x42, 0x67,
  0x5F, 0x45, 0x2C, 0x69, 0x78, 0x32, 0x78, 0x78,
  0x20, 0x20, 0x34, 0x77, 0x35, 0x20, 0x20, 0x27,
  0x62, 0x3B, 0x62, 0x71, 0x30, 0x26, 0x61, 0x73,
  0x27, 0x3D, 0x66, 0x3D, 0x3D, 0x27, 0x27, 0x62,
  0x62, 0x6F, 0x78, 0x53, 0x78, 0x62, 0x54, 0x66,
  0x27, 0x71, 0x3D, 0x71, 0x62, 0x62, 0x27, 0x3B,
  0x62, 0x71, 0x71, 0x27, 0x27, 0x27, 0x27, 0x3D,
  0x54, 0x3D, 0x27, 0x7E, 0x29, 0x29, 0x29, 0x6D,
  0x49, 0x49, 0x6F, 0x54, 0x73, 0x54, 0x20, 0x20,
  0x29, 0x7C, 0x69, 0x43, 0x76, 0x72, 0x2C, 0x76,
  0x68, 0x62, 0x78, 0x29, 0x6D, 0x38, 0x6D, 0x32,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x62,
  0x27, 0x3B, 0x62, 0x71, 0x78, 0x61, 0x6D, 0x3C,
  0x27, 0x3D, 0x54, 0x3D, 0x27, 0x62, 0x3B, 0x6F,
  0x6F, 0x69, 0x49, 0x49, 0x6F, 0x3D, 0x73, 0x66,
  0x3D, 0x3D, 0x3D, 0x3D, 0x71, 0x27, 0x71, 0x62,
  0x62, 0x71, 0x3D, 0x71, 0x71, 0x71, 0x27, 0x71,
  0x54, 0x3D, 0x27, 0x46, 0x49, 0x78, 0x49, 0x6D,
  0x6F, 0x27, 0x54, 0x73, 0x40, 0x20, 0x20, 0x20,
  0x44, 0x32, 0x29, 0x49, 0x77, 0x2F, 0x73, 0x62,
  0x29, 0x32, 0x29, 0x51, 0x6D, 0x38, 0x6D, 0x38,
  0x56, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x71, 0x62, 0x62, 0x71, 0x6F, 0x70, 0x38, 0x71,
  0x27, 0x71, 0x54, 0x3D, 0x62, 0x3B, 0x3B, 0x6F,
  0x6F, 0x6F, 0x3B, 0x27, 0x54, 0x40, 0x73, 0x66,
  0x40, 0x40, 0x66, 0x3D, 0x71, 0x3D, 0x71, 0x71,
  0x27, 0x27, 0x3D, 0x54, 0x3D, 0x3D, 0x71, 0x54,
  0x73, 0x73, 0x3D, 0x46, 0x78, 0x49, 0x78, 0x44,
  0x66, 0x73, 0x5D, 0x5D, 0x35, 0x20, 0x20, 0x78,
  0x6D, 0x51, 0x78, 0x49, 0x58, 0x29, 0x29, 0x49,
  0x29, 0x79, 0x38, 0x38, 0x6D, 0x6D, 0x38, 0x6D,
  0x6D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x6B, 0x71, 0x27, 0x27, 0x29, 0x3C, 0x44, 0x40,
  0x3D, 0x54, 0x73, 0x73, 0x54, 0x71, 0x71, 0x3D,
  0x3D, 0x3D, 0x66, 0x40, 0x5D, 0x5D, 0x5D, 0x40,
  0x21, 0x5D, 0x73, 0x66, 0x3D, 0x3D, 0x71, 0x71,
  0x27, 0x27, 0x3D, 0x54, 0x54, 0x66, 0x54, 0x73,
  0x5D, 0x21, 0x40, 0x33, 0x69, 0x49, 0x30, 0x38,
  0x7A, 0x7A, 0x7A, 0x21, 0x6B, 0x20, 0x20, 0x6D,
  0x38, 0x6D, 0x38, 0x7C, 0x49, 0x29, 0x69, 0x78,
  0x38, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x6D, 0x37, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x71, 0x27, 0x71, 0x78, 0x3C, 0x26, 0x30,
  0x66, 0x66, 0x5D, 0x21, 0x5D, 0x73, 0x73, 0x40,
  0x5D, 0x21, 0x7A, 0x4C, 0x21, 0x5D, 0x21, 0x21,
  0x5D, 0x54, 0x54, 0x54, 0x3D, 0x71, 0x3D, 0x71,
  0x27, 0x27, 0x71, 0x54, 0x66, 0x54, 0x66, 0x66,
  0x5D, 0x21, 0x5D, 0x7E, 0x29, 0x69, 0x49, 0x6D,
  0x4C, 0x7A, 0x5D, 0x20, 0x20, 0x20, 0x51, 0x38,
  0x6D, 0x6D, 0x6D, 0x44, 0x69, 0x78, 0x5B, 0x6D,
  0x6D, 0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x38, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x62, 0x27, 0x3C, 0x69, 0x38, 0x71,
  0x54, 0x73, 0x5D, 0x21, 0x40, 0x73, 0x66, 0x73,
  0x21, 0x4C, 0x4C, 0x7A, 0x5D, 0x5D, 0x5D, 0x4C,
  0x66, 0x62, 0x62, 0x27, 0x71, 0x71, 0x71, 0x27,
  0x27, 0x27, 0x71, 0x3D, 0x54, 0x54, 0x54, 0x54,
  0x73, 0x73, 0x3D, 0x57, 0x29, 0x69, 0x30, 0x38,
  0x73, 0x73, 0x20, 0x20, 0x20, 0x2D, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x38, 0x6D, 0x6D,
  0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x6D, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x27, 0x5B, 0x53, 0x6D, 0x73,
  0x54, 0x54, 0x73, 0x73, 0x3D, 0x27, 0x27, 0x71,
  0x66, 0x40, 0x73, 0x40, 0x66, 0x73, 0x40, 0x21,
  0x62, 0x30, 0x6F, 0x62, 0x27, 0x71, 0x3D, 0x71,
  0x27, 0x71, 0x71, 0x71, 0x3D, 0x3D, 0x3D, 0x3D,
  0x3D, 0x27, 0x58, 0x46, 0x69, 0x30, 0x6F, 0x6D,
  0x3D, 0x71, 0x20, 0x20, 0x20, 0x44, 0x6D, 0x6D,
  0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D,
  0x38, 0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x6D,
  0x6D, 0x6D, 0x2F, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x70, 0x53, 0x38, 0x27,
  0x3D, 0x3D, 0x3D, 0x71, 0x3B, 0x30, 0x62, 0x3D,
  0x66, 0x54, 0x3D, 0x71, 0x3D, 0x3D, 0x66, 0x66,
  0x3B, 0x69, 0x69, 0x6F, 0x62, 0x27, 0x3D, 0x71,
  0x27, 0x27, 0x27, 0x27, 0x71, 0x3D, 0x3D, 0x3D,
  0x3D, 0x27, 0x3B, 0x46, 0x62, 0x3B, 0x49, 0x38,
  0x3D, 0x20, 0x20, 0x20, 0x34, 0x44, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D,
  0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D,
  0x38, 0x6D, 0x26, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x49, 0x79, 0x51, 0x5D,
  0x3D, 0x3D, 0x71, 0x27, 0x62, 0x62, 0x3D, 0x73,
  0x40, 0x66, 0x3D, 0x3D, 0x54, 0x3D, 0x3D, 0x71,
  0x78, 0x49, 0x69, 0x30, 0x3B, 0x62, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x71, 0x71, 0x71, 0x3D, 0x3D,
  0x3D, 0x27, 0x3D, 0x33, 0x49, 0x69, 0x62, 0x44,
  0x20, 0x20, 0x20, 0x20, 0x2D, 0x32, 0x6D, 0x38,
  0x6D, 0x6D, 0x6D, 0x6D, 0x38, 0x38, 0x6D, 0x6D,
  0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x38, 0x51,
  0x26, 0x61, 0x44, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x6A, 0x70, 0x6F, 0x6D, 0x21,
  0x71, 0x3D, 0x3D, 0x71, 0x3D, 0x66, 0x40, 0x5D,
  0x40, 0x73, 0x66, 0x73, 0x66, 0x54, 0x3D, 0x71,
  0x70, 0x78, 0x49, 0x30, 0x6F, 0x6F, 0x62, 0x62,
  0x62, 0x27, 0x71, 0x3D, 0x54, 0x54, 0x54, 0x3D,
  0x3D, 0x71, 0x3D, 0x2A, 0x30, 0x2D, 0x3B, 0x26,
  0x38, 0x20, 0x20, 0x20, 0x2D, 0x62, 0x32, 0x26,
  0x38, 0x6D, 0x6D, 0x38, 0x5B, 0x38, 0x6D, 0x38,
  0x6D, 0x6D, 0x6D, 0x26, 0x32, 0x29, 0x29, 0x29,
  0x53, 0x29, 0x61, 0x6D, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x44, 0x3D, 0x3C, 0x62, 0x79, 0x7A,
  0x54, 0x54, 0x71, 0x27, 0x3D, 0x66, 0x73, 0x40,
  0x73, 0x66, 0x66, 0x73, 0x2D, 0x54, 0x71, 0x71,
  0x4A, 0x3B, 0x62, 0x3B, 0x3B, 0x3B, 0x3B, 0x27,
  0x27, 0x27, 0x71, 0x3D, 0x2D, 0x73, 0x73, 0x54,
  0x3D, 0x71, 0x71, 0x33, 0x30, 0x71, 0x5D, 0x38,
  0x6D, 0x6D, 0x38, 0x38, 0x38, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x44, 0x38, 0x6F, 0x7A, 0x64, 0x64,
  0x23, 0x23, 0x56, 0x23, 0x23, 0x7B, 0x47, 0x64,
  0x54, 0x29, 0x44, 0x38, 0x38, 0x6D, 0x38, 0x38,
  0x6D, 0x38, 0x38, 0x6D, 0x53, 0x49, 0x6D, 0x34,
  0x73, 0x54, 0x3D, 0x71, 0x71, 0x3D, 0x54, 0x3D,
  0x3D, 0x54, 0x66, 0x66, 0x66, 0x54, 0x54, 0x3D,
  0x49, 0x3D, 0x54, 0x54, 0x3D, 0x71, 0x27, 0x27,
  0x71, 0x71, 0x71, 0x3D, 0x54, 0x54, 0x54, 0x3D,
  0x3D, 0x71, 0x71, 0x33, 0x29, 0x3D, 0x3D, 0x6D,
  0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x38, 0x6D,
  0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38, 0x6D,
  0x38, 0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x38, 0x6D, 0x44,
  0x6D, 0x38, 0x38, 0x6D, 0x69, 0x78, 0x61, 0x73,
  0x54, 0x3D, 0x3D, 0x71, 0x71, 0x3D, 0x3D, 0x3D,
  0x71, 0x3D, 0x3D, 0x3D, 0x3D, 0x54, 0x3D, 0x71,
  0x3B, 0x66, 0x73, 0x73, 0x2D, 0x2D, 0x54, 0x3D,
  0x71, 0x71, 0x3D, 0x71, 0x71, 0x71, 0x27, 0x27,
  0x27, 0x71, 0x71, 0x33, 0x3B, 0x62, 0x27, 0x3D,
  0x27, 0x3B, 0x3B, 0x27, 0x62, 0x3B, 0x3D, 0x3D,
  0x30, 0x27, 0x62, 0x62, 0x62, 0x71, 0x30, 0x27,
  0x3B, 0x6F, 0x30, 0x30, 0x3B, 0x30, 0x3B, 0x62,
  0x3B, 0x69, 0x49, 0x30, 0x29, 0x29, 0x29, 0x29,
  0x49, 0x29, 0x30, 0x29, 0x29, 0x29, 0x51, 0x21,
  0x27, 0x27, 0x71, 0x71, 0x71, 0x3D, 0x3D, 0x71,
  0x71, 0x71, 0x71, 0x3D, 0x71, 0x71, 0x71, 0x62,
  0x3B, 0x54, 0x66, 0x66, 0x66, 0x54, 0x3D, 0x54,
  0x66, 0x54, 0x3D, 0x27, 0x62, 0x62, 0x3B, 0x3B,
  0x3B, 0x62, 0x27, 0x33, 0x30, 0x6F, 0x71, 0x3B,
  0x62, 0x3B, 0x62, 0x27, 0x27, 0x30, 0x62, 0x27,
  0x62, 0x27, 0x3B, 0x49, 0x3B, 0x30, 0x29, 0x3B,
  0x3B, 0x30, 0x30, 0x69, 0x30, 0x6F, 0x30, 0x49,
  0x3B, 0x6F, 0x49, 0x29, 0x49, 0x49, 0x3C, 0x29,
  0x49, 0x49, 0x69, 0x70, 0x70, 0x29, 0x51, 0x27,
  0x3B, 0x3B, 0x3B, 0x62, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x3D, 0x3D, 0x3D, 0x71, 0x27, 0x27, 0x27,
  0x69, 0x71, 0x3D, 0x54, 0x71, 0x62, 0x27, 0x71,
  0x54, 0x2D, 0x3D, 0x27, 0x62, 0x3B, 0x3B, 0x3B,
  0x3B, 0x62, 0x62, 0x33, 0x27, 0x27, 0x3B, 0x71,
  0x27, 0x71, 0x27, 0x62, 0x71, 0x6F, 0x27, 0x71,
  0x3B, 0x62, 0x62, 0x6F, 0x62, 0x6F, 0x6F, 0x6F,
  0x6F, 0x69, 0x62, 0x49, 0x69, 0x49, 0x6F, 0x62,
  0x62, 0x49, 0x69, 0x71, 0x6F, 0x6F, 0x6F, 0x69,
  0x69, 0x69, 0x30, 0x29, 0x30, 0x69, 0x44, 0x7B,
  0x3B, 0x3B, 0x3B, 0x62, 0x62, 0x62, 0x62, 0x62,
  0x27, 0x3D, 0x3D, 0x54, 0x71, 0x3D, 0x3D, 0x54,
  0x69, 0x71, 0x3D, 0x71, 0x62, 0x3B, 0x3B, 0x27,
  0x54, 0x54, 0x3D, 0x71, 0x71, 0x71, 0x27, 0x62,
  0x62, 0x62, 0x27, 0x2A, 0x3D, 0x71, 0x3D, 0x71,
  0x3D, 0x62, 0x27, 0x30, 0x30, 0x62, 0x3B, 0x71,
  0x3B, 0x30, 0x30, 0x49, 0x29, 0x30, 0x30, 0x30,
  0x27, 0x49, 0x62, 0x30, 0x6F, 0x30, 0x3B, 0x3B,
  0x6F, 0x3B, 0x49, 0x30, 0x30, 0x3C, 0x3B, 0x49,
  0x30, 0x69, 0x6F, 0x78, 0x30, 0x62, 0x44, 0x7B,
  0x27, 0x62, 0x62, 0x62, 0x71, 0x71, 0x3D, 0x54,
  0x3D, 0x73, 0x66, 0x73, 0x66, 0x73, 0x73, 0x66,
  0x62, 0x66, 0x66, 0x3D, 0x27, 0x3B, 0x3B, 0x71,
  0x3D, 0x3D, 0x3D, 0x54, 0x54, 0x71, 0x3D, 0x3D,
  0x54, 0x73, 0x5D, 0x33, 0x62, 0x27, 0x54, 0x27,
  0x71, 0x3B, 0x71, 0x71, 0x62, 0x3B, 0x54, 0x3B,
  0x71, 0x6F, 0x62, 0x62, 0x62, 0x62, 0x69, 0x71,
  0x71, 0x6F, 0x3B, 0x71, 0x30, 0x62, 0x71, 0x6F,
  0x3B, 0x62, 0x6F, 0x62, 0x6F, 0x69, 0x6F, 0x69,
  0x6F, 0x30, 0x49, 0x3C, 0x69, 0x3B, 0x79, 0x21,
  0x20, 0x3D, 0x54, 0x73, 0x5D, 0x5D, 0x5D, 0x40,
  0x40, 0x73, 0x73, 0x73, 0x2D, 0x66, 0x66, 0x3D,
  0x3D, 0x54, 0x54, 0x3D, 0x71, 0x27, 0x62, 0x27,
  0x71, 0x71, 0x3D, 0x54, 0x54, 0x3D, 0x3D, 0x54,
  0x5D, 0x6A, 0x77, 0x46, 0x71, 0x2D, 0x54, 0x27,
  0x54, 0x3B, 0x3B, 0x3B, 0x6F, 0x3B, 0x71, 0x27,
  0x3B, 0x27, 0x3B, 0x3B, 0x27, 0x27, 0x3B, 0x3B,
  0x3B, 0x62, 0x3D, 0x62, 0x3D, 0x27, 0x3B, 0x54,
  0x3B, 0x2D, 0x49, 0x3B, 0x3B, 0x29, 0x49, 0x3C,
  0x53, 0x69, 0x53, 0x3C, 0x78, 0x3D, 0x78, 0x5D,
  0x20, 0x66, 0x5D, 0x6A, 0x47, 0x77, 0x4C, 0x5D,
  0x66, 0x3D, 0x3D, 0x66, 0x73, 0x66, 0x3D, 0x62,
  0x62, 0x62, 0x71, 0x3D, 0x71, 0x27, 0x27, 0x27,
  0x71, 0x71, 0x71, 0x3D, 0x3D, 0x71, 0x71, 0x73,
  0x7A, 0x77, 0x47, 0x46, 0x27, 0x73, 0x27, 0x54,
  0x3D, 0x71, 0x62, 0x6F, 0x27, 0x71, 0x27, 0x71,
  0x71, 0x71, 0x62, 0x62, 0x71, 0x71, 0x71, 0x62,
  0x62, 0x3B, 0x69, 0x49, 0x62, 0x6F, 0x62, 0x3D,
  0x6F, 0x6F, 0x62, 0x78, 0x2A, 0x20, 0x6B, 0x20,
  0x2A, 0x20, 0x20, 0x2A, 0x3B, 0x6F, 0x3C, 0x4C,
  0x20, 0x20, 0x7A, 0x77, 0x47, 0x6A, 0x5D, 0x54,
  0x27, 0x6F, 0x3B, 0x54, 0x40, 0x2D, 0x71, 0x6F,
  0x49, 0x6F, 0x27, 0x3D, 0x71, 0x62, 0x62, 0x3B,
  0x62, 0x27, 0x71, 0x3D, 0x3D, 0x71, 0x71, 0x66,
  0x7A, 0x34, 0x6A, 0x46, 0x27, 0x5D, 0x3D, 0x54,
  0x3D, 0x3D, 0x3D, 0x62, 0x27, 0x71, 0x27, 0x3D,
  0x3B, 0x3D, 0x30, 0x27, 0x27, 0x3B, 0x27, 0x3D,
  0x20, 0x20, 0x2A, 0x46, 0x46, 0x2A, 0x35, 0x2A,
  0x46, 0x46, 0x23, 0x2A, 0x7A, 0x4F, 0x4F, 0x6B,
  0x6B, 0x4F, 0x4F, 0x62, 0x3B, 0x62, 0x78, 0x20,
  0x20, 0x20, 0x7A, 0x34, 0x34, 0x40, 0x54, 0x71,
  0x3B, 0x69, 0x6F, 0x40, 0x7A, 0x66, 0x62, 0x69,
  0x3C, 0x3B, 0x71, 0x3D, 0x27, 0x3B, 0x6F, 0x27,
  0x71, 0x3D, 0x3D, 0x66, 0x2D, 0x3D, 0x62, 0x27,
  0x2D, 0x4C, 0x7A, 0x33, 0x27, 0x3D, 0x54, 0x2D,
  0x54, 0x62, 0x54, 0x27, 0x54, 0x27, 0x54, 0x71,
  0x62, 0x71, 0x71, 0x62, 0x62, 0x54, 0x71, 0x62,
  0x7A, 0x6B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x35, 0x57,
  0x6B, 0x20, 0x20, 0x30, 0x6F, 0x27, 0x29, 0x20,
  0x20, 0x20, 0x66, 0x4C, 0x7A, 0x54, 0x62, 0x3B,
  0x6F, 0x30, 0x71, 0x7A, 0x4C, 0x3D, 0x69, 0x78,
  0x53, 0x3D, 0x73, 0x2D, 0x71, 0x62, 0x3B, 0x71,
  0x3D, 0x2D, 0x2D, 0x40, 0x73, 0x3D, 0x27, 0x71,
  0x40, 0x6A, 0x20, 0x20, 0x71, 0x2D, 0x62, 0x2D,
  0x3D, 0x3B, 0x71, 0x27, 0x54, 0x27, 0x3D, 0x3D,
  0x27, 0x2D, 0x27, 0x3D, 0x3B, 0x2D, 0x3D, 0x3B,
  0x34, 0x2D, 0x77, 0x6A, 0x77, 0x2D, 0x6A, 0x7A,
  0x5D, 0x6A, 0x5D, 0x54, 0x71, 0x44, 0x6D, 0x6D,
  0x6D, 0x38, 0x26, 0x30, 0x54, 0x62, 0x20, 0x20,
  0x20, 0x20, 0x40, 0x6A, 0x4C, 0x54, 0x6F, 0x69,
  0x30, 0x62, 0x40, 0x6A, 0x21, 0x62, 0x49, 0x29,
  0x71, 0x4C, 0x34, 0x5D, 0x71, 0x3B, 0x27, 0x71,
  0x54, 0x54, 0x40, 0x40, 0x73, 0x3D, 0x3D, 0x40,
  0x6A, 0x20, 0x20, 0x33, 0x2D, 0x73, 0x40, 0x4E,
  0x77, 0x7A, 0x3D, 0x54, 0x2D, 0x54, 0x71, 0x54,
  0x62, 0x71, 0x71, 0x62, 0x71, 0x71, 0x71, 0x71,
  0x2D, 0x3B, 0x27, 0x3B, 0x49, 0x6F, 0x3B, 0x3B,
  0x27, 0x3B, 0x3B, 0x30, 0x49, 0x53, 0x6F, 0x6F,
  0x69, 0x3B, 0x6F, 0x53, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x6A, 0x77, 0x21, 0x27, 0x30, 0x30,
  0x6F, 0x71, 0x66, 0x73, 0x3D, 0x30, 0x49, 0x30,
  0x5D, 0x34, 0x34, 0x40, 0x27, 0x6F, 0x62, 0x3D,
  0x54, 0x66, 0x40, 0x73, 0x2D, 0x66, 0x2D, 0x5D,
  0x7A, 0x20, 0x20, 0x56, 0x20, 0x54, 0x5D, 0x5E,
  0x33, 0x71, 0x3D, 0x62, 0x27, 0x3B, 0x27, 0x30,
  0x3B, 0x3D, 0x27, 0x3D, 0x3D, 0x3D, 0x3B, 0x73,
  0x54, 0x62, 0x62, 0x62, 0x30, 0x6F, 0x71, 0x6F,
  0x6F, 0x6F, 0x6F, 0x71, 0x62, 0x3B, 0x3B, 0x49,
  0x3B, 0x3B, 0x3B, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x7A, 0x21, 0x54, 0x3B, 0x69, 0x69,
  0x30, 0x62, 0x27, 0x71, 0x62, 0x30, 0x30, 0x6F,
  0x4C, 0x77, 0x6A, 0x66, 0x62, 0x6F, 0x62, 0x71,
  0x54, 0x66, 0x2D, 0x73, 0x66, 0x54, 0x73, 0x73,
  0x73, 0x20, 0x20, 0x7E, 0x20, 0x3D, 0x27, 0x6B,
  0x35, 0x21, 0x54, 0x3D, 0x71, 0x71, 0x54, 0x62,
  0x62, 0x71, 0x71, 0x69, 0x71, 0x54, 0x54, 0x30,
  0x27, 0x3B, 0x3B, 0x3B, 0x6F, 0x30, 0x3B, 0x30,
  0x3B, 0x30, 0x30, 0x27, 0x30, 0x6F, 0x62, 0x69,
  0x6F, 0x6F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x73, 0x3D, 0x62, 0x6F, 0x69, 0x69,
  0x6F, 0x71, 0x3D, 0x71, 0x27, 0x62, 0x62, 0x27,
  0x4C, 0x4C, 0x5D, 0x71, 0x30, 0x69, 0x3B, 0x71,
  0x54, 0x66, 0x73, 0x66, 0x66, 0x66, 0x54, 0x3D,
  0x71, 0x20, 0x20, 0x7E, 0x20, 0x20, 0x21, 0x62,
  0x69, 0x27, 0x5D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3B,
  0x3D, 0x3D, 0x27, 0x3B, 0x27, 0x3D, 0x71, 0x6F,
  0x54, 0x62, 0x6F, 0x30, 0x6F, 0x6F, 0x62, 0x6F,
  0x62, 0x62, 0x62, 0x62, 0x3B, 0x3B, 0x27, 0x3B,
  0x30, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x27, 0x3B, 0x6F, 0x30, 0x6F, 0x6F,
  0x62, 0x3D, 0x66, 0x54, 0x54, 0x71, 0x71, 0x71,
  0x5D, 0x5D, 0x54, 0x3B, 0x69, 0x69, 0x3B, 0x71,
  0x54, 0x40, 0x73, 0x66, 0x54, 0x3D, 0x71, 0x62,
  0x6F, 0x20, 0x20, 0x39, 0x20, 0x20, 0x20, 0x2D,
  0x2D, 0x73, 0x40, 0x54, 0x54, 0x54, 0x71, 0x73,
  0x54, 0x73, 0x71, 0x54, 0x54, 0x54, 0x27, 0x3B,
  0x3D, 0x3B, 0x27, 0x62, 0x3B, 0x3B, 0x3B, 0x27,
  0x27, 0x3B, 0x3B, 0x27, 0x62, 0x62, 0x71, 0x62,
  0x71, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3B, 0x6F, 0x30, 0x6F, 0x3B, 0x27,
  0x3D, 0x66, 0x66, 0x54, 0x71, 0x71, 0x27, 0x71,
  0x66, 0x73, 0x54, 0x27, 0x6F, 0x6F, 0x27, 0x54,
  0x40, 0x21, 0x5D, 0x73, 0x3D, 0x27, 0x62, 0x3B,
  0x3B, 0x42, 0x74, 0x52, 0x52, 0x6E, 0x20, 0x20,
  0x40, 0x54, 0x3D, 0x3D, 0x3D, 0x40, 0x27, 0x3B,
  0x30, 0x40, 0x27, 0x27, 0x27, 0x71, 0x54, 0x6F,
  0x5D, 0x6F, 0x3B, 0x71, 0x71, 0x6F, 0x73, 0x6F,
  0x54, 0x6F, 0x54, 0x27, 0x39, 0x6E, 0x6E, 0x3B,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3B, 0x3B, 0x3B, 0x62, 0x27, 0x71,
  0x3D, 0x3D, 0x3D, 0x27, 0x62, 0x27, 0x62, 0x27,
  0x3D, 0x40, 0x54, 0x27, 0x3B, 0x3B, 0x27, 0x73,
  0x7A, 0x21, 0x40, 0x54, 0x71, 0x62, 0x6F, 0x6F,
  0x3B, 0x67, 0x3A, 0x3A, 0x5A, 0x48, 0x3A, 0x20,
  0x20, 0x53, 0x6D, 0x38, 0x38, 0x6D, 0x38, 0x38,
  0x6D, 0x38, 0x79, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x6D, 0x67, 0x52, 0x41, 0x22, 0x2F,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4F, 0x6B,
  0x43, 0x3A, 0x3B, 0x27, 0x27, 0x62, 0x27, 0x71,
  0x71, 0x71, 0x71, 0x3D, 0x71, 0x71, 0x3D, 0x3D,
  0x27, 0x40, 0x54, 0x27, 0x30, 0x30, 0x27, 0x40,
  0x7A, 0x5D, 0x54, 0x71, 0x3B, 0x30, 0x30, 0x3B,
  0x42, 0x67, 0x67, 0x3E, 0x3A, 0x48, 0x22, 0x5A,
  0x4F, 0x20, 0x2D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x6D, 0x6D, 0x26, 0x6D, 0x38, 0x6D, 0x38, 0x6D,
  0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x38, 0x6D, 0x38,
  0x6D, 0x38, 0x38, 0x3E, 0x55, 0x6C, 0x22, 0x73,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D,
  0x5A, 0x45, 0x36, 0x3D, 0x71, 0x27, 0x27, 0x71,
  0x54, 0x66, 0x73, 0x40, 0x73, 0x66, 0x2D, 0x66,
  0x30, 0x66, 0x71, 0x30, 0x69, 0x6F, 0x3D, 0x21,
  0x7A, 0x66, 0x3D, 0x62, 0x3B, 0x6F, 0x3B, 0x28,
  0x67, 0x52, 0x5A, 0x74, 0x41, 0x3A, 0x74, 0x3A,
  0x52, 0x20, 0x20, 0x7E, 0x38, 0x6D, 0x6D, 0x6D,
  0x6D, 0x38, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D,
  0x6D, 0x6D, 0x6D, 0x2F, 0x52, 0x22, 0x28, 0x50,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2E,
  0x41, 0x5A, 0x5A, 0x66, 0x54, 0x3D, 0x54, 0x66,
  0x73, 0x40, 0x40, 0x40, 0x73, 0x66, 0x66, 0x3D,
  0x69, 0x27, 0x3B, 0x30, 0x30, 0x62, 0x73, 0x7A,
  0x21, 0x3D, 0x3B, 0x6F, 0x6F, 0x62, 0x2F, 0x75,
  0x28, 0x55, 0x22, 0x3A, 0x31, 0x3A, 0x41, 0x3A,
  0x5A, 0x2E, 0x20, 0x4F, 0x20, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x6D, 0x6D, 0x78, 0x2F, 0x31, 0x55, 0x2E, 0x3F,
  0x50, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x24, 0x52,
  0x22, 0x22, 0x31, 0x2D, 0x66, 0x54, 0x66, 0x66,
  0x66, 0x66, 0x54, 0x71, 0x27, 0x27, 0x27, 0x62,
  0x30, 0x3B, 0x3B, 0x6F, 0x3B, 0x3D, 0x40, 0x21,
  0x73, 0x71, 0x5F, 0x6E, 0x2E, 0x2E, 0x67, 0x52,
  0x52, 0x31, 0x7D, 0x48, 0x3A, 0x3A, 0x74, 0x74,
  0x55, 0x39, 0x20, 0x20, 0x20, 0x20, 0x38, 0x6D,
  0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D,
  0x6D, 0x29, 0x29, 0x2F, 0x55, 0x52, 0x2E, 0x24,
  0x72, 0x68, 0x25, 0x76, 0x68, 0x3F, 0x2E, 0x39,
  0x52, 0x74, 0x3A, 0x73, 0x66, 0x66, 0x54, 0x54,
  0x27, 0x3B, 0x6F, 0x6F, 0x6F, 0x6F, 0x3B, 0x62,
  0x3B, 0x62, 0x27, 0x71, 0x54, 0x40, 0x21, 0x40,
  0x3D, 0x2E, 0x48, 0x6E, 0x55, 0x55, 0x6E, 0x55,
  0x3A, 0x74, 0x3E, 0x55, 0x74, 0x5A, 0x22, 0x3A,
  0x3A, 0x36, 0x2E, 0x20, 0x20, 0x20, 0x20, 0x38,
  0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x38, 0x6D, 0x38, 0x38, 0x6D, 0x38, 0x6D, 0x38,
  0x6D, 0x32, 0x78, 0x62, 0x3E, 0x52, 0x28, 0x42,
  0x65, 0x24, 0x5F, 0x24, 0x5F, 0x2E, 0x55, 0x22,
  0x3A, 0x41, 0x74, 0x31, 0x54, 0x73, 0x66, 0x54,
  0x27, 0x6F, 0x30, 0x69, 0x30, 0x6F, 0x62, 0x62,
  0x62, 0x71, 0x3D, 0x54, 0x73, 0x5D, 0x5D, 0x66,
  0x71, 0x2E, 0x22, 0x31, 0x55, 0x3A, 0x31, 0x5A,
  0x3A, 0x3A, 0x74, 0x5A, 0x74, 0x3E, 0x31, 0x3A,
  0x55, 0x22, 0x22, 0x35, 0x20, 0x20, 0x20, 0x20,
  0x34, 0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x38, 0x6D,
  0x6D, 0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x38, 0x79, 0x29, 0x2F, 0x42, 0x52, 0x28, 0x48,
  0x48, 0x2E, 0x2E, 0x48, 0x3E, 0x52, 0x3A, 0x74,
  0x7D, 0x3A, 0x3A, 0x3E, 0x40, 0x40, 0x40, 0x54,
  0x27, 0x6F, 0x30, 0x6F, 0x62, 0x71, 0x71, 0x71,
  0x62, 0x3D, 0x66, 0x73, 0x40, 0x5D, 0x73, 0x71,
  0x62, 0x28, 0x55, 0x5A, 0x5A, 0x55, 0x3A, 0x41,
  0x55, 0x3A, 0x3A, 0x31, 0x55, 0x55, 0x5A, 0x74,
  0x3A, 0x31, 0x22, 0x48, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D,
  0x6D, 0x6D, 0x29, 0x2F, 0x24, 0x28, 0x28, 0x52,
  0x52, 0x48, 0x48, 0x28, 0x39, 0x52, 0x74, 0x48,
  0x74, 0x55, 0x22, 0x41, 0x5A, 0x40, 0x54, 0x27,
  0x3B, 0x6F, 0x3B, 0x71, 0x54, 0x66, 0x66, 0x3D,
  0x62, 0x54, 0x40, 0x21, 0x7A, 0x40, 0x3D, 0x62,
  0x62, 0x48, 0x52, 0x55, 0x6C, 0x5A, 0x31, 0x31,
  0x5A, 0x41, 0x31, 0x3A, 0x3A, 0x7D, 0x31, 0x3A,
  0x41, 0x41, 0x22, 0x36, 0x42, 0x20, 0x20, 0x20,
  0x20, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x6D, 0x6D, 0x29, 0x25, 0x59, 0x2E, 0x39, 0x39,
  0x55, 0x39, 0x39, 0x39, 0x31, 0x22, 0x3A, 0x74,
  0x5A, 0x3E, 0x6C, 0x3E, 0x31, 0x3E, 0x3A, 0x69,
  0x49, 0x49, 0x3B, 0x71, 0x66, 0x73, 0x66, 0x54,
  0x27, 0x66, 0x5D, 0x7A, 0x21, 0x73, 0x71, 0x62,
  0x27, 0x75, 0x39, 0x41, 0x3A, 0x36, 0x7D, 0x74,
  0x74, 0x41, 0x55, 0x55, 0x3A, 0x3A, 0x3A, 0x3A,
  0x31, 0x31, 0x5A, 0x22, 0x52, 0x20, 0x20, 0x20,
  0x26, 0x38, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x38,
  0x6D, 0x38, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x38,
  0x38, 0x6D, 0x20, 0x60, 0x24, 0x48, 0x39, 0x3A,
  0x55, 0x55, 0x31, 0x55, 0x41, 0x74, 0x41, 0x22,
  0x7D, 0x3A, 0x22, 0x3E, 0x41, 0x5A, 0x3A, 0x74,
  0x78, 0x30, 0x27, 0x54, 0x40, 0x73, 0x54, 0x3D,
  0x71, 0x54, 0x5D, 0x7A, 0x21, 0x66, 0x62, 0x3B,
  0x71, 0x5F, 0x52, 0x3E, 0x41, 0x5A, 0x5A, 0x22,
  0x3E, 0x3A, 0x74, 0x3E, 0x55, 0x55, 0x3A, 0x31,
  0x41, 0x3A, 0x48, 0x55, 0x41, 0x42, 0x6D, 0x38,
  0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x6D,
  0x38, 0x6D, 0x6D, 0x38, 0x6D, 0x38, 0x6D, 0x6D,
  0x6D, 0x20, 0x20, 0x25, 0x24, 0x28, 0x52, 0x3A,
  0x5A, 0x5A, 0x5A, 0x5A, 0x74, 0x74, 0x7D, 0x74,
  0x3A, 0x74, 0x3A, 0x41, 0x7D, 0x41, 0x3A, 0x3A,
  0x69, 0x3D, 0x21, 0x4C, 0x4C, 0x5D, 0x66, 0x54,
  0x66, 0x73, 0x21, 0x6A, 0x21, 0x3D, 0x3B, 0x6F,
  0x71, 0x75, 0x48, 0x31, 0x5A, 0x3A, 0x3E, 0x48,
  0x74, 0x7D, 0x3A, 0x7D, 0x3A, 0x3A, 0x55, 0x74,
  0x5A, 0x3A, 0x41, 0x55, 0x22, 0x22, 0x3F, 0x6D,
  0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D,
  0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x38,
  0x20, 0x20, 0x20, 0x60, 0x42, 0x28, 0x39, 0x3A,
  0x3A, 0x31, 0x41, 0x3A, 0x22, 0x55, 0x74, 0x55,
  0x74, 0x74, 0x74, 0x3A, 0x3A, 0x74, 0x3A, 0x67,
  0x54, 0x7A, 0x34, 0x77, 0x6A, 0x21, 0x66, 0x66,
  0x7A, 0x21, 0x21, 0x4C, 0x21, 0x3D, 0x3B, 0x62,
  0x66, 0x67, 0x28, 0x55, 0x41, 0x31, 0x55, 0x3A,
  0x74, 0x41, 0x31, 0x3A, 0x3A, 0x41, 0x3A, 0x36,
  0x5A, 0x5A, 0x31, 0x31, 0x39, 0x22, 0x24, 0x43,
  0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x38, 0x6D, 0x6D,
  0x6D, 0x38, 0x6D, 0x6D, 0x6D, 0x38, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x60, 0x24, 0x63, 0x39, 0x55,
  0x31, 0x5A, 0x3A, 0x74, 0x3A, 0x31, 0x3A, 0x31,
  0x5A, 0x48, 0x3A, 0x7D, 0x48, 0x41, 0x31, 0x3E,
  0x6A, 0x64, 0x47, 0x4C, 0x5D, 0x54, 0x71, 0x71,
  0x6A, 0x5D, 0x5D, 0x21, 0x5D, 0x3D, 0x3B, 0x62,
  0x66, 0x42, 0x39, 0x3A, 0x41, 0x3A, 0x31, 0x3A,
  0x7D, 0x3A, 0x74, 0x41, 0x31, 0x31, 0x3E, 0x41,
  0x5A, 0x41, 0x3A, 0x31, 0x39, 0x52, 0x48, 0x25,
  0x62, 0x6D, 0x38, 0x38, 0x6D, 0x38, 0x6D, 0x6D,
  0x6D, 0x6D, 0x6D, 0x6D, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x4D, 0x43, 0x5F, 0x28, 0x52, 0x3E,
  0x22, 0x31, 0x3A, 0x3A, 0x55, 0x3A, 0x3E, 0x31,
  0x74, 0x67, 0x3E, 0x3A, 0x3E, 0x67, 0x54, 0x34,
  0x2B, 0x2B, 0x34, 0x21, 0x66, 0x71, 0x62, 0x62,
  0x3D, 0x3D, 0x54, 0x5D, 0x40, 0x27, 0x6F, 0x3B,
  0x67, 0x48, 0x48, 0x39, 0x52, 0x7D, 0x7D, 0x22,
  0x74, 0x3A, 0x5A, 0x5A, 0x3A, 0x55, 0x31, 0x3A,
  0x41, 0x7D, 0x3A, 0x22, 0x55, 0x48, 0x42, 0x76,
  0x4B, 0x20, 0x37, 0x6D, 0x6D, 0x6D, 0x38, 0x78,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x4D, 0x76, 0x42, 0x48, 0x55, 0x74,
  0x41, 0x6C, 0x48, 0x31, 0x31, 0x3A, 0x5A, 0x74,
  0x31, 0x6C, 0x22, 0x3E, 0x67, 0x62, 0x7A, 0x64,
  0x7B, 0x77, 0x5D, 0x54, 0x71, 0x62, 0x62, 0x3B,
  0x53, 0x62, 0x71, 0x73, 0x73, 0x27, 0x6F, 0x3B,
  0x67, 0x2E, 0x5F, 0x48, 0x48, 0x52, 0x52, 0x52,
  0x52, 0x52, 0x31, 0x41, 0x74, 0x41, 0x74, 0x31,
  0x74, 0x3A, 0x74, 0x74, 0x48, 0x48, 0x42, 0x72,
  0x4B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x4B, 0x68, 0x42, 0x28, 0x55, 0x74,
  0x5A, 0x3A, 0x48, 0x55, 0x5A, 0x31, 0x55, 0x55,
  0x39, 0x67, 0x2F, 0x49, 0x69, 0x27, 0x4C, 0x64,
  0x34, 0x5D, 0x66, 0x71, 0x62, 0x6F, 0x6F, 0x6F,
  0x79, 0x27, 0x66, 0x73, 0x66, 0x27, 0x6F, 0x3B,
  0x54, 0x24, 0x5F, 0x59, 0x24, 0x24, 0x42, 0x2E,
  0x48, 0x67, 0x28, 0x39, 0x52, 0x39, 0x31, 0x3E,
  0x55, 0x3A, 0x3A, 0x31, 0x39, 0x48, 0x24, 0x76,
  0x50, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x4B, 0x76, 0x24, 0x42, 0x52, 0x55,
  0x41, 0x31, 0x31, 0x39, 0x52, 0x52, 0x48, 0x67,
  0x72, 0x71, 0x6F, 0x69, 0x58, 0x2D, 0x4C, 0x34,
  0x7A, 0x40, 0x66, 0x54, 0x62, 0x30, 0x6F, 0x3B,
  0x53, 0x7A, 0x7A, 0x73, 0x3D, 0x62, 0x30, 0x6F,
  0x3D, 0x3D, 0x3B, 0x60, 0x2F, 0x76, 0x59, 0x59,
  0x59, 0x24, 0x24, 0x5F, 0x42, 0x2E, 0x28, 0x55,
  0x3A, 0x39, 0x39, 0x48, 0x48, 0x65, 0x68, 0x25,
  0x4B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x4B, 0x25, 0x72, 0x65, 0x2E, 0x28,
  0x52, 0x28, 0x48, 0x48, 0x2E, 0x24, 0x3F, 0x4B,
  0x71, 0x27, 0x30, 0x30, 0x27, 0x5D, 0x4C, 0x6A,
  0x7A, 0x7A, 0x5D, 0x54, 0x3B, 0x30, 0x6F, 0x71,
  0x27, 0x64, 0x34, 0x40, 0x3D, 0x62, 0x3B, 0x27,
  0x3D, 0x54, 0x71, 0x3B, 0x3B, 0x62, 0x71, 0x4B,
  0x43, 0x43, 0x76, 0x76, 0x72, 0x59, 0x24, 0x24,
  0x42, 0x2E, 0x42, 0x24, 0x2C, 0x76, 0x60, 0x50,
  0x4D, 0x20, 0x20, 0x20, 0x20, 0x62, 0x27, 0x3D,
  0x3D, 0x27, 0x62, 0x62, 0x27, 0x27, 0x62, 0x30,
  0x20, 0x20, 0x4B, 0x25, 0x76, 0x59, 0x24, 0x24,
  0x42, 0x42, 0x42, 0x65, 0x3F, 0x60, 0x6F, 0x62,
  0x27, 0x27, 0x62, 0x3B, 0x3D, 0x5D, 0x7A, 0x4C,
  0x4C, 0x4C, 0x5D, 0x71, 0x30, 0x69, 0x62, 0x54,
  0x7A, 0x2B, 0x34, 0x2D, 0x71, 0x27, 0x58, 0x62,
  0x71, 0x3D, 0x71, 0x6F, 0x30, 0x6F, 0x27, 0x54,
  0x3D, 0x71, 0x66, 0x4B, 0x25, 0x60, 0x76, 0x76,
  0x72, 0x72, 0x3F, 0x76, 0x76, 0x60, 0x50, 0x4B,
  0x20, 0x73, 0x3D, 0x62, 0x3B, 0x27, 0x71, 0x3D,
  0x3D, 0x71, 0x27, 0x62, 0x62, 0x27, 0x62, 0x3B,
  0x30, 0x27, 0x4D, 0x4B, 0x25, 0x76, 0x72, 0x2C,
  0x59, 0x2C, 0x3F, 0x76, 0x25, 0x62, 0x30, 0x3B,
  0x71, 0x3D, 0x71, 0x71, 0x66, 0x5D, 0x5D, 0x21,
  0x21, 0x21, 0x54, 0x30, 0x78, 0x69, 0x27, 0x66,
  0x7A, 0x4C, 0x5D, 0x3D, 0x27, 0x62, 0x62, 0x3B,
  0x62, 0x3D, 0x27, 0x6F, 0x30, 0x3B, 0x71, 0x54,
  0x3D, 0x3D, 0x54, 0x66, 0x66, 0x66, 0x4B, 0x25,
  0x25, 0x25, 0x25, 0x60, 0x25, 0x50, 0x4B, 0x71,
  0x54, 0x54, 0x71, 0x27, 0x3D, 0x54, 0x54, 0x3D,
  0x3D, 0x71, 0x3B, 0x3B, 0x62, 0x3B, 0x62, 0x3B,
  0x27, 0x54, 0x4C, 0x4D, 0x4B, 0x25, 0x76, 0x76,
  0x68, 0x43, 0x25, 0x50, 0x27, 0x30, 0x30, 0x58,
  0x27, 0x54, 0x54, 0x3D, 0x54, 0x54, 0x66, 0x54,
  0x66, 0x71, 0x6F, 0x78, 0x53, 0x69, 0x54, 0x73,
  0x66, 0x66, 0x54, 0x27, 0x27, 0x27, 0x62, 0x3B,
  0x3B, 0x27, 0x27, 0x3B, 0x6F, 0x62, 0x27, 0x54,
  0x66, 0x3D, 0x3D, 0x27, 0x27, 0x27, 0x62, 0x6F,
  0x78, 0x53, 0x78, 0x62, 0x66, 0x73, 0x3D, 0x3D,
  0x66, 0x2D, 0x54, 0x54, 0x73, 0x73, 0x54, 0x71,
  0x71, 0x27, 0x3B, 0x6F, 0x3B, 0x3B, 0x62, 0x3B,
  0x3B, 0x71, 0x73, 0x73, 0x54, 0x71, 0x62, 0x27,
  0x27, 0x58, 0x62, 0x71, 0x71, 0x6F, 0x6F, 0x62,
  0x27, 0x54, 0x66, 0x3D, 0x3D, 0x27, 0x27, 0x62,
  0x62, 0x6F, 0x78, 0x53, 0x78, 0x62, 0x54, 0x66,
  0x71, 0x3D, 0x71, 0x71, 0x62, 0x27, 0x27, 0x62,
  0x62, 0x71, 0x3D, 0x27, 0x27, 0x62, 0x27, 0x3D,
  0x54, 0x3D, 0x27, 0x62, 0x3B, 0x6F, 0x6F, 0x69,
  0x78, 0x78, 0x6F, 0x54, 0x73, 0x66, 0x54, 0x54,
  0x40, 0x5D, 0x40, 0x40, 0x40, 0x66, 0x3D, 0x71,
  0x27, 0x27, 0x3B, 0x30, 0x6F, 0x3B, 0x3B, 0x62,
  0x3B, 0x3B, 0x27, 0x71, 0x71, 0x27, 0x62, 0x62,
  0x62, 0x62, 0x62, 0x71, 0x71, 0x71, 0x62, 0x62,
  0x27, 0x71, 0x54, 0x3D, 0x27, 0x62, 0x3B, 0x6F,
  0x6F, 0x69, 0x49, 0x49, 0x6F, 0x3D, 0x73, 0x66
};

#endif

#else

#define LINUX_LOGO_COLORS 214

#endif

#ifdef INCLUDE_LINUX_LOGO_DATA

#define INCLUDE_LINUX_LOGOBW
#define INCLUDE_LINUX_LOGO16
#include <linux/linux_logo.h>

#else

/* prototypes only */
extern unsigned char linux_logo_red[];
extern unsigned char linux_logo_green[];
extern unsigned char linux_logo_blue[];
extern unsigned char linux_logo[];
extern unsigned char linux_logo_bw[];
extern unsigned char linux_logo16_red[];
extern unsigned char linux_logo16_green[];
extern unsigned char linux_logo16_blue[];
extern unsigned char linux_logo16[];

#endif
