/* GNU xhippo: a GTK-based playlist manager.
   (c) 1998-2000 Adam Sampson, azz@gnu.org

   Please report bugs to bug-xhippo@gnu.org.

   This program is free software, released under the GNU General
   Public License. You may redistribute and/or modify this program
   under the terms of that license as published by the Free Software
   Foundation; either version 2 of the License, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   To get a copy of the GNU General Public License, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA, or see http://www.gnu.org/.
*/

/* User-changable options. */

/* The maximum number of filetypes you can have. Doubt you'll need more. */
#define MAXFILETYPES 100

/*---No user-servicable parts below this line!---*/

/* Localisation */

#ifndef LANG_DEUTSCH
/* English locale by Adam Sampson. */
#define STRBADOPTION "Unknown option \"%c\". xhippo -h for help.\n"
#define STRGUESSTYPE "Unable to guess type."
#define STRPLAYINGWITHPID "Playing with %s (pid %d)."
#define STRPLAYINGWITH "Playing with %s."
#define STRNOSTART "Unable to start player \"%s\".\n"
#define STRNOITEMS "No items to pick from!"
#define STRSTOPPED "Stopped."
#define STRDONE "All items played."
#define STRPAUSED "Paused."
#define STRRESUMEPLAY "Resuming play."
#define STRNOFIND "Couldn't find \"%s\".\n"
#define STRNOTFILE "\"%s\" isn't a regular file.\n"
#define STRWELCOME "Welcome to xhippo!"
#define STRMINI "Mini"
#define STRMINITIP "Toggle the size of the window"
#define STRRESTART "Restart"
#define STRRESTARTTIP "Restart the current song"
#define STRSTOP "Stop"
#define STRSTOPTIP "Stop playing"
#define STRPAUSE "Pause"
#define STRPAUSETIP "Pause playing"
#define STRRANDOM "Random"
#define STRNEXT "Next"
#define STRNEXTTIP "Play the next song"
#define STRINFO "Song information"
#define STRUP "Move song up"
#define STRDOWN "Move song down"
#define STRADD "Add song"
#define STRDELETE "Remove song"
#define STRLOAD "Load playlist"
#define STRSAVE "Save playlist"
#define STRSORTNAME "Sort playlist by name"
#define STRSORTMTIME "Sort playlist by mtime"
#define STRCLEAR "Clear playlist"
#define STRNOPLAYLIST "Couldn't open playlist \"%s\"!\n"
#define STRNUMFILES "%d files in list."
#define STRPICKPLAYLIST "Load playlist"
#define STRSAVEPLAYLIST "Save playlist"
#define STRNOWINSTATE "Couldn't write to $HOME/.xhippo/winstate.\n"
#define STRSETHOME "You must set $HOME to your home directory.\n"
#define STRINFOTITLE "Song information"
#define STRINFONAME "Name:"
#define STRINFOFILENAME "Filename:"
#define STRINFOLASTMODIFIED "Last modified:"
#define STRINFOFILESIZE "File size:"
#define STRINFOCLOSE "Close"
#else
/* German locale courtesy of Volker Assmann, volka@bigfoot.de, and
   Markus Kohls, markusk@bnet-ibb.de. */
#define STRBADOPTION "Unbekannte Option \"%c\". Hilfe mit xhippo -h.\n"
#define STRGUESSTYPE "Unbekannter Dateityp."
#define STRPLAYINGWITHPID "Abspielen durch %s (pid %d)."
#define STRPLAYINGWITH "Abspielen durch %s."
#define STRNOSTART "Player \"%s\" funktioniert nicht.\n"
#define STRNOITEMS "Keine Playlist geladen!"
#define STRSTOPPED "Gestoppt."
#define STRDONE "Alle Lieder gespielt."
#define STRPAUSED "Pause."
#define STRRESUMEPLAY "Fahre mit dem Abspielen fort."
#define STRNOFIND "Kann \"%s\" nicht finden.\n"
#define STRNOTFILE "\"%s\" ist keine normale Datei.\n"
#define STRWELCOME "Wilkommen im xhippo!"
#define STRMINI "Mini"
#define STRMINITIP "Groesse des Fensters aendern"
#define STRRESTART "Neustart"
#define STRRESTARTTIP "Lied wiederholen."
#define STRSTOP "Stop"
#define STRSTOPTIP "Lied anhalten."
#define STRPAUSE "Pause"
#define STRPAUSETIP "Lied pausieren."
#define STRRANDOM "Zufllig"
#define STRNEXT "Vor"
#define STRNEXTTIP "Naechstes Lied auswaehlen."
#define STRNOPLAYLIST "Konnte Playlist \"%s\" nicht oeffnen!\n"
#define STRNUMFILES "%d Lieder in der Playlist."
#define STRPICKPLAYLIST "Playlist waehlen"
#define STRSAVEPLAYLIST "Playlist speichern"
#define STRNOWINSTATE "Konnte $HOME/.xhippo/winstate nicht schreiben.\n"
#define STRINFO "Information"
#define STRUP "Nach Oben"
#define STRDOWN "Nach Unten"
#define STRLOAD "Laden"
#define STRSAVE "Speichern"
#define STRSORTNAME "Sortieren (Name)"
#define STRSORTMTIME "Sortieren (mtime)"
#define STRCLEAR "Alles loeschen"
#define STRADD "Hinzufuegen"
#define STRDELETE "Loeschen"
#define STRSETHOME "$HOME muss auf Home-Verzeichnis zeigen.\n"
#define STRINFOTITLE "Song Information"
#define STRINFONAME "Name:"
#define STRINFOFILENAME "Filename:"
#define STRINFOLASTMODIFIED "Zuletzt geaendert:"
#define STRINFOFILESIZE "Filegroesse:"
#define STRINFOCLOSE "Close"
#endif


