/* 
   Defines.c

   This program creates Defines.h which contains #defines
   for the Windows32 API Library.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

/*
  You want to include in windows.h from some other compiler
  otherwise you will just recursive create the #defines
  */

// Define OEMRESOURCE so that OBM_* are defined
#define OEMRESOURCE

#ifndef _WIN32
#define _WIN32
#endif

#include <windows.h>
#include <stdio.h>

int main()
{
  printf("/* WARNING:  This file is automatically generated. */\n\n");

  printf("#ifndef _GNU_H_WINDOWS32_DEFINES\n");
  printf("#define _GNU_H_WINDOWS32_DEFINES\n\n");

  printf("#ifdef __cplusplus\n");
  printf("extern \"C\" {\n");
  printf("#endif /* __cplusplus */\n\n");

  /* Start of definitions */

  printf("#define MAX_PATH\t(%d)\n", MAX_PATH);
  printf("#define UNICODE_NULL ((WCHAR)0)\n");

  printf("#define LF_FACESIZE\t(%d)\n", LF_FACESIZE);
  printf("#define LF_FULLFACESIZE\t(%d)\n", LF_FULLFACESIZE);
  printf("#define ELF_VENDOR_SIZE\t(%d)\n", ELF_VENDOR_SIZE);

  printf("#define SECURITY_STATIC_TRACKING\t(%d)\n", SECURITY_STATIC_TRACKING);
  printf("#define SECURITY_DYNAMIC_TRACKING\t(%d)\n", SECURITY_DYNAMIC_TRACKING);

  printf("#define MAX_DEFAULTCHAR\t(%d)\n", MAX_DEFAULTCHAR);
  printf("#define MAX_LEADBYTES\t(%d)\n", MAX_LEADBYTES);

  printf("#define EXCEPTION_MAXIMUM_PARAMETERS\t(%d)\n", EXCEPTION_MAXIMUM_PARAMETERS);

  printf("#define CCHDEVICENAME\t(%d)\n", CCHDEVICENAME);
  printf("#define CCHFORMNAME\t(%d)\n", CCHFORMNAME);

#ifndef _GNU_H_WINDOWS32_DEFINES
#define MENU_TEXT_LEN 40
#endif
  printf("#define MENU_TEXT_LEN\t(%d)\n", MENU_TEXT_LEN);

#ifndef _GNU_H_WINDOWS32_DEFINES
#define MAX_LANA 254
#endif
  printf("#define MAX_LANA\t(%d)\n", MAX_LANA);

#ifndef _GNU_H_WINDOWS32_DEFINES
#define NCBNAMSZ 16
#define NETBIOS_NAME_LEN 16
#endif
  printf("#define NCBNAMSZ\t(%d)\n", NCBNAMSZ);
  printf("#define NETBIOS_NAME_LEN\t(%d)\n", NETBIOS_NAME_LEN);

  printf("#define OFS_MAXPATHNAME\t(%d)\n", OFS_MAXPATHNAME);

  printf("#define MAX_TAB_STOPS\t(%d)\n", MAX_TAB_STOPS);

  printf("#define ANYSIZE_ARRAY\t(%d)\n", ANYSIZE_ARRAY);

#ifndef _GNU_H_WINDOWS32_DEFINES
#define RAS_MaxCallbackNumber 128
#define RAS_MaxDeviceName     128
#define RAS_MaxDeviceType     16
#define RAS_MaxEntryName      256
#define RAS_MaxIpAddress      15
#define RAS_MaxIpxAddress     21
#define RAS_MaxPhoneNumber    128
#endif
  printf("#define RAS_MaxCallbackNumber\t(%d)\n", RAS_MaxCallbackNumber);
  printf("#define RAS_MaxDeviceName\t(%d)\n", RAS_MaxDeviceName);
  printf("#define RAS_MaxDeviceType\t(%d)\n", RAS_MaxDeviceType);
  printf("#define RAS_MaxEntryName\t(%d)\n", RAS_MaxEntryName);
  printf("#define RAS_MaxIpAddress\t(%d)\n", RAS_MaxIpAddress);
  printf("#define RAS_MaxIpxAddress\t(%d)\n", RAS_MaxIpxAddress);
  printf("#define RAS_MaxPhoneNumber\t(%d)\n", RAS_MaxPhoneNumber);

#ifndef _GNU_H_WINDOWS32_DEFINES
#define UNLEN 256
#define PWLEN 256
#define CNLEN 15
#define DNLEN 15
#endif
  printf("#define UNLEN\t(%d)\n", UNLEN);
  printf("#define PWLEN\t(%d)\n", PWLEN);
  printf("#define CNLEN\t(%d)\n", CNLEN);
  printf("#define DNLEN\t(%d)\n", DNLEN);

  printf("\n/* _llseek */\n");
  printf("#define FILE_BEGIN\t(%d)\n", FILE_BEGIN);
  printf("#define FILE_CURRENT\t(%d)\n", FILE_CURRENT);
  printf("#define FILE_END\t(%d)\n", FILE_END);

  printf("\n/* _lopen, LZOpenFile, OpenFile */\n");
  printf("#define OF_READ\t(%d)\n", OF_READ);
  printf("#define OF_READWRITE\t(%d)\n", OF_READWRITE);
  printf("#define OF_WRITE\t(%d)\n", OF_WRITE);
  printf("#define OF_SHARE_COMPAT\t(%d)\n", OF_SHARE_COMPAT);
  printf("#define OF_SHARE_DENY_NONE\t(%d)\n", OF_SHARE_DENY_NONE);
  printf("#define OF_SHARE_DENY_READ\t(%d)\n", OF_SHARE_DENY_READ);
  printf("#define OF_SHARE_DENY_WRITE\t(%d)\n", OF_SHARE_DENY_WRITE);
  printf("#define OF_SHARE_EXCLUSIVE\t(%d)\n", OF_SHARE_EXCLUSIVE);
  printf("#define OF_CANCEL\t(%d)\n", OF_CANCEL);
  printf("#define OF_CREATE\t(%d)\n", OF_CREATE);
  printf("#define OF_DELETE\t(%d)\n", OF_DELETE);
  printf("#define OF_EXIST\t(%d)\n", OF_EXIST);
  printf("#define OF_PARSE\t(%d)\n", OF_PARSE);
  printf("#define OF_PROMPT\t(%d)\n", OF_PROMPT);
  printf("#define OF_REOPEN\t(%d)\n", OF_REOPEN);
  printf("#define OF_VERIFY\t(%d)\n", OF_VERIFY);

  printf("\n/* ActivateKeyboardLayout, LoadKeyboardLayout */\n");
  printf("#define HKL_NEXT\t(%d)\n", HKL_NEXT);
  printf("#define HKL_PREV\t(%d)\n", HKL_PREV);
  printf("#define KLF_REORDER\t(%d)\n", KLF_REORDER);
  printf("#define KLF_UNLOADPREVIOUS\t(%d)\n", KLF_UNLOADPREVIOUS);
  printf("#define KLF_ACTIVATE\t(%d)\n", KLF_ACTIVATE);
  printf("#define KLF_NOTELLSHELL\t(%d)\n", KLF_NOTELLSHELL);
  printf("#define KLF_REPLACELANG\t(%d)\n", KLF_REPLACELANG);
  printf("#define KLF_SUBSTITUTE_OK\t(%d)\n", KLF_SUBSTITUTE_OK);

  printf("\n/* AppendMenu */\n");
  printf("#define MF_BITMAP\t(%#lxL)\n", MF_BITMAP);
  printf("#define MF_CHECKED\t(%#lxL)\n", MF_CHECKED);
  printf("#define MF_DISABLED\t(%#lxL)\n", MF_DISABLED);
  printf("#define MF_ENABLED\t(%#lxL)\n", MF_ENABLED);
  printf("#define MF_GRAYED\t(%#lxL)\n", MF_GRAYED);
  printf("#define MF_MENUBARBREAK\t(%#lxL)\n", MF_MENUBARBREAK);
  printf("#define MF_MENUBREAK\t(%#lxL)\n", MF_MENUBREAK);
  printf("#define MF_OWNERDRAW\t(%#lxL)\n", MF_OWNERDRAW);
  printf("#define MF_POPUP\t(%#lxL)\n", MF_POPUP);
  printf("#define MF_SEPARATOR\t(%#lxL)\n", MF_SEPARATOR);
  printf("#define MF_STRING\t(%#lxL)\n", MF_STRING);
  printf("#define MF_UNCHECKED\t(%#lxL)\n", MF_UNCHECKED);

  printf("\n/* Ternary Raster Operations - BitBlt */\n");
  printf("#define BLACKNESS\t0x00000042\n");
  printf("#define NOTSRCERASE\t0x001100A6\n");
  printf("#define NOTSRCCOPY\t0x00330008\n");
  printf("#define SRCERASE\t0x00440328\n");
  printf("#define DSTINVERT\t0x00550009\n");
  printf("#define PATINVERT\t0x005A0049\n");
  printf("#define SRCINVERT\t0x00660046\n");
  printf("#define SRCAND\t0x008800C6\n");
  printf("#define MERGEPAINT\t0x00BB0226\n");
  printf("#define MERGECOPY\t0x00C000CA\n");
  printf("#define SRCCOPY\t0x00CC0020\n");
  printf("#define SRCPAINT\t0x00EE0086\n");
  printf("#define PATCOPY\t0x00F00021\n");
  printf("#define PATPAINT\t0x00FB0A09\n");
  printf("#define WHITENESS\t0x00FF0062\n");
  printf("\n/* Binary Raster Operations */\n");
  printf("#define R2_BLACK\t(%d)\n", R2_BLACK);
  printf("#define R2_COPYPEN\t(%d)\n", R2_COPYPEN);
  printf("#define R2_MASKNOTPEN\t(%d)\n", R2_MASKNOTPEN);
  printf("#define R2_MASKPEN\t(%d)\n", R2_MASKPEN);
  printf("#define R2_MASKPENNOT\t(%d)\n", R2_MASKPENNOT);
  printf("#define R2_MERGENOTPEN\t(%d)\n", R2_MERGENOTPEN);
  printf("#define R2_MERGEPEN\t(%d)\n", R2_MERGEPEN);
  printf("#define R2_MERGEPENNOT\t(%d)\n", R2_MERGEPENNOT);
  printf("#define R2_NOP\t(%d)\n", R2_NOP);
  printf("#define R2_NOT\t(%d)\n", R2_NOT);
  printf("#define R2_NOTCOPYPEN\t(%d)\n", R2_NOTCOPYPEN);
  printf("#define R2_NOTMASKPEN\t(%d)\n", R2_NOTMASKPEN);
  printf("#define R2_NOTMERGEPEN\t(%d)\n", R2_NOTMERGEPEN);
  printf("#define R2_NOTXORPEN\t(%d)\n", R2_NOTXORPEN);
  printf("#define R2_WHITE\t(%d)\n", R2_WHITE);
  printf("#define R2_XORPEN\t(%d)\n", R2_XORPEN);

  printf("\n/* BroadcastSystemMessage */\n");
  printf("#define BSF_FLUSHDISK\t(%d)\n", BSF_FLUSHDISK);
  printf("#define BSF_FORCEIFHUNG\t(%d)\n", BSF_FORCEIFHUNG);
  printf("#define BSF_IGNORECURRENTTASK\t(%d)\n", BSF_IGNORECURRENTTASK);
//  printf("#define BSF_LPARAMPOINTER\t(%d)\n", BSF_LPARAMPOINTER);
  printf("#define BSF_NOHANG\t(%d)\n", BSF_NOHANG);
  printf("#define BSF_POSTMESSAGE\t(%d)\n", BSF_POSTMESSAGE);
  printf("#define BSF_QUERY\t(%d)\n", BSF_QUERY);
  printf("#define BSM_ALLCOMPONENTS\t(%d)\n", BSM_ALLCOMPONENTS);
  printf("#define BSM_APPLICATIONS\t(%d)\n", BSM_APPLICATIONS);
  printf("#define BSM_INSTALLABLEDRIVERS\t(%d)\n", BSM_INSTALLABLEDRIVERS);
  printf("#define BSM_NETDRIVER\t(%d)\n", BSM_NETDRIVER);
  printf("#define BSM_VXDS\t(%d)\n", BSM_VXDS);
  printf("#define BROADCAST_QUERY_DENY\t(%d)\n", BROADCAST_QUERY_DENY);

  printf("\n/* BrowseCallbackProc */\n");
  /*
  printf("#define BFFM_ENABLEOK\t(%d)\n", BFFM_ENABLEOK);
  printf("#define BFFM_SETSELECTION\t(%d)\n", BFFM_SETSELECTION);
  printf("#define BFFM_SETSTATUSTEXT\t(%d)\n", BFFM_SETSTATUSTEXT);
  printf("#define BFFM_INITIALIZED\t(%d)\n", BFFM_INITIALIZED);
  printf("#define BFFM_SELCHANGED\t(%d)\n", BFFM_SELCHANGED);
  */

  printf("\n/* CallNamedPipe */\n");
  printf("#define NMPWAIT_NOWAIT\t(%d)\n", NMPWAIT_NOWAIT);
  printf("#define NMPWAIT_WAIT_FOREVER\t(%d)\n", NMPWAIT_WAIT_FOREVER);
  printf("#define NMPWAIT_USE_DEFAULT_WAIT\t(%d)\n", NMPWAIT_USE_DEFAULT_WAIT);

  printf("\n/* CascadeWindows, TileWindows */\n");
  printf("#define MDITILE_SKIPDISABLED\t(%d)\n", MDITILE_SKIPDISABLED);
  printf("#define MDITILE_HORIZONTAL\t(%d)\n", MDITILE_HORIZONTAL);
  printf("#define MDITILE_VERTICAL\t(%d)\n", MDITILE_VERTICAL);

  printf("\n/* CBTProc */\n");
  printf("#define HCBT_ACTIVATE\t(%d)\n", HCBT_ACTIVATE);
  printf("#define HCBT_CLICKSKIPPED\t(%d)\n", HCBT_CLICKSKIPPED);
  printf("#define HCBT_CREATEWND\t(%d)\n", HCBT_CREATEWND);
  printf("#define HCBT_DESTROYWND\t(%d)\n", HCBT_DESTROYWND);
  printf("#define HCBT_KEYSKIPPED\t(%d)\n", HCBT_KEYSKIPPED);
  printf("#define HCBT_MINMAX\t(%d)\n", HCBT_MINMAX);
  printf("#define HCBT_MOVESIZE\t(%d)\n", HCBT_MOVESIZE);
  printf("#define HCBT_QS\t(%d)\n", HCBT_QS);
  printf("#define HCBT_SETFOCUS\t(%d)\n", HCBT_SETFOCUS);
  printf("#define HCBT_SYSCOMMAND\t(%d)\n", HCBT_SYSCOMMAND);

  printf("\n/* ChangeDisplaySettings */\n");
  printf("#define DM_BITSPERPEL\t(%#lxL)\n", DM_BITSPERPEL);
  printf("#define DM_PELSWIDTH\t(%#lxL)\n", DM_PELSWIDTH);
  printf("#define DM_PELSHEIGHT\t(%#lxL)\n", DM_PELSHEIGHT);
  printf("#define DM_DISPLAYFLAGS\t(%#lxL)\n", DM_DISPLAYFLAGS);
  printf("#define DM_DISPLAYFREQUENCY\t(%#lxL)\n", DM_DISPLAYFREQUENCY);
  printf("#define CDS_UPDATEREGISTRY\t(%d)\n", CDS_UPDATEREGISTRY);
  printf("#define CDS_TEST\t(%d)\n", CDS_TEST);
  printf("#define DISP_CHANGE_SUCCESSFUL\t(%d)\n", DISP_CHANGE_SUCCESSFUL);
  printf("#define DISP_CHANGE_RESTART\t(%d)\n", DISP_CHANGE_RESTART);
  printf("#define DISP_CHANGE_BADFLAGS\t(%d)\n", DISP_CHANGE_BADFLAGS);
  printf("#define DISP_CHANGE_FAILED\t(%d)\n", DISP_CHANGE_FAILED);
  printf("#define DISP_CHANGE_BADMODE\t(%d)\n", DISP_CHANGE_BADMODE);
  printf("#define DISP_CHANGE_NOTUPDATED\t(%d)\n", DISP_CHANGE_NOTUPDATED);

  printf("\n/* ChangeServiceConfig */\n");
  printf("#define SERVICE_NO_CHANGE\t(%d)\n", SERVICE_NO_CHANGE);
  printf("#define SERVICE_WIN32_OWN_PROCESS\t(%d)\n", SERVICE_WIN32_OWN_PROCESS);
  printf("#define SERVICE_WIN32_SHARE_PROCESS\t(%d)\n", SERVICE_WIN32_SHARE_PROCESS);
  printf("#define SERVICE_KERNEL_DRIVER\t(%d)\n", SERVICE_KERNEL_DRIVER);
  printf("#define SERVICE_FILE_SYSTEM_DRIVER\t(%d)\n", SERVICE_FILE_SYSTEM_DRIVER);
  printf("#define SERVICE_INTERACTIVE_PROCESS\t(%d)\n", SERVICE_INTERACTIVE_PROCESS);
  printf("#define SERVICE_BOOT_START\t(%d)\n", SERVICE_BOOT_START);
  printf("#define SERVICE_SYSTEM_START\t(%d)\n", SERVICE_SYSTEM_START);
  printf("#define SERVICE_AUTO_START\t(%d)\n", SERVICE_AUTO_START);
  printf("#define SERVICE_DEMAND_START\t(%d)\n", SERVICE_DEMAND_START);
  printf("#define SERVICE_DISABLED\t(%d)\n", SERVICE_DISABLED);

  printf("\n/* SERVICE_STATUS structure */\n");
  printf("#define SERVICE_STOPPED\t(%d)\n", SERVICE_STOPPED);
  printf("#define SERVICE_START_PENDING\t(%d)\n", SERVICE_START_PENDING);
  printf("#define SERVICE_STOP_PENDING\t(%d)\n", SERVICE_STOP_PENDING);
  printf("#define SERVICE_RUNNING\t(%d)\n", SERVICE_RUNNING);
  printf("#define SERVICE_CONTINUE_PENDING\t(%d)\n", SERVICE_CONTINUE_PENDING);
  printf("#define SERVICE_PAUSE_PENDING\t(%d)\n", SERVICE_PAUSE_PENDING);
  printf("#define SERVICE_PAUSED\t(%d)\n", SERVICE_PAUSED);
  printf("#define SERVICE_ACCEPT_STOP\t(%d)\n", SERVICE_ACCEPT_STOP);
  printf("#define SERVICE_ACCEPT_PAUSE_CONTINUE\t(%d)\n", SERVICE_ACCEPT_PAUSE_CONTINUE);
  printf("#define SERVICE_ACCEPT_SHUTDOWN\t(%d)\n", SERVICE_ACCEPT_SHUTDOWN);

  printf("\n/* CheckDlgButton */\n");
  printf("#define BST_CHECKED\t(%d)\n", BST_CHECKED);
  printf("#define BST_INDETERMINATE\t(%d)\n", BST_INDETERMINATE);
  printf("#define BST_UNCHECKED\t(%d)\n", BST_UNCHECKED);
  printf("#define BST_FOCUS\t(%d)\n", BST_FOCUS);
  printf("#define BST_PUSHED\t(%d)\n", BST_PUSHED);

  printf("\n/* CheckMenuItem, HiliteMenuItem */\n");
  printf("#define MF_BYCOMMAND\t(%#lxL)\n", MF_BYCOMMAND);
  printf("#define MF_BYPOSITION\t(%#lxL)\n", MF_BYPOSITION);
  printf("#define MF_CHECKED\t(%#lxL)\n", MF_CHECKED);
  printf("#define MF_UNCHECKED\t(%#lxL)\n", MF_UNCHECKED);
  printf("#define MF_HILITE\t(%#lxL)\n", MF_HILITE);
  printf("#define MF_UNHILITE\t(%#lxL)\n", MF_UNHILITE);

  printf("\n/* ChildWindowFromPointEx */\n");
  printf("#define CWP_ALL\t(%d)\n", CWP_ALL);
  printf("#define CWP_SKIPINVISIBLE\t(%d)\n", CWP_SKIPINVISIBLE);
  printf("#define CWP_SKIPDISABLED\t(%d)\n", CWP_SKIPDISABLED);
  printf("#define CWP_SKIPTRANSPARENT\t(%d)\n", CWP_SKIPTRANSPARENT);

  printf("\n/* ClearCommError */\n");
  printf("#define CE_BREAK\t(%d)\n", CE_BREAK);
  printf("#define CE_DNS\t(%d)\n", CE_DNS);
  printf("#define CE_FRAME\t(%d)\n", CE_FRAME);
  printf("#define CE_IOE\t(%d)\n", CE_IOE);
  printf("#define CE_MODE\t(%d)\n", CE_MODE);
  printf("#define CE_OOP\t(%d)\n", CE_OOP);
  printf("#define CE_OVERRUN\t(%d)\n", CE_OVERRUN);
  printf("#define CE_PTO\t(%d)\n", CE_PTO);
  printf("#define CE_RXOVER\t(%d)\n", CE_RXOVER);
  printf("#define CE_RXPARITY\t(%d)\n", CE_RXPARITY);
  printf("#define CE_TXFULL\t(%d)\n", CE_TXFULL);

  printf("\n/* ChooseMatchToTarget */\n");
  /* TODO: where is this?
  printf("#define CS_ENABLE\t(%d)\n", CS_ENABLE);
  printf("#define CS_DISABLE\t(%d)\n", CS_DISABLE);
  printf("#define CS_DELETE_TRANSFORM\t(%d)\n", CS_DELETE_TRANSFORM);
  */

  printf("\n/* CombineRgn */\n");
  printf("#define RGN_AND\t(%d)\n", RGN_AND);
  printf("#define RGN_COPY\t(%d)\n", RGN_COPY);
  printf("#define RGN_DIFF\t(%d)\n", RGN_DIFF);
  printf("#define RGN_OR\t(%d)\n", RGN_OR);
  printf("#define RGN_XOR\t(%d)\n", RGN_XOR);
  printf("#define NULLREGION\t(%d)\n", NULLREGION);
  printf("#define SIMPLEREGION\t(%d)\n", SIMPLEREGION);
  printf("#define COMPLEXREGION\t(%d)\n", COMPLEXREGION);
  printf("#define ERROR\t(%d)\n", ERROR);

  printf("\n/* CommonDlgExtendedError */\n");
  /* TODO: where is this?
  printf("#define CDERR_DIALOGFAILURE\t(%d)\n", CDERR_DIALOGFAILURE);
  printf("#define CDERR_FINDRESFAILURE\t(%d)\n", CDERR_FINDRESFAILURE);
  printf("#define CDERR_INITIALIZATION\t(%d)\n", CDERR_INITIALIZATION);
  printf("#define CDERR_LOADRESFAILURE\t(%d)\n", CDERR_LOADRESFAILURE);
  printf("#define CDERR_LOCKRESFAILURE\t(%d)\n", CDERR_LOCKRESFAILURE);
  printf("#define CDERR_LOADSTRFAILURE\t(%d)\n", CDERR_LOADSTRFAILURE);
  printf("#define CDERR_MEMALLOCFAILURE\t(%d)\n", CDERR_MEMALLOCFAILURE);
  printf("#define CDERR_MEMLOCKFAILURE\t(%d)\n", CDERR_MEMLOCKFAILURE);
  printf("#define CDERR_NOHINSTANCE\t(%d)\n", CDERR_NOHINSTANCE);
  printf("#define CDERR_NOHOOK\t(%d)\n", CDERR_NONOOK);
  printf("#define CDERR_NOTEMPLATE\t(%d)\n", CDERR_NOTEMPLATE);
  printf("#define CDERR_REGISTERMSGFAIL\t(%d)\n", CDERR_REGISTERMSGFAIL);
  printf("#define CDERR_STRUCTSIZE\t(%d)\n", CDERR_STRUCTSIZE);
  printf("#define CFERR_NOFONTS\t(%d)\n", CFERR_NOFONTS);
  printf("#define CFERR_MAXLESSTHANMIN\t(%d)\n", CFERR_MAXLESSTHANMIN);
  printf("#define FNERR_BUFFERTOOSMALL\t(%d)\n", FNERR_BUFFERTOOSMALL);
  printf("#define FNERR_INVALIDFILENAME\t(%d)\n", FNERR_INVALIDFILENAME);
  printf("#define FNERR_SUBCLASSFAILURE\t(%d)\n", FNERR_SUBCLASSFAILURE);
  printf("#define FRERR_BUFFERLENGTHZERO\t(%d)\n", FRERR_BUFFERLENGTHZERO);
  printf("#define PDERR_CREATEICFAILURE\t(%d)\n", PDERR_CREATEICFAILURE);
  printf("#define PDERR_DEFAULTDIFFERENT\t(%d)\n", PDERR_DEFAULTDIFFERENT);
  printf("#define PDERR_DNDMMISMATCH\t(%d)\n", PDERR_DNDMMISMATCH);
  printf("#define PDERR_GETDEVMODEFAIL\t(%d)\n", PDERR_GETDEVMODEFAIL);
  printf("#define PDERR_INITFAILURE\t(%d)\n", PDERR_INITFAILURE);
  printf("#define PDERR_LOADDRVFAILURE\t(%d)\n", PDERR_LOADDRVFAILURE);
  printf("#define PDERR_NODEFAULTPRN\t(%d)\n", PDERR_NODEFAULTPRN);
  printf("#define PDERR_NODEVICES\t(%d)\n", PDERR_NODEVICES);
  printf("#define PDERR_PARSEFAILURE\t(%d)\n", PDERR_PARSEFAILURE);
  printf("#define PDERR_PRINTERNOTFOUND\t(%d)\n", PDERR_PRINTERNOTFOUND);
  printf("#define PDERR_RETDEFFAILURE\t(%d)\n", PDERR_RETDEFFAILURE);
  printf("#define PDERR_SETUPFAILURE\t(%d)\n", PDERR_SETUPFAILURE);
  */

  printf("\n/* CompareString, LCMapString */\n");
  printf("#define LOCALE_SYSTEM_DEFAULT\t(%#lxL)\n", LOCALE_SYSTEM_DEFAULT);
  printf("#define LOCALE_USER_DEFAULT\t(%#lxL)\n", LOCALE_USER_DEFAULT);
  printf("#define NORM_IGNORECASE\t(%d)\n", NORM_IGNORECASE);
  printf("#define NORM_IGNOREKANATYPE\t(%d)\n", NORM_IGNOREKANATYPE);
  printf("#define NORM_IGNORENONSPACE\t(%d)\n", NORM_IGNORENONSPACE);
  printf("#define NORM_IGNORESYMBOLS\t(%d)\n", NORM_IGNORESYMBOLS);
  printf("#define NORM_IGNOREWIDTH\t(%d)\n", NORM_IGNOREWIDTH);
  printf("#define SORT_STRINGSORT\t(%d)\n", SORT_STRINGSORT);
  printf("#define LCMAP_BYTEREV\t(%d)\n", LCMAP_BYTEREV);
  printf("#define LCMAP_FULLWIDTH\t(%d)\n", LCMAP_FULLWIDTH);
  printf("#define LCMAP_HALFWIDTH\t(%d)\n", LCMAP_HALFWIDTH);
  printf("#define LCMAP_HIRAGANA\t(%d)\n", LCMAP_HIRAGANA);
  printf("#define LCMAP_KATAKANA\t(%d)\n", LCMAP_KATAKANA);
  printf("#define LCMAP_LOWERCASE\t(%d)\n", LCMAP_LOWERCASE);
  printf("#define LCMAP_SORTKEY\t(%d)\n", LCMAP_SORTKEY);
  printf("#define LCMAP_UPPERCASE\t(%d)\n", LCMAP_UPPERCASE);

  printf("\n/* ContinueDebugEvent */\n");
  printf("#define DBG_CONTINUE\t(%#lxL)\n", DBG_CONTINUE);
  printf("#define DBG_EXCEPTION_NOT_HANDLED\t(%#lxL)\n", DBG_EXCEPTION_NOT_HANDLED);

  printf("\n/* ControlService */\n");
  printf("#define SERVICE_CONTROL_STOP\t(%d)\n", SERVICE_CONTROL_STOP);
  printf("#define SERVICE_CONTROL_PAUSE\t(%d)\n", SERVICE_CONTROL_PAUSE);
  printf("#define SERVICE_CONTROL_CONTINUE\t(%d)\n", SERVICE_CONTROL_CONTINUE);
  printf("#define SERVICE_CONTROL_INTERROGATE\t(%d)\n", SERVICE_CONTROL_INTERROGATE);
  printf("#define SERVICE_CONTROL_SHUTDOWN\t(%d)\n", SERVICE_CONTROL_SHUTDOWN);

  printf("\n/* CopyImage, LoadImage */\n");
  printf("#define IMAGE_BITMAP\t(%d)\n", IMAGE_BITMAP);
  printf("#define IMAGE_CURSOR\t(%d)\n", IMAGE_CURSOR);
  printf("#define IMAGE_ENHMETAFILE\t(%d)\n", IMAGE_ICON);
  printf("#define IMAGE_ICON\t(%d)\n", IMAGE_ICON);
//  printf("#define LR_COPYFROMRESOURCE\t(%d)\n", LR_COPYFROMRESOURCE);
  printf("#define LR_COPYDELETEORG\t(%d)\n", LR_COPYDELETEORG);
  printf("#define LR_COPYRETURNORG\t(%d)\n", LR_COPYRETURNORG);
  printf("#define LR_MONOCHROME\t(%d)\n", LR_MONOCHROME);
  printf("#define LR_CREATEDIBSECTION\t(%d)\n", LR_CREATEDIBSECTION);
  printf("#define LR_DEFAULTSIZE\t(%d)\n", LR_DEFAULTSIZE);

  printf("\n/* CreateDesktop */\n");
  printf("#define DF_ALLOWOTHERACCOUNTHOOK\t(%#lxL)\n", DF_ALLOWOTHERACCOUNTHOOK);
  printf("#define DESKTOP_CREATEMENU\t(%#lxL)\n", DESKTOP_CREATEMENU);
  printf("#define DESKTOP_CREATEWINDOW\t(%#lxL)\n", DESKTOP_CREATEWINDOW);
  printf("#define DESKTOP_ENUMERATE\t(%#lxL)\n", DESKTOP_ENUMERATE);
  printf("#define DESKTOP_HOOKCONTROL\t(%#lxL)\n", DESKTOP_HOOKCONTROL);
  printf("#define DESKTOP_JOURNALPLAYBACK\t(%#lxL)\n", DESKTOP_JOURNALPLAYBACK);
  printf("#define DESKTOP_JOURNALRECORD\t(%#lxL)\n", DESKTOP_JOURNALRECORD);
  printf("#define DESKTOP_READOBJECTS\t(%#lxL)\n", DESKTOP_READOBJECTS);
  printf("#define DESKTOP_SWITCHDESKTOP\t(%#lxL)\n", DESKTOP_SWITCHDESKTOP);
  printf("#define DESKTOP_WRITEOBJECTS\t(%#lxL)\n", DESKTOP_WRITEOBJECTS);
  printf("#define WSF_VISIBLE\t(%#lxL)\n", WSF_VISIBLE);

  printf("\n/* CreateDIBitmap */\n");
  printf("#define CBM_INIT\t(%#lxL)\n", CBM_INIT);
  printf("#define DIB_PAL_COLORS\t(%d)\n", DIB_PAL_COLORS);
  printf("#define DIB_RGB_COLORS\t(%d)\n", DIB_RGB_COLORS);

  printf("\n/* CreateFile, GetFileAttributes, SetFileAttributes */\n");
  printf("#define GENERIC_READ\t(%#lxL)\n", GENERIC_READ);
  printf("#define GENERIC_WRITE\t(%#lxL)\n", GENERIC_WRITE);
  printf("#define FILE_SHARE_READ\t(%d)\n", FILE_SHARE_READ);
  printf("#define FILE_SHARE_WRITE\t(%d)\n", FILE_SHARE_WRITE);
  printf("#define CONSOLE_TEXTMODE_BUFFER\t(%d)\n", CONSOLE_TEXTMODE_BUFFER);
  printf("#define CREATE_NEW\t(%d)\n", CREATE_NEW);
  printf("#define CREATE_ALWAYS\t(%d)\n", CREATE_ALWAYS);
  printf("#define OPEN_EXISTING\t(%d)\n", OPEN_EXISTING);
  printf("#define OPEN_ALWAYS\t(%d)\n", OPEN_ALWAYS);
  printf("#define TRUNCATE_EXISTING\t(%d)\n", TRUNCATE_EXISTING);
  printf("#define FILE_ATTRIBUTE_ARCHIVE\t(%d)\n", FILE_ATTRIBUTE_ARCHIVE);
  printf("#define FILE_ATTRIBUTE_COMPRESSED\t(%d)\n", FILE_ATTRIBUTE_COMPRESSED);
  printf("#define FILE_ATTRIBUTE_NORMAL\t(%d)\n", FILE_ATTRIBUTE_NORMAL);
  printf("#define FILE_ATTRIBUTE_DIRECTORY\t(%d)\n", FILE_ATTRIBUTE_DIRECTORY);
  printf("#define FILE_ATTRIBUTE_HIDDEN\t(%d)\n", FILE_ATTRIBUTE_HIDDEN);
  printf("#define FILE_ATTRIBUTE_READONLY\t(%d)\n", FILE_ATTRIBUTE_READONLY);
  printf("#define FILE_ATTRIBUTE_SYSTEM\t(%d)\n", FILE_ATTRIBUTE_SYSTEM);
  printf("#define FILE_ATTRIBUTE_TEMPORARY\t(%d)\n", FILE_ATTRIBUTE_TEMPORARY);
  printf("#define FILE_FLAG_WRITE_THROUGH\t0x%8x\n", FILE_FLAG_WRITE_THROUGH);
  printf("#define FILE_FLAG_OVERLAPPED\t(%d)\n", FILE_FLAG_OVERLAPPED);
  printf("#define FILE_FLAG_NO_BUFFERING\t(%d)\n", FILE_FLAG_NO_BUFFERING);
  printf("#define FILE_FLAG_RANDOM_ACCESS\t(%d)\n", FILE_FLAG_RANDOM_ACCESS);
  printf("#define FILE_FLAG_SEQUENTIAL_SCAN\t(%d)\n", FILE_FLAG_SEQUENTIAL_SCAN);
  printf("#define FILE_FLAG_DELETE_ON_CLOSE\t(%d)\n", FILE_FLAG_DELETE_ON_CLOSE);
  printf("#define FILE_FLAG_BACKUP_SEMANTICS\t(%d)\n", FILE_FLAG_BACKUP_SEMANTICS);
  printf("#define FILE_FLAG_POSIX_SEMANTICS\t(%d)\n", FILE_FLAG_POSIX_SEMANTICS);
  printf("#define SECURITY_ANONYMOUS\t(%d)\n", SECURITY_ANONYMOUS);
  printf("#define SECURITY_IDENTIFICATION\t(%d)\n", SECURITY_IDENTIFICATION);
  printf("#define SECURITY_IMPERSONATION\t(%d)\n", SECURITY_IMPERSONATION);
  printf("#define SECURITY_DELEGATION\t(%d)\n", SECURITY_DELEGATION);
  printf("#define SECURITY_CONTEXT_TRACKING\t(%d)\n", SECURITY_CONTEXT_TRACKING);
  printf("#define SECURITY_EFFECTIVE_ONLY\t(%d)\n", SECURITY_EFFECTIVE_ONLY);
  printf("#define SECURITY_SQOS_PRESENT\t(%d)\n", SECURITY_SQOS_PRESENT);

  printf("\n/* CreateFileMapping, VirtualAlloc, VirtualFree, VirtualProtect */\n");
  printf("#define PAGE_READONLY\t(%d)\n", PAGE_READONLY);
  printf("#define PAGE_READWRITE\t(%d)\n", PAGE_READWRITE);
  printf("#define PAGE_WRITECOPY\t(%d)\n", PAGE_WRITECOPY);
  printf("#define SEC_COMMIT\t(%d)\n", SEC_COMMIT);
  printf("#define SEC_IMAGE\t(%d)\n", SEC_IMAGE);
  printf("#define SEC_NOCACHE\t(%d)\n", SEC_NOCACHE);
  printf("#define SEC_RESERVE\t(%d)\n", SEC_RESERVE);
  printf("#define MEM_COMMIT\t(%d)\n", MEM_COMMIT);
  printf("#define MEM_RESERVE\t(%d)\n", MEM_RESERVE);
  printf("#define MEM_TOP_DOWN\t(%d)\n", MEM_TOP_DOWN);
  printf("#define PAGE_EXECUTE\t(%d)\n", PAGE_EXECUTE);
  printf("#define PAGE_EXECUTE_READ\t(%d)\n", PAGE_EXECUTE_READ);
  printf("#define PAGE_EXECUTE_READWRITE\t(%d)\n", PAGE_EXECUTE_READWRITE);
  printf("#define PAGE_GUARD\t(%d)\n", PAGE_GUARD);
  printf("#define PAGE_NOACCESS\t(%d)\n", PAGE_NOACCESS);
  printf("#define PAGE_NOCACHE\t(%d)\n", PAGE_NOCACHE);
  printf("#define MEM_COMMIT\t(%d)\n", MEM_COMMIT);
  printf("#define MEM_FREE\t(%d)\n", MEM_FREE);
  printf("#define MEM_RESERVE\t(%d)\n", MEM_RESERVE);
  printf("#define MEM_IMAGE\t(%d)\n", MEM_IMAGE);
  printf("#define MEM_MAPPED\t(%d)\n", MEM_MAPPED);
  printf("#define MEM_PRIVATE\t(%d)\n", MEM_PRIVATE);
  printf("#define MEM_DECOMMIT\t(%d)\n", MEM_DECOMMIT);
  printf("#define MEM_RELEASE\t(%d)\n", MEM_RELEASE);
  printf("#define PAGE_EXECUTE_WRITECOPY\t(%d)\n", PAGE_EXECUTE_WRITECOPY);
  printf("#define EXCEPTION_GUARD_PAGE\t(%#lxL)\n", EXCEPTION_GUARD_PAGE);
  printf("#define SECTION_EXTEND_SIZE\t(%#x)\n", SECTION_EXTEND_SIZE);
//  printf("#define SECTION_EXECUTE\t(%#lxL)\n", SECTION_EXECUTE);
  printf("#define SECTION_MAP_READ\t(%#x)\n", SECTION_MAP_READ);
  printf("#define SECTION_MAP_WRITE\t(%#x)\n", SECTION_MAP_WRITE);
  printf("#define SECTION_QUERY\t(%#x)\n", SECTION_QUERY);
  printf("#define SECTION_ALL_ACCESS\t(%#lxL)\n", SECTION_ALL_ACCESS);

  printf("\n/* CreateFont */\n");
  printf("#define FW_DONTCARE\t(%d)\n", FW_DONTCARE);
  printf("#define FW_THIN\t(%d)\n", FW_THIN);
  printf("#define FW_EXTRALIGHT\t(%d)\n", FW_EXTRALIGHT);
  printf("#define FW_LIGHT\t(%d)\n", FW_LIGHT);
  printf("#define FW_NORMAL\t(%d)\n", FW_NORMAL);
  printf("#define FW_MEDIUM\t(%d)\n", FW_MEDIUM);
  printf("#define FW_SEMIBOLD\t(%d)\n", FW_SEMIBOLD);
  printf("#define FW_BOLD\t(%d)\n", FW_BOLD);
  printf("#define FW_EXTRABOLD\t(%d)\n", FW_EXTRABOLD);
  printf("#define FW_HEAVY\t(%d)\n", FW_HEAVY);
  printf("#define ANSI_CHARSET\t(%d)\n", ANSI_CHARSET);
  printf("#define DEFAULT_CHARSET\t(%d)\n", DEFAULT_CHARSET);
  printf("#define SYMBOL_CHARSET\t(%d)\n", SYMBOL_CHARSET);
  printf("#define SHIFTJIS_CHARSET\t(%d)\n", SHIFTJIS_CHARSET);
  printf("#define HANGEUL_CHARSET\t(%d)\n", HANGEUL_CHARSET);
  printf("#define GB2312_CHARSET\t(%d)\n", GB2312_CHARSET);
  printf("#define CHINESEBIG5_CHARSET\t(%d)\n", CHINESEBIG5_CHARSET);
  printf("#define GREEK_CHARSET\t(%d)\n", GREEK_CHARSET);
  printf("#define TURKISH_CHARSET\t(%d)\n", TURKISH_CHARSET);
  printf("#define HEBREW_CHARSET\t(%d)\n", HEBREW_CHARSET);
  printf("#define ARABIC_CHARSET\t(%d)\n", ARABIC_CHARSET);
  printf("#define BALTIC_CHARSET\t(%d)\n", BALTIC_CHARSET);
  printf("#define RUSSIAN_CHARSET\t(%d)\n", RUSSIAN_CHARSET);
  printf("#define THAI_CHARSET\t(%d)\n", THAI_CHARSET);
  printf("#define EASTEUROPE_CHARSET\t(%d)\n", EASTEUROPE_CHARSET);
  printf("#define OEM_CHARSET\t(%d)\n", OEM_CHARSET);
  printf("#define OUT_DEFAULT_PRECIS\t(%d)\n", OUT_DEFAULT_PRECIS);
  printf("#define OUT_STRING_PRECIS\t(%d)\n", OUT_STRING_PRECIS);
  printf("#define OUT_CHARACTER_PRECIS\t(%d)\n", OUT_CHARACTER_PRECIS);
  printf("#define OUT_STROKE_PRECIS\t(%d)\n", OUT_STROKE_PRECIS);
  printf("#define OUT_TT_PRECIS\t(%d)\n", OUT_TT_PRECIS);
  printf("#define OUT_DEVICE_PRECIS\t(%d)\n", OUT_DEVICE_PRECIS);
  printf("#define OUT_RASTER_PRECIS\t(%d)\n", OUT_RASTER_PRECIS);
  printf("#define OUT_TT_ONLY_PRECIS\t(%d)\n", OUT_TT_ONLY_PRECIS);
  printf("#define OUT_OUTLINE_PRECIS\t(%d)\n", OUT_OUTLINE_PRECIS);
  printf("#define CLIP_DEFAULT_PRECIS\t(%d)\n", CLIP_DEFAULT_PRECIS);
  printf("#define CLIP_CHARACTER_PRECIS\t(%d)\n", CLIP_CHARACTER_PRECIS);
  printf("#define CLIP_STROKE_PRECIS\t(%d)\n", CLIP_STROKE_PRECIS);
  printf("#define CLIP_MASK\t(%d)\n", CLIP_MASK);
  printf("#define CLIP_LH_ANGLES\t(%d)\n", CLIP_LH_ANGLES);
  printf("#define CLIP_TT_ALWAYS\t(%d)\n", CLIP_TT_ALWAYS);
  printf("#define CLIP_EMBEDDED\t(%d)\n", CLIP_EMBEDDED);
  printf("#define DEFAULT_QUALITY\t(%d)\n", DEFAULT_QUALITY);
  printf("#define DRAFT_QUALITY\t(%d)\n", DRAFT_QUALITY);
  printf("#define PROOF_QUALITY\t(%d)\n", PROOF_QUALITY);
  printf("#define DEFAULT_PITCH\t(%d)\n", DEFAULT_PITCH);
  printf("#define FIXED_PITCH\t(%d)\n", FIXED_PITCH);
  printf("#define VARIABLE_PITCH\t(%d)\n", VARIABLE_PITCH);
  printf("#define FF_DECORATIVE\t(%d)\n", FF_DECORATIVE);
  printf("#define FF_DONTCARE\t(%d)\n", FF_DONTCARE);
  printf("#define FF_MODERN\t(%d)\n", FF_MODERN);
  printf("#define FF_ROMAN\t(%d)\n", FF_ROMAN);
  printf("#define FF_SCRIPT\t(%d)\n", FF_SCRIPT);
  printf("#define FF_SWISS\t(%d)\n", FF_SWISS);

  printf("\n/* CreateHatchBrush */\n");
  printf("#define HS_BDIAGONAL\t(%d)\n", HS_BDIAGONAL);
  printf("#define HS_CROSS\t(%d)\n", HS_CROSS);
  printf("#define HS_DIAGCROSS\t(%d)\n", HS_DIAGCROSS);
  printf("#define HS_FDIAGONAL\t(%d)\n", HS_FDIAGONAL);
  printf("#define HS_HORIZONTAL\t(%d)\n", HS_HORIZONTAL);
  printf("#define HS_VERTICAL\t(%d)\n", HS_VERTICAL);

  printf("\n/* CreateIconFromResourceEx */\n");
  printf("#define LR_DEFAULTCOLOR\t(%d)\n", LR_DEFAULTCOLOR);
  printf("#define LR_LOADREALSIZE\t(%d)\n", LR_LOADREALSIZE);
  printf("#define LR_MONOCHROME\t(%d)\n", LR_MONOCHROME);

  printf("\n/* CreateMailslot, GetMailslotInfo */\n");
  printf("#define MAILSLOT_WAIT_FOREVER\t(%#lxL)\n", MAILSLOT_WAIT_FOREVER);
  printf("#define MAILSLOT_NO_MESSAGE\t(%#lxL)\n", MAILSLOT_NO_MESSAGE);

  printf("\n/* CreateMappedBitmap */\n");
  printf("#define CMB_MASKED\t(%d)\n", CMB_MASKED);

  printf("\n/* CreateNamedPipe */\n");
  printf("#define PIPE_ACCESS_DUPLEX\t(%d)\n", PIPE_ACCESS_DUPLEX);
  printf("#define PIPE_ACCESS_INBOUND\t(%d)\n", PIPE_ACCESS_INBOUND);
  printf("#define PIPE_ACCESS_OUTBOUND\t(%d)\n", PIPE_ACCESS_OUTBOUND);
  printf("#define WRITE_DAC\t(%#lxL)\n", WRITE_DAC);
  printf("#define WRITE_OWNER\t(%#lxL)\n", WRITE_OWNER);
  printf("#define ACCESS_SYSTEM_SECURITY\t(%#lxL)\n", ACCESS_SYSTEM_SECURITY);
  printf("#define PIPE_TYPE_BYTE\t(%d)\n", PIPE_TYPE_BYTE);
  printf("#define PIPE_TYPE_MESSAGE\t(%d)\n", PIPE_TYPE_MESSAGE);
  printf("#define PIPE_READMODE_BYTE\t(%d)\n", PIPE_READMODE_BYTE);
  printf("#define PIPE_READMODE_MESSAGE\t(%d)\n", PIPE_READMODE_MESSAGE);
  printf("#define PIPE_WAIT\t(%d)\n", PIPE_WAIT);
  printf("#define PIPE_NOWAIT\t(%d)\n", PIPE_NOWAIT);

  printf("\n/* CreatePen, ExtCreatePen */\n");
  printf("#define PS_GEOMETRIC\t(%d)\n", PS_GEOMETRIC);
  printf("#define PS_COSMETIC\t(%d)\n", PS_COSMETIC);
  printf("#define PS_ALTERNATE\t(%d)\n", PS_ALTERNATE);
  printf("#define PS_SOLID\t(%d)\n", PS_SOLID);
  printf("#define PS_DASH\t(%d)\n", PS_DASH);
  printf("#define PS_DOT\t(%d)\n", PS_DOT);
  printf("#define PS_DASHDOT\t(%d)\n", PS_DASHDOT);
  printf("#define PS_DASHDOTDOT\t(%d)\n", PS_DASHDOTDOT);
  printf("#define PS_NULL\t(%d)\n", PS_NULL);
  printf("#define PS_USERSTYLE\t(%d)\n", PS_USERSTYLE);
  printf("#define PS_INSIDEFRAME\t(%d)\n", PS_INSIDEFRAME);
  printf("#define PS_ENDCAP_ROUND\t(%d)\n", PS_ENDCAP_ROUND);
  printf("#define PS_ENDCAP_SQUARE\t(%d)\n", PS_ENDCAP_SQUARE);
  printf("#define PS_ENDCAP_FLAT\t(%d)\n", PS_ENDCAP_FLAT);
  printf("#define PS_JOIN_BEVEL\t(%d)\n", PS_JOIN_BEVEL);
  printf("#define PS_JOIN_MITER\t(%d)\n", PS_JOIN_MITER);
  printf("#define PS_JOIN_ROUND\t(%d)\n", PS_JOIN_ROUND);
  printf("#define PS_STYLE_MASK\t(%d)\n", PS_STYLE_MASK);
  printf("#define PS_ENDCAP_MASK\t(%d)\n", PS_ENDCAP_MASK);
  printf("#define PS_TYPE_MASK\t(%d)\n", PS_TYPE_MASK);

  printf("\n/* CreatePolygonRgn */\n");
  printf("#define ALTERNATE\t(%d)\n", ALTERNATE);
  printf("#define WINDING\t(%d)\n", WINDING);

  printf("\n/* CreateProcess */\n");
  printf("#define CREATE_DEFAULT_ERROR_MODE\t(%d)\n", CREATE_DEFAULT_ERROR_MODE);
  printf("#define CREATE_NEW_CONSOLE\t(%d)\n", CREATE_NEW_CONSOLE);
  printf("#define CREATE_NEW_PROCESS_GROUP\t(%d)\n", CREATE_NEW_PROCESS_GROUP);
  printf("#define CREATE_SEPARATE_WOW_VDM\t(%d)\n", CREATE_SEPARATE_WOW_VDM);
  printf("#define CREATE_SUSPENDED\t(%d)\n", CREATE_SUSPENDED);
  printf("#define CREATE_UNICODE_ENVIRONMENT\t(%d)\n", CREATE_UNICODE_ENVIRONMENT);
  printf("#define DEBUG_PROCESS\t(%d)\n", DEBUG_PROCESS);
  printf("#define DEBUG_ONLY_THIS_PROCESS\t(%d)\n", DEBUG_ONLY_THIS_PROCESS);
  printf("#define DETACHED_PROCESS\t(%d)\n", DETACHED_PROCESS);
  printf("#define HIGH_PRIORITY_CLASS\t(%d)\n", HIGH_PRIORITY_CLASS);
  printf("#define IDLE_PRIORITY_CLASS\t(%d)\n", IDLE_PRIORITY_CLASS);
  printf("#define NORMAL_PRIORITY_CLASS\t(%d)\n", NORMAL_PRIORITY_CLASS);
  printf("#define REALTIME_PRIORITY_CLASS\t(%d)\n", REALTIME_PRIORITY_CLASS);

  printf("\n/* CreateService */\n");
  printf("#define SERVICE_ALL_ACCESS\t(%#lxL)\n", SERVICE_ALL_ACCESS);
  printf("#define SERVICE_CHANGE_CONFIG\t(%d)\n", SERVICE_CHANGE_CONFIG);
  printf("#define SERVICE_ENUMERATE_DEPENDENTS\t(%d)\n", SERVICE_ENUMERATE_DEPENDENTS);
  printf("#define SERVICE_INTERROGATE\t(%d)\n", SERVICE_INTERROGATE);
  printf("#define SERVICE_PAUSE_CONTINUE\t(%d)\n", SERVICE_PAUSE_CONTINUE);
  printf("#define SERVICE_QUERY_CONFIG\t(%d)\n", SERVICE_QUERY_CONFIG);
  printf("#define SERVICE_QUERY_STATUS\t(%d)\n", SERVICE_QUERY_STATUS);
  printf("#define SERVICE_START\t(%d)\n", SERVICE_START);
  printf("#define SERVICE_STOP\t(%d)\n", SERVICE_STOP);
  printf("#define SERVICE_USER_DEFINED_CONTROL\t(%d)\n", SERVICE_USER_DEFINED_CONTROL);
  printf("#define DELETE\t(%#lxL)\n", DELETE);
  printf("#define READ_CONTROL\t(%#lxL)\n", READ_CONTROL);
  printf("#define GENERIC_EXECUTE\t(%#lxL)\n", GENERIC_EXECUTE);
  printf("#define SERVICE_WIN32_OWN_PROCESS\t(%d)\n", SERVICE_WIN32_OWN_PROCESS);
  printf("#define SERVICE_WIN32_SHARE_PROCESS\t(%d)\n", SERVICE_WIN32_SHARE_PROCESS);
  printf("#define SERVICE_KERNEL_DRIVER\t(%d)\n", SERVICE_KERNEL_DRIVER);
  printf("#define SERVICE_FILE_SYSTEM_DRIVER\t(%d)\n", SERVICE_FILE_SYSTEM_DRIVER);
  printf("#define SERVICE_INTERACTIVE_PROCESS\t(%d)\n", SERVICE_INTERACTIVE_PROCESS);
  printf("#define SERVICE_BOOT_START\t(%d)\n", SERVICE_BOOT_START);
  printf("#define SERVICE_SYSTEM_START\t(%d)\n", SERVICE_SYSTEM_START);
  printf("#define SERVICE_AUTO_START\t(%d)\n", SERVICE_AUTO_START);
  printf("#define SERVICE_DEMAND_START\t(%d)\n", SERVICE_DEMAND_START);
  printf("#define SERVICE_DISABLED\t(%d)\n", SERVICE_DISABLED);
  printf("#define SERVICE_ERROR_IGNORE\t(%d)\n", SERVICE_ERROR_IGNORE);
  printf("#define SERVICE_ERROR_NORMAL\t(%d)\n", SERVICE_ERROR_NORMAL);
  printf("#define SERVICE_ERROR_SEVERE\t(%d)\n", SERVICE_ERROR_SEVERE);
  printf("#define SERVICE_ERROR_CRITICAL\t(%d)\n", SERVICE_ERROR_CRITICAL);

  printf("\n/* CreateTapePartition, WriteTapemark */\n");
  printf("#define TAPE_FIXED_PARTITIONS\t(%#lxL)\n", TAPE_FIXED_PARTITIONS);
  printf("#define TAPE_INITIATOR_PARTITIONS\t(%#lxL)\n", TAPE_INITIATOR_PARTITIONS);
  printf("#define TAPE_SELECT_PARTITIONS\t(%#lxL)\n", TAPE_SELECT_PARTITIONS);
  printf("#define TAPE_FILEMARKS\t(%#lxL)\n", TAPE_FILEMARKS);
  printf("#define TAPE_LONG_FILEMARKS\t(%#lxL)\n", TAPE_LONG_FILEMARKS);
  printf("#define TAPE_SETMARKS\t(%#lxL)\n", TAPE_SETMARKS);
  printf("#define TAPE_SHORT_FILEMARKS\t(%#lxL)\n", TAPE_SHORT_FILEMARKS);

  printf("\n/* CreateWindow */\n");
  printf("#define CW_USEDEFAULT\t(%#x)\n", CW_USEDEFAULT);
  printf("#define WS_BORDER\t(%#lxL)\n", WS_BORDER);
  printf("#define WS_CAPTION\t(%#lxL)\n", WS_CAPTION);
  printf("#define WS_CHILD\t(%#lxL)\n", WS_CHILD);
  printf("#define WS_CHILDWINDOW\t(%#lxL)\n", WS_CHILDWINDOW);
  printf("#define WS_CLIPCHILDREN\t(%#lxL)\n", WS_CLIPCHILDREN);
  printf("#define WS_CLIPSIBLINGS\t(%#lxL)\n", WS_CLIPSIBLINGS);
  printf("#define WS_DISABLED\t(%#lxL)\n", WS_DISABLED);
  printf("#define WS_DLGFRAME\t(%#lxL)\n", WS_DLGFRAME);
  printf("#define WS_GROUP\t(%#lxL)\n", WS_GROUP);
  printf("#define WS_HSCROLL\t(%#lxL)\n", WS_HSCROLL);
  printf("#define WS_ICONIC\t(%#lxL)\n", WS_ICONIC);
  printf("#define WS_MAXIMIZE\t(%#lxL)\n", WS_MAXIMIZE);
  printf("#define WS_MAXIMIZEBOX\t(%#lxL)\n", WS_MAXIMIZEBOX);
  printf("#define WS_MINIMIZE\t(%#lxL)\n", WS_MINIMIZE);
  printf("#define WS_MINIMIZEBOX\t(%#lxL)\n", WS_MINIMIZEBOX);
  printf("#define WS_OVERLAPPED\t(%#lxL)\n", WS_OVERLAPPED);
  printf("#define WS_OVERLAPPEDWINDOW\t(%#lxL)\n", WS_OVERLAPPEDWINDOW);
  printf("#define WS_POPUP\t(%#lxL)\n", WS_POPUP);
  printf("#define WS_POPUPWINDOW\t(%#lxL)\n", WS_POPUPWINDOW);
  printf("#define WS_SIZEBOX\t(%#lxL)\n", WS_SIZEBOX);
  printf("#define WS_SYSMENU\t(%#lxL)\n", WS_SYSMENU);
  printf("#define WS_TABSTOP\t(%#lxL)\n", WS_TABSTOP);
  printf("#define WS_THICKFRAME\t(%#lxL)\n", WS_THICKFRAME);
  printf("#define WS_TILED\t(%#lxL)\n", WS_TILED);
  printf("#define WS_TILEDWINDOW\t(%#lxL)\n", WS_TILEDWINDOW);
  printf("#define WS_VISIBLE\t(%#lxL)\n", WS_VISIBLE);
  printf("#define WS_VSCROLL\t(%#lxL)\n", WS_VSCROLL);
  printf("#define MDIS_ALLCHILDSTYLES\t(%#x)\n", MDIS_ALLCHILDSTYLES);
  printf("#define BS_3STATE\t(%#lxL)\n", BS_3STATE);
  printf("#define BS_AUTO3STATE\t(%#lxL)\n", BS_AUTO3STATE);
  printf("#define BS_AUTOCHECKBOX\t(%#lxL)\n", BS_AUTOCHECKBOX);
  printf("#define BS_AUTORADIOBUTTON\t(%#lxL)\n", BS_AUTORADIOBUTTON);
  printf("#define BS_BITMAP\t(%#lxL)\n", BS_BITMAP);
  printf("#define BS_BOTTOM\t(%#lxL)\n", BS_BOTTOM);
  printf("#define BS_CENTER\t(%#lxL)\n", BS_CENTER);
  printf("#define BS_CHECKBOX\t(%#lxL)\n", BS_CHECKBOX);
  printf("#define BS_DEFPUSHBUTTON\t(%#lxL)\n", BS_DEFPUSHBUTTON);
  printf("#define BS_GROUPBOX\t(%#lxL)\n", BS_GROUPBOX);
  printf("#define BS_ICON\t(%#lxL)\n", BS_ICON);
  printf("#define BS_LEFT\t(%#lxL)\n", BS_LEFT);
  printf("#define BS_LEFTTEXT\t(%#lxL)\n", BS_LEFTTEXT);
  printf("#define BS_MULTILINE\t(%#lxL)\n", BS_MULTILINE);
  printf("#define BS_NOTIFY\t(%#lxL)\n", BS_NOTIFY);
  printf("#define BS_OWNERDRAW\t(%#lxL)\n", BS_OWNERDRAW);
  printf("#define BS_PUSHBUTTON\t(%#lxL)\n", BS_PUSHBUTTON);
  printf("#define BS_PUSHLIKE\t(%#lxL)\n", BS_PUSHLIKE);
  printf("#define BS_RADIOBUTTON\t(%#lxL)\n", BS_RADIOBUTTON);
  printf("#define BS_RIGHT\t(%#lxL)\n", BS_RIGHT);
  printf("#define BS_RIGHTBUTTON\t(%#lxL)\n", BS_RIGHTBUTTON);
  printf("#define BS_TEXT\t(%#lxL)\n", BS_TEXT);
  printf("#define BS_TOP\t(%#lxL)\n", BS_TOP);
  printf("#define BS_USERBUTTON\t(%#lxL)\n", BS_USERBUTTON);
  printf("#define BS_VCENTER\t(%#lxL)\n", BS_VCENTER);
  printf("#define CBS_AUTOHSCROLL\t(%#lxL)\n", CBS_AUTOHSCROLL);
  printf("#define CBS_DISABLENOSCROLL\t(%#lxL)\n", CBS_DISABLENOSCROLL);
  printf("#define CBS_DROPDOWN\t(%#lxL)\n", CBS_DROPDOWN);
  printf("#define CBS_DROPDOWNLIST\t(%#lxL)\n", CBS_DROPDOWNLIST);
  printf("#define CBS_HASSTRINGS\t(%#lxL)\n", CBS_HASSTRINGS);
  printf("#define CBS_LOWERCASE\t(%#lxL)\n", CBS_LOWERCASE);
  printf("#define CBS_NOINTEGRALHEIGHT\t(%#lxL)\n", CBS_NOINTEGRALHEIGHT);
  printf("#define CBS_OEMCONVERT\t(%#lxL)\n", CBS_OEMCONVERT);
  printf("#define CBS_OWNERDRAWFIXED\t(%#lxL)\n", CBS_OWNERDRAWFIXED);
  printf("#define CBS_OWNERDRAWVARIABLE\t(%#lxL)\n", CBS_OWNERDRAWVARIABLE);
  printf("#define CBS_SIMPLE\t(%#lxL)\n", CBS_SIMPLE);
  printf("#define CBS_SORT\t(%#lxL)\n", CBS_SORT);
  printf("#define CBS_UPPERCASE\t(%#lxL)\n", CBS_UPPERCASE);
  printf("#define ES_AUTOHSCROLL\t(%#lxL)\n", ES_AUTOHSCROLL);
  printf("#define ES_AUTOVSCROLL\t(%#lxL)\n", ES_AUTOVSCROLL);
  printf("#define ES_CENTER\t(%#lxL)\n", ES_CENTER);
  printf("#define ES_LEFT\t(%#lxL)\n", ES_LEFT);
  printf("#define ES_LOWERCASE\t(%#lxL)\n", ES_LOWERCASE);
  printf("#define ES_MULTILINE\t(%#lxL)\n", ES_MULTILINE);
  printf("#define ES_NOHIDESEL\t(%#lxL)\n", ES_NOHIDESEL);
  printf("#define ES_NUMBER\t(%#lxL)\n", ES_NUMBER);
  printf("#define ES_OEMCONVERT\t(%#lxL)\n", ES_OEMCONVERT);
  printf("#define ES_PASSWORD\t(%#lxL)\n", ES_PASSWORD);
  printf("#define ES_READONLY\t(%#lxL)\n", ES_READONLY);
  printf("#define ES_RIGHT\t(%#lxL)\n", ES_RIGHT);
  printf("#define ES_UPPERCASE\t(%#lxL)\n", ES_UPPERCASE);
  printf("#define ES_WANTRETURN\t(%#lxL)\n", ES_WANTRETURN);
  printf("#define LBS_DISABLENOSCROLL\t(%#lxL)\n", LBS_DISABLENOSCROLL);
  printf("#define LBS_EXTENDEDSEL\t(%#lxL)\n", LBS_EXTENDEDSEL);
  printf("#define LBS_HASSTRINGS\t(%#lxL)\n", LBS_HASSTRINGS);
  printf("#define LBS_MULTICOLUMN\t(%#lxL)\n", LBS_MULTICOLUMN);
  printf("#define LBS_MULTIPLESEL\t(%#lxL)\n", LBS_MULTIPLESEL);
  printf("#define LBS_NODATA\t(%#lxL)\n", LBS_NODATA);
  printf("#define LBS_NOINTEGRALHEIGHT\t(%#lxL)\n", LBS_NOINTEGRALHEIGHT);
  printf("#define LBS_NOREDRAW\t(%#lxL)\n", LBS_NOREDRAW);
  printf("#define LBS_NOSEL\t(%#lxL)\n", LBS_NOSEL);
  printf("#define LBS_NOTIFY\t(%#lxL)\n", LBS_NOTIFY);
  printf("#define LBS_OWNERDRAWFIXED\t(%#lxL)\n", LBS_OWNERDRAWFIXED);
  printf("#define LBS_OWNERDRAWVARIABLE\t(%#lxL)\n", LBS_OWNERDRAWVARIABLE);
  printf("#define LBS_SORT\t(%#lxL)\n", LBS_SORT);
  printf("#define LBS_STANDARD\t(%#lxL)\n", LBS_STANDARD);
  printf("#define LBS_USETABSTOPS\t(%#lxL)\n", LBS_USETABSTOPS);
  printf("#define LBS_WANTKEYBOARDINPUT\t(%#lxL)\n", LBS_WANTKEYBOARDINPUT);
  printf("#define SBS_BOTTOMALIGN\t(%#lxL)\n", SBS_BOTTOMALIGN);
  printf("#define SBS_HORZ\t(%#lxL)\n", SBS_HORZ);
  printf("#define SBS_LEFTALIGN\t(%#lxL)\n", SBS_LEFTALIGN);
  printf("#define SBS_RIGHTALIGN\t(%#lxL)\n", SBS_RIGHTALIGN);
  printf("#define SBS_SIZEBOX\t(%#lxL)\n", SBS_SIZEBOX);
  printf("#define SBS_SIZEBOXBOTTOMRIGHTALIGN\t(%#lxL)\n", SBS_SIZEBOXBOTTOMRIGHTALIGN);
  printf("#define SBS_SIZEBOXTOPLEFTALIGN\t(%#lxL)\n", SBS_SIZEBOXTOPLEFTALIGN);
  printf("#define SBS_SIZEGRIP\t(%#lxL)\n", SBS_SIZEGRIP);
  printf("#define SBS_TOPALIGN\t(%#lxL)\n", SBS_TOPALIGN);
  printf("#define SBS_VERT\t(%#lxL)\n", SBS_VERT);
  printf("#define SS_BITMAP\t(%#lxL)\n", SS_BITMAP);
  printf("#define SS_BLACKFRAME\t(%#lxL)\n", SS_BLACKFRAME);
  printf("#define SS_BLACKRECT\t(%#lxL)\n", SS_BLACKRECT);
  printf("#define SS_CENTER\t(%#lxL)\n", SS_CENTER);
  printf("#define SS_CENTERIMAGE\t(%#lxL)\n", SS_CENTERIMAGE);
  printf("#define SS_ENHMETAFILE\t(%#lxL)\n", SS_ENHMETAFILE);
  printf("#define SS_ETCHEDFRAME\t(%#lxL)\n", SS_ETCHEDFRAME);
  printf("#define SS_ETCHEDHORZ\t(%#lxL)\n", SS_ETCHEDHORZ);
  printf("#define SS_ETCHEDVERT\t(%#lxL)\n", SS_ETCHEDVERT);
  printf("#define SS_GRAYFRAME\t(%#lxL)\n", SS_GRAYFRAME);
  printf("#define SS_GRAYRECT\t(%#lxL)\n", SS_GRAYRECT);
  printf("#define SS_ICON\t(%#lxL)\n", SS_ICON);
  printf("#define SS_LEFT\t(%#lxL)\n", SS_LEFT);
  printf("#define SS_LEFTNOWORDWRAP\t(%#lxL)\n", SS_LEFTNOWORDWRAP);
//  printf("#define SS_METAPICT\t(%#lxL)\n", SS_METAPICT);
  printf("#define SS_NOPREFIX\t(%#lxL)\n", SS_NOPREFIX);
  printf("#define SS_NOTIFY\t(%#lxL)\n", SS_NOTIFY);
  printf("#define SS_OWNERDRAW\t(%#lxL)\n", SS_OWNERDRAW);
  printf("#define SS_REALSIZEIMAGE\t(%#lxL)\n", SS_REALSIZEIMAGE);
  printf("#define SS_RIGHT\t(%#lxL)\n", SS_RIGHT);
  printf("#define SS_RIGHTJUST\t(%#lxL)\n", SS_RIGHTJUST);
//  printf("#define SS_RIGHTIMAGE\t(%#lxL)\n", SS_RIGHTIMAGE);
  printf("#define SS_SIMPLE\t(%#lxL)\n", SS_SIMPLE);
  printf("#define SS_SUNKEN\t(%#lxL)\n", SS_SUNKEN);
  printf("#define SS_WHITEFRAME\t(%#lxL)\n", SS_WHITEFRAME);
  printf("#define SS_WHITERECT\t(%#lxL)\n", SS_WHITERECT);
  printf("#define DS_3DLOOK\t(%#lxL)\n", DS_3DLOOK);
  printf("#define DS_ABSALIGN\t(%#lxL)\n", DS_ABSALIGN);
  printf("#define DS_CENTER\t(%#lxL)\n", DS_CENTER);
  printf("#define DS_CENTERMOUSE\t(%#lxL)\n", DS_CENTERMOUSE);
  printf("#define DS_CONTEXTHELP\t(%#lxL)\n", DS_CONTEXTHELP);
  printf("#define DS_CONTROL\t(%#lxL)\n", DS_CONTROL);
  printf("#define DS_FIXEDSYS\t(%#lxL)\n", DS_FIXEDSYS);
  printf("#define DS_LOCALEDIT\t(%#lxL)\n", DS_LOCALEDIT);
  printf("#define DS_MODALFRAME\t(%#lxL)\n", DS_MODALFRAME);
  printf("#define DS_NOFAILCREATE\t(%#lxL)\n", DS_NOFAILCREATE);
  printf("#define DS_NOIDLEMSG\t(%#lxL)\n", DS_NOIDLEMSG);
//  printf("#define DS_RECURSE\t(%#lxL)\n", DS_RECURSE);
  printf("#define DS_SETFONT\t(%#lxL)\n", DS_SETFONT);
  printf("#define DS_SETFOREGROUND\t(%#lxL)\n", DS_SETFOREGROUND);
  printf("#define DS_SYSMODAL\t(%#lxL)\n", DS_SYSMODAL);

  printf("\n/* CreateWindowEx */\n");
//  printf("#define WS_EX_ABSPOSITION\t(%#lxL)\n", WS_EX_ABSPOSITION);
  printf("#define WS_EX_ACCEPTFILES\t(%#lxL)\n", WS_EX_ACCEPTFILES);
  printf("#define WS_EX_APPWINDOW\t(%#lxL)\n", WS_EX_APPWINDOW);
  printf("#define WS_EX_CLIENTEDGE\t(%#lxL)\n", WS_EX_CLIENTEDGE);
  printf("#define WS_EX_CONTEXTHELP\t(%#lxL)\n", WS_EX_CONTEXTHELP);
  printf("#define WS_EX_CONTROLPARENT\t(%#lxL)\n", WS_EX_CONTROLPARENT);
  printf("#define WS_EX_DLGMODALFRAME\t(%#lxL)\n", WS_EX_DLGMODALFRAME);
  printf("#define WS_EX_LEFT\t(%#lxL)\n", WS_EX_LEFT);
  printf("#define WS_EX_LEFTSCROLLBAR\t(%#lxL)\n", WS_EX_LEFTSCROLLBAR);
  printf("#define WS_EX_LTRREADING\t(%#lxL)\n", WS_EX_LTRREADING);
  printf("#define WS_EX_MDICHILD\t(%#lxL)\n", WS_EX_MDICHILD);
  printf("#define WS_EX_NOPARENTNOTIFY\t(%#lxL)\n", WS_EX_NOPARENTNOTIFY);
  printf("#define WS_EX_OVERLAPPEDWINDOW\t(%#lxL)\n", WS_EX_OVERLAPPEDWINDOW);
  printf("#define WS_EX_PALETTEWINDOW\t(%#lxL)\n", WS_EX_PALETTEWINDOW);
  printf("#define WS_EX_RIGHT\t(%#lxL)\n", WS_EX_RIGHT);
  printf("#define WS_EX_RIGHTSCROLLBAR\t(%#lxL)\n", WS_EX_RIGHTSCROLLBAR);
  printf("#define WS_EX_RTLREADING\t(%#lxL)\n", WS_EX_RTLREADING);
  printf("#define WS_EX_STATICEDGE\t(%#lxL)\n", WS_EX_STATICEDGE);
  printf("#define WS_EX_TOOLWINDOW\t(%#lxL)\n", WS_EX_TOOLWINDOW);
  printf("#define WS_EX_TOPMOST\t(%#lxL)\n", WS_EX_TOPMOST);
  printf("#define WS_EX_TRANSPARENT\t(%#lxL)\n", WS_EX_TRANSPARENT);
  printf("#define WS_EX_WINDOWEDGE\t(%#lxL)\n", WS_EX_WINDOWEDGE);

  printf("\n/* CreateWindowStation */\n");
  printf("#define WINSTA_ACCESSCLIPBOARD\t(%#lxL)\n", WINSTA_ACCESSCLIPBOARD);
  printf("#define WINSTA_ACCESSGLOBALATOMS\t(%#lxL)\n", WINSTA_ACCESSGLOBALATOMS);
  printf("#define WINSTA_CREATEDESKTOP\t(%#lxL)\n", WINSTA_CREATEDESKTOP);
  printf("#define WINSTA_ENUMDESKTOPS\t(%#lxL)\n", WINSTA_ENUMDESKTOPS);
  printf("#define WINSTA_ENUMERATE\t(%#lxL)\n", WINSTA_ENUMERATE);
  printf("#define WINSTA_EXITWINDOWS\t(%#lxL)\n", WINSTA_EXITWINDOWS);
  printf("#define WINSTA_READATTRIBUTES\t(%#lxL)\n", WINSTA_READATTRIBUTES);
  printf("#define WINSTA_READSCREEN\t(%#lxL)\n", WINSTA_READSCREEN);
  printf("#define WINSTA_WRITEATTRIBUTES\t(%#lxL)\n", WINSTA_WRITEATTRIBUTES);

  printf("\n/* DdeCallback */\n");
  /* TODO: DDE
  printf("#define XCLASS_BOOL\t(%d)\n", XCLASS_BOOL);
  printf("#define XCLASS_DATA\t(%d)\n", XCLASS_DATA);
  printf("#define XCLASS_FLAGS\t(%d)\n", XCLASS_FLAGS);
  printf("#define XCLASS_NOTIFICATION\t(%d)\n", XCLASS_NOTIFICATION);
  */

  printf("\n/* DdeClientTransaction */\n");
  /* TODO: DDE
  printf("#define XTYP_ADVSTART\t(%d)\n", XTYP_ADVSTART);
  printf("#define XTYP_ADVSTOP\t(%d)\n", XTYP_ADVSTOP);
  printf("#define XTYP_EXECUTE\t(%d)\n", XTYP_EXECUTE);
  printf("#define XTYP_POKE\t(%d)\n", XTYP_POKE);
  printf("#define XTYP_REQUEST\t(%d)\n", XTYP_REQUEST);
  */

  printf("\n/* DdeEnableCallback */\n");
  /* TODO: DDE
  printf("#define EC_ENABLEALL\t(%d)\n", EC_ENABLEALL);
  printf("#define EC_ENABLEONE\t(%d)\n", EC_ENABLEONE);
  printf("#define EC_DISABLE\t(%d)\n", EC_DISABLE);
  printf("#define EC_QUERYWAITING\t(%d)\n", EC_QUERYWAITING);
  */

  printf("\n/* DdeGetLastError */\n");
  /* TODO: DDE
  printf("#define DMLERR_ADVACKTIMEOUT\t(%d)\n", DMLERR_ADVACKTIMEOUT);
  printf("#define DMLERR_BUSY\t(%d)\n", DMLERR_BUSY);
  printf("#define DMLERR_DATAACKTIMEOUT\t(%d)\n", DMLERR_DATAACKTIMEOUT);
  printf("#define DMLERR_DLL_NOT_INITIALIZED\t(%d)\n", DMLERR_DLL_NOT_INITIALIZED);
  printf("#define DMLERR_DLL_USAGE\t(%d)\n", DMLERR_DLL_USAGE);
  printf("#define DMLERR_EXECACKTIMEOUT\t(%d)\n", DMLERR_EXECACKTIMEOUT);
  printf("#define DMLERR_INVALIDPARAMETER\t(%d)\n", DMLERR_INVALIDPARAMETER);
  printf("#define DMLERR_LOW_MEMORY\t(%d)\n", DMLERR_LOW_MEMORY);
  printf("#define DMLERR_MEMORY_ERROR\t(%d)\n", DMLERR_MEMORY_ERROR);
  printf("#define DMLERR_NO_CONV_ESTABLISHED\t(%d)\n", DMLERR_NO_CONV_ESTABLISHED);
  printf("#define DMLERR_NOTPROCESSED\t(%d)\n", DMLERR_NOTPROCESSED);
  printf("#define DMLERR_POKEACKTIMEOUT\t(%d)\n", DMLERR_POKEACKTIMEOUT);
  printf("#define DMLERR_POSTMSG_FAILED\t(%d)\n", DMLERR_POSTMSG_FAILED);
  printf("#define DMLERR_REENTRANCY\t(%d)\n", DMLERR_REENTRANCY);
  printf("#define DMLERR_SERVER_DIED\t(%d)\n", DMLERR_SERVER_DIED);
  printf("#define DMLERR_SYS_ERROR\t(%d)\n", DMLERR_SYS_ERROR);
  printf("#define DMLERR_UNADVACKTIMEOUT\t(%d)\n", DMLERR_UNADVACKTIMEOUT);
  printf("#define DMLERR_UNFOUND_QUEUE_ID\t(%d)\n", DMLERR_UNFOUND_QUEUE_ID);
  */

  printf("\n/* DdeInitialize */\n");
  /* TODO: DDE
  printf("#define APPCLASS_MONITOR\t(%d)\n", APPCLASS_MONITOR);
  printf("#define APPCLASS_STANDARD\t(%d)\n", APPCLASS_STANDARD);
  printf("#define APPCMD_CLIENTONLY\t(%d)\n", APPCMD_CLIENTONLY);
  printf("#define APPCMD_FILTERINITS\t(%d)\n", APPCMD_FILTERINITS);
  printf("#define CBF_FAIL_ALLSVRXACTIONS\t(%d)\n", CBF_FAIL_ALLSVRXACTIONS);
  printf("#define CBF_FAIL_ADVISES\t(%d)\n", CBF_FAIL_ADVISES);
  printf("#define CBF_FAIL_CONNECTIONS\t(%d)\n", CBF_FAIL_CONNECTIONS);
  printf("#define CBF_FAIL_EXECUTES\t(%d)\n", CBF_FAIL_EXECUTES);
  printf("#define CBF_FAIL_POKES\t(%d)\n", CBF_FAIL_POKES);
  printf("#define CBF_FAIL_REQUESTS\t(%d)\n", CBF_FAIL_REQUESTS);
  printf("#define CBF_FAIL_SELFCONNECTIONS\t(%d)\n", CBF_FAIL_SELFCONNECTIONS);
  printf("#define CBF_SKIP_ALLNOTIFICATIONS\t(%d)\n", CBF_SKIP_ALLNOTIFICATIONS);
  printf("#define CBF_SKIP_CONNECT_CONFIRMS\t(%d)\n", CBF_SKIP_CONNECT_CONFIRMS);
  printf("#define CBF_SKIP_DISCONNECTS\t(%d)\n", CBF_SKIP_DISCONNECTS);
  printf("#define CBF_SKIP_REGISTRATIONS\t(%d)\n", CBF_SKIP_REGISTRATIONS);
  printf("#define CBF_SKIP_UNREGISTRATIONS\t(%d)\n", CBF_SKIP_UNREGISTRATIONS);
  printf("#define MF_CALLBACKS\t(%d)\n", MF_CALLBACK);
  printf("#define MF_CONV\t(%d)\n", MF_CONV);
  printf("#define MF_ERRORS\t(%d)\n", MF_ERRORS);
  printf("#define MF_HSZ_INFO\t(%d)\n", MF_HSZ_INFO);
  printf("#define MF_LINKS\t(%d)\n", MF_LINKS);
  printf("#define MF_POSTMSGS\t(%d)\n", MF_POSTMSGS);
  printf("#define MF_SENDMSGS\t(%d)\n", MF_SENDMSGS);
  */

  printf("\n/* DdeNameService */\n");
  /* TODO: DDE
  printf("#define DNS_REGISTER\t(%d)\n", DNS_REGISTER);
  printf("#define DNS_UNREGISTER\t(%d)\n", DNS_UNREGISTER);
  printf("#define DNS_FILTERON\t(%d)\n", DNS_FILTERON);
  printf("#define DNS_FILTEROFF\t(%d)\n", DNS_FILTEROFF);
  */

  printf("\n/* DebugProc */\n");
  printf("#define WH_CALLWNDPROC\t(%d)\n", WH_CALLWNDPROC);
  printf("#define WH_CALLWNDPROCRET\t(%d)\n", WH_CALLWNDPROCRET);
  printf("#define WH_CBT\t(%d)\n", WH_CBT);
  printf("#define WH_DEBUG\t(%d)\n", WH_DEBUG);
  printf("#define WH_GETMESSAGE\t(%d)\n", WH_GETMESSAGE);
  printf("#define WH_JOURNALPLAYBACK\t(%d)\n", WH_JOURNALPLAYBACK);
  printf("#define WH_JOURNALRECORD\t(%d)\n", WH_JOURNALRECORD);
  printf("#define WH_KEYBOARD\t(%d)\n", WH_KEYBOARD);
  printf("#define WH_MOUSE\t(%d)\n", WH_MOUSE);
  printf("#define WH_MSGFILTER\t(%d)\n", WH_MSGFILTER);
  printf("#define WH_SHELL\t(%d)\n", WH_SHELL);
  printf("#define WH_SYSMSGFILTER\t(%d)\n", WH_SYSMSGFILTER);
  printf("#define WH_MSGFILTER\t(%d)\n", WH_MSGFILTER);
  printf("#define WH_FOREGROUNDIDLE\t(%d)\n", WH_FOREGROUNDIDLE);

  printf("\n/* DefineDosDevice */\n");
  printf("#define DDD_RAW_TARGET_PATH\t(%d)\n", DDD_RAW_TARGET_PATH);
  printf("#define DDD_REMOVE_DEFINITION\t(%d)\n", DDD_REMOVE_DEFINITION);
  printf("#define DDD_EXACT_MATCH_ON_REMOVE\t(%d)\n", DDD_EXACT_MATCH_ON_REMOVE);

  printf("\n/* DeviceCapbilities */\n");
  printf("#define DC_BINNAMES\t(%d)\n", DC_BINNAMES);
  printf("#define DC_BINS\t(%d)\n", DC_BINS);
  printf("#define DC_COPIES\t(%d)\n", DC_COPIES);
  printf("#define DC_DRIVER\t(%d)\n", DC_DRIVER);
  printf("#define DC_DATATYPE_PRODUCED\t(%d)\n", DC_DATATYPE_PRODUCED);
  printf("#define DC_DUPLEX\t(%d)\n", DC_DUPLEX);
  printf("#define DC_EMF_COMPLIANT\t(%d)\n", DC_EMF_COMPLIANT);
  printf("#define DC_ENUMRESOLUTIONS\t(%d)\n", DC_ENUMRESOLUTIONS);
  printf("#define DC_EXTRA\t(%d)\n", DC_EXTRA);
  printf("#define DC_FIELDS\t(%d)\n", DC_FIELDS);
  printf("#define DC_FILEDEPENDENCIES\t(%d)\n", DC_FILEDEPENDENCIES);
  printf("#define DC_MAXEXTENT\t(%d)\n", DC_MAXEXTENT);
  printf("#define DC_MINEXTENT\t(%d)\n", DC_MINEXTENT);
  printf("#define DC_ORIENTATION\t(%d)\n", DC_ORIENTATION);
  printf("#define DC_PAPERNAMES\t(%d)\n", DC_PAPERNAMES);
  printf("#define DC_PAPERS\t(%d)\n", DC_PAPERS);
  printf("#define DC_PAPERSIZE\t(%d)\n", DC_PAPERSIZE);
  printf("#define DC_SIZE\t(%d)\n", DC_SIZE);
  printf("#define DC_TRUETYPE\t(%d)\n", DC_TRUETYPE);
  printf("#define DCTT_BITMAP\t(%#lxL)\n", DCTT_BITMAP);
  printf("#define DCTT_DOWNLOAD\t(%#lxL)\n", DCTT_DOWNLOAD);
  printf("#define DCTT_SUBDEV\t(%#lxL)\n", DCTT_SUBDEV);
  printf("#define DC_VERSION\t(%d)\n", DC_VERSION);
  printf("#define DC_BINADJUST\t(%d)\n", DC_BINADJUST);
  printf("#define DC_EMF_COMPLIANT\t(%d)\n", DC_EMF_COMPLIANT);
  printf("#define DC_DATATYPE_PRODUCED\t(%d)\n", DC_DATATYPE_PRODUCED);
//  printf("#define DC_COLLATE\t(%d)\n", DC_COLLATE);

  printf("\n/* DeviceIoControl */\n");
  /* TODO: where is this?
  printf("#define FSCTL_DISMOUNT_VOLUME\t(%d)\n", FSCTL_DISMOUNT_VOLUME);
  printf("#define FSCTL_GET_COMPRESSION\t(%d)\n", FSCTL_GET_COMPRESSION);
  printf("#define FSCTL_LOCK_VOLUME\t(%d)\n", FSCTL_LOCK_VOLUME);
  printf("#define FSCTL_READ_COMPRESSION\t(%d)\n", FSCTL_READ_COMPRESSION);
  printf("#define FSCTL_SET_COMPRESSION\t(%d)\n", FSCTL_SET_COMPRESSION);
  printf("#define FSCTL_UNLOCK_VOLUME\t(%d)\n", FSCTL_UNLOCK_VOLUME);
  printf("#define FSCTL_WRITE_COMPRESSION\t(%d)\n", FSCTL_WRITE_COMPRESSION);
  printf("#define IOCTL_DISK_CHECK_VERIFY\t(%d)\n", IOCTL_DISK_CHECK_VERIFY);
  printf("#define IOCTL_DISK_EJECT_MEDIA\t(%d)\n", IOCTL_DISK_EJECT_MEDIA);
  printf("#define IOCTL_DISK_FORMAT_TRACKS\t(%d)\n", IOCTL_DISK_FORMAT_TRACKS);
  printf("#define IOCTL_DISK_GET_DRIVE_GEOMETRY\t(%d)\n", IOCTL_DISK_GET_DRIVE_GEOMETRY);
  printf("#define IOCTL_DISK_GET_DRIVE_LAYOUT\t(%d)\n", IOCTL_DISK_GET_DRIVE_LAYOUT);
  printf("#define IOCTL_DISK_GET_MEDIA_TYPES\t(%d)\n", IOCTL_DISK_GET_MEDIA_TYPES);
  printf("#define IOCTL_DISK_GET_PARTITION_INFO\t(%d)\n", IOCTL_DISK_GET_PARTITION_INFO);
  printf("#define IOCTL_DISK_LOAD_MEDIA\t(%d)\n", IOCTL_DISK_LOAD_MEDIA);
  printf("#define IOCTL_DISK_MEDIA_REMOVAL\t(%d)\n", IOCTL_DISK_MEDIA_REMOVAL);
  printf("#define IOCTL_DISK_PERFORMANCE\t(%d)\n", IOCTL_DISK_PERFORMANCE);
  printf("#define IOCTL_DISK_REASSIGN_BLOCKS\t(%d)\n", IOCTL_DISK_REASSIGN_BLOCKS);
  printf("#define IOCTL_DISK_SET_DRIVE_LAYOUT\t(%d)\n", IOCTL_DISK_SET_DRIVE_LAYOUT);
  printf("#define IOCTL_DISK_SET_PARTITION_INFO\t(%d)\n", IOCTL_DISK_SET_PARTITION_INFO);
  printf("#define IOCTL_DISK_VERIFY\t(%d)\n", IOCTL_DISK_VERIFY);
  printf("#define IOCTL_SERIAL_LSRMST_INSERT\t(%d)\n", IOCTL_SERIAL_LSRMST_INSERT);
  */

  printf("\n/* DlgDirList */\n");
  printf("#define DDL_ARCHIVE\t(%d)\n", DDL_ARCHIVE);
  printf("#define DDL_DIRECTORY\t(%d)\n", DDL_DIRECTORY);
  printf("#define DDL_DRIVES\t(%d)\n", DDL_DRIVES);
  printf("#define DDL_EXCLUSIVE\t(%d)\n", DDL_EXCLUSIVE);
  printf("#define DDL_HIDDEN\t(%d)\n", DDL_HIDDEN);
  printf("#define DDL_READONLY\t(%d)\n", DDL_READONLY);
  printf("#define DDL_READWRITE\t(%d)\n", DDL_READWRITE);
  printf("#define DDL_SYSTEM\t(%d)\n", DDL_SYSTEM);
  printf("#define DDL_POSTMSGS\t(%d)\n", DDL_POSTMSGS);

  printf("\n/* DllEntryPoint */\n");
  printf("#define DLL_PROCESS_ATTACH\t(%d)\n", DLL_PROCESS_ATTACH);
  printf("#define DLL_THREAD_ATTACH\t(%d)\n", DLL_THREAD_ATTACH);
  printf("#define DLL_PROCESS_DETACH\t(%d)\n", DLL_PROCESS_DETACH);
  printf("#define DLL_THREAD_DETACH\t(%d)\n", DLL_THREAD_DETACH);

  printf("\n/* DocumentProperties */\n");
  printf("#define DM_IN_BUFFER\t(%d)\n", DM_IN_BUFFER);
  printf("#define DM_MODIFY\t(%d)\n", DM_MODIFY);
  printf("#define DM_IN_PROMPT\t(%d)\n", DM_IN_PROMPT);
  printf("#define DM_PROMPT\t(%d)\n", DM_PROMPT);
  printf("#define DM_OUT_BUFFER\t(%d)\n", DM_OUT_BUFFER);
  printf("#define DM_COPY\t(%d)\n", DM_COPY);
  printf("#define DM_UPDATE\t(%d)\n", DM_UPDATE);

  printf("\n/* DrawAnimatedRects */\n");
  printf("#define IDANI_OPEN\t(%d)\n", IDANI_OPEN);
  printf("#define IDANI_CLOSE\t(%d)\n", IDANI_CLOSE);

  printf("\n/* DrawCaption */\n");
  printf("#define DC_ACTIVE\t(%d)\n", DC_ACTIVE);
  printf("#define DC_SMALLCAP\t(%d)\n", DC_SMALLCAP);

  printf("\n/* DrawEdge */\n");
  printf("#define BDR_RAISEDINNER\t(%d)\n", BDR_RAISEDINNER);
  printf("#define BDR_SUNKENINNER\t(%d)\n", BDR_SUNKENINNER);
  printf("#define BDR_RAISEDOUTER\t(%d)\n", BDR_RAISEDOUTER);
  printf("#define BDR_SUNKENOUTER\t(%d)\n", BDR_RAISEDOUTER);
  printf("#define EDGE_BUMP\t(%d)\n", EDGE_BUMP);
  printf("#define EDGE_ETCHED\t(%d)\n", EDGE_ETCHED);
  printf("#define EDGE_RAISED\t(%d)\n", EDGE_RAISED);
  printf("#define EDGE_SUNKEN\t(%d)\n", EDGE_SUNKEN);
  printf("#define BF_ADJUST\t(%d)\n", BF_ADJUST);
  printf("#define BF_BOTTOM\t(%d)\n", BF_BOTTOM);
  printf("#define BF_BOTTOMLEFT\t(%d)\n", BF_BOTTOMLEFT);
  printf("#define BF_BOTTOMRIGHT\t(%d)\n", BF_BOTTOMRIGHT);
  printf("#define BF_DIAGONAL\t(%d)\n", BF_DIAGONAL);
  printf("#define BF_DIAGONAL_ENDBOTTOMLEFT\t(%d)\n", BF_DIAGONAL_ENDBOTTOMLEFT);
  printf("#define BF_DIAGONAL_ENDBOTTOMRIGHT\t(%d)\n", BF_DIAGONAL_ENDBOTTOMRIGHT);
  printf("#define BF_DIAGONAL_ENDTOPLEFT\t(%d)\n", BF_DIAGONAL_ENDTOPLEFT);
  printf("#define BF_DIAGONAL_ENDTOPRIGHT\t(%d)\n", BF_DIAGONAL_ENDTOPRIGHT);
  printf("#define BF_FLAT\t(%d)\n", BF_FLAT);
  printf("#define BF_LEFT\t(%d)\n", BF_LEFT);
  printf("#define BF_MIDDLE\t(%d)\n", BF_MIDDLE);
  printf("#define BF_MONO\t(%d)\n", BF_MONO);
  printf("#define BF_RECT\t(%d)\n", BF_RECT);
  printf("#define BF_RIGHT\t(%d)\n", BF_RIGHT);
  printf("#define BF_SOFT\t(%d)\n", BF_SOFT);
  printf("#define BF_TOP\t(%d)\n", BF_TOP);
  printf("#define BF_TOPLEFT\t(%d)\n", BF_TOPLEFT);
  printf("#define BF_TOPRIGHT\t(%d)\n", BF_TOPRIGHT);

  printf("\n/* DrawFrameControl */\n");
  printf("#define DFC_BUTTON\t(%d)\n", DFC_BUTTON);
  printf("#define DFC_CAPTION\t(%d)\n", DFC_CAPTION);
  printf("#define DFC_MENU\t(%d)\n", DFC_MENU);
  printf("#define DFC_SCROLL\t(%d)\n", DFC_SCROLL);
  printf("#define DFCS_BUTTON3STATE\t(%d)\n", DFCS_BUTTON3STATE);
  printf("#define DFCS_BUTTONCHECK\t(%d)\n", DFCS_BUTTONCHECK);
  printf("#define DFCS_BUTTONPUSH\t(%d)\n", DFCS_BUTTONPUSH);
  printf("#define DFCS_BUTTONRADIO\t(%d)\n", DFCS_BUTTONRADIO);
  printf("#define DFCS_BUTTONRADIOIMAGE\t(%d)\n", DFCS_BUTTONRADIOIMAGE);
  printf("#define DFCS_BUTTONRADIOMASK\t(%d)\n", DFCS_BUTTONRADIOMASK);
  printf("#define DFCS_CAPTIONCLOSE\t(%d)\n", DFCS_CAPTIONCLOSE);
  printf("#define DFCS_CAPTIONHELP\t(%d)\n", DFCS_CAPTIONHELP);
  printf("#define DFCS_CAPTIONMAX\t(%d)\n", DFCS_CAPTIONMAX);
  printf("#define DFCS_CAPTIONMIN\t(%d)\n", DFCS_CAPTIONMIN);
  printf("#define DFCS_CAPTIONRESTORE\t(%d)\n", DFCS_CAPTIONRESTORE);
  printf("#define DFCS_MENUARROW\t(%d)\n", DFCS_MENUARROW);
  printf("#define DFCS_MENUBULLET\t(%d)\n", DFCS_MENUBULLET);
  printf("#define DFCS_MENUCHECK\t(%d)\n", DFCS_MENUCHECK);
  printf("#define DFCS_SCROLLCOMBOBOX\t(%d)\n", DFCS_SCROLLCOMBOBOX);
  printf("#define DFCS_SCROLLDOWN\t(%d)\n", DFCS_SCROLLDOWN);
  printf("#define DFCS_SCROLLLEFT\t(%d)\n", DFCS_SCROLLLEFT);
  printf("#define DFCS_SCROLLRIGHT\t(%d)\n", DFCS_SCROLLRIGHT);
  printf("#define DFCS_SCROLLSIZEGRIP\t(%d)\n", DFCS_SCROLLSIZEGRIP);
  printf("#define DFCS_SCROLLUP\t(%d)\n", DFCS_SCROLLUP);
  printf("#define DFCS_ADJUSTRECT\t(%d)\n", DFCS_ADJUSTRECT);
  printf("#define DFCS_CHECKED\t(%d)\n", DFCS_CHECKED);
  printf("#define DFCS_FLAT\t(%d)\n", DFCS_FLAT);
  printf("#define DFCS_INACTIVE\t(%d)\n", DFCS_INACTIVE);
  printf("#define DFCS_MONO\t(%d)\n", DFCS_MONO);
  printf("#define DFCS_PUSHED\t(%d)\n", DFCS_PUSHED);

  printf("\n/* DrawIconEx */\n");
  printf("#define DI_COMPAT\t(%d)\n", DI_COMPAT);
  printf("#define DI_DEFAULTSIZE\t(%d)\n", DI_DEFAULTSIZE);
  printf("#define DI_IMAGE\t(%d)\n", DI_IMAGE);
  printf("#define DI_MASK\t(%d)\n", DI_MASK);
  printf("#define DI_NORMAL\t(%d)\n", DI_NORMAL);

  printf("\n/* DrawState */\n");
  printf("#define DST_BITMAP\t(%d)\n", DST_BITMAP);
  printf("#define DST_COMPLEX\t(%d)\n", DST_COMPLEX);
  printf("#define DST_ICON\t(%d)\n", DST_ICON);
  printf("#define DST_PREFIXTEXT\t(%d)\n", DST_PREFIXTEXT);
  printf("#define DST_TEXT\t(%d)\n", DST_TEXT);
  printf("#define DSS_NORMAL\t(%d)\n", DSS_NORMAL);
  printf("#define DSS_UNION\t(%d)\n", DSS_UNION);
  printf("#define DSS_DISABLED\t(%d)\n", DSS_DISABLED);
//  printf("#define DSS_DEFAULT\t(%d)\n", DSS_DEFAULT);
  printf("#define DSS_MONO\t(%d)\n", DSS_MONO);

  printf("\n/* DrawStatusText */\n");
  printf("#define SBT_NOBORDERS\t(%d)\n", SBT_NOBORDERS);
  printf("#define SBT_OWNERDRAW\t(%d)\n", SBT_OWNERDRAW);
  printf("#define SBT_POPOUT\t(%d)\n", SBT_POPOUT);
  printf("#define SBT_RTLREADING\t(%d)\n", SBT_RTLREADING);

  printf("\n/* DrawText, DrawTextEx */\n");
  printf("#define DT_BOTTOM\t(%d)\n", DT_BOTTOM);
  printf("#define DT_CALCRECT\t(%d)\n", DT_CALCRECT);
  printf("#define DT_CENTER\t(%d)\n", DT_CENTER);
  printf("#define DT_EDITCONTROL\t(%d)\n", DT_EDITCONTROL);
  printf("#define DT_END_ELLIPSIS\t(%d)\n", DT_END_ELLIPSIS);
  printf("#define DT_PATH_ELLIPSIS\t(%d)\n", DT_PATH_ELLIPSIS);
  printf("#define DT_EXPANDTABS\t(%d)\n", DT_EXPANDTABS);
  printf("#define DT_EXTERNALLEADING\t(%d)\n", DT_EXTERNALLEADING);
  printf("#define DT_LEFT\t(%d)\n", DT_LEFT);
  printf("#define DT_MODIFYSTRING\t(%d)\n", DT_MODIFYSTRING);
  printf("#define DT_NOCLIP\t(%d)\n", DT_NOCLIP);
  printf("#define DT_NOPREFIX\t(%d)\n", DT_NOPREFIX);
  printf("#define DT_RIGHT\t(%d)\n", DT_RIGHT);
  printf("#define DT_RTLREADING\t(%d)\n", DT_RTLREADING);
  printf("#define DT_SINGLELINE\t(%d)\n", DT_SINGLELINE);
  printf("#define DT_TABSTOP\t(%d)\n", DT_TABSTOP);
  printf("#define DT_TOP\t(%d)\n", DT_TOP);
  printf("#define DT_VCENTER\t(%d)\n", DT_VCENTER);
  printf("#define DT_WORDBREAK\t(%d)\n", DT_WORDBREAK);
  printf("#define DT_INTERNAL\t(%d)\n", DT_INTERNAL);

  printf("\n/* DuplicateHandle, MapViewOfFile */\n");
  printf("#define DUPLICATE_CLOSE_SOURCE\t(%d)\n", DUPLICATE_CLOSE_SOURCE);
  printf("#define DUPLICATE_SAME_ACCESS\t(%d)\n", DUPLICATE_SAME_ACCESS);
  printf("#define FILE_MAP_ALL_ACCESS\t(%#lxL)\n", FILE_MAP_ALL_ACCESS);
  printf("#define FILE_MAP_READ\t(%d)\n", FILE_MAP_READ);
  printf("#define FILE_MAP_WRITE\t(%d)\n", FILE_MAP_WRITE);
  printf("#define FILE_MAP_COPY\t(%d)\n", FILE_MAP_COPY);
  printf("#define MUTEX_ALL_ACCESS\t(%#lxL)\n", MUTEX_ALL_ACCESS);
  printf("#define MUTEX_MODIFY_STATE\t(%d)\n", MUTEX_MODIFY_STATE);
  printf("#define SYNCHRONIZE\t(%#lxL)\n", SYNCHRONIZE);
  printf("#define SEMAPHORE_ALL_ACCESS\t(%#lxL)\n", SEMAPHORE_ALL_ACCESS);
  printf("#define SEMAPHORE_MODIFY_STATE\t(%d)\n", SEMAPHORE_MODIFY_STATE);
  printf("#define EVENT_ALL_ACCESS\t(%#lxL)\n", EVENT_ALL_ACCESS);
  printf("#define EVENT_MODIFY_STATE\t(%d)\n", EVENT_MODIFY_STATE);
  printf("#define KEY_ALL_ACCESS\t(%#lxL)\n", KEY_ALL_ACCESS);
  printf("#define KEY_CREATE_LINK\t(%d)\n", KEY_CREATE_LINK);
  printf("#define KEY_CREATE_SUB_KEY\t(%d)\n", KEY_CREATE_SUB_KEY);
  printf("#define KEY_ENUMERATE_SUB_KEYS\t(%d)\n", KEY_ENUMERATE_SUB_KEYS);
  printf("#define KEY_EXECUTE\t(%#lxL)\n", KEY_EXECUTE);
  printf("#define KEY_NOTIFY\t(%d)\n", KEY_NOTIFY);
  printf("#define KEY_QUERY_VALUE\t(%d)\n", KEY_QUERY_VALUE);
  printf("#define KEY_READ\t(%#lxL)\n", KEY_READ);
  printf("#define KEY_SET_VALUE\t(%d)\n", KEY_SET_VALUE);
  printf("#define KEY_WRITE\t(%#lxL)\n", KEY_WRITE);
  printf("#define PROCESS_ALL_ACCESS\t(%#lxL)\n", PROCESS_ALL_ACCESS);
  printf("#define PROCESS_CREATE_PROCESS\t(%d)\n", PROCESS_CREATE_PROCESS);
  printf("#define PROCESS_CREATE_THREAD\t(%d)\n", PROCESS_CREATE_THREAD);
  printf("#define PROCESS_DUP_HANDLE\t(%d)\n", PROCESS_DUP_HANDLE);
  printf("#define PROCESS_QUERY_INFORMATION\t(%d)\n", PROCESS_QUERY_INFORMATION);
  printf("#define PROCESS_SET_INFORMATION\t(%d)\n", PROCESS_SET_INFORMATION);
  printf("#define PROCESS_TERMINATE\t(%d)\n", PROCESS_TERMINATE);
  printf("#define PROCESS_VM_OPERATION\t(%d)\n", PROCESS_VM_OPERATION);
  printf("#define PROCESS_VM_READ\t(%d)\n", PROCESS_VM_READ);
  printf("#define PROCESS_VM_WRITE\t(%d)\n", PROCESS_VM_WRITE);
  printf("#define THREAD_ALL_ACCESS\t(%#lxL)\n", THREAD_ALL_ACCESS);
  printf("#define THREAD_DIRECT_IMPERSONATION\t(%d)\n", THREAD_DIRECT_IMPERSONATION);
  printf("#define THREAD_GET_CONTEXT\t(%d)\n", THREAD_GET_CONTEXT);
  printf("#define THREAD_IMPERSONATE\t(%d)\n", THREAD_IMPERSONATE);
  printf("#define THREAD_QUERY_INFORMATION\t(%d)\n", THREAD_QUERY_INFORMATION);
  printf("#define THREAD_SET_CONTEXT\t(%d)\n", THREAD_SET_CONTEXT);
  printf("#define THREAD_SET_INFORMATION\t(%d)\n", THREAD_SET_INFORMATION);
  printf("#define THREAD_SET_THREAD_TOKEN\t(%d)\n", THREAD_SET_THREAD_TOKEN);
  printf("#define THREAD_SUSPEND_RESUME\t(%d)\n", THREAD_SUSPEND_RESUME);
  printf("#define THREAD_TERMINATE\t(%d)\n", THREAD_TERMINATE);

  printf("\n/* EditWordBreakProc */\n");
  printf("#define WB_ISDELIMITER\t(%d)\n", WB_ISDELIMITER);
  printf("#define WB_LEFT\t(%d)\n", WB_LEFT);
  printf("#define WB_RIGHT\t(%d)\n", WB_RIGHT);

  printf("\n/* EnableScrollBar */\n");
  printf("#define SB_BOTH\t(%d)\n", SB_BOTH);
  printf("#define SB_CTL\t(%d)\n", SB_CTL);
  printf("#define SB_HORZ\t(%d)\n", SB_HORZ);
  printf("#define SB_VERT\t(%d)\n", SB_VERT);
  printf("#define ESB_DISABLE_BOTH\t(%d)\n", ESB_DISABLE_BOTH);
  printf("#define ESB_DISABLE_DOWN\t(%d)\n", ESB_DISABLE_DOWN);
  printf("#define ESB_DISABLE_LEFT\t(%d)\n", ESB_DISABLE_LEFT);
  printf("#define ESB_DISABLE_LTUP\t(%d)\n", ESB_DISABLE_LTUP);
  printf("#define ESB_DISABLE_RIGHT\t(%d)\n", ESB_DISABLE_RIGHT);
  printf("#define ESB_DISABLE_RTDN\t(%d)\n", ESB_DISABLE_RTDN);
  printf("#define ESB_DISABLE_UP\t(%d)\n", ESB_DISABLE_UP);
  printf("#define ESB_ENABLE_BOTH\t(%d)\n", ESB_ENABLE_BOTH);

  printf("\n/* Scroll Bar notifications*/\n");
  printf("#define SB_LINEUP\t(%d)\n", SB_LINEUP);
  printf("#define SB_LINEDOWN\t(%d)\n", SB_LINEDOWN);
  printf("#define SB_LINELEFT\t(%d)\n", SB_LINELEFT);
  printf("#define SB_LINERIGHT\t(%d)\n", SB_LINERIGHT);
  printf("#define SB_PAGEUP\t(%d)\n", SB_PAGEUP);
  printf("#define SB_PAGEDOWN\t(%d)\n", SB_PAGEDOWN);
  printf("#define SB_PAGELEFT\t(%d)\n", SB_PAGELEFT);
  printf("#define SB_PAGERIGHT\t(%d)\n", SB_PAGERIGHT);
  printf("#define SB_THUMBPOSITION\t(%d)\n", SB_THUMBPOSITION);
  printf("#define SB_THUMBTRACK\t(%d)\n", SB_THUMBTRACK);
  printf("#define SB_ENDSCROLL\t(%d)\n", SB_ENDSCROLL);
  printf("#define SB_LEFT\t(%d)\n", SB_LEFT);
  printf("#define SB_RIGHT\t(%d)\n", SB_RIGHT);
  printf("#define SB_BOTTOM\t(%d)\n", SB_BOTTOM);
  printf("#define SB_TOP\t(%d)\n", SB_TOP);

  printf("\n/* EnumCalendarInfo */\n");
  printf("#define ENUM_ALL_CALENDARS\t(%d)\n", ENUM_ALL_CALENDARS);

  printf("\n/* EnumDateFormats */\n");
  printf("#define DATE_SHORTDATE\t(%d)\n", DATE_SHORTDATE);
  printf("#define DATE_LONGDATE\t(%d)\n", DATE_LONGDATE);

  printf("\n/* EnumDependentServices */\n");
  printf("#define SERVICE_ACTIVE\t(%d)\n", SERVICE_ACTIVE);
  printf("#define SERVICE_INACTIVE\t(%d)\n", SERVICE_INACTIVE);

  printf("\n/* EnumFontFamExProc */\n");
  printf("#define DEVICE_FONTTYPE\t(%d)\n", DEVICE_FONTTYPE);
  printf("#define RASTER_FONTTYPE\t(%d)\n", RASTER_FONTTYPE);
  printf("#define TRUETYPE_FONTTYPE\t(%d)\n", TRUETYPE_FONTTYPE);

  printf("\n/* EnumObjects, GetCurrentObject, GetObjectType */\n");
  printf("#define OBJ_BRUSH\t(%d)\n", OBJ_BRUSH);
  printf("#define OBJ_PEN\t(%d)\n", OBJ_PEN);
  printf("#define OBJ_PAL\t(%d)\n", OBJ_PAL);
  printf("#define OBJ_FONT\t(%d)\n", OBJ_FONT);
  printf("#define OBJ_BITMAP\t(%d)\n", OBJ_BITMAP);
  printf("#define OBJ_EXTPEN\t(%d)\n", OBJ_EXTPEN);
  printf("#define OBJ_REGION\t(%d)\n", OBJ_REGION);
  printf("#define OBJ_DC\t(%d)\n", OBJ_DC);
  printf("#define OBJ_MEMDC\t(%d)\n", OBJ_MEMDC);
  printf("#define OBJ_METAFILE\t(%d)\n", OBJ_METAFILE);
  printf("#define OBJ_METADC\t(%d)\n", OBJ_METADC);
  printf("#define OBJ_ENHMETAFILE\t(%d)\n", OBJ_ENHMETAFILE);
  printf("#define OBJ_ENHMETADC\t(%d)\n", OBJ_ENHMETADC);

  printf("\n/* EnumPrinters */\n");
  /* TODO: where is this?
  printf("#define PRINTER_ENUM_CONNECTIONS\t(%d)\n", PRINTER_ENUM_CONNECTIONS);
  printf("#define PRINTER_ENUM_LOCAL\t(%d)\n", PRINTER_ENUM_LOCAL);
  printf("#define PRINTER_ENUM_NAME\t(%d)\n", PRINTER_ENUM_NAME);
  printf("#define PRINTER_ENUM_NETWORK\t(%d)\n", PRINTER_ENUM_NETWORK);
  printf("#define PRINTER_ENUM_REMOTE\t(%d)\n", PRINTER_ENUM_REMOTE);
  printf("#define PRINTER_ENUM_SHARED\t(%d)\n", PRINTER_ENUM_SHARED);
  */

  printf("\n/* EnumProtocols */\n");
  /* These are defined in Sockets.h now
  printf("#define IPPROTO_TCP\t(%d)\n", IPPROTO_TCP);
  printf("#define IPPROTO_UDP\t(%d)\n", IPPROTO_UDP);
  TODO: missing other protocols
  printf("#define ISOPROTO_TP4\t(%d)\n", ISOPROTO_TP4);
  printf("#define NSPROTO_IPX\t(%d)\n", NSPROTO_IPX);
  printf("#define NSPROTO_SPX\t(%d)\n", NSPROTO_SPX);
  printf("#define NSPROTO_SPXII\t(%d)\n", NSPROTO_SPXII);
  */

  printf("\n/* EnumResLangProc */\n");
  printf("#define RT_ACCELERATOR\t(MAKEINTRESOURCE(9))\n");
  printf("#define RT_BITMAP\t(MAKEINTRESOURCE(2))\n");
  printf("#define RT_DIALOG\t(MAKEINTRESOURCE(5))\n");
  printf("#define RT_FONT\t(MAKEINTRESOURCE(8))\n");
  printf("#define RT_FONTDIR\t(MAKEINTRESOURCE(7))\n");
  printf("#define RT_MENU\t(MAKEINTRESOURCE(4))\n");
  printf("#define RT_RCDATA\t(MAKEINTRESOURCE(10))\n");
  printf("#define RT_STRING\t(MAKEINTRESOURCE(6))\n");
  printf("#define RT_MESSAGETABLE\t(MAKEINTRESOURCE(11))\n");
  printf("#define RT_CURSOR\t(MAKEINTRESOURCE(1))\n");
  printf("#define RT_GROUP_CURSOR\t(MAKEINTRESOURCE(12))\n");
  printf("#define RT_ICON\t(MAKEINTRESOURCE(3))\n");
  printf("#define RT_GROUP_ICON\t(MAKEINTRESOURCE(13))\n");
  printf("#define RT_VERSION\t(MAKEINTRESOURCE(16))\n");

  printf("\n/* EnumServicesStatus */\n");
  printf("#define SERVICE_WIN32\t(%d)\n", SERVICE_WIN32);
  printf("#define SERVICE_DRIVER\t(%d)\n", SERVICE_DRIVER);

  printf("\n/* EnumSystemCodePages */\n");
  printf("#define CP_INSTALLED\t(%d)\n", CP_INSTALLED);
  printf("#define CP_SUPPORTED\t(%d)\n", CP_SUPPORTED);

  printf("\n/* EnumSystemLocales */\n");
  printf("#define LCID_INSTALLED\t(%d)\n", LCID_INSTALLED);
  printf("#define LCID_SUPPORTED\t(%d)\n", LCID_SUPPORTED);

  printf("\n/* EraseTape */\n");
  printf("#define TAPE_ERASE_LONG\t(%#lxL)\n", TAPE_ERASE_LONG);
  printf("#define TAPE_ERASE_SHORT\t(%#lxL)\n", TAPE_ERASE_SHORT);

  printf("\n/* Escape */\n");
  printf("#define SP_ERROR\t(%d)\n", SP_ERROR);
  printf("#define SP_OUTOFDISK\t(%d)\n", SP_OUTOFDISK);
  printf("#define SP_OUTOFMEMORY\t(%d)\n", SP_OUTOFMEMORY);
  printf("#define SP_USERABORT\t(%d)\n", SP_USERABORT);
  printf("#define PHYSICALWIDTH\t(%d)\n", PHYSICALWIDTH);
  printf("#define PHYSICALHEIGHT\t(%d)\n", PHYSICALHEIGHT);
  printf("#define PHYSICALOFFSETX\t(%d)\n", PHYSICALOFFSETX);
  printf("#define PHYSICALOFFSETY\t(%d)\n", PHYSICALOFFSETY);
  printf("#define SCALINGFACTORX\t(%d)\n", SCALINGFACTORX);
  printf("#define SCALINGFACTORY\t(%d)\n", SCALINGFACTORY);
  printf("#define QUERYESCSUPPORT\t(%d)\n", QUERYESCSUPPORT);
  printf("#define ABORTDOC\t(%d)\n", ABORTDOC);
  printf("#define ENDDOC\t(%d)\n", ENDDOC);
  printf("#define GETPHYSPAGESIZE\t(%d)\n", GETPHYSPAGESIZE);
  printf("#define GETPRINTINGOFFSET\t(%d)\n", GETPRINTINGOFFSET);
  printf("#define GETSCALINGFACTOR\t(%d)\n", GETSCALINGFACTOR);
  printf("#define NEWFRAME\t(%d)\n", NEWFRAME);
  printf("#define NEXTBAND\t(%d)\n", NEXTBAND);
  printf("#define PASSTHROUGH\t(%d)\n", PASSTHROUGH);
  printf("#define SETABORTPROC\t(%d)\n", SETABORTPROC);
  printf("#define STARTDOC\t(%d)\n", STARTDOC);

  printf("\n/* EscapeCommFunction */\n");
  printf("#define CLRDTR\t(%d)\n", CLRDTR);
  printf("#define CLRRTS\t(%d)\n", CLRRTS);
  printf("#define SETDTR\t(%d)\n", SETDTR);
  printf("#define SETRTS\t(%d)\n", SETRTS);
  printf("#define SETXOFF\t(%d)\n", SETXOFF);
  printf("#define SETXON\t(%d)\n", SETXON);
  printf("#define SETBREAK\t(%d)\n", SETBREAK);
  printf("#define CLRBREAK\t(%d)\n", CLRBREAK);

  printf("\n/* ExitWindowsEx */\n");
  printf("#define EWX_FORCE\t(%d)\n", EWX_FORCE);
  printf("#define EWX_LOGOFF\t(%d)\n", EWX_LOGOFF);
  printf("#define EWX_POWEROFF\t(%d)\n", EWX_POWEROFF);
  printf("#define EWX_REBOOT\t(%d)\n", EWX_REBOOT);
  printf("#define EWX_SHUTDOWN\t(%d)\n", EWX_SHUTDOWN);

  printf("\n/* ExtFloodFill */\n");
  printf("#define FLOODFILLBORDER\t(%d)\n", FLOODFILLBORDER);
  printf("#define FLOODFILLSURFACE\t(%d)\n", FLOODFILLSURFACE);

  printf("\n/* ExtTextOut */\n");
  printf("#define ETO_CLIPPED\t(%d)\n", ETO_CLIPPED);
  printf("#define ETO_GLYPH_INDEX\t(%d)\n", ETO_GLYPH_INDEX);
  printf("#define ETO_OPAQUE\t(%d)\n", ETO_OPAQUE);
  printf("#define ETO_RTLREADING\t(%d)\n", ETO_RTLREADING);

  printf("\n/* FillConsoleOutputAttribute */\n");
  printf("#define FOREGROUND_BLUE\t(%d)\n", FOREGROUND_BLUE);
  printf("#define FOREGROUND_GREEN\t(%d)\n", FOREGROUND_GREEN);
  printf("#define FOREGROUND_RED\t(%d)\n", FOREGROUND_RED);
  printf("#define FOREGROUND_INTENSITY\t(%d)\n", FOREGROUND_INTENSITY);
  printf("#define BACKGROUND_BLUE\t(%d)\n", BACKGROUND_BLUE);
  printf("#define BACKGROUND_GREEN\t(%d)\n", BACKGROUND_GREEN);
  printf("#define BACKGROUND_RED\t(%d)\n", BACKGROUND_RED);
  printf("#define BACKGROUND_INTENSITY\t(%d)\n", BACKGROUND_INTENSITY);

  printf("\n/* FindFirstChangeNotification */\n");
  printf("#define FILE_NOTIFY_CHANGE_FILE_NAME\t(%d)\n", FILE_NOTIFY_CHANGE_FILE_NAME);
  printf("#define FILE_NOTIFY_CHANGE_DIR_NAME\t(%d)\n", FILE_NOTIFY_CHANGE_DIR_NAME);
  printf("#define FILE_NOTIFY_CHANGE_ATTRIBUTES\t(%d)\n", FILE_NOTIFY_CHANGE_ATTRIBUTES);
  printf("#define FILE_NOTIFY_CHANGE_SIZE\t(%d)\n", FILE_NOTIFY_CHANGE_SIZE);
  printf("#define FILE_NOTIFY_CHANGE_LAST_WRITE\t(%d)\n", FILE_NOTIFY_CHANGE_LAST_WRITE);
  printf("#define FILE_NOTIFY_CHANGE_SECURITY\t(%d)\n", FILE_NOTIFY_CHANGE_SECURITY);

  printf("\n/* FindFirstPrinterChangeNotification */\n");
  /* TODO: where is this?
  printf("#define PRINTER_CHANGE_FORM\t(%d)\n", PRINTER_CHANGE_FORM);
  printf("#define PRINTER_CHANGE_JOB\t(%d)\n", PRINTER_CHANGE_JOB);
  printf("#define PRINTER_CHANGE_PORT\t(%d)\n", PRINTER_CHANGE_PORT);
  printf("#define PRINTER_CHANGE_PRINT_PROCESSOR\t(%d)\n", PRINTER_CHANGE_PRINT_PROCESSOR);
  printf("#define PRINTER_CHANGE_PRINTER\t(%d)\n", PRINTER_CHANGE_PRINTER);
  printf("#define PRINTER_CHANGE_PRINTER_DRIVER\t(%d)\n", PRINTER_CHANGE_PRINTER_DRIVER);
  printf("#define PRINTER_CHANGE_ALL\t(%d)\n", PRINTER_CHANGE_ALL);
  */

  printf("\n/* FindNextPrinterNotification */\n");
  /* TODO: where is this?
  printf("#define PRINTER_CHANGE_ADD_FORM\t(%d)\n", PRINTER_CHANGE_ADD_FORM);
  printf("#define PRINTER_CHANGE_ADD_JOB\t(%d)\n", PRINTER_CHANGE_ADD_JOB);
  printf("#define PRINTER_CHANGE_ADD_PORT\t(%d)\n", PRINTER_CHANGE_ADD_PORT);
  printf("#define PRINTER_CHANGE_ADD_PRINT_PROCESSOR\t(%d)\n", PRINTER_CHANGE_ADD_PRINT_PROCESSOR);
  printf("#define PRINTER_CHANGE_ADD_PRINTER\t(%d)\n", PRINTER_CHANGE_ADD_PRINTER);
  printf("#define PRINTER_CHANGE_ADD_PRINTER_DRIVER\t(%d)\n", PRINTER_CHANGE_ADD_PRINTER_DRIVER);
  printf("#define PRINTER_CHANGE_CONFIGURE_PORT\t(%d)\n", PRINTER_CHANGE_CONFIGURE_PORT);
  printf("#define PRINTER_CHANGE_DELETE_FORM\t(%d)\n", PRINTER_CHANGE_DELETE_FORM);
  printf("#define PRINTER_CHANGE_DELETE_JOB\t(%d)\n", PRINTER_CHANGE_DELETE_JOB);
  printf("#define PRINTER_CHANGE_DELETE_PORT\t(%d)\n", PRINTER_CHANGE_DELETE_PORT);
  printf("#define PRINTER_CHANGE_DELETE_PRINT_PROCESSOR\t(%d)\n", PRINTER_CHANGE_DELETE_PRINT_PROCESSOR);
  printf("#define PRINTER_CHANGE_DELETE_PRINTER\t(%d)\n", PRINTER_CHANGE_DELETE_PRINTER);
  printf("#define PRINTER_CHANGE_DELETE_PRINTER_DRIVER\t(%d)\n", PRINTER_CHANGE_DELETE_PRINTER_DRIVER);
  printf("#define PRINTER_CHANGE_FAILED_CONNECTION_PRINTER\t(%d)\n", PRINTER_CHANGE_FAILED_CONNECTION_PRINTER);
  printf("#define PRINTER_CHANGE_SET_FORM\t(%d)\n", PRINTER_CHANGE_SET_FORM);
  printf("#define PRINTER_CHANGE_SET_JOB\t(%d)\n", PRINTER_CHANGE_SET_JOB);
  printf("#define PRINTER_CHANGE_SET_PRINTER\t(%d)\n", PRINTER_CHANGE_SET_PRINTER);
  printf("#define PRINTER_CHANGE_SET_PRINTER_DRIVER\t(%d)\n", PRINTER_CHANGE_SET_PRINTER_DRIVER);
  printf("#define PRINTER_CHANGE_WRITE_JOB\t(%d)\n", PRINTER_CHANGE_WRITE_JOB);
  */

  printf("\n/* FMExtensionProc */\n");
  /* TODO: FileManager extensions
  printf("#define FMEVENT_INITMENU\t(%d)\n", FMEVENT_INITMENU);
  printf("#define FMEVENT_LOAD\t(%d)\n", FMEVENT_LOAD);
  printf("#define FMEVENT_SELCHANGE\t(%d)\n", FMEVENT_SELCHANGE);
  printf("#define FMEVENT_UNLOAD\t(%d)\n", FMEVENT_UNLOAD);
  printf("#define FMEVENT_USER_REFRESH\t(%d)\n", FMEVENT_USER_REFRESH);
  */

  printf("\n/* FoldString */\n");
  printf("#define MAP_FOLDCZONE\t(%d)\n", MAP_FOLDCZONE);
  printf("#define MAP_FOLDDIGITS\t(%d)\n", MAP_FOLDDIGITS);
  printf("#define MAP_PRECOMPOSED\t(%d)\n", MAP_PRECOMPOSED);
  printf("#define MAP_COMPOSITE\t(%d)\n", MAP_COMPOSITE);

  printf("\n/* ForegroundIdleProc */\n");
  printf("#define HC_ACTION\t(%d)\n", HC_ACTION);

  printf("\n/* FormatMessage */\n");
  printf("#define FORMAT_MESSAGE_ALLOCATE_BUFFER\t(%d)\n", FORMAT_MESSAGE_ALLOCATE_BUFFER);
  printf("#define FORMAT_MESSAGE_IGNORE_INSERTS\t(%d)\n", FORMAT_MESSAGE_IGNORE_INSERTS);
  printf("#define FORMAT_MESSAGE_FROM_STRING\t(%d)\n", FORMAT_MESSAGE_FROM_STRING);
  printf("#define FORMAT_MESSAGE_FROM_HMODULE\t(%d)\n", FORMAT_MESSAGE_FROM_HMODULE);
  printf("#define FORMAT_MESSAGE_FROM_SYSTEM\t(%d)\n", FORMAT_MESSAGE_FROM_SYSTEM);
  printf("#define FORMAT_MESSAGE_ARGUMENT_ARRAY\t(%d)\n", FORMAT_MESSAGE_ARGUMENT_ARRAY);
  printf("#define FORMAT_MESSAGE_MAX_WIDTH_MASK\t(%d)\n", FORMAT_MESSAGE_MAX_WIDTH_MASK);

  printf("\n/* GdiComment */\n");
  printf("#define GDICOMMENT_WINDOWS_METAFILE\t(%d)\n", GDICOMMENT_WINDOWS_METAFILE);
  printf("#define GDICOMMENT_BEGINGROUP\t(%d)\n", GDICOMMENT_BEGINGROUP);
  printf("#define GDICOMMENT_ENDGROUP\t(%d)\n", GDICOMMENT_ENDGROUP);
  printf("#define GDICOMMENT_MULTIFORMATS\t(%d)\n", GDICOMMENT_MULTIFORMATS);
  printf("#define GDICOMMENT_IDENTIFIER\t(%d)\n", GDICOMMENT_IDENTIFIER);

  printf("\n/* GenerateConsoleCtrlEvent, HandlerRoutine */\n");
  printf("#define CTRL_C_EVENT\t(%d)\n", CTRL_C_EVENT);
  printf("#define CTRL_BREAK_EVENT\t(%d)\n", CTRL_BREAK_EVENT);
  printf("#define CTRL_CLOSE_EVENT\t(%d)\n", CTRL_CLOSE_EVENT);
  printf("#define CTRL_LOGOFF_EVENT\t(%d)\n", CTRL_LOGOFF_EVENT);
  printf("#define CTRL_SHUTDOWN_EVENT\t(%d)\n", CTRL_SHUTDOWN_EVENT);

  printf("\n/* GetAddressByName */\n");
  /* where is this?
  printf("#define NS_DEFAULT\t(%d)\n", NS_DEFAULT);
  printf("#define NS_DNS\t(%d)\n", NS_DNS);
  printf("#define NS_NETBT\t(%d)\n", NS_NETBT);
  printf("#define NS_SAP\t(%d)\n", NS_SAP);
  printf("#define NS_TCPIP_HOSTS\t(%d)\n", NS_TCPIP_HOSTS);
  printf("#define NS_TCPIP_LOCAL\t(%d)\n", NS_TCPIP_LOCAL);
  printf("#define RES_SERVICE\t(%d)\n", RES_SERVICE);
  printf("#define RES_FIND_MULTIPLE\t(%d)\n", RES_FIND_MULTIPLE);
  printf("#define RES_SOFT_SEARCH\t(%d)\n", RES_SOFT_SEARCH);
  */

  printf("\n/* GetArcDirection */\n");
  printf("#define AD_COUNTERCLOCKWISE\t(%d)\n", AD_COUNTERCLOCKWISE);
  printf("#define AD_CLOCKWISE\t(%d)\n", AD_CLOCKWISE);

  printf("\n/* GetBinaryTypes */\n");
  printf("#define SCS_32BIT_BINARY\t(%d)\n", SCS_32BIT_BINARY);
  printf("#define SCS_DOS_BINARY\t(%d)\n", SCS_DOS_BINARY);
  printf("#define SCS_OS216_BINARY\t(%d)\n", SCS_OS216_BINARY);
  printf("#define SCS_PIF_BINARY\t(%d)\n", SCS_PIF_BINARY);
  printf("#define SCS_POSIX_BINARY\t(%d)\n", SCS_POSIX_BINARY);
  printf("#define SCS_WOW_BINARY\t(%d)\n", SCS_WOW_BINARY);

  printf("\n/* GetBoundsRect, SetBoundsRect */\n");
  printf("#define DCB_DISABLE\t(%d)\n", DCB_DISABLE);
  printf("#define DCB_ENABLE\t(%d)\n", DCB_ENABLE);
  printf("#define DCB_RESET\t(%d)\n", DCB_RESET);
  printf("#define DCB_SET\t(%d)\n", DCB_SET);
  printf("#define DCB_ACCUMULATE\t(%d)\n", DCB_ACCUMULATE);

  printf("\n/* GetCharacterPlacement, GetFontLanguageInfo */\n");
  printf("#define GCP_DBCS\t(%d)\n", GCP_DBCS);
  printf("#define GCP_ERROR\t(%#x)\n", GCP_ERROR);
  printf("#define GCP_CLASSIN\t(%#lxL)\n", GCP_CLASSIN);
  printf("#define GCP_DIACRITIC\t(%d)\n", GCP_DIACRITIC);
  printf("#define GCP_DISPLAYZWG\t(%#lxL)\n", GCP_DISPLAYZWG);
  printf("#define GCP_GLYPHSHAPE\t(%d)\n", GCP_GLYPHSHAPE);
  printf("#define GCP_JUSTIFY\t(%#lxL)\n", GCP_JUSTIFY);
  printf("#define GCP_JUSTIFYIN\t(%#lxL)\n", GCP_JUSTIFYIN);
  printf("#define GCP_KASHIDA\t(%d)\n", GCP_KASHIDA);
  printf("#define GCP_LIGATE\t(%d)\n", GCP_LIGATE);
  printf("#define GCP_MAXEXTENT\t(%#lxL)\n", GCP_MAXEXTENT);
  printf("#define GCP_NEUTRALOVERRIDE\t(%#lxL)\n", GCP_NEUTRALOVERRIDE);
  printf("#define GCP_NUMERICOVERRIDE\t(%#lxL)\n", GCP_NUMERICOVERRIDE);
  printf("#define GCP_NUMERICSLATIN\t(%#lxL)\n", GCP_NUMERICSLATIN);
  printf("#define GCP_NUMERICSLOCAL\t(%#lxL)\n", GCP_NUMERICSLOCAL);
  printf("#define GCP_REORDER\t(%d)\n", GCP_REORDER);
  printf("#define GCP_SYMSWAPOFF\t(%#lxL)\n", GCP_SYMSWAPOFF);
  printf("#define GCP_USEKERNING\t(%d)\n", GCP_USEKERNING);
  printf("#define FLI_GLYPHS\t(%#lxL)\n", FLI_GLYPHS);
  printf("#define FLI_MASK\t(%#x)\n", FLI_MASK);

  printf("\n/* GetClassLong, GetClassWord */\n");
  printf("#define GCW_ATOM\t(%d)\n", GCW_ATOM);
  printf("#define GCL_CBCLSEXTRA\t(%d)\n", GCL_CBCLSEXTRA);
  printf("#define GCL_CBWNDEXTRA\t(%d)\n", GCL_CBWNDEXTRA);
  printf("#define GCL_HBRBACKGROUND\t(%d)\n", GCL_HBRBACKGROUND);
  printf("#define GCL_HCURSOR\t(%d)\n", GCL_HCURSOR);
  printf("#define GCL_HICON\t(%d)\n", GCL_HICON);
  printf("#define GCL_HICONSM\t(%d)\n", GCL_HICONSM);
//  printf("#define GCW_HICONSM\t(%d)\n", GCW_HICONSM);
  printf("#define GCL_HMODULE\t(%d)\n", GCL_HMODULE);
  printf("#define GCL_MENUNAME\t(%d)\n", GCL_MENUNAME);
  printf("#define GCL_STYLE\t(%d)\n", GCL_STYLE);
  printf("#define GCL_WNDPROC\t(%d)\n", GCL_WNDPROC);

  printf("\n/* GetClipboardFormat, SetClipboardData */\n");
  printf("#define CF_BITMAP\t(%d)\n", CF_BITMAP);
  printf("#define CF_DIB\t(%d)\n", CF_DIB);
  printf("#define CF_PALETTE\t(%d)\n", CF_PALETTE);
  printf("#define CF_ENHMETAFILE\t(%d)\n", CF_ENHMETAFILE);
  printf("#define CF_METAFILEPICT\t(%d)\n", CF_METAFILEPICT);
  printf("#define CF_OEMTEXT\t(%d)\n", CF_OEMTEXT);
  printf("#define CF_TEXT\t(%d)\n", CF_TEXT);
  printf("#define CF_UNICODETEXT\t(%d)\n", CF_UNICODETEXT);
  printf("#define CF_DIF\t(%d)\n", CF_DIF);
  printf("#define CF_DSPBITMAP\t(%d)\n", CF_DSPBITMAP);
  printf("#define CF_DSPENHMETAFILE\t(%d)\n", CF_DSPENHMETAFILE);
  printf("#define CF_DSPMETAFILEPICT\t(%d)\n", CF_DSPMETAFILEPICT);
  printf("#define CF_DSPTEXT\t(%d)\n", CF_DSPTEXT);
  printf("#define CF_GDIOBJFIRST\t(%d)\n", CF_GDIOBJFIRST);
  printf("#define CF_GDIOBJLAST\t(%d)\n", CF_GDIOBJLAST);
  printf("#define CF_HDROP\t(%d)\n", CF_HDROP);
  printf("#define CF_LOCALE\t(%d)\n", CF_LOCALE);
  printf("#define CF_OWNERDISPLAY\t(%d)\n", CF_OWNERDISPLAY);
  printf("#define CF_PENDATA\t(%d)\n", CF_PENDATA);
  printf("#define CF_PRIVATEFIRST\t(%d)\n", CF_PRIVATEFIRST);
  printf("#define CF_PRIVATELAST\t(%d)\n", CF_PRIVATELAST);
  printf("#define CF_RIFF\t(%d)\n", CF_RIFF);
  printf("#define CF_SYLK\t(%d)\n", CF_SYLK);
  printf("#define CF_WAVE\t(%d)\n", CF_WAVE);
  printf("#define CF_TIFF\t(%d)\n", CF_TIFF);

  printf("\n/* GetCommMask */\n");
  printf("#define EV_BREAK\t(%d)\n", EV_BREAK);
  printf("#define EV_CTS\t(%d)\n", EV_CTS);
  printf("#define EV_DSR\t(%d)\n", EV_DSR);
  printf("#define EV_ERR\t(%d)\n", EV_ERR);
  printf("#define EV_EVENT1\t(%d)\n", EV_EVENT1);
  printf("#define EV_EVENT2\t(%d)\n", EV_EVENT2);
  printf("#define EV_PERR\t(%d)\n", EV_PERR);
  printf("#define EV_RING\t(%d)\n", EV_RING);
  printf("#define EV_RLSD\t(%d)\n", EV_RLSD);
  printf("#define EV_RX80FULL\t(%d)\n", EV_RX80FULL);
  printf("#define EV_RXCHAR\t(%d)\n", EV_RXCHAR);
  printf("#define EV_RXFLAG\t(%d)\n", EV_RXFLAG);
  printf("#define EV_TXEMPTY\t(%d)\n", EV_TXEMPTY);

  printf("\n/* GetCommModemStatus */\n");
  printf("#define MS_CTS_ON\t(%#lxL)\n", MS_CTS_ON);
  printf("#define MS_DSR_ON\t(%#lxL)\n", MS_DSR_ON);
  printf("#define MS_RING_ON\t(%#lxL)\n", MS_RING_ON);
  printf("#define MS_RLSD_ON\t(%#lxL)\n", MS_RLSD_ON);

  printf("\n/* GetComputerName */\n");
  printf("#define MAX_COMPUTERNAME_LENGTH\t(%d)\n", MAX_COMPUTERNAME_LENGTH);

  printf("\n/* GetConsoleMode */\n");
  printf("#define ENABLE_LINE_INPUT\t(%d)\n", ENABLE_LINE_INPUT);
  printf("#define ENABLE_ECHO_INPUT\t(%d)\n", ENABLE_ECHO_INPUT);
  printf("#define ENABLE_PROCESSED_INPUT\t(%d)\n", ENABLE_PROCESSED_INPUT);
  printf("#define ENABLE_WINDOW_INPUT\t(%d)\n", ENABLE_WINDOW_INPUT);
  printf("#define ENABLE_MOUSE_INPUT\t(%d)\n", ENABLE_MOUSE_INPUT);
  printf("#define ENABLE_PROCESSED_OUTPUT\t(%d)\n", ENABLE_PROCESSED_OUTPUT);
  printf("#define ENABLE_WRAP_AT_EOL_OUTPUT\t(%d)\n", ENABLE_WRAP_AT_EOL_OUTPUT);

  printf("\n/* GetCPInfo */\n");
  printf("#define CP_ACP\t(%d)\n", CP_ACP);
  printf("#define CP_MACCP\t(%d)\n", CP_MACCP);
  printf("#define CP_OEMCP\t(%d)\n", CP_OEMCP);

  printf("\n/* GetDateFormat */\n");
  printf("#define DATE_SHORTDATE\t(%d)\n", DATE_SHORTDATE);
  printf("#define DATE_LONGDATE\t(%d)\n", DATE_LONGDATE);
  printf("#define DATE_USE_ALT_CALENDAR\t(%d)\n", DATE_USE_ALT_CALENDAR);

  printf("\n/* GetDCEx */\n");
  printf("#define DCX_WINDOW\t(%#lxL)\n", DCX_WINDOW);
  printf("#define DCX_CACHE\t(%#lxL)\n", DCX_CACHE);
  printf("#define DCX_PARENTCLIP\t(%#lxL)\n", DCX_PARENTCLIP);
  printf("#define DCX_CLIPSIBLINGS\t(%#lxL)\n", DCX_CLIPSIBLINGS);
  printf("#define DCX_CLIPCHILDREN\t(%#lxL)\n", DCX_CLIPCHILDREN);
  printf("#define DCX_NORESETATTRS\t(%#lxL)\n", DCX_NORESETATTRS);
  printf("#define DCX_LOCKWINDOWUPDATE\t(%#lxL)\n", DCX_LOCKWINDOWUPDATE);
  printf("#define DCX_EXCLUDERGN\t(%#lxL)\n", DCX_EXCLUDERGN);
  printf("#define DCX_INTERSECTRGN\t(%#lxL)\n", DCX_INTERSECTRGN);
  printf("#define DCX_VALIDATE\t(%#lxL)\n", DCX_VALIDATE);

  printf("\n/* GetDeviceCaps */\n");
  printf("#define DRIVERVERSION\t(%d)\n", DRIVERVERSION);
  printf("#define TECHNOLOGY\t(%d)\n", TECHNOLOGY);
  printf("#define DT_PLOTTER\t(%d)\n", DT_PLOTTER);
  printf("#define DT_RASDISPLAY\t(%d)\n", DT_RASDISPLAY);
  printf("#define DT_RASPRINTER\t(%d)\n", DT_RASPRINTER);
  printf("#define DT_RASCAMERA\t(%d)\n", DT_RASCAMERA);
  printf("#define DT_CHARSTREAM\t(%d)\n", DT_CHARSTREAM);
  printf("#define DT_METAFILE\t(%d)\n", DT_METAFILE);
  printf("#define DT_DISPFILE\t(%d)\n", DT_DISPFILE);
  printf("#define HORZSIZE\t(%d)\n", HORZSIZE);
  printf("#define VERTSIZE\t(%d)\n", VERTSIZE);
  printf("#define HORZRES\t(%d)\n", HORZRES);
  printf("#define VERTRES\t(%d)\n", VERTRES);
  printf("#define LOGPIXELSX\t(%d)\n", LOGPIXELSX);
  printf("#define LOGPIXELSY\t(%d)\n", LOGPIXELSY);
  printf("#define BITSPIXEL\t(%d)\n", BITSPIXEL);
  printf("#define PLANES\t(%d)\n", PLANES);
  printf("#define NUMBRUSHES\t(%d)\n", NUMBRUSHES);
  printf("#define NUMPENS\t(%d)\n", NUMPENS);
  printf("#define NUMFONTS\t(%d)\n", NUMFONTS);
  printf("#define NUMCOLORS\t(%d)\n", NUMCOLORS);
  printf("#define ASPECTX\t(%d)\n", ASPECTX);
  printf("#define ASPECTY\t(%d)\n", ASPECTY);
  printf("#define ASPECTXY\t(%d)\n", ASPECTXY);
  printf("#define PDEVICESIZE\t(%d)\n", PDEVICESIZE);
  printf("#define CLIPCAPS\t(%d)\n", CLIPCAPS);
  printf("#define SIZEPALETTE\t(%d)\n", SIZEPALETTE);
  printf("#define NUMRESERVED\t(%d)\n", NUMRESERVED);
  printf("#define COLORRES\t(%d)\n", COLORRES);
  printf("#define PHYSICALWIDTH\t(%d)\n", PHYSICALWIDTH);
  printf("#define PHYSICALHEIGHT\t(%d)\n", PHYSICALHEIGHT);
  printf("#define PHYSICALOFFSETX\t(%d)\n", PHYSICALOFFSETX);
  printf("#define PHYSICALOFFSETY\t(%d)\n", PHYSICALOFFSETY);
  printf("#define SCALINGFACTORX\t(%d)\n", SCALINGFACTORX);
  printf("#define SCALINGFACTORY\t(%d)\n", SCALINGFACTORY);
  printf("#define VREFRESH\t(%d)\n", VREFRESH);
  printf("#define DESKTOPHORZRES\t(%d)\n", DESKTOPHORZRES);
  printf("#define DESKTOPVERTRES\t(%d)\n", DESKTOPVERTRES);
  printf("#define BLTALIGNMENT\t(%d)\n", BLTALIGNMENT);
  printf("#define RASTERCAPS\t(%d)\n", RASTERCAPS);
  printf("#define RC_BANDING\t(%d)\n", RC_BANDING);
  printf("#define RC_BITBLT\t(%d)\n", RC_BITBLT);
  printf("#define RC_BITMAP64\t(%d)\n", RC_BITMAP64);
  printf("#define RC_DI_BITMAP\t(%d)\n", RC_DI_BITMAP);
  printf("#define RC_DIBTODEV\t(%d)\n", RC_DIBTODEV);
  printf("#define RC_FLOODFILL\t(%d)\n", RC_FLOODFILL);
  printf("#define RC_GDI20_OUTPUT\t(%d)\n", RC_GDI20_OUTPUT);
  printf("#define RC_PALETTE\t(%d)\n", RC_PALETTE);
  printf("#define RC_SCALING\t(%d)\n", RC_SCALING);
  printf("#define RC_STRETCHBLT\t(%d)\n", RC_STRETCHBLT);
  printf("#define RC_STRETCHDIB\t(%d)\n", RC_STRETCHDIB);
  printf("#define CURVECAPS\t(%d)\n", CURVECAPS);
  printf("#define CC_NONE\t(%d)\n", CC_NONE);
  printf("#define CC_CIRCLES\t(%d)\n", CC_CIRCLES);
  printf("#define CC_PIE\t(%d)\n", CC_PIE);
  printf("#define CC_CHORD\t(%d)\n", CC_CHORD);
  printf("#define CC_ELLIPSES\t(%d)\n", CC_ELLIPSES);
  printf("#define CC_WIDE\t(%d)\n", CC_WIDE);
  printf("#define CC_STYLED\t(%d)\n", CC_STYLED);
  printf("#define CC_WIDESTYLED\t(%d)\n", CC_WIDESTYLED);
  printf("#define CC_INTERIORS\t(%d)\n", CC_INTERIORS);
  printf("#define CC_ROUNDRECT\t(%d)\n", CC_ROUNDRECT);
  printf("#define LINECAPS\t(%d)\n", LINECAPS);
  printf("#define LC_NONE\t(%d)\n", LC_NONE);
  printf("#define LC_POLYLINE\t(%d)\n", LC_POLYLINE);
  printf("#define LC_MARKER\t(%d)\n", LC_MARKER);
  printf("#define LC_POLYMARKER\t(%d)\n", LC_POLYMARKER);
  printf("#define LC_WIDE\t(%d)\n", LC_WIDE);
  printf("#define LC_STYLED\t(%d)\n", LC_STYLED);
  printf("#define LC_WIDESTYLED\t(%d)\n", LC_WIDESTYLED);
  printf("#define LC_INTERIORS\t(%d)\n", LC_INTERIORS);
  printf("#define POLYGONALCAPS\t(%d)\n", POLYGONALCAPS);
  printf("#define PC_NONE\t(%d)\n", PC_NONE);
  printf("#define PC_POLYGON\t(%d)\n", PC_POLYGON);
  printf("#define PC_RECTANGLE\t(%d)\n", PC_RECTANGLE);
  printf("#define PC_WINDPOLYGON\t(%d)\n", PC_WINDPOLYGON);
  printf("#define PC_SCANLINE\t(%d)\n", PC_SCANLINE);
  printf("#define PC_WIDE\t(%d)\n", PC_WIDE);
  printf("#define PC_STYLED\t(%d)\n", PC_STYLED);
  printf("#define PC_WIDESTYLED\t(%d)\n", PC_WIDESTYLED);
  printf("#define PC_INTERIORS\t(%d)\n", PC_INTERIORS);
  printf("#define TEXTCAPS\t(%d)\n", TEXTCAPS);
  printf("#define TC_OP_CHARACTER\t(%d)\n", TC_OP_CHARACTER);
  printf("#define TC_OP_STROKE\t(%d)\n", TC_OP_STROKE);
  printf("#define TC_CP_STROKE\t(%d)\n", TC_CP_STROKE);
  printf("#define TC_CR_90\t(%d)\n", TC_CR_90);
  printf("#define TC_CR_ANY\t(%d)\n", TC_CR_ANY);
  printf("#define TC_SF_X_YINDEP\t(%d)\n", TC_SF_X_YINDEP);
  printf("#define TC_SA_DOUBLE\t(%d)\n", TC_SA_DOUBLE);
  printf("#define TC_SA_INTEGER\t(%d)\n", TC_SA_INTEGER);
  printf("#define TC_SA_CONTIN\t(%d)\n", TC_SA_CONTIN);
  printf("#define TC_EA_DOUBLE\t(%d)\n", TC_EA_DOUBLE);
  printf("#define TC_IA_ABLE\t(%d)\n", TC_IA_ABLE);
  printf("#define TC_UA_ABLE\t(%d)\n", TC_UA_ABLE);
  printf("#define TC_SO_ABLE\t(%d)\n", TC_SO_ABLE);
  printf("#define TC_RA_ABLE\t(%d)\n", TC_RA_ABLE);
  printf("#define TC_VA_ABLE\t(%d)\n", TC_VA_ABLE);
  printf("#define TC_RESERVED\t(%d)\n", TC_RESERVED);
  printf("#define TC_SCROLLBLT\t(%d)\n", TC_SCROLLBLT);
  printf("#define PC_PATHS\t(%d)\n", PC_PATHS);

  printf("\n/* GetDriveType */\n");
  printf("#define DRIVE_REMOVABLE\t(%d)\n", DRIVE_REMOVABLE);
  printf("#define DRIVE_FIXED\t(%d)\n", DRIVE_FIXED);
  printf("#define DRIVE_REMOTE\t(%d)\n", DRIVE_REMOTE);
  printf("#define DRIVE_CDROM\t(%d)\n", DRIVE_CDROM);
  printf("#define DRIVE_RAMDISK\t(%d)\n", DRIVE_RAMDISK);
  // found these in the knowledge base
  printf("#define DRIVE_UNKNOWN\t(%d)\n", DRIVE_UNKNOWN);
  printf("#define DRIVE_NO_ROOT_DIR\t(%d)\n", DRIVE_NO_ROOT_DIR);

  printf("\n/* GetExceptionCode */\n");
  printf("#define EXCEPTION_ACCESS_VIOLATION\t(%#lxL)\n", EXCEPTION_ACCESS_VIOLATION);
  printf("#define EXCEPTION_BREAKPOINT\t(%#lxL)\n", EXCEPTION_BREAKPOINT);
  printf("#define EXCEPTION_DATATYPE_MISALIGNMENT\t(%#lxL)\n", EXCEPTION_DATATYPE_MISALIGNMENT);
  printf("#define EXCEPTION_SINGLE_STEP\t(%#lxL)\n", EXCEPTION_SINGLE_STEP);
  printf("#define EXCEPTION_ARRAY_BOUNDS_EXCEEDED\t(%#lxL)\n", EXCEPTION_ARRAY_BOUNDS_EXCEEDED);
  printf("#define EXCEPTION_FLT_DENORMAL_OPERAND\t(%#lxL)\n", EXCEPTION_FLT_DENORMAL_OPERAND);
  printf("#define EXCEPTION_FLT_DIVIDE_BY_ZERO\t(%#lxL)\n", EXCEPTION_FLT_DIVIDE_BY_ZERO);
  printf("#define EXCEPTION_FLT_INEXACT_RESULT\t(%#lxL)\n", EXCEPTION_FLT_INEXACT_RESULT);
  printf("#define EXCEPTION_FLT_INVALID_OPERATION\t(%#lxL)\n", EXCEPTION_FLT_INVALID_OPERATION);
  printf("#define EXCEPTION_FLT_OVERFLOW\t(%#lxL)\n", EXCEPTION_FLT_OVERFLOW);
  printf("#define EXCEPTION_FLT_STACK_CHECK\t(%#lxL)\n", EXCEPTION_FLT_STACK_CHECK);
  printf("#define EXCEPTION_FLT_UNDERFLOW\t(%#lxL)\n", EXCEPTION_FLT_UNDERFLOW);
  printf("#define EXCEPTION_INT_DIVIDE_BY_ZERO\t(%#lxL)\n", EXCEPTION_INT_DIVIDE_BY_ZERO);
  printf("#define EXCEPTION_INT_OVERFLOW\t(%#lxL)\n", EXCEPTION_INT_OVERFLOW);
  printf("#define EXCEPTION_PRIV_INSTRUCTION\t(%#lxL)\n", EXCEPTION_PRIV_INSTRUCTION);
  printf("#define EXCEPTION_NONCONTINUABLE_EXCEPTION\t(%#lxL)\n", EXCEPTION_NONCONTINUABLE_EXCEPTION);
  printf("#define EXCEPTION_NONCONTINUABLE\t(%#x)\n", EXCEPTION_NONCONTINUABLE);
  printf("#define EXCEPTION_STACK_OVERFLOW\t(%#lxL)\n", EXCEPTION_STACK_OVERFLOW);
  printf("#define EXCEPTION_INVALID_DISPOSITION\t(%#lxL)\n", EXCEPTION_INVALID_DISPOSITION);

  printf("\n/* GetFileType */\n");
  printf("#define FILE_TYPE_UNKNOWN\t(%d)\n", FILE_TYPE_UNKNOWN);
  printf("#define FILE_TYPE_DISK\t(%d)\n", FILE_TYPE_DISK);
  printf("#define FILE_TYPE_CHAR\t(%d)\n", FILE_TYPE_CHAR);
  printf("#define FILE_TYPE_PIPE\t(%d)\n", FILE_TYPE_PIPE);

  printf("\n/* GetGlyphOutline */\n");
  printf("#define GGO_BITMAP\t(%d)\n", GGO_BITMAP);
  printf("#define GGO_NATIVE\t(%d)\n", GGO_NATIVE);
  printf("#define GGO_METRICS\t(%d)\n", GGO_METRICS);
  printf("#define GGO_GRAY2_BITMAP\t(%d)\n", GGO_GRAY2_BITMAP);
  printf("#define GGO_GRAY4_BITMAP\t(%d)\n", GGO_GRAY4_BITMAP);
  printf("#define GGO_GRAY8_BITMAP\t(%d)\n", GGO_GRAY8_BITMAP);
  printf("#define GDI_ERROR\t(%#lxL)\n", GDI_ERROR);

  printf("\n/* GetGraphicsMode */\n");
  printf("#define GM_COMPATIBLE\t(%d)\n", GM_COMPATIBLE);
  printf("#define GM_ADVANCED\t(%d)\n", GM_ADVANCED);

  printf("\n/* GetHandleInformation */\n");
  printf("#define HANDLE_FLAG_INHERIT\t(%d)\n", HANDLE_FLAG_INHERIT);
  printf("#define HANDLE_FLAG_PROTECT_FROM_CLOSE\t(%d)\n", HANDLE_FLAG_PROTECT_FROM_CLOSE);

  printf("\n/* GetIconInfo */\n");
  printf("#define IDC_ARROW\t(MAKEINTRESOURCE(32512))\n");
  printf("#define IDC_IBEAM\t(MAKEINTRESOURCE(32513))\n");
  printf("#define IDC_WAIT\t(MAKEINTRESOURCE(32514))\n");
  printf("#define IDC_CROSS\t(MAKEINTRESOURCE(32515))\n");
  printf("#define IDC_UPARROW\t(MAKEINTRESOURCE(32516))\n");
  printf("#define IDC_SIZENWSE\t(MAKEINTRESOURCE(32642))\n");
  printf("#define IDC_SIZENESW\t(MAKEINTRESOURCE(32643))\n");
  printf("#define IDC_SIZEWE\t(MAKEINTRESOURCE(32644))\n");
  printf("#define IDC_SIZENS\t(MAKEINTRESOURCE(32645))\n");
  printf("#define IDC_SIZEALL\t(MAKEINTRESOURCE(32646))\n");
  printf("#define IDC_NO\t(MAKEINTRESOURCE(32648))\n");
  printf("#define IDC_APPSTARTING\t(MAKEINTRESOURCE(32650))\n");
  printf("#define IDC_HELP\t(MAKEINTRESOURCE(32651))\n");
  printf("#define IDI_APPLICATION\t(MAKEINTRESOURCE(32512))\n");
  printf("#define IDI_HAND\t(MAKEINTRESOURCE(32513))\n");
  printf("#define IDI_QUESTION\t(MAKEINTRESOURCE(32514))\n");
  printf("#define IDI_EXCLAMATION\t(MAKEINTRESOURCE(32515))\n");
  printf("#define IDI_ASTERISK\t(MAKEINTRESOURCE(32516))\n");
  printf("#define IDI_WINLOGO\t(MAKEINTRESOURCE(32517))\n");

  printf("\n/* GetMapMode */\n");
  printf("#define MM_ANISOTROPIC\t(%d)\n", MM_ANISOTROPIC);
  printf("#define MM_HIENGLISH\t(%d)\n", MM_HIENGLISH);
  printf("#define MM_HIMETRIC\t(%d)\n", MM_HIMETRIC);
  printf("#define MM_ISOTROPIC\t(%d)\n", MM_ISOTROPIC);
  printf("#define MM_LOENGLISH\t(%d)\n", MM_LOENGLISH);
  printf("#define MM_LOMETRIC\t(%d)\n", MM_LOMETRIC);
  printf("#define MM_TEXT\t(%d)\n", MM_TEXT);
  printf("#define MM_TWIPS\t(%d)\n", MM_TWIPS);

  printf("\n/* GetMenuDefaultItem */\n");
  printf("#define GMDI_GOINTOPOPUPS\t(%#lxL)\n", GMDI_GOINTOPOPUPS);
  printf("#define GMDI_USEDISABLED\t(%#lxL)\n", GMDI_USEDISABLED);

  printf("\n/* PeekMessage */\n");
  printf("#define PM_NOREMOVE\t(%d)\n", PM_NOREMOVE);
  printf("#define PM_REMOVE\t(%d)\n", PM_REMOVE);
  printf("#define PM_NOYIELD\t(%d)\n", PM_NOYIELD);

  printf("\n/* GetNamedPipeHandleState */\n");
  printf("#define PIPE_NOWAIT\t(%d)\n", PIPE_NOWAIT);
  printf("#define PIPE_READMODE_MESSAGE\t(%d)\n", PIPE_READMODE_MESSAGE);

  printf("\n/* GetNamedPipeInfo */\n");
  printf("#define PIPE_CLIENT_END\t(%d)\n", PIPE_CLIENT_END);
  printf("#define PIPE_SERVER_END\t(%d)\n", PIPE_SERVER_END);
  printf("#define PIPE_TYPE_MESSAGE\t(%d)\n", PIPE_TYPE_MESSAGE);

  printf("\n/* GetNextWindow, GetWindow */\n");
  printf("#define GW_HWNDNEXT\t(%d)\n", GW_HWNDNEXT);
  printf("#define GW_HWNDPREV\t(%d)\n", GW_HWNDPREV);
  printf("#define GW_CHILD\t(%d)\n", GW_CHILD);
  printf("#define GW_HWNDFIRST\t(%d)\n", GW_HWNDFIRST);
  printf("#define GW_HWNDLAST\t(%d)\n", GW_HWNDLAST);
  printf("#define GW_OWNER\t(%d)\n", GW_OWNER);

  printf("\n/* GetPath */\n");
  printf("#define PT_MOVETO\t(%d)\n", PT_MOVETO);
  printf("#define PT_LINETO\t(%d)\n", PT_LINETO);
  printf("#define PT_BEZIERTO\t(%d)\n", PT_BEZIERTO);
  printf("#define PT_CLOSEFIGURE\t(%d)\n", PT_CLOSEFIGURE);

  printf("\n/* GetProcessShutdownParameters */\n");
  printf("#define SHUTDOWN_NORETRY\t(%d)\n", SHUTDOWN_NORETRY);

  printf("\n/* GetQueueStatus */\n");
  printf("#define QS_ALLEVENTS\t(%d)\n", QS_ALLEVENTS);
  printf("#define QS_ALLINPUT\t(%d)\n", QS_ALLINPUT);
  printf("#define QS_HOTKEY\t(%d)\n", QS_HOTKEY);
  printf("#define QS_INPUT\t(%d)\n", QS_INPUT);
  printf("#define QS_KEY\t(%d)\n", QS_KEY);
  printf("#define QS_MOUSE\t(%d)\n", QS_MOUSE);
  printf("#define QS_MOUSEBUTTON\t(%d)\n", QS_MOUSEBUTTON);
  printf("#define QS_MOUSEMOVE\t(%d)\n", QS_MOUSEMOVE);
  printf("#define QS_PAINT\t(%d)\n", QS_PAINT);
  printf("#define QS_POSTMESSAGE\t(%d)\n", QS_POSTMESSAGE);
  printf("#define QS_SENDMESSAGE\t(%d)\n", QS_SENDMESSAGE);
  printf("#define QS_TIMER\t(%d)\n", QS_TIMER);

  printf("\n/* GetScrollInfo, SetScrollInfo */\n");
  printf("#define SIF_ALL\t(%d)\n", SIF_ALL);
  printf("#define SIF_PAGE\t(%d)\n", SIF_PAGE);
  printf("#define SIF_POS\t(%d)\n", SIF_POS);
  printf("#define SIF_RANGE\t(%d)\n", SIF_RANGE);
  printf("#define SIF_DISABLENOSCROLL\t(%d)\n", SIF_DISABLENOSCROLL);

  printf("\n/* GetStdHandle */\n");
  printf("#define STD_INPUT_HANDLE\t(%#lxL)\n", STD_INPUT_HANDLE);
  printf("#define STD_OUTPUT_HANDLE\t(%#lxL)\n", STD_OUTPUT_HANDLE);
  printf("#define STD_ERROR_HANDLE\t(%#lxL)\n", STD_ERROR_HANDLE);
  printf("#define INVALID_HANDLE_VALUE\t((HANDLE)-1)\n");

  printf("\n/* GetStockObject */\n");
  printf("#define BLACK_BRUSH\t(%d)\n", BLACK_BRUSH);
  printf("#define DKGRAY_BRUSH\t(%d)\n", DKGRAY_BRUSH);
  printf("#define GRAY_BRUSH\t(%d)\n", GRAY_BRUSH);
  printf("#define HOLLOW_BRUSH\t(%d)\n", HOLLOW_BRUSH);
  printf("#define LTGRAY_BRUSH\t(%d)\n", LTGRAY_BRUSH);
  printf("#define NULL_BRUSH\t(%d)\n", NULL_BRUSH);
  printf("#define WHITE_BRUSH\t(%d)\n", WHITE_BRUSH);
  printf("#define BLACK_PEN\t(%d)\n", BLACK_PEN);
  printf("#define NULL_PEN\t(%d)\n", NULL_PEN);
  printf("#define WHITE_PEN\t(%d)\n", WHITE_PEN);
  printf("#define ANSI_FIXED_FONT\t(%d)\n", ANSI_FIXED_FONT);
  printf("#define ANSI_VAR_FONT\t(%d)\n", ANSI_VAR_FONT);
  printf("#define DEVICE_DEFAULT_FONT\t(%d)\n", DEVICE_DEFAULT_FONT);
  printf("#define DEFAULT_GUI_FONT\t(%d)\n", DEFAULT_GUI_FONT);
  printf("#define OEM_FIXED_FONT\t(%d)\n", OEM_FIXED_FONT);
  printf("#define SYSTEM_FONT\t(%d)\n", SYSTEM_FONT);
  printf("#define SYSTEM_FIXED_FONT\t(%d)\n", SYSTEM_FIXED_FONT);
  printf("#define DEFAULT_PALETTE\t(%d)\n", DEFAULT_PALETTE);

  printf("\n/* GetStringTypeA */\n");
  printf("#define CT_CTYPE1\t(%d)\n", CT_CTYPE1);
  printf("#define CT_CTYPE2\t(%d)\n", CT_CTYPE2);
  printf("#define CT_CTYPE3\t(%d)\n", CT_CTYPE3);
  printf("#define C1_UPPER\t(%d)\n", C1_UPPER);
  printf("#define C1_LOWER\t(%d)\n", C1_LOWER);
  printf("#define C1_DIGIT\t(%d)\n", C1_DIGIT);
  printf("#define C1_SPACE\t(%d)\n", C1_SPACE);
  printf("#define C1_PUNCT\t(%d)\n", C1_PUNCT);
  printf("#define C1_CNTRL\t(%d)\n", C1_CNTRL);
  printf("#define C1_BLANK\t(%d)\n", C1_BLANK);
  printf("#define C1_XDIGIT\t(%d)\n", C1_XDIGIT);
  printf("#define C1_ALPHA\t(%d)\n", C1_ALPHA);
  printf("#define C2_LEFTTORIGHT\t(%d)\n", C2_LEFTTORIGHT);
  printf("#define C2_RIGHTTOLEFT\t(%d)\n", C2_RIGHTTOLEFT);
  printf("#define C2_EUROPENUMBER\t(%d)\n", C2_EUROPENUMBER);
  printf("#define C2_EUROPESEPARATOR\t(%d)\n", C2_EUROPESEPARATOR);
  printf("#define C2_EUROPETERMINATOR\t(%d)\n", C2_EUROPETERMINATOR);
  printf("#define C2_ARABICNUMBER\t(%d)\n", C2_ARABICNUMBER);
  printf("#define C2_COMMONSEPARATOR\t(%d)\n", C2_COMMONSEPARATOR);
  printf("#define C2_BLOCKSEPARATOR\t(%d)\n", C2_BLOCKSEPARATOR);
  printf("#define C2_SEGMENTSEPARATOR\t(%d)\n", C2_SEGMENTSEPARATOR);
  printf("#define C2_WHITESPACE\t(%d)\n", C2_WHITESPACE);
  printf("#define C2_OTHERNEUTRAL\t(%d)\n", C2_OTHERNEUTRAL);
  printf("#define C2_NOTAPPLICABLE\t(%d)\n", C2_NOTAPPLICABLE);
  printf("#define C3_NONSPACING\t(%d)\n", C3_NONSPACING);
  printf("#define C3_DIACRITIC\t(%d)\n", C3_DIACRITIC);
  printf("#define C3_VOWELMARK\t(%d)\n", C3_VOWELMARK);
  printf("#define C3_SYMBOL\t(%d)\n", C3_SYMBOL);
  printf("#define C3_KATAKANA\t(%d)\n", C3_KATAKANA);
  printf("#define C3_HIRAGANA\t(%d)\n", C3_HIRAGANA);
  printf("#define C3_HALFWIDTH\t(%d)\n", C3_HALFWIDTH);
  printf("#define C3_FULLWIDTH\t(%d)\n", C3_FULLWIDTH);
  printf("#define C3_IDEOGRAPH\t(%d)\n", C3_IDEOGRAPH);
  printf("#define C3_KASHIDA\t(%d)\n", C3_KASHIDA);
  printf("#define C3_ALPHA\t(%d)\n", C3_ALPHA);
  printf("#define C3_NOTAPPLICABLE\t(%d)\n", C3_NOTAPPLICABLE);

  printf("\n/* GetSysColor */\n");
  printf("#define COLOR_3DDKSHADOW\t(%d)\n", COLOR_3DDKSHADOW);
  printf("#define COLOR_3DFACE\t(%d)\n", COLOR_3DFACE);
  printf("#define COLOR_3DHILIGHT\t(%d)\n", COLOR_3DHILIGHT);
  printf("#define COLOR_3DLIGHT\t(%d)\n", COLOR_3DLIGHT);
  printf("#define COLOR_BTNHILIGHT\t(%d)\n", COLOR_BTNHILIGHT);
  printf("#define COLOR_3DSHADOW\t(%d)\n", COLOR_3DSHADOW);
  printf("#define COLOR_ACTIVEBORDER\t(%d)\n", COLOR_ACTIVEBORDER);
  printf("#define COLOR_ACTIVECAPTION\t(%d)\n", COLOR_ACTIVECAPTION);
  printf("#define COLOR_APPWORKSPACE\t(%d)\n", COLOR_APPWORKSPACE);
  printf("#define COLOR_BACKGROUND\t(%d)\n", COLOR_BACKGROUND);
  printf("#define COLOR_DESKTOP\t(%d)\n", COLOR_DESKTOP);
  printf("#define COLOR_BTNFACE\t(%d)\n", COLOR_BTNFACE);
  printf("#define COLOR_BTNHIGHLIGHT\t(%d)\n", COLOR_BTNHIGHLIGHT);
  printf("#define COLOR_BTNSHADOW\t(%d)\n", COLOR_BTNSHADOW);
  printf("#define COLOR_BTNTEXT\t(%d)\n", COLOR_BTNTEXT);
  printf("#define COLOR_CAPTIONTEXT\t(%d)\n", COLOR_CAPTIONTEXT);
  printf("#define COLOR_GRAYTEXT\t(%d)\n", COLOR_GRAYTEXT);
  printf("#define COLOR_HIGHLIGHT\t(%d)\n", COLOR_HIGHLIGHT);
  printf("#define COLOR_HIGHLIGHTTEXT\t(%d)\n", COLOR_HIGHLIGHTTEXT);
  printf("#define COLOR_INACTIVEBORDER\t(%d)\n", COLOR_INACTIVEBORDER);
  printf("#define COLOR_INACTIVECAPTION\t(%d)\n", COLOR_INACTIVECAPTION);
  printf("#define COLOR_INACTIVECAPTIONTEXT\t(%d)\n", COLOR_INACTIVECAPTIONTEXT);
  printf("#define COLOR_INFOBK\t(%d)\n", COLOR_INFOBK);
  printf("#define COLOR_INFOTEXT\t(%d)\n", COLOR_INFOTEXT);
  printf("#define COLOR_MENU\t(%d)\n", COLOR_MENU);
  printf("#define COLOR_MENUTEXT\t(%d)\n", COLOR_MENUTEXT);
  printf("#define COLOR_SCROLLBAR\t(%d)\n", COLOR_SCROLLBAR);
  printf("#define COLOR_WINDOW\t(%d)\n", COLOR_WINDOW);
  printf("#define COLOR_WINDOWFRAME\t(%d)\n", COLOR_WINDOWFRAME);
  printf("#define COLOR_WINDOWTEXT\t(%d)\n", COLOR_WINDOWTEXT);

  printf("\n/* GetSystemMetrics */\n");
  printf("#define SM_CYMIN\t(%d)\n", SM_CYMIN);
  printf("#define SM_CXMIN\t(%d)\n", SM_CXMIN);
  printf("#define SM_ARRANGE\t(%d)\n", SM_ARRANGE);
  printf("#define SM_CLEANBOOT\t(%d)\n", SM_CLEANBOOT);
  printf("#define SM_CMETRICS\t(%d)\n", SM_CMETRICS);
  printf("#define SM_CMOUSEBUTTONS\t(%d)\n", SM_CMOUSEBUTTONS);
  printf("#define SM_CXBORDER\t(%d)\n", SM_CXBORDER);
  printf("#define SM_CYBORDER\t(%d)\n", SM_CYBORDER);
  printf("#define SM_CXCURSOR\t(%d)\n", SM_CXCURSOR);
  printf("#define SM_CYCURSOR\t(%d)\n", SM_CYCURSOR);
  printf("#define SM_CXDLGFRAME\t(%d)\n", SM_CXDLGFRAME);
  printf("#define SM_CYDLGFRAME\t(%d)\n", SM_CYDLGFRAME);
  printf("#define SM_CXDOUBLECLK\t(%d)\n", SM_CXDOUBLECLK);
  printf("#define SM_CYDOUBLECLK\t(%d)\n", SM_CYDOUBLECLK);
  printf("#define SM_CXDRAG\t(%d)\n", SM_CXFRAME);
  printf("#define SM_CYDRAG\t(%d)\n", SM_CYFRAME);
  printf("#define SM_CXEDGE\t(%d)\n", SM_CXFRAME);
  printf("#define SM_CYEDGE\t(%d)\n", SM_CYFRAME);
  printf("#define SM_CXFIXEDFRAME\t(%d)\n", SM_CXFRAME);
  printf("#define SM_CYFIXEDFRAME\t(%d)\n", SM_CYFRAME);
  printf("#define SM_CXFRAME\t(%d)\n", SM_CXFRAME);
  printf("#define SM_CYFRAME\t(%d)\n", SM_CYFRAME);
  printf("#define SM_CXFULLSCREEN\t(%d)\n", SM_CXFULLSCREEN);
  printf("#define SM_CYFULLSCREEN\t(%d)\n", SM_CYFULLSCREEN);
  printf("#define SM_CXHSCROLL\t(%d)\n", SM_CXHSCROLL);
  printf("#define SM_CYHSCROLL\t(%d)\n", SM_CYHSCROLL);
  printf("#define SM_CXHTHUMB\t(%d)\n", SM_CXHTHUMB);
  printf("#define SM_CXICON\t(%d)\n", SM_CXICON);
  printf("#define SM_CYICON\t(%d)\n", SM_CYICON);
  printf("#define SM_CXICONSPACING\t(%d)\n", SM_CXICONSPACING);
  printf("#define SM_CYICONSPACING\t(%d)\n", SM_CYICONSPACING);
  printf("#define SM_CXMAXIMIZED\t(%d)\n", SM_CXMAXIMIZED);
  printf("#define SM_CYMAXIMIZED\t(%d)\n", SM_CYMAXIMIZED);
  printf("#define SM_CXMAXTRACK\t(%d)\n", SM_CXMAXTRACK);
  printf("#define SM_CYMAXTRACK\t(%d)\n", SM_CYMAXTRACK);
  printf("#define SM_CXMENUCHECK\t(%d)\n", SM_CXMENUCHECK);
  printf("#define SM_CYMENUCHECK\t(%d)\n", SM_CYMENUCHECK);
  printf("#define SM_CXMENUSIZE\t(%d)\n", SM_CXMENUSIZE);
  printf("#define SM_CYMENUSIZE\t(%d)\n", SM_CYMENUSIZE);
  printf("#define SM_CXMINIMIZED\t(%d)\n", SM_CXMINIMIZED);
  printf("#define SM_CYMINIMIZED\t(%d)\n", SM_CYMINIMIZED);
  printf("#define SM_CXMINSPACING\t(%d)\n", SM_CXMINSPACING);
  printf("#define SM_CYMINSPACING\t(%d)\n", SM_CYMINSPACING);
  printf("#define SM_CXMINTRACK\t(%d)\n", SM_CXMINTRACK);
  printf("#define SM_CYMINTRACK\t(%d)\n", SM_CYMINTRACK);
  printf("#define SM_CXSCREEN\t(%d)\n", SM_CXSCREEN);
  printf("#define SM_CYSCREEN\t(%d)\n", SM_CYSCREEN);
  printf("#define SM_CXSIZE\t(%d)\n", SM_CXSIZE);
  printf("#define SM_CYSIZE\t(%d)\n", SM_CYSIZE);
  printf("#define SM_CXSIZEFRAME\t(%d)\n", SM_CXSIZEFRAME);
  printf("#define SM_CYSIZEFRAME\t(%d)\n", SM_CYSIZEFRAME);
  printf("#define SM_CXSMICON\t(%d)\n", SM_CXSMICON);
  printf("#define SM_CYSMICON\t(%d)\n", SM_CYSMICON);
  printf("#define SM_CXSMSIZE\t(%d)\n", SM_CXSMSIZE);
  printf("#define SM_CYSMSIZE\t(%d)\n", SM_CYSMSIZE);
  printf("#define SM_CXVSCROLL\t(%d)\n", SM_CXVSCROLL);
  printf("#define SM_CYHSCROLL\t(%d)\n", SM_CYHSCROLL);
  printf("#define SM_CXHSCROLL\t(%d)\n", SM_CXHSCROLL);
  printf("#define SM_CYVSCROLL\t(%d)\n", SM_CYVSCROLL);
  printf("#define SM_CYVTHUMB\t(%d)\n", SM_CYVTHUMB);
  printf("#define SM_CYCAPTION\t(%d)\n", SM_CYCAPTION);
  printf("#define SM_CYKANJIWINDOW\t(%d)\n", SM_CYKANJIWINDOW);
  printf("#define SM_CYMENU\t(%d)\n", SM_CYMENU);
  printf("#define SM_CYSMCAPTION\t(%d)\n", SM_CYSMCAPTION);
  printf("#define SM_DBCSENABLED\t(%d)\n", SM_DBCSENABLED);
  printf("#define SM_DEBUG\t(%d)\n", SM_DEBUG);
  printf("#define SM_MENUDROPALIGNMENT\t(%d)\n", SM_MENUDROPALIGNMENT);
  printf("#define SM_MIDEASTENABLED\t(%d)\n", SM_MIDEASTENABLED);
  printf("#define SM_MOUSEPRESENT\t(%d)\n", SM_MOUSEPRESENT);
  printf("#define SM_NETWORK\t(%d)\n", SM_NETWORK);
  printf("#define SM_PENWINDOWS\t(%d)\n", SM_PENWINDOWS);
  printf("#define SM_SECURE\t(%d)\n", SM_SECURE);
  printf("#define SM_SHOWSOUNDS\t(%d)\n", SM_SHOWSOUNDS);
  printf("#define SM_SLOWMACHINE\t(%d)\n", SM_SLOWMACHINE);
  printf("#define SM_SWAPBUTTON\t(%d)\n", SM_SWAPBUTTON);
  printf("#define ARW_BOTTOMLEFT\t(%#lxL)\n", ARW_BOTTOMLEFT);
  printf("#define ARW_BOTTOMRIGHT\t(%#lxL)\n", ARW_BOTTOMRIGHT);
  printf("#define ARW_HIDE\t(%#lxL)\n", ARW_HIDE);
  printf("#define ARW_TOPLEFT\t(%#lxL)\n", ARW_TOPLEFT);
  printf("#define ARW_TOPRIGHT\t(%#lxL)\n", ARW_TOPRIGHT);
  printf("#define ARW_DOWN\t(%#lxL)\n", ARW_DOWN);
  printf("#define ARW_LEFT\t(%#lxL)\n", ARW_LEFT);
  printf("#define ARW_RIGHT\t(%#lxL)\n", ARW_RIGHT);
  printf("#define ARW_UP\t(%#lxL)\n", ARW_UP);

  printf("\n/* GetSystemPaletteUse */\n");
  printf("#define SYSPAL_NOSTATIC\t(%d)\n", SYSPAL_NOSTATIC);
  printf("#define SYSPAL_STATIC\t(%d)\n", SYSPAL_STATIC);
  printf("#define SYSPAL_ERROR\t(%d)\n", SYSPAL_ERROR);

  printf("\n/* GetTapeParameters, SetTapeParameters */\n");
  printf("#define GET_TAPE_MEDIA_INFORMATION\t(%d)\n", GET_TAPE_MEDIA_INFORMATION);
  printf("#define GET_TAPE_DRIVE_INFORMATION\t(%d)\n", GET_TAPE_DRIVE_INFORMATION);
  printf("#define SET_TAPE_MEDIA_INFORMATION\t(%d)\n", SET_TAPE_MEDIA_INFORMATION);
  printf("#define SET_TAPE_DRIVE_INFORMATION\t(%d)\n", SET_TAPE_DRIVE_INFORMATION);

  printf("\n/* GetTapePosition */\n");
  printf("#define TAPE_ABSOLUTE_POSITION\t(%#lxL)\n", TAPE_ABSOLUTE_POSITION);
  printf("#define TAPE_LOGICAL_POSITION\t(%#lxL)\n", TAPE_LOGICAL_POSITION);

  printf("\n/* GetTextAlign */\n");
  printf("#define TA_BASELINE\t(%d)\n", TA_BASELINE);
  printf("#define TA_BOTTOM\t(%d)\n", TA_BOTTOM);
  printf("#define TA_TOP\t(%d)\n", TA_TOP);
  printf("#define TA_CENTER\t(%d)\n", TA_CENTER);
  printf("#define TA_LEFT\t(%d)\n", TA_LEFT);
  printf("#define TA_RIGHT\t(%d)\n", TA_RIGHT);
  printf("#define TA_RTLREADING\t(%d)\n", TA_RTLREADING);
  printf("#define TA_NOUPDATECP\t(%d)\n", TA_NOUPDATECP);
  printf("#define TA_UPDATECP\t(%d)\n", TA_UPDATECP);
  printf("#define VTA_BASELINE\t(%d)\n", VTA_BASELINE);
  printf("#define VTA_CENTER\t(%d)\n", VTA_CENTER);

  printf("\n/* GetThreadPriority */\n");
  printf("#define THREAD_PRIORITY_ABOVE_NORMAL\t(%d)\n", THREAD_PRIORITY_ABOVE_NORMAL);
  printf("#define THREAD_PRIORITY_BELOW_NORMAL\t(%d)\n", THREAD_PRIORITY_BELOW_NORMAL);
  printf("#define THREAD_PRIORITY_HIGHEST\t(%d)\n", THREAD_PRIORITY_HIGHEST);
  printf("#define THREAD_PRIORITY_IDLE\t(%d)\n", THREAD_PRIORITY_IDLE);
  printf("#define THREAD_PRIORITY_LOWEST\t(%d)\n", THREAD_PRIORITY_LOWEST);
  printf("#define THREAD_PRIORITY_NORMAL\t(%d)\n", THREAD_PRIORITY_NORMAL);
  printf("#define THREAD_PRIORITY_TIME_CRITICAL\t(%d)\n", THREAD_PRIORITY_TIME_CRITICAL);
  printf("#define THREAD_PRIORITY_ERROR_RETURN\t(%d)\n", THREAD_PRIORITY_ERROR_RETURN);
  printf("#define TLS_MINIMUM_AVAILABLE\t(%d)\n", TLS_MINIMUM_AVAILABLE);

  printf("\n/* GetTimeFormat */\n");
  printf("#define TIME_NOMINUTESORSECONDS\t(%d)\n", TIME_NOMINUTESORSECONDS);
  printf("#define TIME_NOSECONDS\t(%d)\n", TIME_NOSECONDS);
  printf("#define TIME_NOTIMEMARKER\t(%d)\n", TIME_NOTIMEMARKER);
  printf("#define TIME_FORCE24HOURFORMAT\t(%d)\n", TIME_FORCE24HOURFORMAT);

  printf("\n/* GetTimeZoneInformation */\n");
  printf("#define TIME_ZONE_ID_UNKNOWN\t(%d)\n", TIME_ZONE_ID_UNKNOWN);
  printf("#define TIME_ZONE_ID_STANDARD\t(%d)\n", TIME_ZONE_ID_STANDARD);
  printf("#define TIME_ZONE_ID_DAYLIGHT\t(%d)\n", TIME_ZONE_ID_DAYLIGHT);

  printf("\n/* GetUserObjectInformation */\n");
  printf("#define UOI_FLAGS\t(%d)\n", UOI_FLAGS);
  printf("#define UOI_NAME\t(%d)\n", UOI_NAME);
  printf("#define UOI_TYPE\t(%d)\n", UOI_TYPE);

  printf("\n/* GetVolumeInformation */\n");
  printf("#define FS_CASE_IS_PRESERVED\t(%d)\n", FS_CASE_IS_PRESERVED);
  printf("#define FS_CASE_SENSITIVE\t(%d)\n", FS_CASE_SENSITIVE);
  printf("#define FS_UNICODE_STORED_ON_DISK\t(%d)\n", FS_UNICODE_STORED_ON_DISK);
  printf("#define FS_PERSISTENT_ACLS\t(%d)\n", FS_PERSISTENT_ACLS);
  printf("#define FS_FILE_COMPRESSION\t(%d)\n", FS_FILE_COMPRESSION);
  printf("#define FS_VOL_IS_COMPRESSED\t(%d)\n", FS_VOL_IS_COMPRESSED);

  printf("\n/* GetWindowLong */\n");
  printf("#define GWL_EXSTYLE\t(%d)\n", GWL_EXSTYLE);
  printf("#define GWL_STYLE\t(%d)\n", GWL_STYLE);
  printf("#define GWL_WNDPROC\t(%d)\n", GWL_WNDPROC);
  printf("#define GWL_HINSTANCE\t(%d)\n", GWL_HINSTANCE);
  printf("#define GWL_HWNDPARENT\t(%d)\n", GWL_HWNDPARENT);
  printf("#define GWL_ID\t(%d)\n", GWL_ID);
  printf("#define GWL_USERDATA\t(%d)\n", GWL_USERDATA);
  printf("#define DWL_DLGPROC\t(%d)\n", DWL_DLGPROC);
  printf("#define DWL_MSGRESULT\t(%d)\n", DWL_MSGRESULT);
  printf("#define DWL_USER\t(%d)\n", DWL_USER);
  
  printf("\n/* GlobalAlloc, GlobalFlags */\n");
  printf("#define GMEM_FIXED\t(%d)\n", GMEM_FIXED);
  printf("#define GMEM_MOVEABLE\t(%d)\n", GMEM_MOVEABLE);
  printf("#define GPTR\t(%d)\n", GPTR);
  printf("#define GHND\t(%d)\n", GHND);
  printf("#define GMEM_DDESHARE\t(%d)\n", GMEM_DDESHARE);
  printf("#define GMEM_DISCARDABLE\t(%d)\n", GMEM_DISCARDABLE);
  printf("#define GMEM_LOWER\t(%d)\n", GMEM_LOWER);
  printf("#define GMEM_NOCOMPACT\t(%d)\n", GMEM_NOCOMPACT);
  printf("#define GMEM_NODISCARD\t(%d)\n", GMEM_NODISCARD);
  printf("#define GMEM_NOT_BANKED\t(%d)\n", GMEM_NOT_BANKED);
  printf("#define GMEM_NOTIFY\t(%d)\n", GMEM_NOTIFY);
  printf("#define GMEM_SHARE\t(%d)\n", GMEM_SHARE);
  printf("#define GMEM_ZEROINIT\t(%d)\n", GMEM_ZEROINIT);
  printf("#define GMEM_DISCARDED\t(%d)\n", GMEM_DISCARDED);
  printf("#define GMEM_INVALID_HANDLE\t(%d)\n", GMEM_INVALID_HANDLE);
  printf("#define GMEM_LOCKCOUNT\t(%d)\n", GMEM_LOCKCOUNT);

  printf("\n/* HeapAlloc, HeapReAlloc */\n");
  printf("#define HEAP_GENERATE_EXCEPTIONS\t(%d)\n", HEAP_GENERATE_EXCEPTIONS);
  printf("#define HEAP_NO_SERIALIZE\t(%d)\n", HEAP_NO_SERIALIZE);
  printf("#define HEAP_ZERO_MEMORY\t(%d)\n", HEAP_ZERO_MEMORY);
  printf("#define STATUS_NO_MEMORY\t(%#lxL)\n", STATUS_NO_MEMORY);
  printf("#define STATUS_ACCESS_VIOLATION\t(%#lxL)\n", STATUS_ACCESS_VIOLATION);
  printf("#define HEAP_REALLOC_IN_PLACE_ONLY\t(%d)\n", HEAP_REALLOC_IN_PLACE_ONLY);

  printf("\n/* ImageList_Create */\n");
  printf("#define ILC_COLOR\t(%d)\n", ILC_COLOR);
  printf("#define ILC_COLOR4\t(%d)\n", ILC_COLOR4);
  printf("#define ILC_COLOR8\t(%d)\n", ILC_COLOR8);
  printf("#define ILC_COLOR16\t(%d)\n", ILC_COLOR16);
  printf("#define ILC_COLOR24\t(%d)\n", ILC_COLOR24);
  printf("#define ILC_COLOR32\t(%d)\n", ILC_COLOR32);
  printf("#define ILC_COLORDDB\t(%d)\n", ILC_COLORDDB);
  printf("#define ILC_MASK\t(%d)\n", ILC_MASK);
  printf("#define ILC_PALETTE\t(%d)\n", ILC_PALETTE);

  printf("\n/* ImageList_Draw, ImageList_DrawEx */\n");
  printf("#define ILD_BLEND25\t(%d)\n", ILD_BLEND25);
  printf("#define ILD_BLEND50\t(%d)\n", ILD_BLEND50);
  printf("#define ILD_SELECTED\t(%d)\n", ILD_SELECTED);
  printf("#define ILD_BLEND\t(%d)\n", ILD_BLEND);
  printf("#define ILD_FOCUS\t(%d)\n", ILD_FOCUS);
  printf("#define ILD_MASK\t(%d)\n", ILD_MASK);
  printf("#define ILD_NORMAL\t(%d)\n", ILD_NORMAL);
  printf("#define ILD_TRANSPARENT\t(%d)\n", ILD_TRANSPARENT);
  printf("#define CLR_NONE\t(%#lxL)\n", CLR_NONE);
  printf("#define CLR_DEFAULT\t(%#lxL)\n", CLR_DEFAULT);

  printf("\n/* ImageList_LoadImage */\n");
  printf("#define LR_DEFAULTCOLOR\t(%d)\n", LR_DEFAULTCOLOR);
//  printf("#define LR_LOADDEFAULT\t(%d)\n", LR_LOADDEFAULT);
  printf("#define LR_LOADFROMFILE\t(%d)\n", LR_LOADFROMFILE);
  printf("#define LR_LOADMAP3DCOLORS\t(%d)\n", LR_LOADMAP3DCOLORS);
  printf("#define LR_LOADTRANSPARENT\t(%d)\n", LR_LOADTRANSPARENT);
  printf("#define LR_MONOCHROME\t(%d)\n", LR_MONOCHROME);
//  printf("#define LR_SHARE\t(%d)\n", LR_SHARE);

  printf("\n/* ImmConfigureIME */\n");
  printf("#define IME_CONFIG_GENERAL\t(%d)\n", IME_CONFIG_GENERAL);
  printf("#define IME_CONFIG_REGISTERWORD\t(%d)\n", IME_CONFIG_REGISTERWORD);
  printf("#define IME_CONFIG_SELECTDICTIONARY\t(%d)\n", IME_CONFIG_SELECTDICTIONARY);

  printf("\n/* ImmGetConversionList */\n");
  printf("#define GCL_CONVERSION\t(%d)\n", GCL_CONVERSION);
  printf("#define GCL_REVERSECONVERSION\t(%d)\n", GCL_REVERSECONVERSION);
  printf("#define GCL_REVERSE_LENGTH\t(%d)\n", GCL_REVERSE_LENGTH);

  printf("\n/* ImmGetGuideLine */\n");
  printf("#define GGL_LEVEL\t(%d)\n", GGL_LEVEL);
  printf("#define GGL_INDEX\t(%d)\n", GGL_INDEX);
  printf("#define GGL_STRING\t(%d)\n", GGL_STRING);
  printf("#define GGL_PRIVATE\t(%d)\n", GGL_PRIVATE);
  printf("#define GL_LEVEL_ERROR\t(%d)\n", GL_LEVEL_ERROR);
  printf("#define GL_LEVEL_FATAL\t(%d)\n", GL_LEVEL_FATAL);
  printf("#define GL_LEVEL_INFORMATION\t(%d)\n", GL_LEVEL_INFORMATION);
  printf("#define GL_LEVEL_NOGUIDELINE\t(%d)\n", GL_LEVEL_NOGUIDELINE);
  printf("#define GL_LEVEL_WARNING\t(%d)\n", GL_LEVEL_WARNING);
  printf("#define GL_ID_CANNOTSAVE\t(%d)\n", GL_ID_CANNOTSAVE);
  printf("#define GL_ID_NOCONVERT\t(%d)\n", GL_ID_NOCONVERT);
  printf("#define GL_ID_NODICTIONARY\t(%d)\n", GL_ID_NODICTIONARY);
  printf("#define GL_ID_NOMODULE\t(%d)\n", GL_ID_NOMODULE);
  printf("#define GL_ID_READINGCONFLICT\t(%d)\n", GL_ID_READINGCONFLICT);
  printf("#define GL_ID_TOOMANYSTROKE\t(%d)\n", GL_ID_TOOMANYSTROKE);
  printf("#define GL_ID_TYPINGERROR\t(%d)\n", GL_ID_TYPINGERROR);
  printf("#define GL_ID_UNKNOWN\t(%d)\n", GL_ID_UNKNOWN);
  printf("#define GL_ID_INPUTREADING\t(%d)\n", GL_ID_INPUTREADING);
  printf("#define GL_ID_INPUTRADICAL\t(%d)\n", GL_ID_INPUTRADICAL);
  printf("#define GL_ID_INPUTCODE\t(%d)\n", GL_ID_INPUTCODE);
  printf("#define GL_ID_CHOOSECANDIDATE\t(%d)\n", GL_ID_CHOOSECANDIDATE);
  printf("#define GL_ID_REVERSECONVERSION\t(%d)\n", GL_ID_REVERSECONVERSION);

  printf("\n/* ImmGetProperty */\n");
  printf("#define IGP_PROPERTY\t(%d)\n", IGP_PROPERTY);
  printf("#define IGP_CONVERSION\t(%d)\n", IGP_CONVERSION);
  printf("#define IGP_SENTENCE\t(%d)\n", IGP_SENTENCE);
  printf("#define IGP_UI\t(%d)\n", IGP_UI);
  printf("#define IGP_SETCOMPSTR\t(%d)\n", IGP_SETCOMPSTR);
  printf("#define IGP_SELECT\t(%d)\n", IGP_SELECT);
  printf("#define IME_PROP_AT_CARET\t(%d)\n", IME_PROP_AT_CARET);
  printf("#define IME_PROP_SPECIAL_UI\t(%d)\n", IME_PROP_SPECIAL_UI);
  printf("#define IME_PROP_CANDLIST_START_FROM_1\t(%d)\n", IME_PROP_CANDLIST_START_FROM_1);
  printf("#define IME_PROP_UNICODE\t(%d)\n", IME_PROP_UNICODE);
  printf("#define UI_CAP_2700\t(%d)\n", UI_CAP_2700);
  printf("#define UI_CAP_ROT90\t(%d)\n", UI_CAP_ROT90);
  printf("#define UI_CAP_ROTANY\t(%d)\n", UI_CAP_ROTANY);
  printf("#define SCS_CAP_COMPSTR\t(%d)\n", SCS_CAP_COMPSTR);
  printf("#define SCS_CAP_MAKEREAD\t(%d)\n", SCS_CAP_MAKEREAD);
  printf("#define SELECT_CAP_CONVERSION\t(%d)\n", SELECT_CAP_CONVERSION);
  printf("#define SELECT_CAP_SENTENCE\t(%d)\n", SELECT_CAP_SENTENCE);

  printf("\n/* ImmNotifyIME */\n");
  printf("#define NI_CHANGECANDIDATELIST\t(%d)\n", NI_CHANGECANDIDATELIST);
  printf("#define NI_CLOSECANDIDATE\t(%d)\n", NI_CLOSECANDIDATE);
  printf("#define NI_COMPOSITIONSTR\t(%d)\n", NI_COMPOSITIONSTR);
  printf("#define NI_OPENCANDIDATE\t(%d)\n", NI_OPENCANDIDATE);
  printf("#define NI_SELECTCANDIDATESTR\t(%d)\n", NI_SELECTCANDIDATESTR);
  printf("#define NI_SETCANDIDATE_PAGESIZE\t(%d)\n", NI_SETCANDIDATE_PAGESIZE);
  printf("#define NI_SETCANDIDATE_PAGESTART\t(%d)\n", NI_SETCANDIDATE_PAGESTART);
  printf("#define CPS_CANCEL\t(%d)\n", CPS_CANCEL);
  printf("#define CPS_COMPLETE\t(%d)\n", CPS_COMPLETE);
  printf("#define CPS_CONVERT\t(%d)\n", CPS_CONVERT);
  printf("#define CPS_REVERT\t(%d)\n", CPS_REVERT);

  printf("\n/* ImmSetCompositionString */\n");
  printf("#define SCS_SETSTR\t(%d)\n", SCS_SETSTR);
  printf("#define SCS_CHANGEATTR\t(%d)\n", SCS_CHANGEATTR);
  printf("#define SCS_CHANGECLAUSE\t(%d)\n", SCS_CHANGECLAUSE);

  printf("\n/* ImmUnregisterWord */\n");
  printf("#define IME_REGWORD_STYLE_EUDC\t(%d)\n", IME_REGWORD_STYLE_EUDC);
  printf("#define IME_REGWORD_STYLE_USER_FIRST\t0x%8x\n", IME_REGWORD_STYLE_USER_FIRST);
  printf("#define IME_REGWORD_STYLE_USER_LAST\t(%d)\n", IME_REGWORD_STYLE_USER_LAST);

  printf("\n/* InitializeSecurityDescriptor */\n");
  printf("#define SECURITY_DESCRIPTOR_REVISION\t(%d)\n", SECURITY_DESCRIPTOR_REVISION);

  printf("\n/* IsTextUnicode */\n");
  printf("#define IS_TEXT_UNICODE_ASCII16\t(%d)\n", IS_TEXT_UNICODE_ASCII16);
  printf("#define IS_TEXT_UNICODE_REVERSE_ASCII16\t(%d)\n", IS_TEXT_UNICODE_REVERSE_ASCII16);
  printf("#define IS_TEXT_UNICODE_STATISTICS\t(%d)\n", IS_TEXT_UNICODE_STATISTICS);
  printf("#define IS_TEXT_UNICODE_REVERSE_STATISTICS\t(%d)\n", IS_TEXT_UNICODE_REVERSE_STATISTICS);
  printf("#define IS_TEXT_UNICODE_CONTROLS\t(%d)\n", IS_TEXT_UNICODE_CONTROLS);
  printf("#define IS_TEXT_UNICODE_REVERSE_CONTROLS\t(%d)\n", IS_TEXT_UNICODE_REVERSE_CONTROLS);
//  printf("#define IS_TEXT_UNICODE_BUFFER_TOO_SMALL\t(%d)\n", IS_TEXT_UNICODE_BUFFER_TOO_SMALL);
  printf("#define IS_TEXT_UNICODE_SIGNATURE\t(%d)\n", IS_TEXT_UNICODE_SIGNATURE);
  printf("#define IS_TEXT_UNICODE_REVERSE_SIGNATURE\t(%d)\n", IS_TEXT_UNICODE_REVERSE_SIGNATURE);
  printf("#define IS_TEXT_UNICODE_ILLEGAL_CHARS\t(%d)\n", IS_TEXT_UNICODE_ILLEGAL_CHARS);
  printf("#define IS_TEXT_UNICODE_ODD_LENGTH\t(%d)\n", IS_TEXT_UNICODE_ODD_LENGTH);
  printf("#define IS_TEXT_UNICODE_NULL_BYTES\t(%d)\n", IS_TEXT_UNICODE_NULL_BYTES);
  printf("#define IS_TEXT_UNICODE_UNICODE_MASK\t(%d)\n", IS_TEXT_UNICODE_UNICODE_MASK);
  printf("#define IS_TEXT_UNICODE_REVERSE_MASK\t(%d)\n", IS_TEXT_UNICODE_REVERSE_MASK);
  printf("#define IS_TEXT_UNICODE_NOT_UNICODE_MASK\t(%d)\n", IS_TEXT_UNICODE_NOT_UNICODE_MASK);
  printf("#define IS_TEXT_UNICODE_NOT_ASCII_MASK\t(%d)\n", IS_TEXT_UNICODE_NOT_ASCII_MASK);

  printf("\n/* JournalPlaybackProc, KeyboardProc */\n");
  printf("#define HC_GETNEXT\t(%d)\n", HC_GETNEXT);
  printf("#define HC_SKIP\t(%d)\n", HC_SKIP);
  printf("#define HC_SYSMODALOFF\t(%d)\n", HC_SYSMODALOFF);
  printf("#define HC_SYSMODALON\t(%d)\n", HC_SYSMODALON);
  printf("#define HC_NOREMOVE\t(%d)\n", HC_NOREMOVE);

  printf("\n/* keybd_event */\n");
  printf("#define KEYEVENTF_EXTENDEDKEY\t(%d)\n", KEYEVENTF_EXTENDEDKEY);
  printf("#define KEYEVENTF_KEYUP\t(%d)\n", KEYEVENTF_KEYUP);

  printf("\n/* LoadBitmap */\n");
  printf("#define OBM_BTNCORNERS\t(%d)\n", OBM_BTNCORNERS);
  printf("#define OBM_BTSIZE\t(%d)\n", OBM_BTSIZE);
  printf("#define OBM_CHECK\t(%d)\n", OBM_CHECK);
  printf("#define OBM_CHECKBOXES\t(%d)\n", OBM_CHECKBOXES);
  printf("#define OBM_CLOSE\t(%d)\n", OBM_CLOSE);
  printf("#define OBM_COMBO\t(%d)\n", OBM_COMBO);
  printf("#define OBM_DNARROW\t(%d)\n", OBM_DNARROW);
  printf("#define OBM_DNARROWD\t(%d)\n", OBM_DNARROWD);
  printf("#define OBM_DNARROWI\t(%d)\n", OBM_DNARROWI);
  printf("#define OBM_LFARROW\t(%d)\n", OBM_LFARROW);
  printf("#define OBM_LFARROWI\t(%d)\n", OBM_LFARROWI);
  printf("#define OBM_LFARROWD\t(%d)\n", OBM_LFARROWD);
  printf("#define OBM_MNARROW\t(%d)\n", OBM_MNARROW);
  printf("#define OBM_OLD_CLOSE\t(%d)\n", OBM_OLD_CLOSE);
  printf("#define OBM_OLD_DNARROW\t(%d)\n", OBM_OLD_DNARROW);
  printf("#define OBM_OLD_LFARROW\t(%d)\n", OBM_OLD_LFARROW);
  printf("#define OBM_OLD_REDUCE\t(%d)\n", OBM_OLD_REDUCE);
  printf("#define OBM_OLD_RESTORE\t(%d)\n", OBM_OLD_RESTORE);
  printf("#define OBM_OLD_RGARROW\t(%d)\n", OBM_OLD_RGARROW);
  printf("#define OBM_OLD_UPARROW\t(%d)\n", OBM_OLD_UPARROW);
  printf("#define OBM_OLD_ZOOM\t(%d)\n", OBM_OLD_ZOOM);
  printf("#define OBM_REDUCE\t(%d)\n", OBM_REDUCE);
  printf("#define OBM_REDUCED\t(%d)\n", OBM_REDUCED);
  printf("#define OBM_RESTORE\t(%d)\n", OBM_RESTORE);
  printf("#define OBM_RESTORED\t(%d)\n", OBM_RESTORED);
  printf("#define OBM_RGARROW\t(%d)\n", OBM_RGARROW);
  printf("#define OBM_RGARROWD\t(%d)\n", OBM_RGARROWD);
  printf("#define OBM_RGARROWI\t(%d)\n", OBM_RGARROWI);
  printf("#define OBM_SIZE\t(%d)\n", OBM_SIZE);
  printf("#define OBM_UPARROW\t(%d)\n", OBM_UPARROW);
  printf("#define OBM_UPARROWD\t(%d)\n", OBM_UPARROWD);
  printf("#define OBM_UPARROWI\t(%d)\n", OBM_UPARROWI);
  printf("#define OBM_ZOOM\t(%d)\n", OBM_ZOOM);
  printf("#define OBM_ZOOMD\t(%d)\n", OBM_ZOOMD);

  printf("\n/* LoadLibraryEx */\n");
  printf("#define DONT_RESOLVE_DLL_REFERENCES\t(%d)\n", DONT_RESOLVE_DLL_REFERENCES);
  printf("#define LOAD_LIBRARY_AS_DATAFILE\t(%d)\n", LOAD_LIBRARY_AS_DATAFILE);
  printf("#define LOAD_WITH_ALTERED_SEARCH_PATH\t(%d)\n", LOAD_WITH_ALTERED_SEARCH_PATH);

  printf("\n/* LocalAlloc, LocalFlags */\n");
  printf("#define LMEM_FIXED\t(%d)\n", LMEM_FIXED);
  printf("#define LMEM_MOVEABLE\t(%d)\n", LMEM_MOVEABLE);
  printf("#define LPTR\t(%d)\n", LPTR);
  printf("#define LHND\t(%d)\n", LHND);
  printf("#define NONZEROLHND\t(%d)\n", NONZEROLHND);
  printf("#define NONZEROLPTR\t(%d)\n", NONZEROLPTR);
  printf("#define LMEM_NONZEROLHND\t(%d)\n", NONZEROLHND);
  printf("#define LMEM_NONZEROLPTR\t(%d)\n", NONZEROLPTR);
  printf("#define LMEM_DISCARDABLE\t(%d)\n", LMEM_DISCARDABLE);
  printf("#define LMEM_NOCOMPACT\t(%d)\n", LMEM_NOCOMPACT);
  printf("#define LMEM_NODISCARD\t(%d)\n", LMEM_NODISCARD);
  printf("#define LMEM_ZEROINIT\t(%d)\n", LMEM_ZEROINIT);
  printf("#define LMEM_DISCARDED\t(%d)\n", LMEM_DISCARDED);
  printf("#define LMEM_MODIFY\t(%d)\n", LMEM_MODIFY);
  printf("#define LMEM_INVALID_HANDLE\t(%d)\n", LMEM_INVALID_HANDLE);
  printf("#define LMEM_LOCKCOUNT\t(%d)\n", LMEM_LOCKCOUNT);

  printf("\n/* LockFileEx */\n");
  printf("#define LOCKFILE_FAIL_IMMEDIATELY\t(%d)\n", LOCKFILE_FAIL_IMMEDIATELY);
  printf("#define LOCKFILE_EXCLUSIVE_LOCK\t(%d)\n", LOCKFILE_EXCLUSIVE_LOCK);

  printf("\n/* LogonUser */\n");
  /* TODO: where is this?
  printf("#define LOGON32_LOGON_BATCH\t(%d)\n", LOGON32_LOGON_BATCH);
  printf("#define LOGON32_LOGON_INTERACTIVE\t(%d)\n", LOGON32_LOGON_INTERACTIVE);
  printf("#define LOGON32_LOGON_SERVICE\t(%d)\n", LOGON32_LOGON_SERVICE);
  printf("#define LOGON32_PROVIDER_DEFAULT\t(%d)\n", LOGON32_PROVIDER_DEFAULT);
  */

  printf("\n/* LZCopy, LZInit, LZRead */\n");
  /* TODO: where is this?
  printf("#define LZERROR_BADINHANDLE\t(%d)\n", LZERROR_BADINHANDLE);
  printf("#define LZERROR_BADOUTHANDLE\t(%d)\n", LZERROR_BADOUTHANDLE);
  printf("#define LZERROR_GLOBALLOC\t(%d)\n", LZERROR_GLOBALLOC);
  printf("#define LZERROR_GLOBLOCK\t(%d)\n", LZERROR_GLOBLOCK);
  printf("#define LZERROR_READ\t(%d)\n", LZERROR_READ);
  printf("#define LZERROR_UNKNOWNALG\t(%d)\n", LZERROR_UNKNOWNALG);
  printf("#define LZERROR_BADVALUE\t(%d)\n", LZERROR_BADVALUE);
  printf("#define LZERROR_WRITE\t(%d)\n", LZERROR_WRITE);
  */

  printf("\n/* MessageBeep, MessageBox */\n");
  printf("#define MB_USERICON\t(%#lxL)\n", MB_USERICON);
  printf("#define MB_ICONASTERISK\t(%#lxL)\n", MB_ICONASTERISK);
  printf("#define MB_ICONEXCLAMATION\t(%#lxL)\n", MB_ICONEXCLAMATION);
  printf("#define MB_ICONWARNING\t(%#lxL)\n", MB_ICONWARNING);
  printf("#define MB_ICONERROR\t(%#lxL)\n", MB_ICONERROR);
  printf("#define MB_ICONHAND\t(%#lxL)\n", MB_ICONHAND);
  printf("#define MB_ICONQUESTION\t(%#lxL)\n", MB_ICONQUESTION);
  printf("#define MB_OK\t(%#lxL)\n", MB_OK);
  printf("#define MB_ABORTRETRYIGNORE\t(%#lxL)\n", MB_ABORTRETRYIGNORE);
  printf("#define MB_APPLMODAL\t(%#lxL)\n", MB_APPLMODAL);
  printf("#define MB_DEFAULT_DESKTOP_ONLY\t(%#lxL)\n", MB_DEFAULT_DESKTOP_ONLY);
  printf("#define MB_HELP\t(%#lxL)\n", MB_HELP);
  printf("#define MB_RIGHT\t(%#lxL)\n", MB_RIGHT);
  printf("#define MB_RTLREADING\t(%#lxL)\n", MB_RTLREADING);
  printf("#define MB_TOPMOST\t(%#lxL)\n", MB_TOPMOST);
  printf("#define MB_DEFBUTTON1\t(%#lxL)\n", MB_DEFBUTTON1);
  printf("#define MB_DEFBUTTON2\t(%#lxL)\n", MB_DEFBUTTON2);
  printf("#define MB_DEFBUTTON3\t(%#lxL)\n", MB_DEFBUTTON3);
  printf("#define MB_DEFBUTTON4\t(%#lxL)\n", MB_DEFBUTTON4);
  printf("#define MB_ICONINFORMATION\t(%#lxL)\n", MB_ICONINFORMATION);
  printf("#define MB_ICONSTOP\t(%#lxL)\n", MB_ICONSTOP);
  printf("#define MB_OKCANCEL\t(%#lxL)\n", MB_OKCANCEL);
  printf("#define MB_RETRYCANCEL\t(%#lxL)\n", MB_RETRYCANCEL);
  printf("#define MB_SERVICE_NOTIFICATION\t(%#lxL)\n", MB_SERVICE_NOTIFICATION);
  printf("#define MB_SETFOREGROUND\t(%#lxL)\n", MB_SETFOREGROUND);
  printf("#define MB_SYSTEMMODAL\t(%#lxL)\n", MB_SYSTEMMODAL);
  printf("#define MB_TASKMODAL\t(%#lxL)\n", MB_TASKMODAL);
  printf("#define MB_YESNO\t(%#lxL)\n", MB_YESNO);
  printf("#define MB_YESNOCANCEL\t(%#lxL)\n", MB_YESNOCANCEL);
  printf("#define IDABORT\t(%d)\n", IDABORT);
  printf("#define IDCANCEL\t(%d)\n", IDCANCEL);
  printf("#define IDCLOSE\t(%d)\n", IDCLOSE);
  printf("#define IDHELP\t(%d)\n", IDHELP);
  printf("#define IDIGNORE\t(%d)\n", IDIGNORE);
  printf("#define IDNO\t(%d)\n", IDNO);
  printf("#define IDOK\t(%d)\n", IDOK);
  printf("#define IDRETRY\t(%d)\n", IDRETRY);
  printf("#define IDYES\t(%d)\n", IDYES);

  printf("\n/* MessageProc */\n");
//  printf("#define MSGF_DDEMGR\t(%d)\n", MSGF_DDEMGR);
  printf("#define MSGF_DIALOGBOX\t(%d)\n", MSGF_DIALOGBOX);
  printf("#define MSGF_MENU\t(%d)\n", MSGF_MENU);
  printf("#define MSGF_NEXTWINDOW\t(%d)\n", MSGF_NEXTWINDOW);
  printf("#define MSGF_SCROLLBAR\t(%d)\n", MSGF_SCROLLBAR);
  printf("#define MSGF_MAINLOOP\t(%d)\n", MSGF_MAINLOOP);
  printf("#define MSGF_USER\t(%d)\n", MSGF_USER);

  printf("\n/* ModifyWorldTransform */\n");
  printf("#define MWT_IDENTITY\t(%d)\n", MWT_IDENTITY);
  printf("#define MWT_LEFTMULTIPLY\t(%d)\n", MWT_LEFTMULTIPLY);
  printf("#define MWT_RIGHTMULTIPLY\t(%d)\n", MWT_RIGHTMULTIPLY);

  printf("\n/* mouse_event */\n");
  printf("#define MOUSEEVENTF_ABSOLUTE\t(%d)\n", MOUSEEVENTF_ABSOLUTE);
  printf("#define MOUSEEVENTF_MOVE\t(%d)\n", MOUSEEVENTF_MOVE);
  printf("#define MOUSEEVENTF_LEFTDOWN\t(%d)\n", MOUSEEVENTF_LEFTDOWN);
  printf("#define MOUSEEVENTF_LEFTUP\t(%d)\n", MOUSEEVENTF_LEFTUP);
  printf("#define MOUSEEVENTF_RIGHTDOWN\t(%d)\n", MOUSEEVENTF_RIGHTDOWN);
  printf("#define MOUSEEVENTF_RIGHTUP\t(%d)\n", MOUSEEVENTF_RIGHTUP);
  printf("#define MOUSEEVENTF_MIDDLEDOWN\t(%d)\n", MOUSEEVENTF_MIDDLEDOWN);
  printf("#define MOUSEEVENTF_MIDDLEUP\t(%d)\n", MOUSEEVENTF_MIDDLEUP);

  printf("\n/* MoveFileEx */\n");
  printf("#define MOVEFILE_REPLACE_EXISTING\t(%d)\n", MOVEFILE_REPLACE_EXISTING);
  printf("#define MOVEFILE_COPY_ALLOWED\t(%d)\n", MOVEFILE_COPY_ALLOWED);
  printf("#define MOVEFILE_DELAY_UNTIL_REBOOT\t(%d)\n", MOVEFILE_DELAY_UNTIL_REBOOT);

  printf("\n/* MsgWaitForMultipleObjects, WaitForMultipleObjectsEx */\n");
  printf("#define WAIT_OBJECT_0\t(%#lxL)\n", WAIT_OBJECT_0);
  printf("#define WAIT_ABANDONED_0\t(%#lxL)\n", WAIT_ABANDONED_0);
  printf("#define WAIT_TIMEOUT\t(%#lxL)\n", WAIT_TIMEOUT);
  printf("#define WAIT_IO_COMPLETION\t(%#lxL)\n", WAIT_IO_COMPLETION);
  printf("#define WAIT_ABANDONED\t(%#lxL)\n", WAIT_ABANDONED);
  printf("#define WAIT_FAILED\t(%#lxL)\n", WAIT_FAILED);
  printf("#define MAXIMUM_WAIT_OBJECTS\t(%#x)\n", MAXIMUM_WAIT_OBJECTS);
  printf("#define MAXIMUM_SUSPEND_COUNT\t(%#x)\n", MAXIMUM_SUSPEND_COUNT);

  printf("\n/* MultiByteToWideChar */\n");
  printf("#define MB_PRECOMPOSED\t(%d)\n", MB_PRECOMPOSED);
  printf("#define MB_COMPOSITE\t(%d)\n", MB_COMPOSITE);
  printf("#define MB_ERR_INVALID_CHARS\t(%d)\n", MB_ERR_INVALID_CHARS);
  printf("#define MB_USEGLYPHCHARS\t(%d)\n", MB_USEGLYPHCHARS);

  printf("\n/* NDdeSetTrustedShare */\n");
  /* TODO: where is this?
  printf("#define NDDE_TRUST_SHARE_START\t(%d)\n", NDDE_TRUST_SHARE_START);
  printf("#define NDDE_TRUST_SHARE_INIT\t(%d)\n", NDDE_TRUST_SHARE_INIT);
  printf("#define NDDE_TRUST_SHARE_DEL\t(%d)\n", NDDE_TRUST_SHARE_DEL);
  printf("#define NDDE_TRUST_CMD_SHOWt(%d)\n", NDDE_TRUST_CMD_SHOW);
  printf("#define NDDE_CMD_SHOW_MASK\t(%d)\n", NDDE_CMD_SHOW_MASK);
  */

  printf("\n/* NetAccessCheck */\n");
  /* TODO: where is this?
  printf("#define ACCESS_READ\t(%d)\n", ACCESS_READ);
  printf("#define ACCESS_WRITE\t(%d)\n", ACCESS_WRITE);
  printf("#define ACCESS_CREATE\t(%d)\n", ACCESS_CREATE);
  printf("#define ACCESS_EXEC\t(%d)\n", ACCESS_EXEC);
  printf("#define ACCESS_DELETE\t(%d)\n", ACCESS_DELETE);
  printf("#define ACCESS_ATRIB\t(%d)\n", ACCESS_ATRIB);
  printf("#define ACCESS_PERM\t(%d)\n", ACCESS_PERM);
  printf("#define ACCESS_ALL\t(%d)\n", ACCESS_ALL);
  */

  printf("\n/* NetServerEnum */\n");
  /* TODO: where is this?
  printf("#define SV_TYPE_WORKSTATION\t(%d)\n", SV_TYPE_WORKSTATION);
  printf("#define SV_TYPE_SERVER\t(%d)\n", SV_TYPE_SERVER);
  printf("#define SV_TYPE_SQLSERVER\t(%d)\n", SV_TYPE_SQLSERVER);
  printf("#define SV_TYPE_DOMAIN_CTRL\t(%d)\n", SV_TYPE_DOMAIN_CTRL);
  printf("#define SV_TYPE_DOMAIN_BAKCTRL\t(%d)\n", SV_TYPE_DOMAIN_BAKCTRL);
  printf("#define SV_TYPE_TIMESOURCE\t(%d)\n", SV_TYPE_TIMESOURCE);
  printf("#define SV_TYPE_AFP\t(%d)\n", SV_TYPE_AFP);
  printf("#define SV_TYPE_NOVELL\t(%d)\n", SV_TYPE_NOVELL);
  printf("#define SV_TYPE_DOMAIN_MEMBER\t(%d)\n", SV_TYPE_DOMAIN_MEMBER);
  printf("#define SV_TYPE_PRINT\t(%d)\n", SV_TYPE_PRINT);
  printf("#define SV_TYPE_DIALIN\t(%d)\n", SV_TYPE_DIALIN);
  printf("#define SV_TYPE_XENIX_SERVER\t(%d)\n", SV_TYPE_XENIX_SERVER);
  printf("#define SV_TYPE_NT\t(%d)\n", SV_TYPE_NT);
  printf("#define SV_TYPE_WFW\t(%d)\n", SV_TYPE_WFW);
  printf("#define SV_TYPE_POTENTIAL_BROWSER\t(%d)\n", SV_TYPE_POTENTIAL_BROWSER);
  printf("#define SV_TYPE_BACKUP_BROWSER\t(%d)\n", SV_TYPE_BACKUP_BROWSER);
  printf("#define SV_TYPE_MASTER_BROWSER\t(%d)\n", SV_TYPE_MASTER_BROWSER);
  printf("#define SV_TYPE_DOMAIN_MASTER\t(%d)\n", SV_TYPE_DOMAIN_MASTER);
  printf("#define SV_TYPE_DOMAIN_ENUM\t(%d)\n", SV_TYPE_DOMAIN_ENUM);
  printf("#define SV_TYPE_ALL\t(%d)\n", SV_TYPE_ALL);
  */

  printf("\n/* NetServiceControl */\n");
  /* TODO: where is this?
  printf("#define SERVICE_CTRL_INTERROGATE\t(%d)\n", SERVICE_CTRL_INTERROGATE);
  printf("#define SERVICE_CTRL_PAUSE\t(%d)\n", SERVICE_CTRL_PAUSE);
  printf("#define SERVICE_CTRL_CONTINUE\t(%d)\n", SERVICE_CTRL_CONTINUE);
  printf("#define SERVICE_CTRL_UNINSTALL\t(%d)\n", SERVICE_CTRL_UNINSTALL);
  */

  printf("\n/* NetUserEnum */\n");
  /* TODO: where is this?
  printf("#define FILTER_TEMP_DUPLICATE_ACCOUNTS\t(%d)\n", FILTER_TEMP_DUPLICATE_ACCOUNTS);
  printf("#define FILTER_NORMAL_ACCOUNT\t(%d)\n", FILTER_NORMAL_ACCOUNT);
  printf("#define FILTER_INTERDOMAIN_TRUST_ACCOUNT\t(%d)\n", FILTER_INTERDOMAIN_TRUST_ACCOUNT);
  printf("#define FILTER_WORKSTATION_TRUST_ACCOUNT\t(%d)\n", FILTER_WORKSTATION_TRUST_ACCOUNT);
  printf("#define FILTER_SERVER_TRUST_ACCOUNT\t(%d)\n", FILTER_SERVER_TRUST_ACCOUNT);
  */

  printf("\n/* OpenProcessToken */\n");
  printf("#define TOKEN_ADJUST_DEFAULT\t(%d)\n", TOKEN_ADJUST_DEFAULT);
  printf("#define TOKEN_ADJUST_GROUPS\t(%d)\n", TOKEN_ADJUST_GROUPS);
  printf("#define TOKEN_ADJUST_PRIVILEGES\t(%d)\n", TOKEN_ADJUST_PRIVILEGES);
  printf("#define TOKEN_ALL_ACCESS\t(%#lxL)\n", TOKEN_ALL_ACCESS);
  printf("#define TOKEN_ASSIGN_PRIMARY\t(%d)\n", TOKEN_ASSIGN_PRIMARY);
  printf("#define TOKEN_DUPLICATE\t(%d)\n", TOKEN_DUPLICATE);
  printf("#define TOKEN_EXECUTE\t(%#lxL)\n", TOKEN_EXECUTE);
  printf("#define TOKEN_IMPERSONATE\t(%d)\n", TOKEN_IMPERSONATE);
  printf("#define TOKEN_QUERY\t(%d)\n", TOKEN_QUERY);
  printf("#define TOKEN_QUERY_SOURCE\t(%d)\n", TOKEN_QUERY_SOURCE);
  printf("#define TOKEN_READ\t(%#lxL)\n", TOKEN_READ);
  printf("#define TOKEN_WRITE\t(%#lxL)\n", TOKEN_WRITE);

  printf("\n/* OpenSCManager */\n");
  printf("#define SC_MANAGER_ALL_ACCESS\t(%#lxL)\n", SC_MANAGER_ALL_ACCESS);
  printf("#define SC_MANAGER_CONNECT\t(%d)\n", SC_MANAGER_CONNECT);
  printf("#define SC_MANAGER_CREATE_SERVICE\t(%d)\n", SC_MANAGER_CREATE_SERVICE);
  printf("#define SC_MANAGER_ENUMERATE_SERVICE\t(%d)\n", SC_MANAGER_ENUMERATE_SERVICE);
  printf("#define SC_MANAGER_LOCK\t(%d)\n", SC_MANAGER_LOCK);
  printf("#define SC_MANAGER_QUERY_LOCK_STATUS\t(%d)\n", SC_MANAGER_QUERY_LOCK_STATUS);
  printf("#define SC_MANAGER_MODIFY_BOOT_CONFIG\t(%d)\n", SC_MANAGER_MODIFY_BOOT_CONFIG);

  printf("\n/* PostMessage */\n");
  printf("#define HWND_BROADCAST\t((HWND)0xFFFF)\n");

  printf("\n/* PrepareTape */\n");
  printf("#define TAPE_FORMAT\t(%#lxL)\n", TAPE_FORMAT);
  printf("#define TAPE_LOAD\t(%#lxL)\n", TAPE_LOAD);
  printf("#define TAPE_LOCK\t(%#lxL)\n", TAPE_LOCK);
  printf("#define TAPE_TENSION\t(%#lxL)\n", TAPE_TENSION);
  printf("#define TAPE_UNLOAD\t(%#lxL)\n", TAPE_UNLOAD);
  printf("#define TAPE_UNLOCK\t(%#lxL)\n", TAPE_UNLOCK);

  printf("\n/* PropertySheet */\n");
  printf("#define IS_PSREBOOTSYSTEM\t(%d)\n", ID_PSREBOOTSYSTEM);
  printf("#define IS_PSRESTARTWINDOWS\t(%d)\n", ID_PSRESTARTWINDOWS);

  printf("\n/* PropSheetPageProc */\n");
  printf("#define PSPCB_CREATE\t(%d)\n", PSPCB_CREATE);
  printf("#define PSPCB_RELEASE\t(%d)\n", PSPCB_RELEASE);

  printf("\n/* PurgeComm */\n");
  printf("#define PURGE_TXABORT\t(%d)\n", PURGE_TXABORT);
  printf("#define PURGE_RXABORT\t(%d)\n", PURGE_RXABORT);
  printf("#define PURGE_TXCLEAR\t(%d)\n", PURGE_TXCLEAR);
  printf("#define PURGE_RXCLEAR\t(%d)\n", PURGE_RXCLEAR);

  printf("\n/* QueryServiceObjectSecurity */\n");
  printf("#define OWNER_SECURITY_INFORMATION\t(%#lxL)\n", OWNER_SECURITY_INFORMATION);
  printf("#define GROUP_SECURITY_INFORMATION\t(%#lxL)\n", GROUP_SECURITY_INFORMATION);
  printf("#define DACL_SECURITY_INFORMATION\t(%#lxL)\n", DACL_SECURITY_INFORMATION);
  printf("#define SACL_SECURITY_INFORMATION\t(%#lxL)\n", SACL_SECURITY_INFORMATION);

  printf("\n/* ReadEventLog, ReportEvent */\n");
  printf("#define EVENTLOG_FORWARDS_READ\t(%d)\n", EVENTLOG_FORWARDS_READ);
  printf("#define EVENTLOG_BACKWARDS_READ\t(%d)\n", EVENTLOG_BACKWARDS_READ);
  printf("#define EVENTLOG_SEEK_READ\t(%d)\n", EVENTLOG_SEEK_READ);
  printf("#define EVENTLOG_SEQUENTIAL_READ\t(%d)\n", EVENTLOG_SEQUENTIAL_READ);
  printf("#define EVENTLOG_ERROR_TYPE\t(%d)\n", EVENTLOG_ERROR_TYPE);
  printf("#define EVENTLOG_WARNING_TYPE\t(%d)\n", EVENTLOG_WARNING_TYPE);
  printf("#define EVENTLOG_INFORMATION_TYPE\t(%d)\n", EVENTLOG_INFORMATION_TYPE);
  printf("#define EVENTLOG_AUDIT_SUCCESS\t(%d)\n", EVENTLOG_AUDIT_SUCCESS);
  printf("#define EVENTLOG_AUDIT_FAILURE\t(%d)\n", EVENTLOG_AUDIT_FAILURE);

  printf("\n/* RedrawWindow */\n");
  printf("#define RDW_ERASE\t(%d)\n", RDW_ERASE);
  printf("#define RDW_FRAME\t(%d)\n", RDW_FRAME);
  printf("#define RDW_INTERNALPAINT\t(%d)\n", RDW_INTERNALPAINT);
  printf("#define RDW_INVALIDATE\t(%d)\n", RDW_INVALIDATE);
  printf("#define RDW_NOERASE\t(%d)\n", RDW_NOERASE);
  printf("#define RDW_NOFRAME\t(%d)\n", RDW_NOFRAME);
  printf("#define RDW_NOINTERNALPAINT\t(%d)\n", RDW_NOINTERNALPAINT);
  printf("#define RDW_VALIDATE\t(%d)\n", RDW_VALIDATE);
  printf("#define RDW_ERASENOW\t(%d)\n", RDW_ERASENOW);
  printf("#define RDW_UPDATENOW\t(%d)\n", RDW_UPDATENOW);
  printf("#define RDW_ALLCHILDREN\t(%d)\n", RDW_ALLCHILDREN);
  printf("#define RDW_NOCHILDREN\t(%d)\n", RDW_NOCHILDREN);

  printf("\n/* RegCreateKey */\n");
  printf("#define HKEY_CLASSES_ROOT\t((HKEY)0x80000000)\n");
  printf("#define HKEY_CURRENT_USER\t((HKEY)0x80000001)\n");
  printf("#define HKEY_LOCAL_MACHINE\t((HKEY)0x80000002)\n");
  printf("#define HKEY_USERS\t((HKEY)0x80000003)\n");
  printf("#define HKEY_PERFORMANCE_DATA\t((HKEY)0x80000004)\n");
  printf("#define HKEY_CURRENT_CONFIG\t((HKEY)0x80000005)\n");

  printf("\n/* RegCreateKeyEx */\n");
  printf("#define REG_OPTION_VOLATILE\t(%#lxL)\n", REG_OPTION_VOLATILE);
  printf("#define REG_OPTION_NON_VOLATILE\t(%#lxL)\n", REG_OPTION_NON_VOLATILE);
  printf("#define REG_CREATED_NEW_KEY\t(%#lxL)\n", REG_CREATED_NEW_KEY);
  printf("#define REG_OPENED_EXISTING_KEY\t(%#lxL)\n", REG_OPENED_EXISTING_KEY);

  printf("\n/* RegEnumValue */\n");
  printf("#define REG_BINARY\t(%d)\n", REG_BINARY);
  printf("#define REG_DWORD\t(%d)\n", REG_DWORD);
  printf("#define REG_DWORD_LITTLE_ENDIAN\t(%d)\n", REG_DWORD_LITTLE_ENDIAN);
  printf("#define REG_DWORD_BIG_ENDIAN\t(%d)\n", REG_DWORD_BIG_ENDIAN);
  printf("#define REG_EXPAND_SZ\t(%d)\n", REG_EXPAND_SZ);
  printf("#define REG_LINK\t(%d)\n", REG_LINK);
  printf("#define REG_MULTI_SZ\t(%d)\n", REG_MULTI_SZ);
  printf("#define REG_NONE\t(%d)\n", REG_NONE);
  printf("#define REG_RESOURCE_LIST\t(%d)\n", REG_RESOURCE_LIST);
  printf("#define REG_SZ\t(%d)\n", REG_SZ);

  printf("\n/* RegisterHotKey */\n");
  printf("#define MOD_ALT\t(%d)\n", MOD_ALT);
  printf("#define MOD_CONTROL\t(%d)\n", MOD_CONTROL);
  printf("#define MOD_SHIFT\t(%d)\n", MOD_SHIFT);
  printf("#define MOD_WIN\t(%d)\n", MOD_WIN);
  printf("#define IDHOT_SNAPDESKTOP\t(%d)\n", IDHOT_SNAPDESKTOP);
  printf("#define IDHOT_SNAPWINDOW\t(%d)\n", IDHOT_SNAPWINDOW);

  printf("\n/* RegNotifyChangeKeyValue */\n");
  printf("#define REG_NOTIFY_CHANGE_NAME\t(%#lxL)\n", REG_NOTIFY_CHANGE_NAME);
  printf("#define REG_NOTIFY_CHANGE_ATTRIBUTES\t(%#lxL)\n", REG_NOTIFY_CHANGE_ATTRIBUTES);
  printf("#define REG_NOTIFY_CHANGE_LAST_SET\t(%#lxL)\n", REG_NOTIFY_CHANGE_LAST_SET);
  printf("#define REG_NOTIFY_CHANGE_SECURITY\t(%#lxL)\n", REG_NOTIFY_CHANGE_SECURITY);

  printf("\n/* ScrollWindowEx */\n");
  printf("#define SW_ERASE\t(%d)\n", SW_ERASE);
  printf("#define SW_INVALIDATE\t(%d)\n", SW_INVALIDATE);
  printf("#define SW_SCROLLCHILDREN\t(%d)\n", SW_SCROLLCHILDREN);

  printf("\n/* SendMessageTimeout */\n");
  printf("#define SMTO_ABORTIFHUNG\t(%d)\n", SMTO_ABORTIFHUNG);
  printf("#define SMTO_BLOCK\t(%d)\n", SMTO_BLOCK);
  printf("#define SMTO_NORMAL\t(%d)\n", SMTO_NORMAL);

  printf("\n/* SetBkMode */\n");
  printf("#define OPAQUE\t(%d)\n", OPAQUE);
  printf("#define TRANSPARENT\t(%d)\n", TRANSPARENT);

  printf("\n/* SetDebugErrorLevel */\n");
  printf("#define SLE_ERROR\t(%d)\n", SLE_ERROR);
  printf("#define SLE_MINORERROR\t(%d)\n", SLE_MINORERROR);
  printf("#define SLE_WARNING\t(%d)\n", SLE_WARNING);

  printf("\n/* SetErrorMode */\n");
  printf("#define SEM_FAILCRITICALERRORS\t(%d)\n", SEM_FAILCRITICALERRORS);
  printf("#define SEM_NOALIGNMENTFAULTEXCEPT\t(%d)\n", SEM_NOALIGNMENTFAULTEXCEPT);
  printf("#define SEM_NOGPFAULTERRORBOX\t(%d)\n", SEM_NOGPFAULTERRORBOX);
  printf("#define SEM_NOOPENFILEERRORBOX\t(%d)\n", SEM_NOOPENFILEERRORBOX);

  printf("\n/* SetICMMode */\n");
  printf("#define ICM_ON\t(%d)\n", ICM_ON);
  printf("#define ICM_OFF\t(%d)\n", ICM_OFF);
  printf("#define ICM_QUERY\t(%d)\n", ICM_QUERY);

  printf("\n/* SetJob */\n");
  /* TODO: where is this?
  printf("#define JOB_CONTROL_CANCEL\t(%d)\n", JOB_CONTROL_CANCEL);
  printf("#define JOB_CONTROL_PAUSE\t(%d)\n", JOB_CONTROL_PAUSE);
  printf("#define JOB_CONTROL_RESTART\t(%d)\n", JOB_CONTROL_RESTART);
  printf("#define JOB_CONTROL_RESUME\t(%d)\n", JOB_CONTROL_RESUME);
  */

  printf("\n/* Locale Information */\n");
  printf("#define LOCALE_ILANGUAGE\t(%d)\n", LOCALE_ILANGUAGE);
  printf("#define LOCALE_SLANGUAGE\t(%d)\n", LOCALE_SLANGUAGE);
  printf("#define LOCALE_SENGLANGUAGE\t(%d)\n", LOCALE_SENGLANGUAGE);
  printf("#define LOCALE_SABBREVLANGNAME\t(%d)\n", LOCALE_SABBREVLANGNAME);
  printf("#define LOCALE_SNATIVELANGNAME\t(%d)\n", LOCALE_SNATIVELANGNAME);
  printf("#define LOCALE_ICOUNTRY\t(%d)\n", LOCALE_ICOUNTRY);
  printf("#define LOCALE_SCOUNTRY\t(%d)\n", LOCALE_SCOUNTRY);
  printf("#define LOCALE_SENGCOUNTRY\t(%d)\n", LOCALE_SENGCOUNTRY);
  printf("#define LOCALE_SABBREVCTRYNAME\t(%d)\n", LOCALE_SABBREVCTRYNAME);
  printf("#define LOCALE_SNATIVECTRYNAME\t(%d)\n", LOCALE_SNATIVECTRYNAME);
  printf("#define LOCALE_IDEFAULTLANGUAGE\t(%d)\n", LOCALE_IDEFAULTLANGUAGE);
  printf("#define LOCALE_IDEFAULTCOUNTRY\t(%d)\n", LOCALE_IDEFAULTCOUNTRY);
  printf("#define LOCALE_IDEFAULTANSICODEPAGE\t(%d)\n", LOCALE_IDEFAULTANSICODEPAGE);
//  printf("#define LOCALE_IDEFAULTOEMCODEPAGE\t(%d)\n", LOCALE_IDEFAULTOEMCODEPAGE);
  printf("#define LOCALE_IDEFAULTCODEPAGE\t(%d)\n", LOCALE_IDEFAULTCODEPAGE);
  printf("#define LOCALE_SLIST\t(%d)\n", LOCALE_SLIST);
  printf("#define LOCALE_IMEASURE\t(%d)\n", LOCALE_IMEASURE);
  printf("#define LOCALE_SDECIMAL\t(%d)\n", LOCALE_SDECIMAL);
  printf("#define LOCALE_STHOUSAND\t(%d)\n", LOCALE_STHOUSAND);
  printf("#define LOCALE_SGROUPING\t(%d)\n", LOCALE_SGROUPING);
  printf("#define LOCALE_IDIGITS\t(%d)\n", LOCALE_IDIGITS);
  printf("#define LOCALE_ILZERO\t(%d)\n", LOCALE_ILZERO);
  printf("#define LOCALE_INEGNUMBER\t(%d)\n", LOCALE_INEGNUMBER);
//  printf("#define LOCALE_SNATIVEDIGITS\t(%d)\n", LOCALE_SNATIVEDIGITS);
  printf("#define LOCALE_SCURRENCY\t(%d)\n", LOCALE_SCURRENCY);
//  printf("#define LOCALE_SINTLSYMBOL\t(%d)\n", LOCALE_SINTLSYMBOL);
  printf("#define LOCALE_SMONDECIMALSEP\t(%d)\n", LOCALE_SMONDECIMALSEP);
  printf("#define LOCALE_SMONTHOUSANDSEP\t(%d)\n", LOCALE_SMONTHOUSANDSEP);
  printf("#define LOCALE_SMONGROUPING\t(%d)\n", LOCALE_SMONGROUPING);
  printf("#define LOCALE_ICURRDIGITS\t(%d)\n", LOCALE_ICURRDIGITS);
//  printf("#define LOCALE_IINTLCURRDIGITS\t(%d)\n", LOCALE_IINTLCURRDIGITS);
  printf("#define LOCALE_ICURRENCY\t(%d)\n", LOCALE_ICURRENCY);
  printf("#define LOCALE_INEGCURR\t(%d)\n", LOCALE_INEGCURR);
  printf("#define LOCALE_SDATE\t(%d)\n", LOCALE_SDATE);
  printf("#define LOCALE_STIME\t(%d)\n", LOCALE_STIME);
  printf("#define LOCALE_STIMEFORMAT\t(%d)\n", LOCALE_STIMEFORMAT);
  printf("#define LOCALE_SSHORTDATE\t(%d)\n", LOCALE_SSHORTDATE);
  printf("#define LOCALE_SLONGDATE\t(%d)\n", LOCALE_SLONGDATE);
  printf("#define LOCALE_IDATE\t(%d)\n", LOCALE_IDATE);
  printf("#define LOCALE_ILDATE\t(%d)\n", LOCALE_ILDATE);
  printf("#define LOCALE_ITIME\t(%d)\n", LOCALE_ITIME);
  printf("#define LOCALE_ITLZERO\t(%d)\n", LOCALE_ITLZERO);
  printf("#define LOCALE_IDAYLZERO\t(%d)\n", LOCALE_IDAYLZERO);
  printf("#define LOCALE_IMONLZERO\t(%d)\n", LOCALE_IMONLZERO);
  printf("#define LOCALE_S1159\t(%d)\n", LOCALE_S1159);
  printf("#define LOCALE_S2359\t(%d)\n", LOCALE_S2359);
  printf("#define LOCALE_ICALENDARTYPE\t(%d)\n", LOCALE_ICALENDARTYPE);
  printf("#define LOCALE_IOPTIONALCALENDAR\t(%d)\n", LOCALE_IOPTIONALCALENDAR);
  printf("#define LOCALE_IFIRSTDAYOFWEEK\t(%d)\n", LOCALE_IFIRSTDAYOFWEEK);
  printf("#define LOCALE_IFIRSTWEEKOFYEAR\t(%d)\n", LOCALE_IFIRSTWEEKOFYEAR);
  printf("#define LOCALE_SDAYNAME1\t(%d)\n", LOCALE_SDAYNAME1);
  printf("#define LOCALE_SDAYNAME2\t(%d)\n", LOCALE_SDAYNAME2);
  printf("#define LOCALE_SDAYNAME3\t(%d)\n", LOCALE_SDAYNAME3);
  printf("#define LOCALE_SDAYNAME4\t(%d)\n", LOCALE_SDAYNAME4);
  printf("#define LOCALE_SDAYNAME5\t(%d)\n", LOCALE_SDAYNAME5);
  printf("#define LOCALE_SDAYNAME6\t(%d)\n", LOCALE_SDAYNAME6);
  printf("#define LOCALE_SDAYNAME7\t(%d)\n", LOCALE_SDAYNAME7);
  printf("#define LOCALE_SABBREVDAYNAME1\t(%d)\n", LOCALE_SABBREVDAYNAME1);
  printf("#define LOCALE_SABBREVDAYNAME2\t(%d)\n", LOCALE_SABBREVDAYNAME2);
  printf("#define LOCALE_SABBREVDAYNAME3\t(%d)\n", LOCALE_SABBREVDAYNAME3);
  printf("#define LOCALE_SABBREVDAYNAME4\t(%d)\n", LOCALE_SABBREVDAYNAME4);
  printf("#define LOCALE_SABBREVDAYNAME5\t(%d)\n", LOCALE_SABBREVDAYNAME5);
  printf("#define LOCALE_SABBREVDAYNAME6\t(%d)\n", LOCALE_SABBREVDAYNAME6);
  printf("#define LOCALE_SABBREVDAYNAME7\t(%d)\n", LOCALE_SABBREVDAYNAME7);
  printf("#define LOCALE_SMONTHNAME1\t(%d)\n", LOCALE_SMONTHNAME1);
  printf("#define LOCALE_SMONTHNAME2\t(%d)\n", LOCALE_SMONTHNAME2);
  printf("#define LOCALE_SMONTHNAME3\t(%d)\n", LOCALE_SMONTHNAME3);
  printf("#define LOCALE_SMONTHNAME4\t(%d)\n", LOCALE_SMONTHNAME4);
  printf("#define LOCALE_SMONTHNAME5\t(%d)\n", LOCALE_SMONTHNAME5);
  printf("#define LOCALE_SMONTHNAME6\t(%d)\n", LOCALE_SMONTHNAME6);
  printf("#define LOCALE_SMONTHNAME7\t(%d)\n", LOCALE_SMONTHNAME7);
  printf("#define LOCALE_SMONTHNAME8\t(%d)\n", LOCALE_SMONTHNAME8);
  printf("#define LOCALE_SMONTHNAME9\t(%d)\n", LOCALE_SMONTHNAME9);
  printf("#define LOCALE_SMONTHNAME10\t(%d)\n", LOCALE_SMONTHNAME10);
  printf("#define LOCALE_SMONTHNAME11\t(%d)\n", LOCALE_SMONTHNAME11);
  printf("#define LOCALE_SMONTHNAME12\t(%d)\n", LOCALE_SMONTHNAME12);
  printf("#define LOCALE_SMONTHNAME13\t(%d)\n", LOCALE_SMONTHNAME13);
  printf("#define LOCALE_SABBREVMONTHNAME1\t(%d)\n", LOCALE_SABBREVMONTHNAME1);
  printf("#define LOCALE_SABBREVMONTHNAME2\t(%d)\n", LOCALE_SABBREVMONTHNAME2);
  printf("#define LOCALE_SABBREVMONTHNAME3\t(%d)\n", LOCALE_SABBREVMONTHNAME3);
  printf("#define LOCALE_SABBREVMONTHNAME4\t(%d)\n", LOCALE_SABBREVMONTHNAME4);
  printf("#define LOCALE_SABBREVMONTHNAME5\t(%d)\n", LOCALE_SABBREVMONTHNAME5);
  printf("#define LOCALE_SABBREVMONTHNAME6\t(%d)\n", LOCALE_SABBREVMONTHNAME6);
  printf("#define LOCALE_SABBREVMONTHNAME7\t(%d)\n", LOCALE_SABBREVMONTHNAME7);
  printf("#define LOCALE_SABBREVMONTHNAME8\t(%d)\n", LOCALE_SABBREVMONTHNAME8);
  printf("#define LOCALE_SABBREVMONTHNAME9\t(%d)\n", LOCALE_SABBREVMONTHNAME9);
  printf("#define LOCALE_SABBREVMONTHNAME10\t(%d)\n", LOCALE_SABBREVMONTHNAME10);
  printf("#define LOCALE_SABBREVMONTHNAME11\t(%d)\n", LOCALE_SABBREVMONTHNAME11);
  printf("#define LOCALE_SABBREVMONTHNAME12\t(%d)\n", LOCALE_SABBREVMONTHNAME12);
  printf("#define LOCALE_SABBREVMONTHNAME13\t(%d)\n", LOCALE_SABBREVMONTHNAME13);
  printf("#define LOCALE_SPOSITIVESIGN\t(%d)\n", LOCALE_SPOSITIVESIGN);
  printf("#define LOCALE_SNEGATIVESIGN\t(%d)\n", LOCALE_SNEGATIVESIGN);
  printf("#define LOCALE_IPOSSIGNPOSN\t(%d)\n", LOCALE_IPOSSIGNPOSN);
  printf("#define LOCALE_INEGSIGNPOSN\t(%d)\n", LOCALE_INEGSIGNPOSN);
  printf("#define LOCALE_IPOSSYMPRECEDES\t(%d)\n", LOCALE_IPOSSYMPRECEDES);
  printf("#define LOCALE_IPOSSEPBYSPACE\t(%d)\n", LOCALE_IPOSSEPBYSPACE);
  printf("#define LOCALE_INEGSYMPRECEDES\t(%d)\n", LOCALE_INEGSYMPRECEDES);
  printf("#define LOCALE_INEGSEPBYSPACE\t(%d)\n", LOCALE_INEGSEPBYSPACE);
  printf("#define LOCALE_NOUSEROVERRIDE\t(%#x)\n", LOCALE_NOUSEROVERRIDE);

  printf("\n/* Calendar Type Information */\n");
  printf("#define CAL_ICALINTVALUE\t(%d)\n", CAL_ICALINTVALUE);
  printf("#define CAL_IYEAROFFSETRANGE\t(%d)\n", CAL_IYEAROFFSETRANGE);
  printf("#define CAL_SABBREVDAYNAME1\t(%d)\n", CAL_SABBREVDAYNAME1);
  printf("#define CAL_SABBREVDAYNAME2\t(%d)\n", CAL_SABBREVDAYNAME2);
  printf("#define CAL_SABBREVDAYNAME3\t(%d)\n", CAL_SABBREVDAYNAME3);
  printf("#define CAL_SABBREVDAYNAME4\t(%d)\n", CAL_SABBREVDAYNAME4);
  printf("#define CAL_SABBREVDAYNAME5\t(%d)\n", CAL_SABBREVDAYNAME5);
  printf("#define CAL_SABBREVDAYNAME6\t(%d)\n", CAL_SABBREVDAYNAME6);
  printf("#define CAL_SABBREVDAYNAME7\t(%d)\n", CAL_SABBREVDAYNAME7);
  printf("#define CAL_SABBREVMONTHNAME1\t(%d)\n", CAL_SABBREVMONTHNAME1);
  printf("#define CAL_SABBREVMONTHNAME2\t(%d)\n", CAL_SABBREVMONTHNAME2);
  printf("#define CAL_SABBREVMONTHNAME3\t(%d)\n", CAL_SABBREVMONTHNAME3);
  printf("#define CAL_SABBREVMONTHNAME4\t(%d)\n", CAL_SABBREVMONTHNAME4);
  printf("#define CAL_SABBREVMONTHNAME5\t(%d)\n", CAL_SABBREVMONTHNAME5);
  printf("#define CAL_SABBREVMONTHNAME6\t(%d)\n", CAL_SABBREVMONTHNAME6);
  printf("#define CAL_SABBREVMONTHNAME7\t(%d)\n", CAL_SABBREVMONTHNAME7);
  printf("#define CAL_SABBREVMONTHNAME8\t(%d)\n", CAL_SABBREVMONTHNAME8);
  printf("#define CAL_SABBREVMONTHNAME9\t(%d)\n", CAL_SABBREVMONTHNAME9);
  printf("#define CAL_SABBREVMONTHNAME10\t(%d)\n", CAL_SABBREVMONTHNAME10);
  printf("#define CAL_SABBREVMONTHNAME11\t(%d)\n", CAL_SABBREVMONTHNAME11);
  printf("#define CAL_SABBREVMONTHNAME12\t(%d)\n", CAL_SABBREVMONTHNAME12);
  printf("#define CAL_SABBREVMONTHNAME13\t(%d)\n", CAL_SABBREVMONTHNAME13);
  printf("#define CAL_SCALNAME\t(%d)\n", CAL_SCALNAME);
  printf("#define CAL_SDAYNAME1\t(%d)\n", CAL_SDAYNAME1);
  printf("#define CAL_SDAYNAME2\t(%d)\n", CAL_SDAYNAME2);
  printf("#define CAL_SDAYNAME3\t(%d)\n", CAL_SDAYNAME3);
  printf("#define CAL_SDAYNAME4\t(%d)\n", CAL_SDAYNAME4);
  printf("#define CAL_SDAYNAME5\t(%d)\n", CAL_SDAYNAME5);
  printf("#define CAL_SDAYNAME6\t(%d)\n", CAL_SDAYNAME6);
  printf("#define CAL_SDAYNAME7\t(%d)\n", CAL_SDAYNAME7);
  printf("#define CAL_SERASTRING\t(%d)\n", CAL_SERASTRING);
  printf("#define CAL_SLONGDATE\t(%d)\n", CAL_SLONGDATE);
  printf("#define CAL_SMONTHNAME1\t(%d)\n", CAL_SMONTHNAME1);
  printf("#define CAL_SMONTHNAME2\t(%d)\n", CAL_SMONTHNAME2);
  printf("#define CAL_SMONTHNAME3\t(%d)\n", CAL_SMONTHNAME3);
  printf("#define CAL_SMONTHNAME4\t(%d)\n", CAL_SMONTHNAME4);
  printf("#define CAL_SMONTHNAME5\t(%d)\n", CAL_SMONTHNAME5);
  printf("#define CAL_SMONTHNAME6\t(%d)\n", CAL_SMONTHNAME6);
  printf("#define CAL_SMONTHNAME7\t(%d)\n", CAL_SMONTHNAME7);
  printf("#define CAL_SMONTHNAME8\t(%d)\n", CAL_SMONTHNAME8);
  printf("#define CAL_SMONTHNAME9\t(%d)\n", CAL_SMONTHNAME9);
  printf("#define CAL_SMONTHNAME10\t(%d)\n", CAL_SMONTHNAME10);
  printf("#define CAL_SMONTHNAME11\t(%d)\n", CAL_SMONTHNAME11);
  printf("#define CAL_SMONTHNAME12\t(%d)\n", CAL_SMONTHNAME12);
  printf("#define CAL_SMONTHNAME13\t(%d)\n", CAL_SMONTHNAME13);
  printf("#define CAL_SSHORTDATE\t(%d)\n", CAL_SSHORTDATE);

  printf("\n/* SetProcessWorkingSetSize */\n");
  printf("#define PROCESS_SET_QUOTA\t(%d)\n", PROCESS_SET_QUOTA);

  printf("\n/* SetPrinter */\n");
  /* TODO: where is this?
  printf("#define PRINTER_CONTROL_PAUSE\t(%d)\n", PRINTER_CONTROL_PAUSE);
  printf("#define PRINTER_CONTROL_PURGE\t(%d)\n", PRINTER_CONTROL_PURGE);
  printf("#define PRINTER_CONTROL_RESUME\t(%d)\n", PRINTER_CONTROL_RESUME);
  printf("#define PRINTER_CONTROL_SET_STATUS\t(%d)\n", PRINTER_CONTROL_SET_STATUS);
  */

  printf("\n/* SetService */\n");
  /* TODO: where is this?
  printf("#define SERVICE_REGISTER\t(%d)\n", SERVICE_REGISTER);
  printf("#define SERVICE_DEREGISTER\t(%d)\n", SERVICE_DEREGISTER);
  printf("#define SERVICE_FLUSH\t(%d)\n", SERVICE_FLUSH);
  printf("#define SERVICE_ADD_TYPE\t(%d)\n", SERVICE_ADD_TYPE);
  printf("#define SERVICE_DELETE_TYPE\t(%d)\n", SERVICE_DELETE_TYPE);
  printf("#define SERVICE_FLAG_DEFER\t(%d)\n", SERVICE_FLAG_DEFER);
  printf("#define SERVICE_FLAG_HARD\t(%d)\n", SERVICE_FLAG_HARD);
  printf("#define SET_SERVICE_PARTIAL_SUCCESS\t(%d)\n", SET_SERVICE_PARTIAL_SUCCESS);
  */

  printf("\n/* SetStretchBltMode */\n");
  printf("#define BLACKONWHITE\t(%d)\n", BLACKONWHITE);
  printf("#define COLORONCOLOR\t(%d)\n", COLORONCOLOR);
  printf("#define HALFTONE\t(%d)\n", HALFTONE);
  printf("#define STRETCH_ANDSCANS\t(%d)\n", STRETCH_ANDSCANS);
  printf("#define STRETCH_DELETESCANS\t(%d)\n", STRETCH_DELETESCANS);
  printf("#define STRETCH_HALFTONE\t(%d)\n", STRETCH_HALFTONE);
  printf("#define STRETCH_ORSCANS\t(%d)\n", STRETCH_ORSCANS);
  printf("#define WHITEONBLACK\t(%d)\n", WHITEONBLACK);

  printf("\n/* SetSystemCursor */\n");
  printf("#define OCR_NORMAL\t(%d)\n", OCR_NORMAL);
  printf("#define OCR_IBEAM\t(%d)\n", OCR_IBEAM);
  printf("#define OCR_WAIT\t(%d)\n", OCR_WAIT);
  printf("#define OCR_CROSS\t(%d)\n", OCR_CROSS);
  printf("#define OCR_UP\t(%d)\n", OCR_UP);
  printf("#define OCR_SIZE\t(%d)\n", OCR_SIZE);
  printf("#define OCR_ICON\t(%d)\n", OCR_ICON);
  printf("#define OCR_SIZENWSE\t(%d)\n", OCR_SIZENWSE);
  printf("#define OCR_SIZENESW\t(%d)\n", OCR_SIZENESW);
  printf("#define OCR_SIZEWE\t(%d)\n", OCR_SIZEWE);
  printf("#define OCR_SIZENS\t(%d)\n", OCR_SIZENS);
  printf("#define OCR_SIZEALL\t(%d)\n", OCR_SIZEALL);
  printf("#define OCR_NO\t(%d)\n", OCR_NO);
  printf("#define OCR_APPSTARTING\t(%d)\n", OCR_APPSTARTING);

  printf("\n/* SetTapePosition */\n");
  printf("#define TAPE_ABSOLUTE_BLOCK\t(%#lxL)\n", TAPE_ABSOLUTE_BLOCK);
  printf("#define TAPE_LOGICAL_BLOCK\t(%#lxL)\n", TAPE_LOGICAL_BLOCK);
  printf("#define TAPE_REWIND\t(%#lxL)\n", TAPE_REWIND);
  printf("#define TAPE_SPACE_END_OF_DATA\t(%#lxL)\n", TAPE_SPACE_END_OF_DATA);
  printf("#define TAPE_SPACE_FILEMARKS\t(%#lxL)\n", TAPE_SPACE_FILEMARKS);
  printf("#define TAPE_SPACE_RELATIVE_BLOCKS\t(%#lxL)\n", TAPE_SPACE_RELATIVE_BLOCKS);
  printf("#define TAPE_SPACE_SEQUENTIAL_FMKS\t(%#lxL)\n", TAPE_SPACE_SEQUENTIAL_FMKS);
  printf("#define TAPE_SPACE_SEQUENTIAL_SMKS\t(%#lxL)\n", TAPE_SPACE_SEQUENTIAL_SMKS);
  printf("#define TAPE_SPACE_SETMARKS\t(%#lxL)\n", TAPE_SPACE_SETMARKS);

  printf("\n/* SetUnhandledExceptionFilter */\n");
  printf("#define EXCEPTION_EXECUTE_HANDLER\t(%d)\n", EXCEPTION_EXECUTE_HANDLER);
  printf("#define EXCEPTION_CONTINUE_EXECUTION\t(%d)\n", EXCEPTION_CONTINUE_EXECUTION);
  printf("#define EXCEPTION_CONTINUE_SEARCH\t(%d)\n", EXCEPTION_CONTINUE_SEARCH);

  printf("\n/* SetWindowPos, DeferWindowPos */\n");
  printf("#define HWND_BOTTOM\t((HWND)1)\n");
  printf("#define HWND_NOTOPMOST\t((HWND)-2)\n");
  printf("#define HWND_TOP\t((HWND)0)\n");
  printf("#define HWND_TOPMOST\t((HWND)-1)\n");
  printf("#define SWP_DRAWFRAME\t(%d)\n", SWP_DRAWFRAME);
  printf("#define SWP_FRAMECHANGED\t(%d)\n", SWP_FRAMECHANGED);
  printf("#define SWP_HIDEWINDOW\t(%d)\n", SWP_HIDEWINDOW);
  printf("#define SWP_NOACTIVATE\t(%d)\n", SWP_NOACTIVATE);
  printf("#define SWP_NOCOPYBITS\t(%d)\n", SWP_NOCOPYBITS);
  printf("#define SWP_NOMOVE\t(%d)\n", SWP_NOMOVE);
  printf("#define SWP_NOSIZE\t(%d)\n", SWP_NOSIZE);
  printf("#define SWP_NOREDRAW\t(%d)\n", SWP_NOREDRAW);
  printf("#define SWP_NOZORDER\t(%d)\n", SWP_NOZORDER);
  printf("#define SWP_SHOWWINDOW\t(%d)\n", SWP_SHOWWINDOW);
  printf("#define SWP_NOOWNERZORDER\t(%d)\n", SWP_NOOWNERZORDER);
  printf("#define SWP_NOREPOSITION\t(%d)\n", SWP_NOREPOSITION);
  printf("#define SWP_NOSENDCHANGING\t(%d)\n", SWP_NOSENDCHANGING);

  printf("\n/* SHAddToRecentDocs */\n");
  /* TODO: where is this?
  printf("#define SHARD_PATH\t(%d)\n", SHARD_PATH);
  printf("#define SHARD_PIDL\t(%d)\n", SHARD_PIDL);
  */

  printf("\n/* SHAppBarMessage */\n");
  /* TODO: where is this?
  printf("#define ABM_ACTIVATE\t(%d)\n", ABM_ACTIVATE);
  printf("#define ABM_GETAUTOHIDEBAR\t(%d)\n", ABM_GETAUTOHIDEBAR);
  printf("#define ABM_GETSTATE\t(%d)\n", ABM_GETSTATE);
  printf("#define ABM_GETTASKBARPOS\t(%d)\n", ABM_GETTASKBARPOS);
  printf("#define ABM_NEW\t(%d)\n", ABM_NEW);
  printf("#define ABM_QUERYPOS\t(%d)\n", ABM_QUERYPOS);
  printf("#define ABM_REMOVE\t(%d)\n", ABM_REMOVE);
  printf("#define ABM_SETAUTOHIDEBAR\t(%d)\n", ABM_SETAUTOHIDEBAR);
  printf("#define ABM_SETPOS\t(%d)\n", ABM_SETPOS);
  printf("#define ABM_WINDOWPOSCHANGED\t(%d)\n", ABM_WINDOWPOSCHANGED);
  */

  printf("\n/* SHChangeNotify */\n");
  /* TODO: where is this?
  printf("#define SHCNE_ASSOCCHANGED\t(%d)\n", SHCNE_ASSOCCHANGED);
  printf("#define SHCNE_ATTRIBUTES\t(%d)\n", SHCNE_ATTRIBUTES);
  printf("#define SHCNE_CREATE\t(%d)\n", SHCNE_CREATE);
  printf("#define SHCNE_DELETE\t(%d)\n", SHCNE_DELETE);
  printf("#define SHCNE_DRIVEADD\t(%d)\n", SHCNE_DRIVEADD);
  printf("#define SHCNE_DRIVEADDGUI\t(%d)\n", SHCNE_DRIVEADDGUI);
  printf("#define SHCNE_DRIVEREMOVED\t(%d)\n", SHCNE_DRIVEREMOVED);
  printf("#define SHCNE_INTERRUPT\t(%d)\n", SHCNE_INTERRUPT);
  printf("#define SHCNE_MEDIAINSERTED\t(%d)\n", SHCNE_MEDIAINSERTED);
  printf("#define SHCNE_MEDIAREMOVED\t(%d)\n", SHCNE_MEDIAREMOVED);
  printf("#define SHCNE_MKDIR\t(%d)\n", SHCNE_MKDIR);
  printf("#define SHCNE_NETSHARE\t(%d)\n", SHCNE_NETSHARE);
  printf("#define SHCNE_NETUNSHARE\t(%d)\n", SHCNE_NETUNSHARE);
  printf("#define SHCNE_RENAMEFOLDER\t(%d)\n", SHCNE_RENAMEFOLDER);
  printf("#define SHCNE_RENAMEITEM\t(%d)\n", SHCNE_RENAMEITEM);
  printf("#define SHCNE_RMDIR\t(%d)\n", SHCNE_RMDIR);
  printf("#define SHCNE_SERVERDISCONNECT\t(%d)\n", SHCNE_SERVERDISCONNECT);
  printf("#define SHCNE_UPDATEDIR\t(%d)\n", SHCNE_UPDATEDIR);
  printf("#define SHCNE_UPDATEIMAGE\t(%d)\n", SHCNE_UPDATEIMAGE);
  printf("#define SHCNE_UPDATEITEM\t(%d)\n", SHCNE_UPDATEITEM);
  printf("#define SHCNF_DWORD\t(%d)\n", SHCNF_DWORD);
  printf("#define SHCNF_FLUSH\t(%d)\n", SHCNF_FLUSH);
  printf("#define SHCNF_FLUSHNOWAIT\t(%d)\n", SHCNF_FLUSHNOWAIT);
  printf("#define SHCNF_IDLIST\t(%d)\n", SHCNF_IDLIST);
  printf("#define SHCNF_PATH\t(%d)\n", SHCNF_PATH);
  printf("#define SHCNF_PRINTER\t(%d)\n", SHCNF_PRINTER);
  */
  printf("\n/* ShellProc */\n");
  printf("#define HSHELL_ACTIVATESHELLWINDOW\t(%d)\n", HSHELL_ACTIVATESHELLWINDOW);
  printf("#define HSHELL_GETMINRECT\t(%d)\n", HSHELL_GETMINRECT);
  printf("#define HSHELL_LANGUAGE\t(%d)\n", HSHELL_LANGUAGE);
  printf("#define HSHELL_REDRAW\t(%d)\n", HSHELL_REDRAW);
  printf("#define HSHELL_TASKMAN\t(%d)\n", HSHELL_TASKMAN);
  printf("#define HSHELL_WINDOWACTIVATED\t(%d)\n", HSHELL_WINDOWACTIVATED);
  printf("#define HSHELL_WINDOWCREATED\t(%d)\n", HSHELL_WINDOWCREATED);
  printf("#define HSHELL_WINDOWDESTROYED\t(%d)\n", HSHELL_WINDOWDESTROYED);

  printf("\n/* SHGetFileInfo */\n");
  /* TODO: where is this?
  printf("#define SHGFI_ATTRIBUTES\t(%d)\n", SHGFI_ATTRIBUTES);
  printf("#define SHGFI_DISPLAYNAME\t(%d)\n", SHGFI_DISPLAYNAME);
  printf("#define SHGFI_EXETYPE\t(%d)\n", SHGFI_EXETYPE);
  printf("#define SHGFI_ICON\t(%d)\n", SHGFI_ICON);
  printf("#define SHGFI_ICONLOCATION\t(%d)\n", SHGFI_ICONLOCATION);
  printf("#define SHGFI_LARGEICON\t(%d)\n", SHGFI_LARGEICON);
  printf("#define SHGFI_LINKOVERLAY\t(%d)\n", SHGFI_LINKOVERLAY);
  printf("#define SHGFI_OPENICON\t(%d)\n", SHGFI_OPENICON);
  printf("#define SHGFI_PIDL\t(%d)\n", SHGFI_PIDL);
  printf("#define SHGFI_SELECTED\t(%d)\n", SHGFI_SELECTED);
  printf("#define SHGFI_SHELLICONSIZE\t(%d)\n", SHGFI_SHELLICONSIZE);
  printf("#define SHGFI_SMALLICON\t(%d)\n", SHGFI_SMALLICON);
  printf("#define SHGFI_SYSICONINDEX\t(%d)\n", SHGFI_SYSICONINDEX);
  printf("#define SHGFI_TYPENAME\t(%d)\n", SHGFI_TYPENAME);
  printf("#define SHGFI_USEFILEATTRIBUTES\t(%d)\n", SHGFI_USEFILEATTRIBUTES);
  */

  printf("\n/* SHGetSpecialFolderLocation */\n");
  /* TODO: where is this?
  printf("#define CSIDL_BITBUCKET\t(%d)\n", CSIDL_BITBUCKET);
  printf("#define CSIDL_CONTROLS\t(%d)\n", CSIDL_CONTROLS);
  printf("#define CSIDL_DESKTOP\t(%d)\n", CSIDL_DESKTOP);
  printf("#define CSIDL_DESKTOPDIRECTORY\t(%d)\n", CSIDL_DESKTOPDIRECTORY);
  printf("#define CSIDL_DRIVES\t(%d)\n", CSIDL_DRIVES);
  printf("#define CSIDL_FONTS\t(%d)\n", CSIDL_FONTS);
  printf("#define CSIDL_NETHOOD\t(%d)\n", CSIDL_NETHOOD);
  printf("#define CSIDL_NETWORK\t(%d)\n", CSIDL_NETWORK);
  printf("#define CSIDL_PERSONAL\t(%d)\n", CSIDL_PERSONAL);
  printf("#define CSIDL_PRINTERS\t(%d)\n", CSIDL_PRINTERS);
  printf("#define CSIDL_PROGRAMS\t(%d)\n", CSIDL_PROGRAMS);
  printf("#define CSIDL_RECENT\t(%d)\n", CSIDL_RECENT);
  printf("#define CSIDL_SENDTO\t(%d)\n", CSIDL_SENDTO);
  printf("#define CSIDL_STARTMENU\t(%d)\n", CSIDL_STARTMENU);
  printf("#define CSIDL_STARTUP\t(%d)\n", CSIDL_STARTUP);
  printf("#define CSIDL_TEMPLATES\t(%d)\n", CSIDL_TEMPLATES);
  */

  printf("\n/* ShowWindow */\n");
  printf("#define SW_HIDE\t(%d)\n", SW_HIDE);
  printf("#define SW_MAXIMIZE\t(%d)\n", SW_MAXIMIZE);
  printf("#define SW_MINIMIZE\t(%d)\n", SW_MINIMIZE);
  printf("#define SW_RESTORE\t(%d)\n", SW_RESTORE);
  printf("#define SW_SHOW\t(%d)\n", SW_SHOW);
  printf("#define SW_SHOWDEFAULT\t(%d)\n", SW_SHOWDEFAULT);
  printf("#define SW_SHOWMAXIMIZED\t(%d)\n", SW_SHOWMAXIMIZED);
  printf("#define SW_SHOWMINIMIZED\t(%d)\n", SW_SHOWMINIMIZED);
  printf("#define SW_SHOWMINNOACTIVE\t(%d)\n", SW_SHOWMINNOACTIVE);
  printf("#define SW_SHOWNA\t(%d)\n", SW_SHOWNA);
  printf("#define SW_SHOWNOACTIVATE\t(%d)\n", SW_SHOWNOACTIVATE);
  printf("#define SW_SHOWNORMAL\t(%d)\n", SW_SHOWNORMAL);
  printf("#define WPF_RESTORETOMAXIMIZED\t(%d)\n", WPF_RESTORETOMAXIMIZED);
  printf("#define WPF_SETMINPOSITION\t(%d)\n", WPF_SETMINPOSITION);

  printf("\n/* Sleep */\n");
  printf("#define INFINITE\t(%d)\n", INFINITE);

  printf("\n/* SystemParametersInfo */\n");
  printf("#define SPI_GETACCESSTIMEOUT\t(%d)\n", SPI_GETACCESSTIMEOUT);
  printf("#define SPI_GETANIMATION\t(%d)\n", SPI_GETANIMATION);
  printf("#define SPI_GETBEEP\t(%d)\n", SPI_GETBEEP);
  printf("#define SPI_GETBORDER\t(%d)\n", SPI_GETBORDER);
  printf("#define SPI_GETDEFAULTINPUTLANG\t(%d)\n", SPI_GETDEFAULTINPUTLANG);
  printf("#define SPI_GETDRAGFULLWINDOWS\t(%d)\n", SPI_GETDRAGFULLWINDOWS);
  printf("#define SPI_GETFASTTASKSWITCH\t(%d)\n", SPI_GETFASTTASKSWITCH);
  printf("#define SPI_GETFILTERKEYS\t(%d)\n", SPI_GETFILTERKEYS);
  printf("#define SPI_GETFONTSMOOTHING\t(%d)\n", SPI_GETFONTSMOOTHING);
  printf("#define SPI_GETGRIDGRANULARITY\t(%d)\n", SPI_GETGRIDGRANULARITY);
  printf("#define SPI_GETHIGHCONTRAST\t(%d)\n", SPI_GETHIGHCONTRAST);
  printf("#define SPI_GETICONMETRICS\t(%d)\n", SPI_GETICONMETRICS);
  printf("#define SPI_GETICONTITLELOGFONT\t(%d)\n", SPI_GETICONTITLELOGFONT);
  printf("#define SPI_GETICONTITLEWRAP\t(%d)\n", SPI_GETICONTITLEWRAP);
  printf("#define SPI_GETKEYBOARDDELAY\t(%d)\n", SPI_GETKEYBOARDDELAY);
  printf("#define SPI_GETKEYBOARDPREF\t(%d)\n", SPI_GETKEYBOARDPREF);
  printf("#define SPI_GETKEYBOARDSPEED\t(%d)\n", SPI_GETKEYBOARDSPEED);
  printf("#define SPI_GETLOWPOWERACTIVE\t(%d)\n", SPI_GETLOWPOWERACTIVE);
  printf("#define SPI_GETLOWPOWERTIMEOUT\t(%d)\n", SPI_GETLOWPOWERTIMEOUT);
  printf("#define SPI_GETMENUDROPALIGNMENT\t(%d)\n", SPI_GETMENUDROPALIGNMENT);
  printf("#define SPI_GETMINIMIZEDMETRICS\t(%d)\n", SPI_GETMINIMIZEDMETRICS);
  printf("#define SPI_GETMOUSE\t(%d)\n", SPI_GETMOUSE);
  printf("#define SPI_GETMOUSEKEYS\t(%d)\n", SPI_GETMOUSEKEYS);
  printf("#define SPI_GETMOUSETRAILS\t(%d)\n", SPI_GETMOUSETRAILS);
  printf("#define SPI_GETNONCLIENTMETRICS\t(%d)\n", SPI_GETNONCLIENTMETRICS);
  printf("#define SPI_GETPOWEROFFACTIVE\t(%d)\n", SPI_GETPOWEROFFACTIVE);
  printf("#define SPI_GETPOWEROFFTIMEOUT\t(%d)\n", SPI_GETPOWEROFFTIMEOUT);
  printf("#define SPI_GETSCREENREADER\t(%d)\n", SPI_GETSCREENREADER);
  printf("#define SPI_GETSCREENSAVEACTIVE\t(%d)\n", SPI_GETSCREENSAVEACTIVE);
  printf("#define SPI_GETSCREENSAVETIMEOUT\t(%d)\n", SPI_GETSCREENSAVETIMEOUT);
  printf("#define SPI_GETSERIALKEYS\t(%d)\n", SPI_GETSERIALKEYS);
  printf("#define SPI_GETSHOWSOUNDS\t(%d)\n", SPI_GETSHOWSOUNDS);
  printf("#define SPI_GETSOUNDSENTRY\t(%d)\n", SPI_GETSOUNDSENTRY);
  printf("#define SPI_GETSTICKYKEYS\t(%d)\n", SPI_GETSTICKYKEYS);
  printf("#define SPI_GETTOGGLEKEYS\t(%d)\n", SPI_GETTOGGLEKEYS);
  printf("#define SPI_GETWINDOWSEXTENSION\t(%d)\n", SPI_GETWINDOWSEXTENSION);
  printf("#define SPI_GETWORKAREA\t(%d)\n", SPI_GETWORKAREA);
  printf("#define SPI_ICONHORIZONTALSPACING\t(%d)\n", SPI_ICONHORIZONTALSPACING);
  printf("#define SPI_ICONVERTICALSPACING\t(%d)\n", SPI_ICONVERTICALSPACING);
  printf("#define SPI_LANGDRIVER\t(%d)\n", SPI_LANGDRIVER);
  printf("#define SPI_SCREENSAVERRUNNING\t(%d)\n", SPI_SCREENSAVERRUNNING);
  printf("#define SPI_SETACCESSTIMEOUT\t(%d)\n", SPI_SETACCESSTIMEOUT);
  printf("#define SPI_SETANIMATION\t(%d)\n", SPI_SETANIMATION);
  printf("#define SPI_SETBEEP\t(%d)\n", SPI_SETBEEP);
  printf("#define SPI_SETBORDER\t(%d)\n", SPI_SETBORDER);
  printf("#define SPI_SETDEFAULTINPUTLANG\t(%d)\n", SPI_SETDEFAULTINPUTLANG);
  printf("#define SPI_SETDESKPATTERN\t(%d)\n", SPI_SETDESKPATTERN);
  printf("#define SPI_SETDESKWALLPAPER\t(%d)\n", SPI_SETDESKWALLPAPER);
  printf("#define SPI_SETDOUBLECLICKTIME\t(%d)\n", SPI_SETDOUBLECLICKTIME);
  printf("#define SPI_SETDOUBLECLKHEIGHT\t(%d)\n", SPI_SETDOUBLECLKHEIGHT);
  printf("#define SPI_SETDOUBLECLKWIDTH\t(%d)\n", SPI_SETDOUBLECLKWIDTH);
  printf("#define SPI_SETDRAGFULLWINDOWS\t(%d)\n", SPI_SETDRAGFULLWINDOWS);
  printf("#define SPI_SETDRAGHEIGHT\t(%d)\n", SPI_SETDRAGHEIGHT);
  printf("#define SPI_SETDRAGWIDTH\t(%d)\n", SPI_SETDRAGWIDTH);
  printf("#define SPI_SETFASTTASKSWITCH\t(%d)\n", SPI_SETFASTTASKSWITCH);
  printf("#define SPI_SETFILTERKEYS\t(%d)\n", SPI_SETFILTERKEYS);
  printf("#define SPI_SETFONTSMOOTHING\t(%d)\n", SPI_SETFONTSMOOTHING);
  printf("#define SPI_SETGRIDGRANULARITY\t(%d)\n", SPI_SETGRIDGRANULARITY);
  printf("#define SPI_SETHANDHELD\t(%d)\n", SPI_SETHANDHELD);
  printf("#define SPI_SETHIGHCONTRAST\t(%d)\n", SPI_SETHIGHCONTRAST);
  printf("#define SPI_SETICONMETRICS\t(%d)\n", SPI_SETICONMETRICS);
  printf("#define SPI_SETICONTITLELOGFONT\t(%d)\n", SPI_SETICONTITLELOGFONT);
  printf("#define SPI_SETICONTITLEWRAP\t(%d)\n", SPI_SETICONTITLEWRAP);
  printf("#define SPI_SETKEYBOARDDELAY\t(%d)\n", SPI_SETKEYBOARDDELAY);
  printf("#define SPI_SETKEYBOARDPREF\t(%d)\n", SPI_SETKEYBOARDPREF);
  printf("#define SPI_SETKEYBOARDSPEED\t(%d)\n", SPI_SETKEYBOARDSPEED);
  printf("#define SPI_SETLANGTOGGLE\t(%d)\n", SPI_SETLANGTOGGLE);
  printf("#define SPI_SETLOWPOWERACTIVE\t(%d)\n", SPI_SETLOWPOWERACTIVE);
  printf("#define SPI_SETLOWPOWERTIMEOUT\t(%d)\n", SPI_SETLOWPOWERTIMEOUT);
  printf("#define SPI_SETMENUDROPALIGNMENT\t(%d)\n", SPI_SETMENUDROPALIGNMENT);
  printf("#define SPI_SETMINIMIZEDMETRICS\t(%d)\n", SPI_SETMINIMIZEDMETRICS);
  printf("#define SPI_SETMOUSE\t(%d)\n", SPI_SETMOUSE);
  printf("#define SPI_SETMOUSEBUTTONSWAP\t(%d)\n", SPI_SETMOUSEBUTTONSWAP);
  printf("#define SPI_SETMOUSEKEYS\t(%d)\n", SPI_SETMOUSEKEYS);
  printf("#define SPI_SETMOUSETRAILS\t(%d)\n", SPI_SETMOUSETRAILS);
  printf("#define SPI_SETNONCLIENTMETRICS\t(%d)\n", SPI_SETNONCLIENTMETRICS);
  printf("#define SPI_SETPENWINDOWS\t(%d)\n", SPI_SETPENWINDOWS);
  printf("#define SPI_SETPOWEROFFACTIVE\t(%d)\n", SPI_SETPOWEROFFACTIVE);
  printf("#define SPI_SETPOWEROFFTIMEOUT\t(%d)\n", SPI_SETPOWEROFFTIMEOUT);
  printf("#define SPI_SETSCREENREADER\t(%d)\n", SPI_SETSCREENREADER);
  printf("#define SPI_SETSCREENSAVEACTIVE\t(%d)\n", SPI_SETSCREENSAVEACTIVE);
  printf("#define SPI_SETSCREENSAVETIMEOUT\t(%d)\n", SPI_SETSCREENSAVETIMEOUT);
  printf("#define SPI_SETSERIALKEYS\t(%d)\n", SPI_SETSERIALKEYS);
  printf("#define SPI_SETSHOWSOUNDS\t(%d)\n", SPI_SETSHOWSOUNDS);
  printf("#define SPI_SETSOUNDSENTRY\t(%d)\n", SPI_SETSOUNDSENTRY);
  printf("#define SPI_SETSTICKYKEYS\t(%d)\n", SPI_SETSTICKYKEYS);
  printf("#define SPI_SETTOGGLEKEYS\t(%d)\n", SPI_SETTOGGLEKEYS);
  printf("#define SPI_SETWORKAREA\t(%d)\n", SPI_SETWORKAREA);
  printf("#define SPIF_UPDATEINIFILE\t(%d)\n", SPIF_UPDATEINIFILE);
  printf("#define SPIF_SENDWININICHANGE\t(%d)\n", SPIF_SENDWININICHANGE);
  printf("#define SPIF_SENDCHANGE\t(%d)\n", SPIF_SENDCHANGE);

  printf("\n/* TrackPopupMenu, TrackPopMenuEx */\n");
  printf("#define TPM_CENTERALIGN\t(%#lxL)\n", TPM_CENTERALIGN);
  printf("#define TPM_LEFTALIGN\t(%#lxL)\n", TPM_LEFTALIGN);
  printf("#define TPM_RIGHTALIGN\t(%#lxL)\n", TPM_RIGHTALIGN);
  printf("#define TPM_LEFTBUTTON\t(%#lxL)\n", TPM_LEFTBUTTON);
  printf("#define TPM_RIGHTBUTTON\t(%#lxL)\n", TPM_RIGHTBUTTON);
  printf("#define TPM_HORIZONTAL\t(%#lxL)\n", TPM_HORIZONTAL);
  printf("#define TPM_VERTICAL\t(%#lxL)\n", TPM_VERTICAL);

  printf("\n/* TranslateCharsetInfo */\n");
  printf("#define TCI_SRCCHARSET\t(%d)\n", TCI_SRCCHARSET);
  printf("#define TCI_SRCCODEPAGE\t(%d)\n", TCI_SRCCODEPAGE);
  printf("#define TCI_SRCFONTSIG\t(%d)\n", TCI_SRCFONTSIG);

  printf("\n/* VerFindFile */\n");
  printf("#define VFFF_ISSHAREDFILE\t(%d)\n", VFFF_ISSHAREDFILE);
  printf("#define VFF_CURNEDEST\t(%d)\n", VFF_CURNEDEST);
  printf("#define VFF_FILEINUSE\t(%d)\n", VFF_FILEINUSE);
  printf("#define VFF_BUFFTOOSMALL\t(%d)\n", VFF_BUFFTOOSMALL);

  printf("\n/* VerInstallFile */\n");
  printf("#define VIFF_FORCEINSTALL\t(%d)\n", VIFF_FORCEINSTALL);
  printf("#define VIFF_DONTDELETEOLD\t(%d)\n", VIFF_DONTDELETEOLD);
  printf("#define VIF_TEMPFILE\t(%#lxL)\n", VIF_TEMPFILE);
  printf("#define VIF_MISMATCH\t(%#lxL)\n", VIF_MISMATCH);
  printf("#define VIF_SRCOLD\t(%#lxL)\n", VIF_SRCOLD);
  printf("#define VIF_DIFFLANG\t(%#lxL)\n", VIF_DIFFLANG);
  printf("#define VIF_DIFFCODEPG\t(%#lxL)\n", VIF_DIFFCODEPG);
  printf("#define VIF_DIFFTYPE\t(%#lxL)\n", VIF_DIFFTYPE);
  printf("#define VIF_WRITEPROT\t(%#lxL)\n", VIF_WRITEPROT);
  printf("#define VIF_FILEINUSE\t(%#lxL)\n", VIF_FILEINUSE);
  printf("#define VIF_OUTOFSPACE\t(%#lxL)\n", VIF_OUTOFSPACE);
  printf("#define VIF_ACCESSVIOLATION\t(%#lxL)\n", VIF_ACCESSVIOLATION);
  printf("#define VIF_SHARINGVIOLATION\t(%#lxL)\n", VIF_SHARINGVIOLATION);
  printf("#define VIF_CANNOTCREATE\t(%#lxL)\n", VIF_CANNOTCREATE);
  printf("#define VIF_CANNOTDELETE\t(%#lxL)\n", VIF_CANNOTDELETE);
  printf("#define VIF_CANNOTDELETECUR\t(%#lxL)\n", VIF_CANNOTDELETECUR);
  printf("#define VIF_CANNOTRENAME\t(%#lxL)\n", VIF_CANNOTRENAME);
  printf("#define VIF_OUTOFMEMORY\t(%#lxL)\n", VIF_OUTOFMEMORY);
  printf("#define VIF_CANNOTREADSRC\t(%#lxL)\n", VIF_CANNOTREADSRC);
  printf("#define VIF_CANNOTREADDST\t(%#lxL)\n", VIF_CANNOTREADDST);
  printf("#define VIF_BUFFTOOSMALL\t(%#lxL)\n", VIF_BUFFTOOSMALL);

  printf("\n/* WideCharToMultiByte */\n");
  printf("#define WC_COMPOSITECHECK\t(%d)\n", WC_COMPOSITECHECK);
  printf("#define WC_DISCARDNS\t(%d)\n", WC_DISCARDNS);
  printf("#define WC_SEPCHARS\t(%d)\n", WC_SEPCHARS);
  printf("#define WC_DEFAULTCHAR\t(%d)\n", WC_DEFAULTCHAR);

  printf("\n/* WinHelp */\n");
  printf("#define HELP_COMMAND\t(%#lxL)\n", HELP_COMMAND);
  printf("#define HELP_CONTENTS\t(%#lxL)\n", HELP_CONTENTS);
  printf("#define HELP_CONTEXT\t(%#lxL)\n", HELP_CONTEXT);
  printf("#define HELP_CONTEXTPOPUP\t(%#lxL)\n", HELP_CONTEXTPOPUP);
  printf("#define HELP_FORCEFILE\t(%#lxL)\n", HELP_FORCEFILE);
  printf("#define HELP_HELPONHELP\t(%#lxL)\n", HELP_HELPONHELP);
  printf("#define HELP_INDEX\t(%#lxL)\n", HELP_INDEX);
  printf("#define HELP_KEY\t(%#lxL)\n", HELP_KEY);
  printf("#define HELP_MULTIKEY\t(%#lxL)\n", HELP_MULTIKEY);
  printf("#define HELP_PARTIALKEY\t(%#lxL)\n", HELP_PARTIALKEY);
  printf("#define HELP_QUIT\t(%#lxL)\n", HELP_QUIT);
  printf("#define HELP_SETCONTENTS\t(%#lxL)\n", HELP_SETCONTENTS);
  printf("#define HELP_SETINDEX\t(%#lxL)\n", HELP_SETINDEX);
  printf("#define HELP_CONTEXTMENU\t(%#x)\n", HELP_CONTEXTMENU);
  printf("#define HELP_FINDER\t(%#x)\n", HELP_FINDER);
  printf("#define HELP_WM_HELP\t(%#x)\n", HELP_WM_HELP);
  printf("#define HELP_TCARD\t(%#x)\n", HELP_TCARD);
  printf("#define HELP_TCARD_DATA\t(%#x)\n", HELP_TCARD_DATA);
  printf("#define HELP_TCARD_OTHER_CALLER\t(%#x)\n", HELP_TCARD_OTHER_CALLER);

  printf("\n/* WNetAddConnectino2 */\n");
  printf("#define CONNECT_UPDATE_PROFILE\t(%d)\n", CONNECT_UPDATE_PROFILE);

  printf("\n/* WNetConnectionDialog, WNetDisconnectDialog, WNetOpenEnum */\n");
  printf("#define RESOURCETYPE_DISK\t(%d)\n", RESOURCETYPE_DISK);
  printf("#define RESOURCETYPE_PRINT\t(%d)\n", RESOURCETYPE_PRINT);
  printf("#define RESOURCETYPE_ANY\t(%d)\n", RESOURCETYPE_ANY);
  printf("#define RESOURCE_CONNECTED\t(%d)\n", RESOURCE_CONNECTED);
  printf("#define RESOURCE_GLOBALNET\t(%d)\n", RESOURCE_GLOBALNET);
  printf("#define RESOURCE_REMEMBERED\t(%d)\n", RESOURCE_REMEMBERED);
  printf("#define RESOURCEUSAGE_CONNECTABLE\t(%d)\n", RESOURCEUSAGE_CONNECTABLE);
  printf("#define RESOURCEUSAGE_CONTAINER\t(%d)\n", RESOURCEUSAGE_CONTAINER);

  printf("\n/* WNetGetResourceInformation, WNetGetResourceParent */\n");
  printf("#define WN_BAD_NETNAME\t(%#lxL)\n", WN_BAD_NETNAME);
  printf("#define WN_EXTENDED_ERROR\t(%#lxL)\n", WN_EXTENDED_ERROR);
  printf("#define WN_MORE_DATA\t(%#lxL)\n", WN_MORE_DATA);
  printf("#define WN_NO_NETWORK\t(%#lxL)\n", WN_NO_NETWORK);
  printf("#define WN_SUCCESS\t(%#lxL)\n", WN_SUCCESS);
  printf("#define WN_ACCESS_DENIED\t(%#lxL)\n", WN_ACCESS_DENIED);
  printf("#define WN_BAD_PROVIDER\t(%#lxL)\n", WN_BAD_PROVIDER);
  printf("#define WN_NOT_AUTHENTICATED\t(%#lxL)\n", WN_NOT_AUTHENTICATED);

  printf("\n/* WNetGetUniversalName */\n");
  printf("#define UNIVERSAL_NAME_INFO_LEVEL\t(%d)\n", UNIVERSAL_NAME_INFO_LEVEL);
  printf("#define REMOTE_NAME_INFO_LEVEL\t(%d)\n", REMOTE_NAME_INFO_LEVEL);

  printf("\n/* GetExitCodeThread */\n");
  printf("#define STILL_ACTIVE\t(%#lxL)\n", STILL_ACTIVE);

  printf("\n/* COMMPROP structure */\n");
  printf("#define SP_SERIALCOMM\t(%#lxL)\n", SP_SERIALCOMM);
  printf("#define BAUD_075\t(%#lxL)\n", BAUD_075);
  printf("#define BAUD_110\t(%#lxL)\n", BAUD_110);
  printf("#define BAUD_134_5\t(%#lxL)\n", BAUD_134_5);
  printf("#define BAUD_150\t(%#lxL)\n", BAUD_150);
  printf("#define BAUD_300\t(%#lxL)\n", BAUD_300);
  printf("#define BAUD_600\t(%#lxL)\n", BAUD_600);
  printf("#define BAUD_1200\t(%#lxL)\n", BAUD_1200);
  printf("#define BAUD_1800\t(%#lxL)\n", BAUD_1800);
  printf("#define BAUD_2400\t(%#lxL)\n", BAUD_2400);
  printf("#define BAUD_4800\t(%#lxL)\n", BAUD_4800);
  printf("#define BAUD_7200\t(%#lxL)\n", BAUD_7200);
  printf("#define BAUD_9600\t(%#lxL)\n", BAUD_9600);
  printf("#define BAUD_14400\t(%#lxL)\n", BAUD_14400);
  printf("#define BAUD_19200\t(%#lxL)\n", BAUD_19200);
  printf("#define BAUD_38400\t(%#lxL)\n", BAUD_38400);
  printf("#define BAUD_56K\t(%#lxL)\n", BAUD_56K);
  printf("#define BAUD_57600\t(%#lxL)\n", BAUD_57600);
  printf("#define BAUD_115200\t(%#lxL)\n", BAUD_115200);
  printf("#define BAUD_128K\t(%#lxL)\n", BAUD_128K);
  printf("#define BAUD_USER\t(%#lxL)\n", BAUD_USER);
  printf("#define PST_FAX\t(%#lxL)\n", PST_FAX);
  printf("#define PST_LAT\t(%#lxL)\n", PST_LAT);
  printf("#define PST_MODEM\t(%#lxL)\n", PST_MODEM);
  printf("#define PST_NETWORK_BRIDGE\t(%#lxL)\n", PST_NETWORK_BRIDGE);
  printf("#define PST_PARALLELPORT\t(%#lxL)\n", PST_PARALLELPORT);
  printf("#define PST_RS232\t(%#lxL)\n", PST_RS232);
  printf("#define PST_RS422\t(%#lxL)\n", PST_RS422);
  printf("#define PST_RS423\t(%#lxL)\n", PST_RS423);
  printf("#define PST_RS449\t(%#lxL)\n", PST_RS449);
  printf("#define PST_SCANNER\t(%#lxL)\n", PST_SCANNER);
  printf("#define PST_TCPIP_TELNET\t(%#lxL)\n", PST_TCPIP_TELNET);
  printf("#define PST_UNSPECIFIED\t(%#lxL)\n", PST_UNSPECIFIED);
  printf("#define PST_X25\t(%#lxL)\n", PST_X25);
  printf("#define PCF_16BITMODE\t(%#lxL)\n", PCF_16BITMODE);
  printf("#define PCF_DTRDSR\t(%#lxL)\n", PCF_DTRDSR);
  printf("#define PCF_INTTIMEOUTS\t(%#lxL)\n", PCF_INTTIMEOUTS);
  printf("#define PCF_PARITY_CHECK\t(%#lxL)\n", PCF_PARITY_CHECK);
  printf("#define PCF_RLSD\t(%#lxL)\n", PCF_RLSD);
  printf("#define PCF_RTSCTS\t(%#lxL)\n", PCF_RTSCTS);
  printf("#define PCF_SETXCHAR\t(%#lxL)\n", PCF_SETXCHAR);
  printf("#define PCF_SPECIALCHARS\t(%#lxL)\n", PCF_SPECIALCHARS);
  printf("#define PCF_TOTALTIMEOUTS\t(%#lxL)\n", PCF_TOTALTIMEOUTS);
  printf("#define PCF_XONXOFF\t(%#lxL)\n", PCF_XONXOFF);
  printf("#define SP_BAUD\t(%#lxL)\n", SP_BAUD);
  printf("#define SP_DATABITS\t(%#lxL)\n", SP_DATABITS);
  printf("#define SP_HANDSHAKING\t(%#lxL)\n", SP_HANDSHAKING);
  printf("#define SP_PARITY\t(%#lxL)\n", SP_PARITY);
  printf("#define SP_PARITY_CHECK\t(%#lxL)\n", SP_PARITY_CHECK);
  printf("#define SP_RLSD\t(%#lxL)\n", SP_RLSD);
  printf("#define SP_STOPBITS\t(%#lxL)\n", SP_STOPBITS);
  printf("#define DATABITS_5\t(%d)\n", DATABITS_5);
  printf("#define DATABITS_6\t(%d)\n", DATABITS_6);
  printf("#define DATABITS_7\t(%d)\n", DATABITS_7);
  printf("#define DATABITS_8\t(%d)\n", DATABITS_8);
  printf("#define DATABITS_16\t(%d)\n", DATABITS_16);
  printf("#define DATABITS_16X\t(%d)\n", DATABITS_16X);
  printf("#define STOPBITS_10\t(%d)\n", STOPBITS_10);
  printf("#define STOPBITS_15\t(%d)\n", STOPBITS_15);
  printf("#define STOPBITS_20\t(%d)\n", STOPBITS_20);
  printf("#define PARITY_NONE\t(%d)\n", PARITY_NONE);
  printf("#define PARITY_ODD\t(%d)\n", PARITY_ODD);
  printf("#define PARITY_EVEN\t(%d)\n", PARITY_EVEN);
  printf("#define PARITY_MARK\t(%d)\n", PARITY_MARK);
  printf("#define PARITY_SPACE\t(%d)\n", PARITY_SPACE);
  printf("#define COMMPROP_INITIALIZED\t(%#lxL)\n", COMMPROP_INITIALIZED);

  printf("\n/* DCB structure */\n");
  printf("#define CBR_110\t(%d)\n", CBR_110);
  printf("#define CBR_300\t(%d)\n", CBR_300);
  printf("#define CBR_600\t(%d)\n", CBR_600);
  printf("#define CBR_1200\t(%d)\n", CBR_1200);
  printf("#define CBR_2400\t(%d)\n", CBR_2400);
  printf("#define CBR_4800\t(%d)\n", CBR_4800);
  printf("#define CBR_9600\t(%d)\n", CBR_9600);
  printf("#define CBR_14400\t(%d)\n", CBR_14400);
  printf("#define CBR_19200\t(%d)\n", CBR_19200);
  printf("#define CBR_38400\t(%d)\n", CBR_38400);
  printf("#define CBR_56000\t(%d)\n", CBR_56000);
  printf("#define CBR_57600\t(%d)\n", CBR_57600);
  printf("#define CBR_115200\t(%d)\n", CBR_115200);
  printf("#define CBR_128000\t(%d)\n", CBR_128000);
  printf("#define CBR_256000\t(%d)\n", CBR_256000);
  printf("#define DTR_CONTROL_DISABLE\t(%d)\n", DTR_CONTROL_DISABLE);
  printf("#define DTR_CONTROL_ENABLE\t(%d)\n", DTR_CONTROL_ENABLE);
  printf("#define DTR_CONTROL_HANDSHAKE\t(%d)\n", DTR_CONTROL_HANDSHAKE);
  printf("#define RTS_CONTROL_DISABLE\t(%d)\n", RTS_CONTROL_DISABLE);
  printf("#define RTS_CONTROL_ENABLE\t(%d)\n", RTS_CONTROL_ENABLE);
  printf("#define RTS_CONTROL_HANDSHAKE\t(%d)\n", RTS_CONTROL_HANDSHAKE);
  printf("#define RTS_CONTROL_TOGGLE\t(%d)\n", RTS_CONTROL_TOGGLE);
  printf("#define EVENPARITY\t(%d)\n", EVENPARITY);
  printf("#define MARKPARITY\t(%d)\n", MARKPARITY);
  printf("#define NOPARITY\t(%d)\n", NOPARITY);
  printf("#define ODDPARITY\t(%d)\n", ODDPARITY);
  printf("#define ONESTOPBIT\t(%d)\n", ONESTOPBIT);
  printf("#define ONE5STOPBITS\t(%d)\n", ONE5STOPBITS);
  printf("#define TWOSTOPBITS\t(%d)\n", TWOSTOPBITS);

  printf("\n/* Debugging events */\n");
  printf("#define CREATE_PROCESS_DEBUG_EVENT\t(%d)\n", CREATE_PROCESS_DEBUG_EVENT);
  printf("#define CREATE_THREAD_DEBUG_EVENT\t(%d)\n", CREATE_THREAD_DEBUG_EVENT);
  printf("#define EXCEPTION_DEBUG_EVENT\t(%d)\n", EXCEPTION_DEBUG_EVENT);
  printf("#define EXIT_PROCESS_DEBUG_EVENT\t(%d)\n", EXIT_PROCESS_DEBUG_EVENT);
  printf("#define EXIT_THREAD_DEBUG_EVENT\t(%d)\n", EXIT_THREAD_DEBUG_EVENT);
  printf("#define LOAD_DLL_DEBUG_EVENT\t(%d)\n", LOAD_DLL_DEBUG_EVENT);
  printf("#define OUTPUT_DEBUG_STRING_EVENT\t(%d)\n", OUTPUT_DEBUG_STRING_EVENT);
  printf("#define UNLOAD_DLL_DEBUG_EVENT\t(%d)\n", UNLOAD_DLL_DEBUG_EVENT);
  printf("#define RIP_EVENT\t(%d)\n", RIP_EVENT);

  printf("\n/* PROCESS_HEAP_ENTRY structure */\n");
  printf("#define PROCESS_HEAP_REGION\t(%d)\n", PROCESS_HEAP_REGION);
  printf("#define PROCESS_HEAP_UNCOMMITTED_RANGE\t(%d)\n", PROCESS_HEAP_UNCOMMITTED_RANGE);
  printf("#define PROCESS_HEAP_ENTRY_BUSY\t(%d)\n", PROCESS_HEAP_ENTRY_BUSY);
  printf("#define PROCESS_HEAP_ENTRY_MOVEABLE\t(%d)\n", PROCESS_HEAP_ENTRY_MOVEABLE);
  printf("#define PROCESS_HEAP_ENTRY_DDESHARE\t(%d)\n", PROCESS_HEAP_ENTRY_DDESHARE);

  // Found this in the knowledge base
  printf("\n/* Win32s */\n");
  printf("#define HINSTANCE_ERROR\t(%d)\n", HINSTANCE_ERROR);

  printf("\n/* WIN32_STREAM_ID structure */\n");
  printf("#define BACKUP_DATA\t(%d)\n", BACKUP_DATA);
  printf("#define BACKUP_EA_DATA\t(%d)\n", BACKUP_EA_DATA);
  printf("#define BACKUP_SECURITY_DATA\t(%d)\n", BACKUP_SECURITY_DATA);
  printf("#define BACKUP_ALTERNATE_DATA\t(%d)\n", BACKUP_ALTERNATE_DATA);
  printf("#define BACKUP_LINK\t(%d)\n", BACKUP_LINK);
  printf("#define STREAM_MODIFIED_WHEN_READ\t(%d)\n", STREAM_MODIFIED_WHEN_READ);
  printf("#define STREAM_CONTAINS_SECURITY\t(%d)\n", STREAM_CONTAINS_SECURITY);

  printf("\n/* STARTUPINFO structure */\n");
  printf("#define STARTF_USESHOWWINDOW\t(%d)\n", STARTF_USESHOWWINDOW);
  printf("#define STARTF_USEPOSITION\t(%d)\n", STARTF_USEPOSITION);
  printf("#define STARTF_USESIZE\t(%d)\n", STARTF_USESIZE);
  printf("#define STARTF_USECOUNTCHARS\t(%d)\n", STARTF_USECOUNTCHARS);
  printf("#define STARTF_USEFILLATTRIBUTE\t(%d)\n", STARTF_USEFILLATTRIBUTE);
  printf("#define STARTF_FORCEONFEEDBACK\t(%d)\n", STARTF_FORCEONFEEDBACK);
  printf("#define STARTF_FORCEOFFFEEDBACK\t(%d)\n", STARTF_FORCEOFFFEEDBACK);
  printf("#define STARTF_USESTDHANDLES\t(%d)\n", STARTF_USESTDHANDLES);

  printf("\n/* OSVERSIONINFO structure */\n");
  printf("#define VER_PLATFORM_WIN32s\t(%d)\n", VER_PLATFORM_WIN32s);
  // in a new windows.h somewhere?
//  printf("#define VER_PLATFORM_WIN32_WINDOWS\t(%d)\n", VER_PLATFORM_WIN32_WINDOWS);
  printf("#define VER_PLATFORM_WIN32_NT\t(%d)\n", VER_PLATFORM_WIN32_NT);

  printf("\n/* PROPSHEETPAGE structure */\n");
  printf("#define MAXPROPPAGES\t(%d)\n", MAXPROPPAGES);
  printf("#define PSP_DEFAULT\t(%d)\n", PSP_DEFAULT);
  printf("#define PSP_DLGINDIRECT\t(%d)\n", PSP_DLGINDIRECT);
  printf("#define PSP_HASHELP\t(%d)\n", PSP_HASHELP);
  printf("#define PSP_USECALLBACK\t(%d)\n", PSP_USECALLBACK);
  printf("#define PSP_USEHICON\t(%d)\n", PSP_USEHICON);
  printf("#define PSP_USEICONID\t(%d)\n", PSP_USEICONID);
  printf("#define PSP_USEREFPARENT\t(%d)\n", PSP_USEREFPARENT);
  printf("#define PSP_USETITLE\t(%d)\n", PSP_USETITLE);
  printf("#define PSP_RTLREADING\t(%d)\n", PSP_RTLREADING);

  printf("\n/* PROPSHEETHEADER structure */\n");
  printf("#define PSH_DEFAULT\t(%d)\n", PSH_DEFAULT);
  printf("#define PSH_HASHELP\t(%d)\n", PSH_HASHELP);
  printf("#define PSH_MODELESS\t(%d)\n", PSH_MODELESS);
//  printf("#define PSH_MULTILINETABS\t(%d)\n", PSH_MULTILINETABS);
  printf("#define PSH_NOAPPLYNOW\t(%d)\n", PSH_NOAPPLYNOW);
  printf("#define PSH_PROPSHEETPAGE\t(%d)\n", PSH_PROPSHEETPAGE);
  printf("#define PSH_PROPTITLE\t(%d)\n", PSH_PROPTITLE);
  printf("#define PSH_USECALLBACK\t(%d)\n", PSH_USECALLBACK);
  printf("#define PSH_USEHICON\t(%d)\n", PSH_USEHICON);
  printf("#define PSH_USEICONID\t(%d)\n", PSH_USEICONID);
  printf("#define PSH_USEPSTARTPAGE\t(%d)\n", PSH_USEPSTARTPAGE);
  printf("#define PSH_WIZARD\t(%d)\n", PSH_WIZARD);
  printf("#define PSH_RTLREADING\t(%d)\n", PSH_RTLREADING);

  printf("#define PSCB_INITIALIZED\t(%d)\n", PSCB_INITIALIZED);
  printf("#define PSCB_PRECREATE\t(%d)\n", PSCB_PRECREATE);

  printf("\n/* PSN_APPLY message */\n");
  printf("#define PSNRET_NOERROR\t(%d)\n", PSNRET_NOERROR);
  printf("#define PSNRET_INVALID_NOCHANGEPAGE\t(%d)\n", PSNRET_INVALID_NOCHANGEPAGE);

  printf("\n/* Property Sheet */\n");
  printf("#define PSBTN_APPLYNOW\t(%d)\n", PSBTN_APPLYNOW);
  printf("#define PSBTN_BACK\t(%d)\n", PSBTN_BACK);
  printf("#define PSBTN_CANCEL\t(%d)\n", PSBTN_CANCEL);
  printf("#define PSBTN_FINISH\t(%d)\n", PSBTN_FINISH);
  printf("#define PSBTN_HELP\t(%d)\n", PSBTN_HELP);
  printf("#define PSBTN_NEXT\t(%d)\n", PSBTN_NEXT);
  printf("#define PSBTN_OK\t(%d)\n", PSBTN_OK);

  printf("#define PSWIZB_BACK\t(%d)\n", PSWIZB_BACK);
  printf("#define PSWIZB_NEXT\t(%d)\n", PSWIZB_NEXT);
  printf("#define PSWIZB_FINISH\t(%d)\n", PSWIZB_FINISH);
  printf("#define PSWIZB_DISABLEDFINISH\t(%d)\n", PSWIZB_DISABLEDFINISH);

  printf("#define ID_PSREBOOTSYSTEM\t(%d)\n", ID_PSREBOOTSYSTEM);
  printf("#define ID_PSRESTARTWINDOWS\t(%d)\n", ID_PSRESTARTWINDOWS);

  printf("#define WIZ_BODYCX\t(%d)\n", WIZ_BODYCX);
  printf("#define WIZ_BODYX\t(%d)\n", WIZ_BODYX);
  printf("#define WIZ_CXBMP\t(%d)\n", WIZ_CXBMP);
  printf("#define WIZ_CXDLG\t(%d)\n", WIZ_CXDLG);
  printf("#define WIZ_CYDLG\t(%d)\n", WIZ_CYDLG);

  printf("\n/* VX_FIXEDFILEINFO structure */\n");
  printf("#define VS_FILE_INFO\t(MAKEINTRESOURCE(16))\n");
  printf("#define VS_VERSION_INFO\t(%d)\n", VS_VERSION_INFO);
  printf("#define VS_FF_DEBUG\t(%#lxL)\n", VS_FF_DEBUG);
  printf("#define VS_FF_INFOINFERRED\t(%#lxL)\n", VS_FF_INFOINFERRED);
  printf("#define VS_FF_PATCHED\t(%#lxL)\n", VS_FF_PATCHED);
  printf("#define VS_FF_PRERELEASE\t(%#lxL)\n", VS_FF_PRERELEASE);
  printf("#define VS_FF_PRIVATEBUILD\t(%#lxL)\n", VS_FF_PRIVATEBUILD);
  printf("#define VS_FF_SPECIALBUILD\t(%#lxL)\n", VS_FF_SPECIALBUILD);
  printf("#define VOS_UNKNOWN\t(%#lxL)\n", VOS_UNKNOWN);
  printf("#define VOS_DOS\t(%#lxL)\n", VOS_DOS);
  printf("#define VOS_OS216\t(%#lxL)\n", VOS_OS216);
  printf("#define VOS_OS232\t(%#lxL)\n", VOS_OS232);
  printf("#define VOS_NT\t(%#lxL)\n", VOS_NT);
//  printf("#define VOS_WINDOWS16\t(%#lxL)\n", VOS_WINDOWS16);
//  printf("#define VOS_PM16\t(%#lxL)\n", VOS_PM16);
//  printf("#define VOS_PM32\t(%#lxL)\n", VOS_PM32);
//  printf("#define VOS_WINDOWS32\t(%#lxL)\n", VOS_WINDOWS32);
  printf("#define VOS_DOS_WINDOWS16\t(%#lxL)\n", VOS_DOS_WINDOWS16);
  printf("#define VOS_DOS_WINDOWS32\t(%#lxL)\n", VOS_DOS_WINDOWS32);
  printf("#define VOS_OS216_PM16\t(%#lxL)\n", VOS_OS216_PM16);
  printf("#define VOS_OS232_PM32\t(%#lxL)\n", VOS_OS232_PM32);
  printf("#define VOS_NT_WINDOWS32\t(%#lxL)\n", VOS_NT_WINDOWS32);
  printf("#define VFT_UNKNOWN\t(%#lxL)\n", VFT_UNKNOWN);
  printf("#define VFT_APP\t(%#lxL)\n", VFT_APP);
  printf("#define VFT_DLL\t(%#lxL)\n", VFT_DLL);
  printf("#define VFT_DRV\t(%#lxL)\n", VFT_DRV);
  printf("#define VFT_FONT\t(%#lxL)\n", VFT_FONT);
  printf("#define VFT_VXD\t(%#lxL)\n", VFT_VXD);
  printf("#define VFT_STATIC_LIB\t(%#lxL)\n", VFT_STATIC_LIB);
  printf("#define VFT2_UNKNOWN\t(%#lxL)\n", VFT2_UNKNOWN);
  printf("#define VFT2_DRV_PRINTER\t(%#lxL)\n", VFT2_DRV_PRINTER);
  printf("#define VFT2_DRV_KEYBOARD\t(%#lxL)\n", VFT2_DRV_KEYBOARD);
  printf("#define VFT2_DRV_LANGUAGE\t(%#lxL)\n", VFT2_DRV_LANGUAGE);
  printf("#define VFT2_DRV_DISPLAY\t(%#lxL)\n", VFT2_DRV_DISPLAY);
  printf("#define VFT2_DRV_MOUSE\t(%#lxL)\n", VFT2_DRV_MOUSE);
  printf("#define VFT2_DRV_NETWORK\t(%#lxL)\n", VFT2_DRV_NETWORK);
  printf("#define VFT2_DRV_SYSTEM\t(%#lxL)\n", VFT2_DRV_SYSTEM);
  printf("#define VFT2_DRV_INSTALLABLE\t(%#lxL)\n", VFT2_DRV_INSTALLABLE);
  printf("#define VFT2_DRV_SOUND\t(%#lxL)\n", VFT2_DRV_SOUND);
  printf("#define VFT2_FONT_RASTER\t(%#lxL)\n", VFT2_FONT_RASTER);
  printf("#define VFT2_FONT_VECTOR\t(%#lxL)\n", VFT2_FONT_VECTOR);
  printf("#define VFT2_FONT_TRUETYPE\t(%#lxL)\n", VFT2_FONT_TRUETYPE);

  printf("\n/* PANOSE structure */\n");
  printf("#define PAN_ANY\t(%d)\n", PAN_ANY);
  printf("#define PAN_NO_FIT\t(%d)\n", PAN_NO_FIT);
  printf("#define PAN_FAMILY_TEXT_DISPLAY\t(%d)\n", PAN_FAMILY_TEXT_DISPLAY);
  printf("#define PAN_FAMILY_SCRIPT\t(%d)\n", PAN_FAMILY_SCRIPT);
  printf("#define PAN_FAMILY_DECORATIVE\t(%d)\n", PAN_FAMILY_DECORATIVE);
  printf("#define PAN_FAMILY_PICTORIAL\t(%d)\n", PAN_FAMILY_PICTORIAL);
  printf("#define PAN_SERIF_COVE\t(%d)\n", PAN_SERIF_COVE);
  printf("#define PAN_SERIF_OBTUSE_COVE\t(%d)\n", PAN_SERIF_OBTUSE_COVE);
  printf("#define PAN_SERIF_SQUARE_COVE\t(%d)\n", PAN_SERIF_SQUARE_COVE);
  printf("#define PAN_SERIF_OBTUSE_SQUARE_COVE\t(%d)\n", PAN_SERIF_OBTUSE_SQUARE_COVE);
  printf("#define PAN_SERIF_SQUARE\t(%d)\n", PAN_SERIF_SQUARE);
  printf("#define PAN_SERIF_THIN\t(%d)\n", PAN_SERIF_THIN);
  printf("#define PAN_SERIF_BONE\t(%d)\n", PAN_SERIF_BONE);
  printf("#define PAN_SERIF_EXAGGERATED\t(%d)\n", PAN_SERIF_EXAGGERATED);
  printf("#define PAN_SERIF_TRIANGLE\t(%d)\n", PAN_SERIF_TRIANGLE);
  printf("#define PAN_SERIF_NORMAL_SANS\t(%d)\n", PAN_SERIF_NORMAL_SANS);
  printf("#define PAN_SERIF_OBTUSE_SANS\t(%d)\n", PAN_SERIF_OBTUSE_SANS);
  printf("#define PAN_SERIF_PERP_SANS\t(%d)\n", PAN_SERIF_PERP_SANS);
  printf("#define PAN_SERIF_FLARED\t(%d)\n", PAN_SERIF_FLARED);
  printf("#define PAN_SERIF_ROUNDED\t(%d)\n", PAN_SERIF_ROUNDED);
  printf("#define PAN_WEIGHT_VERY_LIGHT\t(%d)\n", PAN_WEIGHT_VERY_LIGHT);
  printf("#define PAN_WEIGHT_LIGHT\t(%d)\n", PAN_WEIGHT_LIGHT);
  printf("#define PAN_WEIGHT_THIN\t(%d)\n", PAN_WEIGHT_THIN);
  printf("#define PAN_WEIGHT_BOOK\t(%d)\n", PAN_WEIGHT_BOOK);
  printf("#define PAN_WEIGHT_MEDIUM\t(%d)\n", PAN_WEIGHT_MEDIUM);
  printf("#define PAN_WEIGHT_DEMI\t(%d)\n", PAN_WEIGHT_DEMI);
  printf("#define PAN_WEIGHT_BOLD\t(%d)\n", PAN_WEIGHT_BOLD);
  printf("#define PAN_WEIGHT_HEAVY\t(%d)\n", PAN_WEIGHT_HEAVY);
  printf("#define PAN_WEIGHT_BLACK\t(%d)\n", PAN_WEIGHT_BLACK);
  printf("#define PAN_WEIGHT_NORD\t(%d)\n", PAN_WEIGHT_NORD);
  printf("#define PAN_PROP_OLD_STYLE\t(%d)\n", PAN_PROP_OLD_STYLE);
  printf("#define PAN_PROP_MODERN\t(%d)\n", PAN_PROP_MODERN);
  printf("#define PAN_PROP_EVEN_WIDTH\t(%d)\n", PAN_PROP_EVEN_WIDTH);
  printf("#define PAN_PROP_EXPANDED\t(%d)\n", PAN_PROP_EXPANDED);
  printf("#define PAN_PROP_CONDENSED\t(%d)\n", PAN_PROP_CONDENSED);
  printf("#define PAN_PROP_VERY_EXPANDED\t(%d)\n", PAN_PROP_VERY_EXPANDED);
  printf("#define PAN_PROP_VERY_CONDENSED\t(%d)\n", PAN_PROP_VERY_CONDENSED);
  printf("#define PAN_PROP_MONOSPACED\t(%d)\n", PAN_PROP_MONOSPACED);
  printf("#define PAN_CONTRAST_NONE\t(%d)\n", PAN_CONTRAST_NONE);
  printf("#define PAN_CONTRAST_VERY_LOW\t(%d)\n", PAN_CONTRAST_VERY_LOW);
  printf("#define PAN_CONTRAST_LOW\t(%d)\n", PAN_CONTRAST_LOW);
  printf("#define PAN_CONTRAST_MEDIUM_LOW\t(%d)\n", PAN_CONTRAST_MEDIUM_LOW);
  printf("#define PAN_CONTRAST_MEDIUM\t(%d)\n", PAN_CONTRAST_MEDIUM);
  printf("#define PAN_CONTRAST_MEDIUM_HIGH\t(%d)\n", PAN_CONTRAST_MEDIUM_HIGH);
  printf("#define PAN_CONTRAST_HIGH\t(%d)\n", PAN_CONTRAST_HIGH);
  printf("#define PAN_CONTRAST_VERY_HIGH\t(%d)\n", PAN_CONTRAST_VERY_HIGH);
  printf("#define PAN_STROKE_GRADUAL_DIAG\t(%d)\n", PAN_STROKE_GRADUAL_DIAG);
  printf("#define PAN_STROKE_GRADUAL_TRAN\t(%d)\n", PAN_STROKE_GRADUAL_TRAN);
  printf("#define PAN_STROKE_GRADUAL_VERT\t(%d)\n", PAN_STROKE_GRADUAL_VERT);
  printf("#define PAN_STROKE_GRADUAL_HORZ\t(%d)\n", PAN_STROKE_GRADUAL_HORZ);
  printf("#define PAN_STROKE_RAPID_VERT\t(%d)\n", PAN_STROKE_RAPID_VERT);
  printf("#define PAN_STROKE_RAPID_HORZ\t(%d)\n", PAN_STROKE_RAPID_HORZ);
  printf("#define PAN_STROKE_INSTANT_VERT\t(%d)\n", PAN_STROKE_INSTANT_VERT);
  printf("#define PAN_STRAIGHT_ARMS_HORZ\t(%d)\n", PAN_STRAIGHT_ARMS_HORZ);
  printf("#define PAN_STRAIGHT_ARMS_WEDGE\t(%d)\n", PAN_STRAIGHT_ARMS_WEDGE);
  printf("#define PAN_STRAIGHT_ARMS_VERT\t(%d)\n", PAN_STRAIGHT_ARMS_VERT);
  printf("#define PAN_STRAIGHT_ARMS_SINGLE_SERIF\t(%d)\n", PAN_STRAIGHT_ARMS_SINGLE_SERIF);
  printf("#define PAN_STRAIGHT_ARMS_DOUBLE_SERIF\t(%d)\n", PAN_STRAIGHT_ARMS_DOUBLE_SERIF);
  printf("#define PAN_BENT_ARMS_HORZ\t(%d)\n", PAN_BENT_ARMS_HORZ);
  printf("#define PAN_BENT_ARMS_VERT\t(%d)\n", PAN_BENT_ARMS_VERT);
  printf("#define PAN_BENT_ARMS_WEDGE\t(%d)\n", PAN_BENT_ARMS_WEDGE);
  printf("#define PAN_BENT_ARMS_SINGLE_SERIF\t(%d)\n", PAN_BENT_ARMS_SINGLE_SERIF);
  printf("#define PAN_BENT_ARMS_DOUBLE_SERIF\t(%d)\n", PAN_BENT_ARMS_DOUBLE_SERIF);
  printf("#define PAN_LETT_NORMAL_CONTACT\t(%d)\n", PAN_LETT_NORMAL_CONTACT);
  printf("#define PAN_LETT_NORMAL_WEIGHTED\t(%d)\n", PAN_LETT_NORMAL_WEIGHTED);
  printf("#define PAN_LETT_NORMAL_BOXED\t(%d)\n", PAN_LETT_NORMAL_BOXED);
  printf("#define PAN_LETT_NORMAL_FLATTENED\t(%d)\n", PAN_LETT_NORMAL_FLATTENED);
  printf("#define PAN_LETT_NORMAL_ROUNDED\t(%d)\n", PAN_LETT_NORMAL_ROUNDED);
  printf("#define PAN_LETT_NORMAL_OFF_CENTER\t(%d)\n", PAN_LETT_NORMAL_OFF_CENTER);
  printf("#define PAN_LETT_NORMAL_SQUARE\t(%d)\n", PAN_LETT_NORMAL_SQUARE);
  printf("#define PAN_LETT_OBLIQUE_CONTACT\t(%d)\n", PAN_LETT_OBLIQUE_CONTACT);
  printf("#define PAN_LETT_OBLIQUE_WEIGHTED\t(%d)\n", PAN_LETT_OBLIQUE_WEIGHTED);
  printf("#define PAN_LETT_OBLIQUE_BOXED\t(%d)\n", PAN_LETT_OBLIQUE_BOXED);
  printf("#define PAN_LETT_OBLIQUE_FLATTENED\t(%d)\n", PAN_LETT_OBLIQUE_FLATTENED);
  printf("#define PAN_LETT_OBLIQUE_ROUNDED\t(%d)\n", PAN_LETT_OBLIQUE_ROUNDED);
  printf("#define PAN_LETT_OBLIQUE_OFF_CENTER\t(%d)\n", PAN_LETT_OBLIQUE_OFF_CENTER);
  printf("#define PAN_LETT_OBLIQUE_SQUARE\t(%d)\n", PAN_LETT_OBLIQUE_SQUARE);
  printf("#define PAN_MIDLINE_STANDARD_TRIMMED\t(%d)\n", PAN_MIDLINE_STANDARD_TRIMMED);
  printf("#define PAN_MIDLINE_STANDARD_POINTED\t(%d)\n", PAN_MIDLINE_STANDARD_POINTED);
  printf("#define PAN_MIDLINE_STANDARD_SERIFED\t(%d)\n", PAN_MIDLINE_STANDARD_SERIFED);
  printf("#define PAN_MIDLINE_HIGH_TRIMMED\t(%d)\n", PAN_MIDLINE_HIGH_TRIMMED);
  printf("#define PAN_MIDLINE_HIGH_POINTED\t(%d)\n", PAN_MIDLINE_HIGH_POINTED);
  printf("#define PAN_MIDLINE_HIGH_SERIFED\t(%d)\n", PAN_MIDLINE_HIGH_SERIFED);
  printf("#define PAN_MIDLINE_CONSTANT_TRIMMED\t(%d)\n", PAN_MIDLINE_CONSTANT_TRIMMED);
  printf("#define PAN_MIDLINE_CONSTANT_POINTED\t(%d)\n", PAN_MIDLINE_CONSTANT_POINTED);
  printf("#define PAN_MIDLINE_CONSTANT_SERIFED\t(%d)\n", PAN_MIDLINE_CONSTANT_SERIFED);
  printf("#define PAN_MIDLINE_LOW_TRIMMED\t(%d)\n", PAN_MIDLINE_LOW_TRIMMED);
  printf("#define PAN_MIDLINE_LOW_POINTED\t(%d)\n", PAN_MIDLINE_LOW_POINTED);
  printf("#define PAN_MIDLINE_LOW_SERIFED\t(%d)\n", PAN_MIDLINE_LOW_SERIFED);
  printf("#define PAN_XHEIGHT_CONSTANT_SMALL\t(%d)\n", PAN_XHEIGHT_CONSTANT_SMALL);
  printf("#define PAN_XHEIGHT_CONSTANT_STD\t(%d)\n", PAN_XHEIGHT_CONSTANT_STD);
  printf("#define PAN_XHEIGHT_CONSTANT_LARGE\t(%d)\n", PAN_XHEIGHT_CONSTANT_LARGE);
  printf("#define PAN_XHEIGHT_DUCKING_SMALL\t(%d)\n", PAN_XHEIGHT_DUCKING_SMALL);
  printf("#define PAN_XHEIGHT_DUCKING_STD\t(%d)\n", PAN_XHEIGHT_DUCKING_STD);
  printf("#define PAN_XHEIGHT_DUCKING_LARGE\t(%d)\n", PAN_XHEIGHT_DUCKING_LARGE);

  printf("\n/* PALETTENTRY structure */\n");
  printf("#define PC_EXPLICIT\t(%d)\n", PC_EXPLICIT);
  printf("#define PC_NOCOLLAPSE\t(%d)\n", PC_NOCOLLAPSE);
  printf("#define PC_RESERVED\t(%d)\n", PC_RESERVED);

  printf("\n/* LOGBRUSH structure */\n");
  printf("#define BS_DIBPATTERN\t(%d)\n", BS_DIBPATTERN);
  printf("#define BS_DIBPATTERN8X8\t(%d)\n", BS_DIBPATTERN8X8);
  printf("#define BS_DIBPATTERNPT\t(%d)\n", BS_DIBPATTERNPT);
  printf("#define BS_HATCHED\t(%d)\n", BS_HATCHED);
  printf("#define BS_HOLLOW\t(%d)\n", BS_HOLLOW);
  printf("#define BS_NULL\t(%d)\n", BS_NULL);
  printf("#define BS_PATTERN\t(%d)\n", BS_PATTERN);
  printf("#define BS_PATTERN8X8\t(%d)\n", BS_PATTERN8X8);
  printf("#define BS_SOLID\t(%d)\n", BS_SOLID);

  printf("\n/* DEVMODE structure */\n");
  printf("#define DM_ORIENTATION\t(%#lxL)\n", DM_ORIENTATION);
  printf("#define DM_PAPERSIZE\t(%#lxL)\n", DM_PAPERSIZE);
  printf("#define DM_PAPERLENGTH\t(%#lxL)\n", DM_PAPERLENGTH);
  printf("#define DM_PAPERWIDTH\t(%#lxL)\n", DM_PAPERWIDTH);
  printf("#define DM_SCALE\t(%#lxL)\n", DM_SCALE);
  printf("#define DM_COPIES\t(%#lxL)\n", DM_COPIES);
  printf("#define DM_DEFAULTSOURCE\t(%#lxL)\n", DM_DEFAULTSOURCE);
  printf("#define DM_PRINTQUALITY\t(%#lxL)\n", DM_PRINTQUALITY);
  printf("#define DM_COLOR\t(%#lxL)\n", DM_COLOR);
  printf("#define DM_DUPLEX\t(%#lxL)\n", DM_DUPLEX);
  printf("#define DM_YRESOLUTION\t(%#lxL)\n", DM_YRESOLUTION);
  printf("#define DM_TTOPTION\t(%#lxL)\n", DM_TTOPTION);
  printf("#define DM_COLLATE\t(%#lxL)\n", DM_COLLATE);
  printf("#define DM_FORMNAME\t(%#lxL)\n", DM_FORMNAME);
  printf("#define DM_LOGPIXELS\t(%#lxL)\n", DM_LOGPIXELS);
  printf("#define DM_BITSPERPEL\t(%#lxL)\n", DM_BITSPERPEL);
  printf("#define DM_PELSWIDTH\t(%#lxL)\n", DM_PELSWIDTH);
  printf("#define DM_PELSHEIGHT\t(%#lxL)\n", DM_PELSHEIGHT);
  printf("#define DM_DISPLAYFLAGS\t(%#lxL)\n", DM_DISPLAYFLAGS);
  printf("#define DM_DISPLAYFREQUENCY\t(%#lxL)\n", DM_DISPLAYFREQUENCY);
  printf("#define DM_ICMMETHOD\t(%#lxL)\n", DM_ICMMETHOD);
  printf("#define DM_ICMINTENT\t(%#lxL)\n", DM_ICMINTENT);
  printf("#define DM_MEDIATYPE\t(%#lxL)\n", DM_MEDIATYPE);
  printf("#define DM_DITHERTYPE\t(%#lxL)\n", DM_DITHERTYPE);
  printf("#define DMORIENT_LANDSCAPE\t(%d)\n", DMORIENT_LANDSCAPE);
  printf("#define DMORIENT_PORTRAIT\t(%d)\n", DMORIENT_PORTRAIT);
  printf("#define DMPAPER_LETTER\t(%d)\n", DMPAPER_LETTER);
  printf("#define DMPAPER_LEGAL\t(%d)\n", DMPAPER_LEGAL);
  printf("#define DMPAPER_A4\t(%d)\n", DMPAPER_A4);
  printf("#define DMPAPER_CSHEET\t(%d)\n", DMPAPER_CSHEET);
  printf("#define DMPAPER_DSHEET\t(%d)\n", DMPAPER_DSHEET);
  printf("#define DMPAPER_ESHEET\t(%d)\n", DMPAPER_ESHEET);
  printf("#define DMPAPER_LETTERSMALL\t(%d)\n", DMPAPER_LETTERSMALL);
  printf("#define DMPAPER_TABLOID\t(%d)\n", DMPAPER_TABLOID);
  printf("#define DMPAPER_LEDGER\t(%d)\n", DMPAPER_LEDGER);
  printf("#define DMPAPER_STATEMENT\t(%d)\n", DMPAPER_STATEMENT);
  printf("#define DMPAPER_EXECUTIVE\t(%d)\n", DMPAPER_EXECUTIVE);
  printf("#define DMPAPER_A3\t(%d)\n", DMPAPER_A3);
  printf("#define DMPAPER_A4SMALL\t(%d)\n", DMPAPER_A4SMALL);
  printf("#define DMPAPER_A5\t(%d)\n", DMPAPER_A5);
  printf("#define DMPAPER_B4\t(%d)\n", DMPAPER_B4);
  printf("#define DMPAPER_B5\t(%d)\n", DMPAPER_B5);
  printf("#define DMPAPER_FOLIO\t(%d)\n", DMPAPER_FOLIO);
  printf("#define DMPAPER_QUARTO\t(%d)\n", DMPAPER_QUARTO);
  printf("#define DMPAPER_10X14\t(%d)\n", DMPAPER_10X14);
  printf("#define DMPAPER_11X17\t(%d)\n", DMPAPER_11X17);
  printf("#define DMPAPER_NOTE\t(%d)\n", DMPAPER_NOTE);
  printf("#define DMPAPER_ENV_9\t(%d)\n", DMPAPER_ENV_9);
  printf("#define DMPAPER_ENV_10\t(%d)\n", DMPAPER_ENV_10);
  printf("#define DMPAPER_ENV_11\t(%d)\n", DMPAPER_ENV_11);
  printf("#define DMPAPER_ENV_12\t(%d)\n", DMPAPER_ENV_12);
  printf("#define DMPAPER_ENV_14\t(%d)\n", DMPAPER_ENV_14);
  printf("#define DMPAPER_ENV_DL\t(%d)\n", DMPAPER_ENV_DL);
  printf("#define DMPAPER_ENV_C5\t(%d)\n", DMPAPER_ENV_C5);
  printf("#define DMPAPER_ENV_C3\t(%d)\n", DMPAPER_ENV_C3);
  printf("#define DMPAPER_ENV_C4\t(%d)\n", DMPAPER_ENV_C4);
  printf("#define DMPAPER_ENV_C6\t(%d)\n", DMPAPER_ENV_C6);
  printf("#define DMPAPER_ENV_C65\t(%d)\n", DMPAPER_ENV_C65);
  printf("#define DMPAPER_ENV_B4\t(%d)\n", DMPAPER_ENV_B4);
  printf("#define DMPAPER_ENV_B5\t(%d)\n", DMPAPER_ENV_B5);
  printf("#define DMPAPER_ENV_B6\t(%d)\n", DMPAPER_ENV_B6);
  printf("#define DMPAPER_ENV_ITALY\t(%d)\n", DMPAPER_ENV_ITALY);
  printf("#define DMPAPER_ENV_MONARCH\t(%d)\n", DMPAPER_ENV_MONARCH);
  printf("#define DMPAPER_ENV_PERSONAL\t(%d)\n", DMPAPER_ENV_PERSONAL);
  printf("#define DMPAPER_FANFOLD_US\t(%d)\n", DMPAPER_FANFOLD_US);
  printf("#define DMPAPER_FANFOLD_STD_GERMAN\t(%d)\n", DMPAPER_FANFOLD_STD_GERMAN);
  printf("#define DMPAPER_FANFOLD_LGL_GERMAN\t(%d)\n", DMPAPER_FANFOLD_LGL_GERMAN);

  printf("#define DMRES_HIGH\t(%d)\n", DMRES_HIGH);
  printf("#define DMRES_MEDIUM\t(%d)\n", DMRES_MEDIUM);
  printf("#define DMRES_LOW\t(%d)\n", DMRES_LOW);
  printf("#define DMRES_DRAFT\t(%d)\n", DMRES_DRAFT);
  printf("#define DMCOLOR_COLOR\t(%d)\n", DMCOLOR_COLOR);
  printf("#define DMCOLOR_MONOCHROME\t(%d)\n", DMCOLOR_MONOCHROME);
  printf("#define DMDUP_SIMPLEX\t(%d)\n", DMDUP_SIMPLEX);
  printf("#define DMDUP_HORIZONTAL\t(%d)\n", DMDUP_HORIZONTAL);
  printf("#define DMDUP_VERTICAL\t(%d)\n", DMDUP_VERTICAL);
  printf("#define DMTT_BITMAP\t(%d)\n", DMTT_BITMAP);
  printf("#define DMTT_DOWNLOAD\t(%d)\n", DMTT_DOWNLOAD);
  printf("#define DMTT_SUBDEV\t(%d)\n", DMTT_SUBDEV);
  printf("#define DMCOLLATE_TRUE\t(%d)\n", DMCOLLATE_TRUE);
  printf("#define DMCOLLATE_FALSE\t(%d)\n", DMCOLLATE_FALSE);
  printf("#define DM_GRAYSCALE\t(%d)\n", DM_GRAYSCALE);
  printf("#define DM_INTERLACED\t(%d)\n", DM_INTERLACED);
  printf("#define DMICMMETHOD_NONE\t(%d)\n", DMICMMETHOD_NONE);
  printf("#define DMICMMETHOD_SYSTEM\t(%d)\n", DMICMMETHOD_SYSTEM);
  printf("#define DMICMMETHOD_DRIVER\t(%d)\n", DMICMMETHOD_DRIVER);
  printf("#define DMICMMETHOD_DEVICE\t(%d)\n", DMICMMETHOD_DEVICE);
  printf("#define DMICMMETHOD_USER\t(%d)\n", DMICMMETHOD_USER);
  printf("#define DMICM_SATURATE\t(%d)\n", DMICM_SATURATE);
  printf("#define DMICM_CONTRAST\t(%d)\n", DMICM_CONTRAST);
  printf("#define DMICM_COLORMETRIC\t(%d)\n", DMICM_COLORMETRIC);
  printf("#define DMICM_USER\t(%d)\n", DMICM_USER);
  printf("#define DMMEDIA_STANDARD\t(%d)\n", DMMEDIA_STANDARD);
  printf("#define DMMEDIA_GLOSSY\t(%d)\n", DMMEDIA_GLOSSY);
  printf("#define DMMEDIA_TRANSPARENCY\t(%d)\n", DMMEDIA_TRANSPARENCY);
  printf("#define DMMEDIA_USER\t(%d)\n", DMMEDIA_USER);
  printf("#define DMDITHER_NONE\t(%d)\n", DMDITHER_NONE);
  printf("#define DMDITHER_COARSE\t(%d)\n", DMDITHER_COARSE);
  printf("#define DMDITHER_FINE\t(%d)\n", DMDITHER_FINE);
  printf("#define DMDITHER_LINEART\t(%d)\n", DMDITHER_LINEART);
  printf("#define DMDITHER_GRAYSCALE\t(%d)\n", DMDITHER_GRAYSCALE);
  printf("#define DMDITHER_USER\t(%d)\n", DMDITHER_USER);

  printf("\n/* RGNDATAHEADER structure */\n");
  printf("#define RDH_RECTANGLES\t(%d)\n", RDH_RECTANGLES);

  printf("\n/* TTPOLYGONHEADER structure */\n");
  printf("#define TT_POLYGON_TYPE\t(%d)\n", TT_POLYGON_TYPE);

  printf("\n/* TTPOLYCURVE structure */\n");
  printf("#define TT_PRIM_LINE\t(%d)\n", TT_PRIM_LINE);
  printf("#define TT_PRIM_QSPLINE\t(%d)\n", TT_PRIM_QSPLINE);

  printf("\n/* GCP_RESULTS structure */\n");
  printf("#define GCPCLASS_ARABIC\t(%d)\n", GCPCLASS_ARABIC);
  printf("#define GCPCLASS_HEBREW\t(%d)\n", GCPCLASS_HEBREW);
  printf("#define GCPCLASS_LATIN\t(%d)\n", GCPCLASS_LATIN);
  printf("#define GCPCLASS_LATINNUMBER\t(%d)\n", GCPCLASS_LATINNUMBER);
  printf("#define GCPCLASS_LOCALNUMBER\t(%d)\n", GCPCLASS_LOCALNUMBER);
  printf("#define GCPCLASS_LATINNUMERICSEPARATOR\t(%d)\n", GCPCLASS_LATINNUMERICSEPARATOR);
  printf("#define GCPCLASS_LATINNUMERICTERMINATOR\t(%d)\n", GCPCLASS_LATINNUMERICTERMINATOR);
  printf("#define GCPCLASS_NEUTRAL\t(%d)\n", GCPCLASS_NEUTRAL);
  printf("#define GCPCLASS_NUMERICSEPARATOR\t(%d)\n", GCPCLASS_NUMERICSEPARATOR);
  printf("#define GCPCLASS_PREBOUNDLTR\t(%d)\n", GCPCLASS_PREBOUNDLTR);
  printf("#define GCPCLASS_PREBOUNDRTL\t(%d)\n", GCPCLASS_PREBOUNDRTL);
  printf("#define GCPCLASS_POSTBOUNDLTR\t(%d)\n", GCPCLASS_POSTBOUNDLTR);
  printf("#define GCPCLASS_POSTBOUNDRTL\t(%d)\n", GCPCLASS_POSTBOUNDRTL);
  printf("#define GCPGLYPH_LINKBEFORE\t(%d)\n", GCPGLYPH_LINKBEFORE);
  printf("#define GCPGLYPH_LINKAFTER\t(%d)\n", GCPGLYPH_LINKAFTER);

  printf("\n/* RASTERIZER_STATUS structure */\n");
  printf("#define TT_AVAILABLE\t(%d)\n", TT_AVAILABLE);
  printf("#define TT_ENABLED\t(%d)\n", TT_ENABLED);

  printf("\n/* COLORADJUSTMENT structure */\n");
  printf("#define CA_NEGATIVE\t(%d)\n", CA_NEGATIVE);
  printf("#define CA_LOG_FILTER\t(%d)\n", CA_LOG_FILTER);
  printf("#define ILLUMINANT_DEVICE_DEFAULT\t(%d)\n", ILLUMINANT_DEVICE_DEFAULT);
  printf("#define ILLUMINANT_A\t(%d)\n", ILLUMINANT_A);
  printf("#define ILLUMINANT_B\t(%d)\n", ILLUMINANT_B);
  printf("#define ILLUMINANT_C\t(%d)\n", ILLUMINANT_C);
  printf("#define ILLUMINANT_D50\t(%d)\n", ILLUMINANT_D50);
  printf("#define ILLUMINANT_D55\t(%d)\n", ILLUMINANT_D55);
  printf("#define ILLUMINANT_D65\t(%d)\n", ILLUMINANT_D65);
  printf("#define ILLUMINANT_D75\t(%d)\n", ILLUMINANT_D75);
  printf("#define ILLUMINANT_F2\t(%d)\n", ILLUMINANT_F2);
  printf("#define ILLUMINANT_TUNGSTEN\t(%d)\n", ILLUMINANT_TUNGSTEN);
  printf("#define ILLUMINANT_DAYLIGHT\t(%d)\n", ILLUMINANT_DAYLIGHT);
  printf("#define ILLUMINANT_FLUORESCENT\t(%d)\n", ILLUMINANT_FLUORESCENT);
  printf("#define ILLUMINANT_NTSC\t(%d)\n", ILLUMINANT_NTSC);

  printf("\n/* DOCINFO structure */\n");
  printf("#define DI_APPBANDING\t(%d)\n", DI_APPBANDING);

  printf("\n/* EMRMETAHEADER structure */\n");
  printf("#define EMR_HEADER\t(%d)\n", EMR_HEADER);
  printf("#define ENHMETA_SIGNATURE\t(%d)\n", ENHMETA_SIGNATURE);

  printf("\n/* RTF event masks */\n");
  printf("#define ENM_CHANGE\t(%d)\n", ENM_CHANGE);
  printf("#define ENM_CORRECTTEXT\t(%d)\n", ENM_CORRECTTEXT);
  printf("#define ENM_DROPFILES\t(%d)\n", ENM_DROPFILES);
  printf("#define ENM_KEYEVENTS\t(%d)\n", ENM_KEYEVENTS);
  printf("#define ENM_MOUSEEVENTS\t(%d)\n", ENM_MOUSEEVENTS);
  printf("#define ENM_PROTECTED\t(%d)\n", ENM_PROTECTED);
  printf("#define ENM_REQUESTRESIZE\t(%d)\n", ENM_REQUESTRESIZE);
  printf("#define ENM_SCROLL\t(%d)\n", ENM_SCROLL);
  printf("#define ENM_SELCHANGE\t(%d)\n", ENM_SELCHANGE);
  printf("#define ENM_UPDATE\t(%d)\n", ENM_UPDATE);
  printf("#define ENM_NONE\t(%d)\n", ENM_NONE);

  printf("\n/* RTF styles */\n");
  printf("#define ES_DISABLENOSCROLL\t(%d)\n", ES_DISABLENOSCROLL);
  printf("#define ES_EX_NOCALLOLEINIT\t(%d)\n", ES_EX_NOCALLOLEINIT);
  printf("#define ES_NOIME\t(%d)\n", ES_NOIME);
  printf("#define ES_SAVESEL\t(%d)\n", ES_SAVESEL);
  printf("#define ES_SELFIME\t(%d)\n", ES_SELFIME);
  printf("#define ES_SUNKEN\t(%d)\n", ES_SUNKEN);
  printf("#define ES_VERTICAL\t(%d)\n", ES_VERTICAL);
  printf("#define ES_SELECTIONBAR\t(%d)\n", ES_SELECTIONBAR);

  printf("\n/* EM_SETOPTIONS message */\n");
  printf("#define ECOOP_SET\t(%d)\n", ECOOP_SET);
  printf("#define ECOOP_OR\t(%d)\n", ECOOP_OR);
  printf("#define ECOOP_AND\t(%d)\n", ECOOP_AND);
  printf("#define ECOOP_XOR\t(%d)\n", ECOOP_XOR);
  printf("#define ECO_AUTOWORDSELECTION\t(%d)\n", ECO_AUTOWORDSELECTION);
  printf("#define ECO_AUTOVSCROLL\t(%d)\n", ECO_AUTOVSCROLL);
  printf("#define ECO_AUTOHSCROLL\t(%d)\n", ECO_AUTOHSCROLL);
  printf("#define ECO_NOHIDESEL\t(%d)\n", ECO_NOHIDESEL);
  printf("#define ECO_READONLY\t(%d)\n", ECO_READONLY);
  printf("#define ECO_WANTRETURN\t(%d)\n", ECO_WANTRETURN);
  printf("#define ECO_SAVESEL\t(%d)\n", ECO_SAVESEL);
  printf("#define ECO_SELECTIONBAR\t(%d)\n", ECO_SELECTIONBAR);
  printf("#define ECO_VERTICAL\t(%d)\n", ECO_VERTICAL);

  printf("\n/* EM_SETCHARFORMAT message */\n");
//  printf("#define SCF_ALL\t(%d)\n", SCF_ALL);
  printf("#define SCF_WORD\t(%d)\n", SCF_WORD);
  printf("#define SCF_SELECTION\t(%d)\n", SCF_SELECTION);

  printf("\n/* EM_STREAMOUT message */\n");
  printf("#define SF_TEXT\t(%d)\n", SF_TEXT);
  printf("#define SF_RTF\t(%d)\n", SF_RTF);
  printf("#define SF_RTFNOOBJS\t(%d)\n", SF_RTFNOOBJS);
  printf("#define SF_TEXTIZED\t(%d)\n", SF_TEXTIZED);
  printf("#define SFF_SELECTION\t(%d)\n", SFF_SELECTION);
  printf("#define SFF_PLAINRTF\t(%d)\n", SFF_PLAINRTF);

  printf("\n/* EM_FINDWORDBREAK message */\n");
  printf("#define WB_CLASSIFY\t(%d)\n", WB_CLASSIFY);
  printf("#define WB_ISDELIMITER\t(%d)\n", WB_ISDELIMITER);
  printf("#define WB_LEFT\t(%d)\n", WB_LEFT);
  printf("#define WB_LEFTBREAK\t(%d)\n", WB_LEFTBREAK);
  printf("#define WB_PREVBREAK\t(%d)\n", WB_PREVBREAK);
  printf("#define WB_MOVEWORDLEFT\t(%d)\n", WB_MOVEWORDLEFT);
  printf("#define WB_MOVEWORDPREV\t(%d)\n", WB_MOVEWORDPREV);
  printf("#define WB_MOVEWORDRIGHT\t(%d)\n", WB_MOVEWORDRIGHT);
  printf("#define WB_MOVEWORDNEXT\t(%d)\n", WB_MOVEWORDNEXT);
  printf("#define WB_RIGHT\t(%d)\n", WB_RIGHT);
  printf("#define WB_RIGHTBREAK\t(%d)\n", WB_RIGHTBREAK);
  printf("#define WB_NEXTBREAK\t(%d)\n", WB_NEXTBREAK);

  printf("\n/* EM_GETPUNCTUATION message */\n");
  printf("#define PC_LEADING\t(%d)\n", PC_LEADING);
  printf("#define PC_FOLLOWING\t(%d)\n", PC_FOLLOWING);
  printf("#define PC_DELIMITER\t(%d)\n", PC_DELIMITER);
  printf("#define PC_OVERFLOW\t(%d)\n", PC_OVERFLOW);

  printf("\n/* EM_SETWORDWRAPMODE message */\n");
  printf("#define WBF_WORDWRAP\t(%d)\n", WBF_WORDWRAP);
  printf("#define WBF_WORDBREAK\t(%d)\n", WBF_WORDBREAK);
  printf("#define WBF_OVERFLOW\t(%d)\n", WBF_OVERFLOW);
  printf("#define WBF_LEVEL1\t(%d)\n", WBF_LEVEL1);
  printf("#define WBF_LEVEL2\t(%d)\n", WBF_LEVEL2);
  printf("#define WBF_CUSTOM\t(%d)\n", WBF_CUSTOM);
  printf("#define WBF_BREAKAFTER\t(%d)\n", WBF_BREAKAFTER);
  printf("#define WBF_BREAKLINE\t(%d)\n", WBF_BREAKLINE);
  printf("#define WBF_ISWHITE\t(%d)\n", WBF_ISWHITE);

  printf("\n/* CHARFORMAT structure */\n");
  printf("#define CFM_BOLD\t(%d)\n", CFM_BOLD);
  printf("#define CFM_COLOR\t(%d)\n", CFM_COLOR);
  printf("#define CFM_FACE\t(%d)\n", CFM_FACE);
  printf("#define CFM_ITALIC\t(%d)\n", CFM_ITALIC);
  printf("#define CFM_OFFSET\t(%d)\n", CFM_OFFSET);
  printf("#define CFM_PROTECTED\t(%d)\n", CFM_PROTECTED);
  printf("#define CFM_SIZE\t(%#x)\n", CFM_SIZE);
  printf("#define CFM_STRIKEOUT\t(%d)\n", CFM_STRIKEOUT);
  printf("#define CFM_UNDERLINE\t(%d)\n", CFM_UNDERLINE);
  printf("#define CFE_AUTOCOLOR\t(%d)\n", CFE_AUTOCOLOR);
  printf("#define CFE_BOLD\t(%d)\n", CFE_BOLD);
  printf("#define CFE_ITALIC\t(%d)\n", CFE_ITALIC);
  printf("#define CFE_STRIKEOUT\t(%d)\n", CFE_STRIKEOUT);
  printf("#define CFE_UNDERLINE\t(%d)\n", CFE_UNDERLINE);
  printf("#define CFE_PROTECTED\t(%d)\n", CFE_PROTECTED);

  printf("\n/* PARAFORMAT structure */\n");
  printf("#define PFM_ALIGNMENT\t(%d)\n", PFM_ALIGNMENT);
  printf("#define PFM_NUMBERING\t(%d)\n", PFM_NUMBERING);
  printf("#define PFM_OFFSET\t(%d)\n", PFM_OFFSET);
  printf("#define PFM_OFFSETINDENT\t(%#x)\n", PFM_OFFSETINDENT);
  printf("#define PFM_RIGHTINDENT\t(%d)\n", PFM_RIGHTINDENT);
  printf("#define PFM_STARTINDENT\t(%d)\n", PFM_STARTINDENT);
  printf("#define PFM_TABSTOPS\t(%d)\n", PFM_TABSTOPS);
  printf("#define PFN_BULLET\t(%d)\n", PFN_BULLET);
  printf("#define PFA_LEFT\t(%d)\n", PFA_LEFT);
  printf("#define PFA_RIGHT\t(%d)\n", PFA_RIGHT);
  printf("#define PFA_CENTER\t(%d)\n", PFA_CENTER);

  printf("\n/* SELCHANGE structure */\n");
  printf("#define SEL_EMPTY\t(%d)\n", SEL_EMPTY);
  printf("#define SEL_TEXT\t(%d)\n", SEL_TEXT);
  printf("#define SEL_OBJECT\t(%d)\n", SEL_OBJECT);
  printf("#define SEL_MULTICHAR\t(%d)\n", SEL_MULTICHAR);
  printf("#define SEL_MULTIOBJECT\t(%d)\n", SEL_MULTIOBJECT);

  printf("\n/* RTF clipboard formats */\n");
  printf("#define CF_RTF\t\"%s\"\n", CF_RTF);
  printf("#define CF_RETEXTOBJ\t\"%s\"\n", CF_RETEXTOBJ);

  printf("\n/* DRAWITEMSTRUCT structure */\n");
  printf("#define ODT_BUTTON\t(%d)\n", ODT_BUTTON);
  printf("#define ODT_COMBOBOX\t(%d)\n", ODT_COMBOBOX);
  printf("#define ODT_LISTBOX\t(%d)\n", ODT_LISTBOX);
  printf("#define ODT_LISTVIEW\t(%d)\n", ODT_LISTVIEW);
  printf("#define ODT_MENU\t(%d)\n", ODT_MENU);
  printf("#define ODT_STATIC\t(%d)\n", ODT_STATIC);
  printf("#define ODT_TAB\t(%d)\n", ODT_TAB);
  printf("#define ODT_HEADER\t(%d)\n", ODT_HEADER);
  printf("#define ODA_DRAWENTIRE\t(%d)\n", ODA_DRAWENTIRE);
  printf("#define ODA_FOCUS\t(%d)\n", ODA_FOCUS);
  printf("#define ODA_SELECT\t(%d)\n", ODA_SELECT);
  printf("#define ODS_CHECKED\t(%d)\n", ODS_CHECKED);
  printf("#define ODS_COMBOBOXEDIT\t(%d)\n", ODS_COMBOBOXEDIT);
  printf("#define ODS_DEFAULT\t(%d)\n", ODS_DEFAULT);
  printf("#define ODS_DISABLED\t(%d)\n", ODS_DISABLED);
  printf("#define ODS_FOCUS\t(%d)\n", ODS_FOCUS);
  printf("#define ODS_GRAYED\t(%d)\n", ODS_GRAYED);
  printf("#define ODS_SELECTED\t(%d)\n", ODS_SELECTED);

  printf("\n/* Common control window classes */\n");
  printf("#define ANIMATE_CLASSW\tL\"%s\"\n", ANIMATE_CLASSA);
  printf("#define HOTKEY_CLASSW\tL\"%s\"\n", HOTKEY_CLASSA);
  printf("#define PROGRESS_CLASSW\tL\"%s\"\n", PROGRESS_CLASSA);
  printf("#define STATUSCLASSNAMEW\tL\"%s\"\n", STATUSCLASSNAMEA);
  printf("#define TOOLBARCLASSNAMEW\tL\"%s\"\n", TOOLBARCLASSNAMEA);
  printf("#define TOOLTIPS_CLASSW\tL\"%s\"\n", TOOLTIPS_CLASSA);
  printf("#define TRACKBAR_CLASSW\tL\"%s\"\n", TRACKBAR_CLASSA);
  printf("#define UPDOWN_CLASSW\tL\"%s\"\n", UPDOWN_CLASSA);
  printf("#define WC_HEADERW\tL\"%s\"\n", WC_HEADERA);
  printf("#define WC_LISTVIEWW\tL\"%s\"\n", WC_LISTVIEWA);
  printf("#define WC_TABCONTROLW\tL\"%s\"\n", WC_TABCONTROLA);
  printf("#define WC_TREEVIEWW\tL\"%s\"\n", WC_TREEVIEWA);

  printf("\n/* Common control styles */\n");
  printf("#define CCS_ADJUSTABLE\t(%#lxL)\n", CCS_ADJUSTABLE);
  printf("#define CCS_BOTTOM\t(%#lxL)\n", CCS_BOTTOM);
  printf("#define CCS_NODIVIDER\t(%#lxL)\n", CCS_NODIVIDER);
//  printf("#define CCS_NOHILITE\t(%#lxL)\n", CCS_NOHILITE);
  printf("#define CCS_NOMOVEY\t(%#lxL)\n", CCS_NOMOVEY);
  printf("#define CCS_NOPARENTALIGN\t(%#lxL)\n", CCS_NOPARENTALIGN);
  printf("#define CCS_NORESIZE\t(%#lxL)\n", CCS_NORESIZE);
  printf("#define CCS_TOP\t(%#lxL)\n", CCS_TOP);

  printf("#define ANIMATE_CLASSA\t\"%s\"\n", ANIMATE_CLASSA);
  printf("#define HOTKEY_CLASSA\t\"%s\"\n", HOTKEY_CLASSA);
  printf("#define PROGRESS_CLASSA\t\"%s\"\n", PROGRESS_CLASSA);
  printf("#define STATUSCLASSNAMEA\t\"%s\"\n", STATUSCLASSNAMEA);
  printf("#define TOOLBARCLASSNAMEA\t\"%s\"\n", TOOLBARCLASSNAMEA);
  printf("#define TOOLTIPS_CLASSA\t\"%s\"\n", TOOLTIPS_CLASSA);
  printf("#define TRACKBAR_CLASSA\t\"%s\"\n", TRACKBAR_CLASSA);
  printf("#define UPDOWN_CLASSA\t\"%s\"\n", UPDOWN_CLASSA);
  printf("#define WC_HEADERA\t\"%s\"\n", WC_HEADERA);
  printf("#define WC_LISTVIEWA\t\"%s\"\n", WC_LISTVIEWA);
  printf("#define WC_TABCONTROLA\t\"%s\"\n", WC_TABCONTROLA);
  printf("#define WC_TREEVIEWA\t\"%s\"\n", WC_TREEVIEWA);
  printf("#ifdef UNICODE\n");
  printf("#define ANIMATE_CLASS ANIMATE_CLASSW\n");
  printf("#define HOTKEY_CLASS HOTKEY_CLASSW\n");
  printf("#define PROGRESS_CLASS PROGRESS_CLASSW\n");
  printf("#define STATUSCLASSNAME STATUSCLASSNAMEW\n");
  printf("#define TOOLBARCLASSNAME TOOLBARCLASSNAMEW\n");
  printf("#define TOOLTIPS_CLASS TOOLTIPS_CLASSW\n");
  printf("#define TRACKBAR_CLASS TRACKBAR_CLASSW\n");
  printf("#define UPDOWN_CLASS UPDOWN_CLASSW\n");
  printf("#define WC_HEADER WC_HEADERW\n");
  printf("#define WC_LISTVIEW WC_LISTVIEWW\n");
  printf("#define WC_TABCONTROL WC_TABCONTROLW\n");
  printf("#define WC_TREEVIEW WC_TREEVIEWW\n");
  printf("#else\n");
  printf("#define ANIMATE_CLASS ANIMATE_CLASSA\n");
  printf("#define HOTKEY_CLASS HOTKEY_CLASSA\n");
  printf("#define PROGRESS_CLASS PROGRESS_CLASSA\n");
  printf("#define STATUSCLASSNAME STATUSCLASSNAMEA\n");
  printf("#define TOOLBARCLASSNAME TOOLBARCLASSNAMEA\n");
  printf("#define TOOLTIPS_CLASS TOOLTIPS_CLASSA\n");
  printf("#define TRACKBAR_CLASS TRACKBAR_CLASSA\n");
  printf("#define UPDOWN_CLASS UPDOWN_CLASSA\n");
  printf("#define WC_HEADER WC_HEADERA\n");
  printf("#define WC_LISTVIEW WC_LISTVIEWA\n");
  printf("#define WC_TABCONTROL WC_TABCONTROLA\n");
  printf("#define WC_TREEVIEW WC_TREEVIEWA\n");
  printf("#endif /* UNICODE */\n");

  printf("\n/* Header control styles */\n");
  printf("#define HDS_BUTTONS\t(%d)\n", HDS_BUTTONS);
  printf("#define HDS_HIDDEN\t(%d)\n", HDS_HIDDEN);
  printf("#define HDS_HORZ\t(%d)\n", HDS_HORZ);

  printf("\n/* HD_ITEM structure */\n");
  printf("#define HDI_BITMAP\t(%d)\n", HDI_BITMAP);
  printf("#define HDI_FORMAT\t(%d)\n", HDI_FORMAT);
  printf("#define HDI_HEIGHT\t(%d)\n", HDI_HEIGHT);
  printf("#define HDI_LPARAM\t(%d)\n", HDI_LPARAM);
  printf("#define HDI_TEXT\t(%d)\n", HDI_TEXT);
  printf("#define HDI_WIDTH\t(%d)\n", HDI_WIDTH);
  printf("#define HDF_CENTER\t(%d)\n", HDF_CENTER);
  printf("#define HDF_LEFT\t(%d)\n", HDF_LEFT);
  printf("#define HDF_RIGHT\t(%d)\n", HDF_RIGHT);
  printf("#define HDF_RTLREADING\t(%d)\n", HDF_RTLREADING);
  printf("#define HDF_BITMAP\t(%d)\n", HDF_BITMAP);
  printf("#define HDF_OWNERDRAW\t(%d)\n", HDF_OWNERDRAW);
  printf("#define HDF_STRING\t(%d)\n", HDF_STRING);
  printf("#define HDF_JUSTIFYMASK\t(%d)\n", HDF_JUSTIFYMASK);

  printf("\n/* HD_HITTESTINFO structure */\n");
  printf("#define HHT_NOWHERE\t(%d)\n", HHT_NOWHERE);
  printf("#define HHT_ONDIVIDER\t(%d)\n", HHT_ONDIVIDER);
  printf("#define HHT_ONDIVOPEN\t(%d)\n", HHT_ONDIVOPEN);
  printf("#define HHT_ONHEADER\t(%d)\n", HHT_ONHEADER);
  printf("#define HHT_TOLEFT\t(%d)\n", HHT_TOLEFT);
  printf("#define HHT_TORIGHT\t(%d)\n", HHT_TORIGHT);

  printf("\n/* TBADDBITMAP structure */\n");
  printf("#define HINST_COMMCTRL\t((HINSTANCE)-1)\n");
  printf("#define IDB_STD_LARGE_COLOR\t(%d)\n", IDB_STD_LARGE_COLOR);
  printf("#define IDB_STD_SMALL_COLOR\t(%d)\n", IDB_STD_SMALL_COLOR);
  printf("#define IDB_VIEW_LARGE_COLOR\t(%d)\n", IDB_VIEW_LARGE_COLOR);
  printf("#define IDB_VIEW_SMALL_COLOR\t(%d)\n", IDB_VIEW_SMALL_COLOR);
  printf("#define STD_COPY\t(%d)\n", STD_COPY);
  printf("#define STD_CUT\t(%d)\n", STD_CUT);
  printf("#define STD_DELETE\t(%d)\n", STD_DELETE);
  printf("#define STD_FILENEW\t(%d)\n", STD_FILENEW);
  printf("#define STD_FILEOPEN\t(%d)\n", STD_FILEOPEN);
  printf("#define STD_FILESAVE\t(%d)\n", STD_FILESAVE);
  printf("#define STD_FIND\t(%d)\n", STD_FIND);
  printf("#define STD_HELP\t(%d)\n", STD_HELP);
  printf("#define STD_PASTE\t(%d)\n", STD_PASTE);
  printf("#define STD_PRINT\t(%d)\n", STD_PRINT);
  printf("#define STD_PRINTPRE\t(%d)\n", STD_PRINTPRE);
  printf("#define STD_PROPERTIES\t(%d)\n", STD_PROPERTIES);
  printf("#define STD_REDOW\t(%d)\n", STD_REDOW);
  printf("#define STD_REPLACE\t(%d)\n", STD_REPLACE);
  printf("#define STD_UNDO\t(%d)\n", STD_UNDO);
  printf("#define VIEW_LARGEICONS\t(%d)\n", VIEW_LARGEICONS);
  printf("#define VIEW_SMALLICONS\t(%d)\n", VIEW_SMALLICONS);
  printf("#define VIEW_LIST\t(%d)\n", VIEW_LIST);
  printf("#define VIEW_DETAILS\t(%d)\n", VIEW_DETAILS);
  printf("#define VIEW_SORTNAME\t(%d)\n", VIEW_SORTNAME);
  printf("#define VIEW_SORTSIZE\t(%d)\n", VIEW_SORTSIZE);
  printf("#define VIEW_SORTDATE\t(%d)\n", VIEW_SORTDATE);
  printf("#define VIEW_SORTTYPE\t(%d)\n", VIEW_SORTTYPE);

  printf("\n/* Toolbar styles */\n");
  printf("#define TBSTYLE_ALTDRAG\t(%d)\n", TBSTYLE_ALTDRAG);
  printf("#define TBSTYLE_TOOLTIPS\t(%d)\n", TBSTYLE_TOOLTIPS);
  printf("#define TBSTYLE_WRAPABLE\t(%d)\n", TBSTYLE_WRAPABLE);
  printf("#define TBSTYLE_BUTTON\t(%d)\n", TBSTYLE_BUTTON);
  printf("#define TBSTYLE_CHECK\t(%d)\n", TBSTYLE_CHECK);
  printf("#define TBSTYLE_CHECKGROUP\t(%d)\n", TBSTYLE_CHECKGROUP);
  printf("#define TBSTYLE_GROUP\t(%d)\n", TBSTYLE_GROUP);
  printf("#define TBSTYLE_SEP\t(%d)\n", TBSTYLE_SEP);

  printf("\n/* Toolbar states */\n");
  printf("#define TBSTATE_CHECKED\t(%d)\n", TBSTATE_CHECKED);
  printf("#define TBSTATE_ENABLED\t(%d)\n", TBSTATE_ENABLED);
  printf("#define TBSTATE_HIDDEN\t(%d)\n", TBSTATE_HIDDEN);
  printf("#define TBSTATE_INDETERMINATE\t(%d)\n", TBSTATE_INDETERMINATE);
  printf("#define TBSTATE_PRESSED\t(%d)\n", TBSTATE_PRESSED);
  printf("#define TBSTATE_WRAP\t(%d)\n", TBSTATE_WRAP);

  printf("\n/* Tooltip styles */\n");
  printf("#define TTS_ALWAYSTIP\t(%d)\n", TTS_ALWAYSTIP);
  printf("#define TTS_NOPREFIX\t(%d)\n", TTS_NOPREFIX);

  printf("\n/* TOOLINFO structure */\n");
  printf("#define TTF_IDISHWND\t(%d)\n", TTF_IDISHWND);
  printf("#define TTF_CENTERTIP\t(%d)\n", TTF_CENTERTIP);
  printf("#define TTF_RTLREADING\t(%d)\n", TTF_RTLREADING);
  printf("#define TTF_SUBCLASS\t(%d)\n", TTF_SUBCLASS);

  printf("\n/* TTM_SETDELAYTIME message */\n");
  printf("#define TTDT_AUTOMATIC\t(%d)\n", TTDT_AUTOMATIC);
  printf("#define TTDT_AUTOPOP\t(%d)\n", TTDT_AUTOPOP);
  printf("#define TTDT_INITIAL\t(%d)\n", TTDT_INITIAL);
  printf("#define TTDT_RESHOW\t(%d)\n", TTDT_RESHOW);

  printf("\n/* Status window */\n");
  printf("#define SBARS_SIZEGRIP\t(%d)\n", SBARS_SIZEGRIP);
  printf("#define SBARS_SIZEGRIP\t(%d)\n", SBARS_SIZEGRIP);

  printf("\n/* DL_DRAGGING message */\n");
  printf("#define DL_MOVECURSOR\t(%d)\n", DL_MOVECURSOR);
  printf("#define DL_COPYCURSOR\t(%d)\n", DL_COPYCURSOR);
  printf("#define DL_STOPCURSOR\t(%d)\n", DL_STOPCURSOR);

  printf("\n/* Up-down control styles */\n");
  printf("#define UDS_ALIGNLEFT\t(%d)\n", UDS_ALIGNLEFT);
  printf("#define UDS_ALIGNRIGHT\t(%d)\n", UDS_ALIGNRIGHT);
  printf("#define UDS_ARROWKEYS\t(%d)\n", UDS_ARROWKEYS);
  printf("#define UDS_AUTOBUDDY\t(%d)\n", UDS_AUTOBUDDY);
  printf("#define UDS_HORZ\t(%d)\n", UDS_HORZ);
  printf("#define UDS_NOTHOUSANDS\t(%d)\n", UDS_NOTHOUSANDS);
  printf("#define UDS_SETBUDDYINT\t(%d)\n", UDS_SETBUDDYINT);
  printf("#define UDS_WRAP\t(%d)\n", UDS_WRAP);

  printf("\n/* UDM_SETRANGE message */\n");
  printf("#define UD_MAXVAL\t(%d)\n", UD_MAXVAL);
  printf("#define UD_MINVAL\t(%d)\n", UD_MINVAL);

  printf("\n/* HKM_GETHOTKEY message */\n");
  printf("#define HOTKEYF_ALT\t(%d)\n", HOTKEYF_ALT);
  printf("#define HOTKEYF_CONTROL\t(%d)\n", HOTKEYF_CONTROL);
  printf("#define HOTKEYF_EXT\t(%d)\n", HOTKEYF_EXT);
  printf("#define HOTKEYF_SHIFT\t(%d)\n", HOTKEYF_SHIFT);

  printf("\n/* HKM_SETRULES message */\n");
  printf("#define HKCOMB_A\t(%d)\n", HKCOMB_A);
  printf("#define HKCOMB_C\t(%d)\n", HKCOMB_C);
  printf("#define HKCOMB_CA\t(%d)\n", HKCOMB_CA);
  printf("#define HKCOMB_NONE\t(%d)\n", HKCOMB_NONE);
  printf("#define HKCOMB_S\t(%d)\n", HKCOMB_S);
  printf("#define HKCOMB_SA\t(%d)\n", HKCOMB_SA);
  printf("#define HKCOMB_SC\t(%d)\n", HKCOMB_SC);
  printf("#define HKCOMB_SCA\t(%d)\n", HKCOMB_SCA);

  printf("\n/* Trackbar styles */\n");
  printf("#define TBS_HORZ\t(%d)\n", TBS_HORZ);
  printf("#define TBS_VERT\t(%d)\n", TBS_VERT);
  printf("#define TBS_AUTOTICKS\t(%d)\n", TBS_AUTOTICKS);
  printf("#define TBS_NOTICKS\t(%d)\n", TBS_NOTICKS);
  printf("#define TBS_TOP\t(%d)\n", TBS_TOP);
  printf("#define TBS_BOTTOM\t(%d)\n", TBS_BOTTOM);
  printf("#define TBS_LEFT\t(%d)\n", TBS_LEFT);
  printf("#define TBS_RIGHT\t(%d)\n", TBS_RIGHT);
  printf("#define TBS_BOTH\t(%d)\n", TBS_BOTH);
  printf("#define TBS_ENABLESELRANGE\t(%d)\n", TBS_ENABLESELRANGE);
  printf("#define TBS_FIXEDLENGTH\t(%d)\n", TBS_FIXEDLENGTH);
  printf("#define TBS_NOTHUMB\t(%d)\n", TBS_NOTHUMB);
  printf("#define TB_BOTTOM\t(%d)\n", TB_BOTTOM);
  printf("#define TB_ENDTRACK\t(%d)\n", TB_ENDTRACK);
  printf("#define TB_LINEDOWN\t(%d)\n", TB_LINEDOWN);
  printf("#define TB_LINEUP\t(%d)\n", TB_LINEUP);
  printf("#define TB_PAGEDOWN\t(%d)\n", TB_PAGEDOWN);
  printf("#define TB_PAGEUP\t(%d)\n", TB_PAGEUP);
  printf("#define TB_THUMBPOSITION\t(%d)\n", TB_THUMBPOSITION);
  printf("#define TB_THUMBTRACK\t(%d)\n", TB_THUMBTRACK);
  printf("#define TB_TOP\t(%d)\n", TB_TOP);

  printf("\n/* List view styles */\n");
  printf("#define LVS_ALIGNLEFT\t(%d)\n", LVS_ALIGNLEFT);
  printf("#define LVS_ALIGNTOP\t(%d)\n", LVS_ALIGNTOP);
  printf("#define LVS_AUTOARRANGE\t(%d)\n", LVS_AUTOARRANGE);
//  printf("#define LVS_BUTTON\t(%d)\n", LVS_BUTTON);
  printf("#define LVS_EDITLABELS\t(%d)\n", LVS_EDITLABELS);
  printf("#define LVS_ICON\t(%d)\n", LVS_ICON);
  printf("#define LVS_LIST\t(%d)\n", LVS_LIST);
  printf("#define LVS_NOCOLUMNHEADER\t(%d)\n", LVS_NOCOLUMNHEADER);
  printf("#define LVS_NOLABELWRAP\t(%d)\n", LVS_NOLABELWRAP);
  printf("#define LVS_NOSCROLL\t(%d)\n", LVS_NOSCROLL);
  printf("#define LVS_NOSORTHEADER\t(%d)\n", LVS_NOSORTHEADER);
  printf("#define LVS_OWNERDRAWFIXED\t(%d)\n", LVS_OWNERDRAWFIXED);
  printf("#define LVS_REPORT\t(%d)\n", LVS_REPORT);
  printf("#define LVS_SHAREIMAGELISTS\t(%d)\n", LVS_SHAREIMAGELISTS);
  printf("#define LVS_SHOWSELALWAYS\t(%d)\n", LVS_SHOWSELALWAYS);
  printf("#define LVS_SINGLESEL\t(%d)\n", LVS_SINGLESEL);
  printf("#define LVS_SMALLICON\t(%d)\n", LVS_SMALLICON);
  printf("#define LVS_SORTASCENDING\t(%d)\n", LVS_SORTASCENDING);
  printf("#define LVS_SORTDESCENDING\t(%d)\n", LVS_SORTDESCENDING);
  printf("#define LVS_TYPESTYLEMASK\t(%d)\n", LVS_TYPESTYLEMASK);
  printf("#define LVSIL_NORMAL\t(%d)\n", LVSIL_NORMAL);
  printf("#define LVSIL_SMALL\t(%d)\n", LVSIL_SMALL);
  printf("#define LVSIL_STATE\t(%d)\n", LVSIL_STATE);
  printf("#define LVIS_CUT\t(%d)\n", LVIS_CUT);
  printf("#define LVIS_DROPHILITED\t(%d)\n", LVIS_DROPHILITED);
  printf("#define LVIS_FOCUSED\t(%d)\n", LVIS_FOCUSED);
  printf("#define LVIS_SELECTED\t(%d)\n", LVIS_SELECTED);
  printf("#define LVIS_OVERLAYMASK\t(%d)\n", LVIS_OVERLAYMASK);
  printf("#define LVIS_STATEIMAGEMASK\t(%d)\n", LVIS_STATEIMAGEMASK);

  printf("#define LPSTR_TEXTCALLBACKW\t((LPWSTR)-1L)\n");
  printf("#define LPSTR_TEXTCALLBACKA\t(LPSTR)-1L)\n");
  printf("#ifdef UNICODE\n");
  printf("#define LPSTR_TEXTCALLBACK LPSTR_TEXTCALLBACKW\n");
  printf("#else\n");
  printf("#define LPSTR_TEXTCALLBACK LPSTR_TEXTCALLBACKA\n");
  printf("#endif /* UNICODE */\n");
  
  printf("\n/* LV_ITEM structure */\n");
  printf("#define LVIF_TEXT\t(%d)\n", LVIF_TEXT);
  printf("#define LVIF_IMAGE\t(%d)\n", LVIF_IMAGE);
  printf("#define LVIF_PARAM\t(%d)\n", LVIF_PARAM);
  printf("#define LVIF_STATE\t(%d)\n", LVIF_STATE);
  printf("#define LVIF_DI_SETITEM\t(%d)\n", LVIF_DI_SETITEM);

  printf("\n/* LVM_GETNEXTITEM structure */\n");
  printf("#define LVNI_ABOVE\t(%d)\n", LVNI_ABOVE);
  printf("#define LVNI_ALL\t(%d)\n", LVNI_ALL);
  printf("#define LVNI_BELOW\t(%d)\n", LVNI_BELOW);
  printf("#define LVNI_TOLEFT\t(%d)\n", LVNI_TOLEFT);
  printf("#define LVNI_TORIGHT\t(%d)\n", LVNI_TORIGHT);
  printf("#define LVNI_CUT\t(%d)\n", LVNI_CUT);
  printf("#define LVNI_DROPHILITED\t(%d)\n", LVNI_DROPHILITED);
  printf("#define LVNI_FOCUSED\t(%d)\n", LVNI_FOCUSED);
  printf("#define LVNI_SELECTED\t(%d)\n", LVNI_SELECTED);

  printf("\n/* LV_FINDINFO structure */\n");
  printf("#define LVFI_PARAM\t(%d)\n", LVFI_PARAM);
  printf("#define LVFI_PARTIAL\t(%d)\n", LVFI_PARTIAL);
  printf("#define LVFI_STRING\t(%d)\n", LVFI_STRING);
  printf("#define LVFI_WRAP\t(%d)\n", LVFI_WRAP);
  printf("#define LVFI_NEARESTXY\t(%d)\n", LVFI_NEARESTXY);

  printf("\n/* LV_HITTESTINFO structure */\n");
  printf("#define LVHT_ABOVE\t(%d)\n", LVHT_ABOVE);
  printf("#define LVHT_BELOW\t(%d)\n", LVHT_BELOW);
  printf("#define LVHT_NOWHERE\t(%d)\n", LVHT_NOWHERE);
  printf("#define LVHT_ONITEMICON\t(%d)\n", LVHT_ONITEMICON);
  printf("#define LVHT_ONITEMLABEL\t(%d)\n", LVHT_ONITEMLABEL);
  printf("#define LVHT_ONITEMSTATEICON\t(%d)\n", LVHT_ONITEMSTATEICON);
  printf("#define LVHT_TOLEFT\t(%d)\n", LVHT_TOLEFT);
  printf("#define LVHT_TORIGHT\t(%d)\n", LVHT_TORIGHT);

  printf("\n/* LV_COLUMN structure */\n");
  printf("#define LVCF_FMT\t(%d)\n", LVCF_FMT);
  printf("#define LVCF_SUBITEM\t(%d)\n", LVCF_SUBITEM);
  printf("#define LVCF_TEXT\t(%d)\n", LVCF_TEXT);
  printf("#define LVCF_WIDTH\t(%d)\n", LVCF_WIDTH);
  printf("#define LVCFMT_CENTER\t(%d)\n", LVCFMT_CENTER);
  printf("#define LVCFMT_LEFT\t(%d)\n", LVCFMT_LEFT);
  printf("#define LVCFMT_RIGHT\t(%d)\n", LVCFMT_RIGHT);

  printf("\n/* ListView_GetItemRect */\n");
  printf("#define LVIR_BOUNDS\t(%d)\n", LVIR_BOUNDS);
  printf("#define LVIR_ICON\t(%d)\n", LVIR_ICON);
  printf("#define LVIR_LABEL\t(%d)\n", LVIR_LABEL);
  printf("#define LVIR_SELECTBOUNDS\t(%d)\n", LVIR_SELECTBOUNDS);

  printf("\n/* LVM_ARRANGE message */\n");
  printf("#define LVA_ALIGNLEFT\t(%d)\n", LVA_ALIGNLEFT);
  printf("#define LVA_ALIGNTOP\t(%d)\n", LVA_ALIGNTOP);
  printf("#define LVA_DEFAULT\t(%d)\n", LVA_DEFAULT);
  printf("#define LVA_SNAPTOGRID\t(%d)\n", LVA_SNAPTOGRID);

  printf("\n/* LVM_SETCOLUMNWIDTH message */\n");
  printf("#define LVSCW_AUTOSIZE\t(%d)\n", LVSCW_AUTOSIZE);
  printf("#define LVSCW_AUTOSIZE_USEHEADER\t(%d)\n", LVSCW_AUTOSIZE_USEHEADER);

  printf("\n/* Tree View styles */\n");
  printf("#define TVS_DISABLEDRAGDROP\t(%d)\n", TVS_DISABLEDRAGDROP);
  printf("#define TVS_EDITLABELS\t(%d)\n", TVS_EDITLABELS);
  printf("#define TVS_HASBUTTONS\t(%d)\n", TVS_HASBUTTONS);
  printf("#define TVS_HASLINES\t(%d)\n", TVS_HASLINES);
  printf("#define TVS_LINESATROOT\t(%d)\n", TVS_LINESATROOT);
  printf("#define TVS_SHOWSELALWAYS\t(%d)\n", TVS_SHOWSELALWAYS);

  printf("\n/* Tree View states */\n");
  printf("#define TVIS_BOLD\t(%d)\n", TVIS_BOLD);
  printf("#define TVIS_CUT\t(%d)\n", TVIS_CUT);
  printf("#define TVIS_DROPHILITED\t(%d)\n", TVIS_DROPHILITED);
  printf("#define TVIS_EXPANDED\t(%d)\n", TVIS_EXPANDED);
  printf("#define TVIS_EXPANDEDONCE\t(%d)\n", TVIS_EXPANDEDONCE);
  printf("#define TVIS_FOCUSED\t(%d)\n", TVIS_FOCUSED);
  printf("#define TVIS_OVERLAYMASK\t(%d)\n", TVIS_OVERLAYMASK);
  printf("#define TVIS_SELECTED\t(%d)\n", TVIS_SELECTED);
  printf("#define TVIS_STATEIMAGEMASK\t(%d)\n", TVIS_STATEIMAGEMASK);
  printf("#define TVIS_USERMASK\t(%d)\n", TVIS_USERMASK);

  printf("\n/* TV_ITEM structure */\n");
  printf("#define TVIF_CHILDREN\t(%d)\n", TVIF_CHILDREN);
  printf("#define TVIF_HANDLE\t(%d)\n", TVIF_HANDLE);
  printf("#define TVIF_IMAGE\t(%d)\n", TVIF_IMAGE);
  printf("#define TVIF_PARAM\t(%d)\n", TVIF_PARAM);
  printf("#define TVIF_SELECTEDIMAGE\t(%d)\n", TVIF_SELECTEDIMAGE);
  printf("#define TVIF_STATE\t(%d)\n", TVIF_STATE);
  printf("#define TVIF_TEXT\t(%d)\n", TVIF_TEXT);
  printf("#define I_CHILDRENCALLBACK\t(%d)\n", I_CHILDRENCALLBACK);
  printf("#define I_IMAGECALLBACK\t(%d)\n", I_IMAGECALLBACK);

  printf("\n/* TV_INSERTSTRUCT structure */\n");
  printf("#define TVI_ROOT\t((HTREEITEM)0xFFFF0000)\n");
  printf("#define TVI_FIRST\t((HTREEITEM)0xFFFF0001)\n");
  printf("#define TVI_LAST\t((HTREEITEM)0xFFFF0002)\n");
  printf("#define TVI_SORT\t((HTREEITEM)0xFFFF0003)\n");

  printf("\n/* TV_HITTESTINFO structure */\n");
  printf("#define TVHT_ABOVE\t(%d)\n", TVHT_ABOVE);
  printf("#define TVHT_BELOW\t(%d)\n", TVHT_BELOW);
  printf("#define TVHT_NOWHERE\t(%d)\n", TVHT_NOWHERE);
  printf("#define TVHT_ONITEM\t(%d)\n", TVHT_ONITEM);
  printf("#define TVHT_ONITEMBUTTON\t(%d)\n", TVHT_ONITEMBUTTON);
  printf("#define TVHT_ONITEMICON\t(%d)\n", TVHT_ONITEMICON);
  printf("#define TVHT_ONITEMINDENT\t(%d)\n", TVHT_ONITEMINDENT);
  printf("#define TVHT_ONITEMLABEL\t(%d)\n", TVHT_ONITEMLABEL);
  printf("#define TVHT_ONITEMRIGHT\t(%d)\n", TVHT_ONITEMRIGHT);
  printf("#define TVHT_ONITEMSTATEICON\t(%d)\n", TVHT_ONITEMSTATEICON);
  printf("#define TVHT_TOLEFT\t(%d)\n", TVHT_TOLEFT);
  printf("#define TVHT_TORIGHT\t(%d)\n", TVHT_TORIGHT);

  printf("\n/* TVM_EXPAND message */\n");
  printf("#define TVE_COLLAPSE\t(%d)\n", TVE_COLLAPSE);
  printf("#define TVE_COLLAPSERESET\t(%d)\n", TVE_COLLAPSERESET);
  printf("#define TVE_EXPAND\t(%d)\n", TVE_EXPAND);
  printf("#define TVE_TOGGLE\t(%d)\n", TVE_TOGGLE);

  printf("\n/* TVM_GETIMAGELIST message */\n");
  printf("#define TVSIL_NORMAL\t(%d)\n", TVSIL_NORMAL);
  printf("#define TVSIL_STATE\t(%d)\n", TVSIL_STATE);

  printf("\n/* TVM_GETNEXTITEM message */\n");
  printf("#define TVGN_CARET\t(%d)\n", TVGN_CARET);
  printf("#define TVGN_CHILD\t(%d)\n", TVGN_CHILD);
  printf("#define TVGN_DROPHILITE\t(%d)\n", TVGN_DROPHILITE);
  printf("#define TVGN_FIRSTVISIBLE\t(%d)\n", TVGN_FIRSTVISIBLE);
  printf("#define TVGN_NEXT\t(%d)\n", TVGN_NEXT);
  printf("#define TVGN_NEXTVISIBLE\t(%d)\n", TVGN_NEXTVISIBLE);
  printf("#define TVGN_PARENT\t(%d)\n", TVGN_PARENT);
  printf("#define TVGN_PREVIOUS\t(%d)\n", TVGN_PREVIOUS);
  printf("#define TVGN_PREVIOUSVISIBLE\t(%d)\n", TVGN_PREVIOUSVISIBLE);
  printf("#define TVGN_ROOT\t(%d)\n", TVGN_ROOT);

  printf("\n/* TVN_SELCHANGED message */\n");
  printf("#define TVC_BYKEYBOARD\t(%d)\n", TVC_BYKEYBOARD);
  printf("#define TVC_BYMOUSE\t(%d)\n", TVC_BYMOUSE);
  printf("#define TVC_UNKNOWN\t(%d)\n", TVC_UNKNOWN);

  printf("\n/* Tab control styles */\n");
  printf("#define TCS_BUTTONS\t(%d)\n", TCS_BUTTONS);
  printf("#define TCS_FIXEDWIDTH\t(%d)\n", TCS_FIXEDWIDTH);
  printf("#define TCS_FOCUSNEVER\t(%d)\n", TCS_FOCUSNEVER);
  printf("#define TCS_FOCUSONBUTTONDOWN\t(%d)\n", TCS_FOCUSONBUTTONDOWN);
  printf("#define TCS_FORCEICONLEFT\t(%d)\n", TCS_FORCEICONLEFT);
  printf("#define TCS_FORCELABELLEFT\t(%d)\n", TCS_FORCELABELLEFT);
  printf("#define TCS_MULTILINE\t(%d)\n", TCS_MULTILINE);
  printf("#define TCS_OWNERDRAWFIXED\t(%d)\n", TCS_OWNERDRAWFIXED);
  printf("#define TCS_RAGGEDRIGHT\t(%d)\n", TCS_RAGGEDRIGHT);
  printf("#define TCS_RIGHTJUSTIFY\t(%d)\n", TCS_RIGHTJUSTIFY);
  printf("#define TCS_SINGLELINE\t(%d)\n", TCS_SINGLELINE);
  printf("#define TCS_TABS\t(%d)\n", TCS_TABS);
  printf("#define TCS_TOOLTIPS\t(%d)\n", TCS_TOOLTIPS);

  printf("\n/* TC_ITEM structure */\n");
  printf("#define TCIF_TEXT\t(%d)\n", TCIF_TEXT);
  printf("#define TCIF_IMAGE\t(%d)\n", TCIF_IMAGE);
  printf("#define TCIF_PARAM\t(%d)\n", TCIF_PARAM);
  printf("#define TCIF_RTLREADING\t(%d)\n", TCIF_RTLREADING);

  printf("\n/* TC_HITTESTINFO structure */\n");
  printf("#define TCHT_NOWHERE\t(%d)\n", TCHT_NOWHERE);
  printf("#define TCHT_ONITEM\t(%d)\n", TCHT_ONITEM);
  printf("#define TCHT_ONITEMICON\t(%d)\n", TCHT_ONITEMICON);
  printf("#define TCHT_ONITEMLABEL\t(%d)\n", TCHT_ONITEMLABEL);

  printf("\n/* Animation control styles */\n");
  printf("#define ACS_AUTOPLAY\t(%d)\n", ACS_AUTOPLAY);
  printf("#define ACS_CENTER\t(%d)\n", ACS_CENTER);
  printf("#define ACS_TRANSPARENT\t(%d)\n", ACS_TRANSPARENT);

  printf("\n/* MODEMDEVCAPS structure */\n");
  printf("#define DIALOPTION_BILLING\t(%d)\n", DIALOPTION_BILLING);
  printf("#define DIALOPTION_QUIET\t(%d)\n", DIALOPTION_QUIET);
  printf("#define DIALOPTION_DIALTONE\t(%d)\n", DIALOPTION_DIALTONE);
  printf("#define MDMVOLFLAG_LOW\t(%d)\n", MDMVOLFLAG_LOW);
  printf("#define MDMVOLFLAG_MEDIUM\t(%d)\n", MDMVOLFLAG_MEDIUM);
  printf("#define MDMVOLFLAG_HIGH\t(%d)\n", MDMVOLFLAG_HIGH);
  printf("#define MDMVOL_LOW\t(%d)\n", MDMVOL_LOW);
  printf("#define MDMVOL_MEDIUM\t(%d)\n", MDMVOL_MEDIUM);
  printf("#define MDMVOL_HIGH\t(%d)\n", MDMVOL_HIGH);
  printf("#define MDMSPKRFLAG_OFF\t(%d)\n", MDMSPKRFLAG_OFF);
  printf("#define MDMSPKRFLAG_DIAL\t(%d)\n", MDMSPKRFLAG_DIAL);
  printf("#define MDMSPKRFLAG_ON\t(%d)\n", MDMSPKRFLAG_ON);
  printf("#define MDMSPKRFLAG_CALLSETUP\t(%d)\n", MDMSPKRFLAG_CALLSETUP);
  printf("#define MDMSPKR_OFF\t(%d)\n", MDMSPKR_OFF);
  printf("#define MDMSPKR_DIAL\t(%d)\n", MDMSPKR_DIAL);
  printf("#define MDMSPKR_ON\t(%d)\n", MDMSPKR_ON);
  printf("#define MDMSPKR_CALLSETUP\t(%d)\n", MDMSPKR_CALLSETUP);
  printf("#define MDM_BLIND_DIAL\t(%d)\n", MDM_BLIND_DIAL);
  printf("#define MDM_CCITT_OVERRIDE\t(%d)\n", MDM_CCITT_OVERRIDE);
  printf("#define MDM_CELLULAR\t(%d)\n", MDM_CELLULAR);
  printf("#define MDM_COMPRESSION\t(%d)\n", MDM_COMPRESSION);
  printf("#define MDM_ERROR_CONTROL\t(%d)\n", MDM_ERROR_CONTROL);
  printf("#define MDM_FLOWCONTROL_HARD\t(%d)\n", MDM_FLOWCONTROL_HARD);
  printf("#define MDM_FLOWCONTROL_SOFT\t(%d)\n", MDM_FLOWCONTROL_SOFT);
  printf("#define MDM_FORCED_EC\t(%d)\n", MDM_FORCED_EC);
  printf("#define MDM_SPEED_ADJUST\t(%d)\n", MDM_SPEED_ADJUST);
  printf("#define MDM_TONE_DIAL\t(%d)\n", MDM_TONE_DIAL);
  printf("#define MDM_V23_OVERRIDE\t(%d)\n", MDM_V23_OVERRIDE);

  printf("\n/* Languages */\n");
  printf("#define LANG_BULGARIAN\t(%d)\n", LANG_BULGARIAN);
  printf("#define LANG_CHINESE\t(%d)\n", LANG_CHINESE);
  printf("#define LANG_CROATIAN\t(%d)\n", LANG_CROATIAN);
  printf("#define LANG_CZECH\t(%d)\n", LANG_CZECH);
  printf("#define LANG_DANISH\t(%d)\n", LANG_DANISH);
  printf("#define LANG_DUTCH\t(%d)\n", LANG_DUTCH);
  printf("#define LANG_ENGLISH\t(%d)\n", LANG_ENGLISH);
  printf("#define LANG_FINNISH\t(%d)\n", LANG_FINNISH);
  printf("#define LANG_FRENCH\t(%d)\n", LANG_FRENCH);
  printf("#define LANG_GERMAN\t(%d)\n", LANG_GERMAN);
  printf("#define LANG_GREEK\t(%d)\n", LANG_GREEK);
  printf("#define LANG_HUNGARIAN\t(%d)\n", LANG_HUNGARIAN);
  printf("#define LANG_ICELANDIC\t(%d)\n", LANG_ICELANDIC);
  printf("#define LANG_ITALIAN\t(%d)\n", LANG_ITALIAN);
  printf("#define LANG_JAPANESE\t(%d)\n", LANG_JAPANESE);
  printf("#define LANG_KOREAN\t(%d)\n", LANG_KOREAN);
  printf("#define LANG_NEUTRAL\t(%d)\n", LANG_NEUTRAL);
  printf("#define LANG_NORWEGIAN\t(%d)\n", LANG_NORWEGIAN);
  printf("#define LANG_POLISH\t(%d)\n", LANG_POLISH);
  printf("#define LANG_PORTUGUESE\t(%d)\n", LANG_PORTUGUESE);
  printf("#define LANG_ROMANIAN\t(%d)\n", LANG_ROMANIAN);
  printf("#define LANG_RUSSIAN\t(%d)\n", LANG_RUSSIAN);
  printf("#define LANG_SLOVAK\t(%d)\n", LANG_SLOVAK);
  printf("#define LANG_SLOVENIAN\t(%d)\n", LANG_SLOVENIAN);
  printf("#define LANG_SPANISH\t(%d)\n", LANG_SPANISH);
  printf("#define LANG_SWEDISH\t(%d)\n", LANG_SWEDISH);
  printf("#define LANG_TURKISH\t(%d)\n", LANG_TURKISH);
//  printf("#define LANG_AFRIKAANS\t(%d)\n", LANG_AFRIKAANS);
//  printf("#define LANG_ALBANIAN\t(%d)\n", LANG_ALBANIAN);
//  printf("#define LANG_ARABIC\t(%d)\n", LANG_ARABIC);
//  printf("#define LANG_BASQUE\t(%d)\n", LANG_BASQUE);
//  printf("#define LANG_BYELORUSSIAN\t(%d)\n", LANG_BYELORUSSIAN);
//  printf("#define LANG_CATALAN\t(%d)\n", LANG_CATALAN);
//  printf("#define LANG_ESTONIAN\t(%d)\n", LANG_ESTONIAN);
//  printf("#define LANG_HEBREW\t(%d)\n", LANG_HEBREW);
//  printf("#define LANG_INDONESIAN\t(%d)\n", LANG_INDONESIAN);
//  printf("#define LANG_LATVIAN\t(%d)\n", LANG_LATVIAN);
//  printf("#define LANG_LITHUANIAN\t(%d)\n", LANG_LITHUANIAN);
//  printf("#define LANG_SORBIAN\t(%d)\n", LANG_SORBIAN);
//  printf("#define LANG_THAI\t(%d)\n", LANG_THAI);
//  printf("#define LANG_UKRANIAN\t(%d)\n", LANG_UKRANIAN);

  printf("#define SUBLANG_CHINESE_SIMPLIFIED\t(%d)\n", SUBLANG_CHINESE_SIMPLIFIED);
  printf("#define SUBLANG_CHINESE_TRADITIONAL\t(%d)\n", SUBLANG_CHINESE_TRADITIONAL);
  printf("#define SUBLANG_CHINESE_HONGKONG\t(%d)\n", SUBLANG_CHINESE_HONGKONG);
  printf("#define SUBLANG_CHINESE_SINGAPORE\t(%d)\n", SUBLANG_CHINESE_SINGAPORE);
  printf("#define SUBLANG_DEFAULT\t(%d)\n", SUBLANG_DEFAULT);
  printf("#define SUBLANG_DUTCH\t(%d)\n", SUBLANG_DUTCH);
  printf("#define SUBLANG_DUTCH_BELGIAN\t(%d)\n", SUBLANG_DUTCH_BELGIAN);
  printf("#define SUBLANG_ENGLISH_AUS\t(%d)\n", SUBLANG_ENGLISH_AUS);
  printf("#define SUBLANG_ENGLISH_CAN\t(%d)\n", SUBLANG_ENGLISH_CAN);
  printf("#define SUBLANG_ENGLISH_EIRE\t(%d)\n", SUBLANG_ENGLISH_EIRE);
  printf("#define SUBLANG_ENGLISH_NZ\t(%d)\n", SUBLANG_ENGLISH_NZ);
  printf("#define SUBLANG_ENGLISH_UK\t(%d)\n", SUBLANG_ENGLISH_UK);
  printf("#define SUBLANG_ENGLISH_US\t(%d)\n", SUBLANG_ENGLISH_US);
  printf("#define SUBLANG_FRENCH\t(%d)\n", SUBLANG_FRENCH);
  printf("#define SUBLANG_FRENCH_BELGIAN\t(%d)\n", SUBLANG_FRENCH_BELGIAN);
  printf("#define SUBLANG_FRENCH_CANADIAN\t(%d)\n", SUBLANG_FRENCH_CANADIAN);
  printf("#define SUBLANG_FRENCH_SWISS\t(%d)\n", SUBLANG_FRENCH_SWISS);
  printf("#define SUBLANG_GERMAN\t(%d)\n", SUBLANG_GERMAN);
  printf("#define SUBLANG_GERMAN_AUSTRIAN\t(%d)\n", SUBLANG_GERMAN_AUSTRIAN);
  printf("#define SUBLANG_GERMAN_SWISS\t(%d)\n", SUBLANG_GERMAN_SWISS);
  printf("#define SUBLANG_ITALIAN\t(%d)\n", SUBLANG_ITALIAN);
  printf("#define SUBLANG_ITALIAN_SWISS\t(%d)\n", SUBLANG_ITALIAN_SWISS);
  printf("#define SUBLANG_NEUTRAL\t(%d)\n", SUBLANG_NEUTRAL);
  printf("#define SUBLANG_NORWEGIAN_BOKMAL\t(%d)\n", SUBLANG_NORWEGIAN_BOKMAL);
  printf("#define SUBLANG_NORWEGIAN_NYNORSK\t(%d)\n", SUBLANG_NORWEGIAN_NYNORSK);
  printf("#define SUBLANG_PORTUGUESE\t(%d)\n", SUBLANG_PORTUGUESE);
  printf("#define SUBLANG_PORTUGUESE_BRAZILIAN\t(%d)\n", SUBLANG_PORTUGUESE_BRAZILIAN);
  printf("#define SUBLANG_SPANISH\t(%d)\n", SUBLANG_SPANISH);
  printf("#define SUBLANG_SPANISH_MEXICAN\t(%d)\n", SUBLANG_SPANISH_MEXICAN);
  printf("#define SUBLANG_SPANISH_MODERN\t(%d)\n", SUBLANG_SPANISH_MODERN);
  printf("#define SUBLANG_SYS_DEFAULT\t(%d)\n", SUBLANG_SYS_DEFAULT);

  printf("#define NLS_VALID_LOCALE_MASK\t(%d)\n", NLS_VALID_LOCALE_MASK);
  printf("#define SORT_DEFAULT\t(%d)\n", SORT_DEFAULT);
  printf("#define SORT_JAPANESE_XJIS\t(%d)\n", SORT_JAPANESE_XJIS);
  printf("#define SORT_JAPANESE_UNICODE\t(%d)\n", SORT_JAPANESE_UNICODE);
  printf("#define SORT_CHINESE_BIG5\t(%d)\n", SORT_CHINESE_BIG5);
  printf("#define SORT_CHINESE_UNICODE\t(%d)\n", SORT_CHINESE_UNICODE);
  printf("#define SORT_KOREAN_KSC\t(%d)\n", SORT_KOREAN_KSC);
  printf("#define SORT_KOREAN_UNICODE\t(%d)\n", SORT_KOREAN_UNICODE);

  printf("\n/* SYSTEM_INFO structure */\n");
  printf("#define PROCESSOR_INTEL_386\t(%d)\n", PROCESSOR_INTEL_386);
  printf("#define PROCESSOR_INTEL_486\t(%d)\n", PROCESSOR_INTEL_486);
  printf("#define PROCESSOR_INTEL_PENTIUM\t(%d)\n", PROCESSOR_INTEL_PENTIUM);
  printf("#define PROCESSOR_MIPS_R4000\t(%d)\n", PROCESSOR_MIPS_R4000);
  printf("#define PROCESSOR_ALPHA_21064\t(%d)\n", PROCESSOR_ALPHA_21064);

  printf("\n/* FSCTL_SET_COMPRESSION */\n");
  printf("#define COMPRESSION_FORMAT_NONE\t(%d)\n", COMPRESSION_FORMAT_NONE);
  printf("#define COMPRESSION_FORMAT_DEFAULT\t(%d)\n", COMPRESSION_FORMAT_DEFAULT);
  printf("#define COMPRESSION_FORMAT_LZNT1\t(%d)\n", COMPRESSION_FORMAT_LZNT1);

  printf("\n/* TAPE_GET_DRIVE_PARAMETERS structure */\n");
  printf("#define TAPE_DRIVE_COMPRESSION\t(%d)\n", TAPE_DRIVE_COMPRESSION);
  printf("#define TAPE_DRIVE_ECC\t(%d)\n", TAPE_DRIVE_ECC);
  printf("#define TAPE_DRIVE_ERASE_BOP_ONLY\t(%d)\n", TAPE_DRIVE_ERASE_BOP_ONLY);
  printf("#define TAPE_DRIVE_ERASE_LONG\t(%d)\n", TAPE_DRIVE_ERASE_LONG);
  printf("#define TAPE_DRIVE_ERASE_IMMEDIATE\t(%d)\n", TAPE_DRIVE_ERASE_IMMEDIATE);
  printf("#define TAPE_DRIVE_ERASE_SHORT\t(%d)\n", TAPE_DRIVE_ERASE_SHORT);
  printf("#define TAPE_DRIVE_FIXED\t(%d)\n", TAPE_DRIVE_FIXED);
  printf("#define TAPE_DRIVE_FIXED_BLOCK\t(%d)\n", TAPE_DRIVE_FIXED_BLOCK);
  printf("#define TAPE_DRIVE_INITIATOR\t(%d)\n", TAPE_DRIVE_INITIATOR);
  printf("#define TAPE_DRIVE_PADDING\t(%d)\n", TAPE_DRIVE_PADDING);
  printf("#define TAPE_DRIVE_GET_ABSOLUTE_BLK\t(%d)\n", TAPE_DRIVE_GET_ABSOLUTE_BLK);
  printf("#define TAPE_DRIVE_GET_LOGICAL_BLK\t(%d)\n", TAPE_DRIVE_GET_LOGICAL_BLK);
  printf("#define TAPE_DRIVE_REPORT_SMKS\t(%d)\n", TAPE_DRIVE_REPORT_SMKS);
  printf("#define TAPE_DRIVE_SELECT\t(%d)\n", TAPE_DRIVE_SELECT);
  printf("#define TAPE_DRIVE_SET_EOT_WZ_SIZE\t(%d)\n", TAPE_DRIVE_SET_EOT_WZ_SIZE);
  printf("#define TAPE_DRIVE_TAPE_CAPACITY\t(%d)\n", TAPE_DRIVE_TAPE_CAPACITY);
  printf("#define TAPE_DRIVE_TAPE_REMAINING\t(%d)\n", TAPE_DRIVE_TAPE_REMAINING);
  printf("#define TAPE_DRIVE_VARIABLE_BLOCK\t(%d)\n", TAPE_DRIVE_VARIABLE_BLOCK);
  printf("#define TAPE_DRIVE_WRITE_PROTECT\t(%d)\n", TAPE_DRIVE_WRITE_PROTECT);
  printf("#define TAPE_DRIVE_ABS_BLK_IMMED\t(%d)\n", TAPE_DRIVE_ABS_BLK_IMMED);
  printf("#define TAPE_DRIVE_ABSOLUTE_BLK\t(%d)\n", TAPE_DRIVE_ABSOLUTE_BLK);
  printf("#define TAPE_DRIVE_END_OF_DATA\t(%d)\n", TAPE_DRIVE_END_OF_DATA);
  printf("#define TAPE_DRIVE_FILEMARKS\t(%d)\n", TAPE_DRIVE_FILEMARKS);
  printf("#define TAPE_DRIVE_LOAD_UNLOAD\t(%d)\n", TAPE_DRIVE_LOAD_UNLOAD);
  printf("#define TAPE_DRIVE_LOAD_UNLD_IMMED\t(%d)\n", TAPE_DRIVE_LOAD_UNLD_IMMED);
  printf("#define TAPE_DRIVE_LOCK_UNLOCK\t(%d)\n", TAPE_DRIVE_LOCK_UNLOCK);
  printf("#define TAPE_DRIVE_LOCK_UNLK_IMMED\t(%d)\n", TAPE_DRIVE_LOCK_UNLK_IMMED);
  printf("#define TAPE_DRIVE_LOG_BLK_IMMED\t(%d)\n", TAPE_DRIVE_LOG_BLK_IMMED);
  printf("#define TAPE_DRIVE_LOGICAL_BLK\t(%d)\n", TAPE_DRIVE_LOGICAL_BLK);
  printf("#define TAPE_DRIVE_RELATIVE_BLKS\t(%d)\n", TAPE_DRIVE_RELATIVE_BLKS);
  printf("#define TAPE_DRIVE_REVERSE_POSITION\t(%d)\n", TAPE_DRIVE_REVERSE_POSITION);
  printf("#define TAPE_DRIVE_REWIND_IMMEDIATE\t(%d)\n", TAPE_DRIVE_REWIND_IMMEDIATE);
  printf("#define TAPE_DRIVE_SEQUENTIAL_FMKS\t(%d)\n", TAPE_DRIVE_SEQUENTIAL_FMKS);
  printf("#define TAPE_DRIVE_SEQUENTIAL_SMKS\t(%d)\n", TAPE_DRIVE_SEQUENTIAL_SMKS);
  printf("#define TAPE_DRIVE_SET_BLOCK_SIZE\t(%d)\n", TAPE_DRIVE_SET_BLOCK_SIZE);
  printf("#define TAPE_DRIVE_SET_COMPRESSION\t(%d)\n", TAPE_DRIVE_SET_COMPRESSION);
  printf("#define TAPE_DRIVE_SET_ECC\t(%d)\n", TAPE_DRIVE_SET_ECC);
  printf("#define TAPE_DRIVE_SET_PADDING\t(%d)\n", TAPE_DRIVE_SET_PADDING);
  printf("#define TAPE_DRIVE_SET_REPORT_SMKS\t(%d)\n", TAPE_DRIVE_SET_REPORT_SMKS);
  printf("#define TAPE_DRIVE_SETMARKS\t(%d)\n", TAPE_DRIVE_SETMARKS);
  printf("#define TAPE_DRIVE_SPACE_IMMEDIATE\t(%d)\n", TAPE_DRIVE_SPACE_IMMEDIATE);
  printf("#define TAPE_DRIVE_TENSION\t(%d)\n", TAPE_DRIVE_TENSION);
  printf("#define TAPE_DRIVE_TENSION_IMMED\t(%d)\n", TAPE_DRIVE_TENSION_IMMED);
  printf("#define TAPE_DRIVE_WRITE_FILEMARKS\t(%d)\n", TAPE_DRIVE_WRITE_FILEMARKS);
  printf("#define TAPE_DRIVE_WRITE_LONG_FMKS\t(%d)\n", TAPE_DRIVE_WRITE_LONG_FMKS);
  printf("#define TAPE_DRIVE_WRITE_MARK_IMMED\t(%d)\n", TAPE_DRIVE_WRITE_MARK_IMMED);
  printf("#define TAPE_DRIVE_WRITE_SETMARKS\t(%d)\n", TAPE_DRIVE_WRITE_SETMARKS);
  printf("#define TAPE_DRIVE_WRITE_SHORT_FMKS\t(%d)\n", TAPE_DRIVE_WRITE_SHORT_FMKS);

  printf("\n/* Standard rights */\n");
  printf("#define STANDARD_RIGHTS_REQUIRED\t(%#lxL)\n", STANDARD_RIGHTS_REQUIRED);
  printf("#define STANDARD_RIGHTS_WRITE\t(%#lxL)\n", STANDARD_RIGHTS_WRITE);
  printf("#define STANDARD_RIGHTS_READ\t(%#lxL)\n", STANDARD_RIGHTS_READ);
  printf("#define STANDARD_RIGHTS_EXECUTE\t(%#lxL)\n", STANDARD_RIGHTS_EXECUTE);
  printf("#define STANDARD_RIGHTS_ALL\t(%#lxL)\n", STANDARD_RIGHTS_ALL);
  printf("#define SPECIFIC_RIGHTS_ALL\t(%#lxL)\n", SPECIFIC_RIGHTS_ALL);

  printf("\n/* ACCESS_MASK */\n");
  printf("#define MAXIMUM_ALLOWED\t(%#lxL)\n", MAXIMUM_ALLOWED);
  printf("#define GENERIC_ALL\t(%#lxL)\n", GENERIC_ALL);

  printf("\n/* SID */\n");
  printf("#define SECURITY_NULL_RID\t(%#lxL)\n", SECURITY_NULL_RID);
  printf("#define SECURITY_WORLD_RID\t(%#lxL)\n", SECURITY_WORLD_RID);
  printf("#define SECURITY_LOCAL_RID\t(%#lxL)\n", SECURITY_LOCAL_RID);
  printf("#define SECURITY_CREATOR_OWNER_RID\t(%#lxL)\n", SECURITY_CREATOR_OWNER_RID);
  printf("#define SECURITY_CREATOR_GROUP_RID\t(%#lxL)\n", SECURITY_CREATOR_GROUP_RID);
  printf("#define SECURITY_DIALUP_RID\t(%#lxL)\n", SECURITY_DIALUP_RID);
  printf("#define SECURITY_NETWORK_RID\t(%#lxL)\n", SECURITY_NETWORK_RID);
  printf("#define SECURITY_BATCH_RID\t(%#lxL)\n", SECURITY_BATCH_RID);
  printf("#define SECURITY_INTERACTIVE_RID\t(%#lxL)\n", SECURITY_INTERACTIVE_RID);
  printf("#define SECURITY_LOGON_IDS_RID\t(%#lxL)\n", SECURITY_LOGON_IDS_RID);
  printf("#define SECURITY_LOGON_IDS_RID_COUNT\t(%#lxL)\n", SECURITY_LOGON_IDS_RID_COUNT);
  printf("#define SECURITY_SERVICE_RID\t(%#lxL)\n", SECURITY_SERVICE_RID);
  printf("#define SECURITY_LOCAL_SYSTEM_RID\t(%#lxL)\n", SECURITY_LOCAL_SYSTEM_RID);
  printf("#define SECURITY_BUILTIN_DOMAIN_RID\t(%#lxL)\n", SECURITY_BUILTIN_DOMAIN_RID);
  printf("#define DOMAIN_USER_RID_ADMIN\t(%#lxL)\n", DOMAIN_USER_RID_ADMIN);
  printf("#define DOMAIN_USER_RID_GUEST\t(%#lxL)\n", DOMAIN_USER_RID_GUEST);
  printf("#define DOMAIN_GROUP_RID_ADMINS\t(%#lxL)\n", DOMAIN_GROUP_RID_ADMINS);
  printf("#define DOMAIN_GROUP_RID_USERS\t(%#lxL)\n", DOMAIN_GROUP_RID_USERS);
  printf("#define DOMAIN_ALIAS_RID_ADMINS\t(%#lxL)\n", DOMAIN_ALIAS_RID_ADMINS);
  printf("#define DOMAIN_ALIAS_RID_USERS\t(%#lxL)\n", DOMAIN_ALIAS_RID_USERS);
  printf("#define DOMAIN_ALIAS_RID_GUESTS\t(%#lxL)\n", DOMAIN_ALIAS_RID_GUESTS);
  printf("#define DOMAIN_ALIAS_RID_POWER_USERS\t(%#lxL)\n", DOMAIN_ALIAS_RID_POWER_USERS);
  printf("#define DOMAIN_ALIAS_RID_ACCOUNT_OPS\t(%#lxL)\n", DOMAIN_ALIAS_RID_ACCOUNT_OPS);
  printf("#define DOMAIN_ALIAS_RID_SYSTEM_OPS\t(%#lxL)\n", DOMAIN_ALIAS_RID_SYSTEM_OPS);
  printf("#define DOMAIN_ALIAS_RID_PRINT_OPS\t(%#lxL)\n", DOMAIN_ALIAS_RID_PRINT_OPS);
  printf("#define DOMAIN_ALIAS_RID_BACKUP_OPS\t(%#lxL)\n", DOMAIN_ALIAS_RID_BACKUP_OPS);
  printf("#define DOMAIN_ALIAS_RID_REPLICATOR\t(%#lxL)\n", DOMAIN_ALIAS_RID_REPLICATOR);

  printf("\n/* TOKEN_GROUPS structure */\n");
  printf("#define SE_GROUP_MANDATORY\t(%#lxL)\n", SE_GROUP_MANDATORY);
  printf("#define SE_GROUP_ENABLED_BY_DEFAULT\t(%#lxL)\n", SE_GROUP_ENABLED_BY_DEFAULT);
  printf("#define SE_GROUP_ENABLED\t(%#lxL)\n", SE_GROUP_ENABLED);
  printf("#define SE_GROUP_OWNER\t(%#lxL)\n", SE_GROUP_OWNER);
  printf("#define SE_GROUP_LOGON_ID\t(%#lxL)\n", SE_GROUP_LOGON_ID);

  printf("\n/* SECURITY_DESCRIPTOR_CONTROL */\n");
  printf("#define SECURITY_DESCRIPTOR_REVISION\t(%d)\n", SECURITY_DESCRIPTOR_REVISION);
  printf("#define SECURITY_DESCRIPTOR_MIN_LENGTH\t(%d)\n", SECURITY_DESCRIPTOR_MIN_LENGTH);
  printf("#define SE_OWNER_DEFAULTED\t(%d)\n", SE_OWNER_DEFAULTED);
  printf("#define SE_GROUP_DEFAULTED\t(%d)\n", SE_GROUP_DEFAULTED);
  printf("#define SE_DACL_PRESENT\t(%d)\n", SE_DACL_PRESENT);
  printf("#define SE_DACL_DEFAULTED\t(%d)\n", SE_DACL_DEFAULTED);
  printf("#define SE_SACL_PRESENT\t(%d)\n", SE_SACL_PRESENT);
  printf("#define SE_SACL_DEFAULTED\t(%d)\n", SE_SACL_DEFAULTED);
  printf("#define SE_SELF_RELATIVE\t(%d)\n", SE_SELF_RELATIVE);

  printf("\n/* PRIVILEGE_SET */\n");
  printf("#define SE_PRIVILEGE_ENABLED_BY_DEFAULT\t(%#lxL)\n", SE_PRIVILEGE_ENABLED_BY_DEFAULT);
  printf("#define SE_PRIVILEGE_ENABLED\t(%#lxL)\n", SE_PRIVILEGE_ENABLED);
  printf("#define SE_PRIVILEGE_USED_FOR_ACCESS\t(%#lxL)\n", SE_PRIVILEGE_USED_FOR_ACCESS);
  printf("#define PRIVILEGE_SET_ALL_NECESSARY\t(%#x)\n", PRIVILEGE_SET_ALL_NECESSARY);

  printf("\n/* OPENFILENAME structure */\n");
  printf("#define OFN_ALLOWMULTISELECT\t(%#x)\n", OFN_ALLOWMULTISELECT);
  printf("#define OFN_CREATEPROMPT\t(%#x)\n", OFN_CREATEPROMPT);
  printf("#define OFN_ENABLEHOOK\t(%#x)\n", OFN_ENABLEHOOK);
  printf("#define OFN_ENABLETEMPLATE\t(%#x)\n", OFN_ENABLETEMPLATE);
  printf("#define OFN_ENABLETEMPLATEHANDLE\t(%#x)\n", OFN_ENABLETEMPLATEHANDLE);
  printf("#define OFN_EXPLORER\t(%#x)\n", OFN_EXPLORER);
  printf("#define OFN_EXTENSIONDIFFERENT\t(%#x)\n", OFN_EXTENSIONDIFFERENT);
  printf("#define OFN_FILEMUSTEXIST\t(%#x)\n", OFN_FILEMUSTEXIST);
  printf("#define OFN_HIDEREADONLY\t(%#x)\n", OFN_HIDEREADONLY);
  printf("#define OFN_LONGNAMES\t(%#x)\n", OFN_LONGNAMES);
  printf("#define OFN_NOCHANGEDIR\t(%#x)\n", OFN_NOCHANGEDIR);
  printf("#define OFN_NODEREFERENCELINKS\t(%#x)\n", OFN_NODEREFERENCELINKS);
  printf("#define OFN_NOLONGNAMES\t(%#x)\n", OFN_NOLONGNAMES);
  printf("#define OFN_NONETWORKBUTTON\t(%#x)\n", OFN_NONETWORKBUTTON);
  printf("#define OFN_NOREADONLYRETURN\t(%#x)\n", OFN_NOREADONLYRETURN);
  printf("#define OFN_NOTESTFILECREATE\t(%#x)\n", OFN_NOTESTFILECREATE);
  printf("#define OFN_NOVALIDATE\t(%#x)\n", OFN_NOVALIDATE);
  printf("#define OFN_OVERWRITEPROMPT\t(%#x)\n", OFN_OVERWRITEPROMPT);
  printf("#define OFN_PATHMUSTEXIST\t(%#x)\n", OFN_PATHMUSTEXIST);
  printf("#define OFN_READONLY\t(%#x)\n", OFN_READONLY);
  printf("#define OFN_SHAREAWARE\t(%#x)\n", OFN_SHAREAWARE);
  printf("#define OFN_SHOWHELP\t(%#x)\n", OFN_SHOWHELP);

  printf("\n/* SHAREVISTRING message */\n");
  printf("#define OFN_SHAREFALLTHROUGH\t(%#x)\n", OFN_SHAREFALLTHROUGH);
  printf("#define OFN_SHARENOWARN\t(%#x)\n", OFN_SHARENOWARN);
  printf("#define OFN_SHAREWARN\t(%#x)\n", OFN_SHAREWARN);

  printf("\n/* Open/Save notifications */\n");
  printf("#define CDN_INITDONE\t(%#x)\n", CDN_INITDONE);
  printf("#define CDN_SELCHANGE\t(%#x)\n", CDN_SELCHANGE);
  printf("#define CDN_FOLDERCHANGE\t(%#x)\n", CDN_FOLDERCHANGE);
  printf("#define CDN_SHAREVIOLATION\t(%#x)\n", CDN_SHAREVIOLATION);
  printf("#define CDN_HELP\t(%#x)\n", CDN_HELP);
  printf("#define CDN_FILEOK\t(%#x)\n", CDN_FILEOK);
  printf("#define CDN_TYPECHANGE\t(%#x)\n", CDN_TYPECHANGE);

  printf("\n/* Open/Save messages */\n");
  printf("#define CDM_GETFILEPATH\t(%#x)\n", CDM_GETFILEPATH);
  printf("#define CDM_GETFOLDERIDLIST\t(%#x)\n", CDM_GETFOLDERIDLIST);
  printf("#define CDM_GETFOLDERPATH\t(%#x)\n", CDM_GETFOLDERPATH);
  printf("#define CDM_GETSPEC\t(%#x)\n", CDM_GETSPEC);
  printf("#define CDM_HIDECONTROL\t(%#x)\n", CDM_HIDECONTROL);
  printf("#define CDM_SETCONTROLTEXT\t(%#x)\n", CDM_SETCONTROLTEXT);
  printf("#define CDM_SETDEFEXT\t(%#x)\n", CDM_SETDEFEXT);

  printf("\n/* CHOOSECOLOR structure */\n");
  printf("#define CC_ENABLEHOOK\t(%#x)\n", CC_ENABLEHOOK);
  printf("#define CC_ENABLETEMPLATE\t(%#x)\n", CC_ENABLETEMPLATE);
  printf("#define CC_ENABLETEMPLATEHANDLE\t(%#x)\n", CC_ENABLETEMPLATEHANDLE);
  printf("#define CC_FULLOPEN\t(%#x)\n", CC_FULLOPEN);
  printf("#define CC_PREVENTFULLOPEN\t(%#x)\n", CC_PREVENTFULLOPEN);
  printf("#define CC_RGBINIT\t(%#x)\n", CC_RGBINIT);
  printf("#define CC_SHOWHELP\t(%#x)\n", CC_SHOWHELP);
  printf("#define CC_SOLIDCOLOR\t(%#x)\n", CC_SOLIDCOLOR);

  printf("\n/* FINDREPLACE structure */\n");
  printf("#define FR_DIALOGTERM\t(%#x)\n", FR_DIALOGTERM);
  printf("#define FR_DOWN\t(%#x)\n", FR_DOWN);
  printf("#define FR_ENABLEHOOK\t(%#x)\n", FR_ENABLEHOOK);
  printf("#define FR_ENABLETEMPLATE\t(%#x)\n", FR_ENABLETEMPLATE);
  printf("#define FR_ENABLETEMPLATEHANDLE\t(%#x)\n", FR_ENABLETEMPLATEHANDLE);
  printf("#define FR_FINDNEXT\t(%#x)\n", FR_FINDNEXT);
  printf("#define FR_HIDEUPDOWN\t(%#x)\n", FR_HIDEUPDOWN);
  printf("#define FR_HIDEMATCHCASE\t(%#x)\n", FR_HIDEMATCHCASE);
  printf("#define FR_HIDEWHOLEWORD\t(%#x)\n", FR_HIDEWHOLEWORD);
  printf("#define FR_MATCHCASE\t(%#x)\n", FR_MATCHCASE);
  printf("#define FR_NOMATCHCASE\t(%#x)\n", FR_NOMATCHCASE);
  printf("#define FR_NOUPDOWN\t(%#x)\n", FR_NOUPDOWN);
  printf("#define FR_NOWHOLEWORD\t(%#x)\n", FR_NOWHOLEWORD);
  printf("#define FR_REPLACE\t(%#x)\n", FR_REPLACE);
  printf("#define FR_REPLACEALL\t(%#x)\n", FR_REPLACEALL);
  printf("#define FR_SHOWHELP\t(%#x)\n", FR_SHOWHELP);
  printf("#define FR_WHOLEWORD\t(%#x)\n", FR_WHOLEWORD);

  printf("\n/* CHOOSEFONT structure */\n");
  printf("#define CF_APPLY\t(%#lxL)\n", CF_APPLY);
  printf("#define CF_ANSIONLY\t(%#lxL)\n", CF_ANSIONLY);
  printf("#define CF_BOTH\t(%#x)\n", CF_BOTH);
  printf("#define CF_TTONLY\t(%#lxL)\n", CF_TTONLY);
  printf("#define CF_EFFECTS\t(%#lxL)\n", CF_EFFECTS);
  printf("#define CF_ENABLEHOOK\t(%#lxL)\n", CF_ENABLEHOOK);
  printf("#define CF_ENABLETEMPLATE\t(%#lxL)\n", CF_ENABLETEMPLATE);
  printf("#define CF_ENABLETEMPLATEHANDLE\t(%#lxL)\n", CF_ENABLETEMPLATEHANDLE);
  printf("#define CF_FIXEDPITCHONLY\t(%#lxL)\n", CF_FIXEDPITCHONLY);
  printf("#define CF_FORCEFONTEXIST\t(%#lxL)\n", CF_FORCEFONTEXIST);
  printf("#define CF_INITTOLOGFONTSTRUCT\t(%#lxL)\n", CF_INITTOLOGFONTSTRUCT);
  printf("#define CF_LIMITSIZE\t(%#lxL)\n", CF_LIMITSIZE);
  printf("#define CF_NOOEMFONTS\t(%#lxL)\n", CF_NOOEMFONTS);
  printf("#define CF_NOFACESEL\t(%#lxL)\n", CF_NOFACESEL);
  printf("#define CF_NOSCRIPTSEL\t(%#lxL)\n", CF_NOSCRIPTSEL);
  printf("#define CF_NOSTYLESEL\t(%#lxL)\n", CF_NOSTYLESEL);
  printf("#define CF_NOSIZESEL\t(%#lxL)\n", CF_NOSIZESEL);
  printf("#define CF_NOSIMULATIONS\t(%#lxL)\n", CF_NOSIMULATIONS);
  printf("#define CF_NOVECTORFONTS\t(%#lxL)\n", CF_NOVECTORFONTS);
  printf("#define CF_NOVERTFONTS\t(%#lxL)\n", CF_NOVERTFONTS);
  printf("#define CF_PRINTERFONTS\t(%#x)\n", CF_PRINTERFONTS);
  printf("#define CF_SCALABLEONLY\t(%#lxL)\n", CF_SCALABLEONLY);
  printf("#define CF_SCREENFONTS\t(%#x)\n", CF_SCREENFONTS);
  printf("#define CF_SCRIPTSONLY\t(%#lxL)\n", CF_SCRIPTSONLY);
  printf("#define CF_SELECTSCRIPT\t(%#lxL)\n", CF_SELECTSCRIPT);
  printf("#define CF_SHOWHELP\t(%#lxL)\n", CF_SHOWHELP);
  printf("#define CF_USESTYLE\t(%#lxL)\n", CF_USESTYLE);
  printf("#define CF_WYSIWYG\t(%#lxL)\n", CF_WYSIWYG);
  printf("#define BOLD_FONTTYPE\t(%#x)\n", BOLD_FONTTYPE);
  printf("#define ITALIC_FONTTYPE\t(%#x)\n", ITALIC_FONTTYPE);
  printf("#define PRINTER_FONTTYPE\t(%#x)\n", PRINTER_FONTTYPE);
  printf("#define REGULAR_FONTTYPE\t(%#x)\n", REGULAR_FONTTYPE);
  printf("#define SCREEN_FONTTYPE\t(%#x)\n", SCREEN_FONTTYPE);
  printf("#define SIMULATED_FONTTYPE\t(%#x)\n", SIMULATED_FONTTYPE);

  printf("\n/* Common dialog messages */\n");
  printf("#define COLOROKSTRINGW\tL\"%s\"\n", COLOROKSTRINGA);
  printf("#define FILEOKSTRINGW\tL\"%s\"\n", FILEOKSTRINGA);
  printf("#define FINDMSGSTRINGW\tL\"%s\"\n", FINDMSGSTRINGA);
  printf("#define HELPMSGSTRINGW\tL\"%s\"\n", HELPMSGSTRINGA);
  printf("#define LBSELCHSTRINGW\tL\"%s\"\n", LBSELCHSTRINGA);
  printf("#define SETRGBSTRINGW\tL\"%s\"\n", SETRGBSTRINGA);
  printf("#define SHAREVISTRINGW\tL\"%s\"\n", SHAREVISTRINGA);

  printf("#define COLOROKSTRINGA\t\"%s\"\n", COLOROKSTRINGA);
  printf("#define FILEOKSTRINGA\t\"%s\"\n", FILEOKSTRINGA);
  printf("#define FINDMSGSTRINGA\t\"%s\"\n", FINDMSGSTRINGA);
  printf("#define HELPMSGSTRINGA\t\"%s\"\n", HELPMSGSTRINGA);
  printf("#define LBSELCHSTRINGA\t\"%s\"\n", LBSELCHSTRINGA);
  printf("#define SETRGBSTRINGA\t\"%s\"\n", SETRGBSTRINGA);
  printf("#define SHAREVISTRINGA\t\"%s\"\n", SHAREVISTRINGA);

  printf("#ifdef UNICODE\n");
  printf("#define COLOROKSTRING COLOROKSTRINGW\n");
  printf("#define FILEOKSTRING FILEOKSTRINGW\n");
  printf("#define FINDMSGSTRING FINDMSGSTRINGW\n");
  printf("#define HELPMSGSTRING HELPMSGSTRINGW\n");
  printf("#define LBSELCHSTRING LBSELCHSTRINGW\n");
  printf("#define SETRGBSTRING SETRGBSTRINGW\n");
  printf("#define SHAREVISTRING SHAREVISTRINGW\n");
  printf("#else\n");
  printf("#define COLOROKSTRING COLOROKSTRINGA\n");
  printf("#define FILEOKSTRING FILEOKSTRINGA\n");
  printf("#define FINDMSGSTRING FINDMSGSTRINGA\n");
  printf("#define HELPMSGSTRING HELPMSGSTRINGA\n");
  printf("#define LBSELCHSTRING LBSELCHSTRINGA\n");
  printf("#define SETRGBSTRING SETRGBSTRINGA\n");
  printf("#define SHAREVISTRING SHAREVISTRINGA\n");
  printf("#endif\n");

  printf("\n/* LBSELCHSTRING message */\n");
  printf("#define CD_LBSELCHANGE\t(%d)\n", CD_LBSELCHANGE);
  printf("#define CD_LBSELADD\t(%d)\n", CD_LBSELADD);
  printf("#define CD_LBSELSUB\t(%d)\n", CD_LBSELSUB);
  printf("#define CD_LBSELNOITEMS\t(%d)\n", CD_LBSELNOITEMS);

  printf("\n/* DEVNAMES structure */\n");
  printf("#define DN_DEFAULTPRN\t(%d)\n", DN_DEFAULTPRN);

  printf("\n/* PRINTDLG structure */\n");
  printf("#define PD_ALLPAGES\t(%d)\n", PD_ALLPAGES);
  printf("#define PD_COLLATE\t(%d)\n", PD_COLLATE);
  printf("#define PD_DISABLEPRINTTOFILE\t(%d)\n", PD_DISABLEPRINTTOFILE);
  printf("#define PD_ENABLEPRINTHOOK\t(%d)\n", PD_ENABLEPRINTHOOK);
  printf("#define PD_ENABLEPRINTTEMPLATE\t(%d)\n", PD_ENABLEPRINTTEMPLATE);
  printf("#define PD_ENABLEPRINTTEMPLATEHANDLE\t(%d)\n", PD_ENABLEPRINTTEMPLATEHANDLE);
  printf("#define PD_ENABLESETUPHOOK\t(%d)\n", PD_ENABLESETUPHOOK);
  printf("#define PD_ENABLESETUPTEMPLATE\t(%d)\n", PD_ENABLESETUPTEMPLATE);
  printf("#define PD_ENABLESETUPTEMPLATEHANDLE\t(%d)\n", PD_ENABLESETUPTEMPLATEHANDLE);
  printf("#define PD_HIDEPRINTTOFILE\t(%d)\n", PD_HIDEPRINTTOFILE);
  printf("#define PD_NOPAGENUMS\t(%d)\n", PD_NOPAGENUMS);
  printf("#define PD_NOSELECTION\t(%d)\n", PD_NOSELECTION);
  printf("#define PD_NOWARNING\t(%d)\n", PD_NOWARNING);
  printf("#define PD_PAGENUMS\t(%d)\n", PD_PAGENUMS);
  printf("#define PD_PRINTSETUP\t(%d)\n", PD_PRINTSETUP);
  printf("#define PD_PRINTTOFILE\t(%d)\n", PD_PRINTTOFILE);
  printf("#define PD_RETURNDC\t(%d)\n", PD_RETURNDC);
  printf("#define PD_RETURNDEFAULT\t(%d)\n", PD_RETURNDEFAULT);
  printf("#define PD_RETURNIC\t(%d)\n", PD_RETURNIC);
  printf("#define PD_SELECTION\t(%d)\n", PD_SELECTION);
  printf("#define PD_SHOWHELP\t(%d)\n", PD_SHOWHELP);
  printf("#define PD_USEDEVMODECOPIES\t(%d)\n", PD_USEDEVMODECOPIES);
  printf("#define PD_USEDEVMODECOPIESANDCOLLATE\t(%d)\n", PD_USEDEVMODECOPIESANDCOLLATE);

  printf("\n/* PAGESETUPDLG structure */\n");
  printf("#define PSD_DEFAULTMINMARGINS\t(%d)\n", PSD_DEFAULTMINMARGINS);
  printf("#define PSD_DISABLEMARGINS\t(%d)\n", PSD_DISABLEMARGINS);
  printf("#define PSD_DISABLEORIENTATION\t(%d)\n", PSD_DISABLEORIENTATION);
  printf("#define PSD_DISABLEPAGEPAINTING\t(%d)\n", PSD_DISABLEPAGEPAINTING);
  printf("#define PSD_DISABLEPAPER\t(%d)\n", PSD_DISABLEPAPER);
  printf("#define PSD_DISABLEPRINTER\t(%d)\n", PSD_DISABLEPRINTER);
  printf("#define PSD_ENABLEPAGEPAINTHOOK\t(%d)\n", PSD_ENABLEPAGEPAINTHOOK);
  printf("#define PSD_ENABLEPAGESETUPHOOK\t(%d)\n", PSD_ENABLEPAGESETUPHOOK);
  printf("#define PSD_ENABLEPAGESETUPTEMPLATE\t(%d)\n", PSD_ENABLEPAGESETUPTEMPLATE);
  printf("#define PSD_ENABLEPAGESETUPTEMPLATEHANDLE\t(%d)\n", PSD_ENABLEPAGESETUPTEMPLATEHANDLE);
  printf("#define PSD_INHUNDREDTHSOFMILLIMETERS\t(%d)\n", PSD_INHUNDREDTHSOFMILLIMETERS);
  printf("#define PSD_INTHOUSANDTHSOFINCHES\t(%d)\n", PSD_INTHOUSANDTHSOFINCHES);
  printf("#define PSD_INWININIINTLMEASURE\t(%d)\n", PSD_INWININIINTLMEASURE);
  printf("#define PSD_MARGINS\t(%d)\n", PSD_MARGINS);
  printf("#define PSD_MINMARGINS\t(%d)\n", PSD_MINMARGINS);
  printf("#define PSD_NOWARNING\t(%d)\n", PSD_NOWARNING);
  printf("#define PSD_RETURNDEFAULT\t(%d)\n", PSD_RETURNDEFAULT);
  printf("#define PSD_SHOWHELP\t(%d)\n", PSD_SHOWHELP);

  printf("\n/* WM_SHOWWINDOW message */\n");
  printf("#define SW_OTHERUNZOOM\t(%d)\n", SW_OTHERUNZOOM);
  printf("#define SW_OTHERZOOM\t(%d)\n", SW_OTHERZOOM);
  printf("#define SW_PARENTCLOSING\t(%d)\n", SW_PARENTCLOSING);
  printf("#define SW_PARENTOPENING\t(%d)\n", SW_PARENTOPENING);

  printf("\n/* Virtual Key codes */\n");
  printf("#define VK_LBUTTON\t(%d)\n", VK_LBUTTON);
  printf("#define VK_RBUTTON\t(%d)\n", VK_RBUTTON);
  printf("#define VK_CANCEL\t(%d)\n", VK_CANCEL);
  printf("#define VK_MBUTTON\t(%d)\n", VK_MBUTTON);
  printf("#define VK_BACK\t(%d)\n", VK_BACK);
  printf("#define VK_TAB\t(%d)\n", VK_TAB);
  printf("#define VK_CLEAR\t(%d)\n", VK_CLEAR);
  printf("#define VK_RETURN\t(%d)\n", VK_RETURN);
  printf("#define VK_SHIFT\t(%d)\n", VK_SHIFT);
  printf("#define VK_CONTROL\t(%d)\n", VK_CONTROL);
  printf("#define VK_MENU\t(%d)\n", VK_MENU);
  printf("#define VK_PAUSE\t(%d)\n", VK_PAUSE);
  printf("#define VK_CAPITAL\t(%d)\n", VK_CAPITAL);
  printf("#define VK_ESCAPE\t(%d)\n", VK_ESCAPE);
  printf("#define VK_SPACE\t(%d)\n", VK_SPACE);
  printf("#define VK_PRIOR\t(%d)\n", VK_PRIOR);
  printf("#define VK_NEXT\t(%d)\n", VK_NEXT);
  printf("#define VK_END\t(%d)\n", VK_END);
  printf("#define VK_HOME\t(%d)\n", VK_HOME);
  printf("#define VK_LEFT\t(%d)\n", VK_LEFT);
  printf("#define VK_UP\t(%d)\n", VK_UP);
  printf("#define VK_RIGHT\t(%d)\n", VK_RIGHT);
  printf("#define VK_DOWN\t(%d)\n", VK_DOWN);
  printf("#define VK_SELECT\t(%d)\n", VK_SELECT);
  printf("#define VK_EXECUTE\t(%d)\n", VK_EXECUTE);
  printf("#define VK_SNAPSHOT\t(%d)\n", VK_SNAPSHOT);
  printf("#define VK_INSERT\t(%d)\n", VK_INSERT);
  printf("#define VK_DELETE\t(%d)\n", VK_DELETE);
  printf("#define VK_HELP\t(%d)\n", VK_HELP);
  printf("#define VK_0\t(%d)\n", '0');
  printf("#define VK_1\t(%d)\n", '1');
  printf("#define VK_2\t(%d)\n", '2');
  printf("#define VK_3\t(%d)\n", '3');
  printf("#define VK_4\t(%d)\n", '4');
  printf("#define VK_5\t(%d)\n", '5');
  printf("#define VK_6\t(%d)\n", '6');
  printf("#define VK_7\t(%d)\n", '7');
  printf("#define VK_8\t(%d)\n", '8');
  printf("#define VK_9\t(%d)\n", '9');
  printf("#define VK_A\t(%d)\n", 'A');
  printf("#define VK_B\t(%d)\n", 'B');
  printf("#define VK_C\t(%d)\n", 'C');
  printf("#define VK_D\t(%d)\n", 'D');
  printf("#define VK_E\t(%d)\n", 'E');
  printf("#define VK_F\t(%d)\n", 'F');
  printf("#define VK_G\t(%d)\n", 'G');
  printf("#define VK_H\t(%d)\n", 'H');
  printf("#define VK_I\t(%d)\n", 'I');
  printf("#define VK_J\t(%d)\n", 'J');
  printf("#define VK_K\t(%d)\n", 'K');
  printf("#define VK_L\t(%d)\n", 'L');
  printf("#define VK_M\t(%d)\n", 'M');
  printf("#define VK_N\t(%d)\n", 'N');
  printf("#define VK_O\t(%d)\n", 'O');
  printf("#define VK_P\t(%d)\n", 'P');
  printf("#define VK_Q\t(%d)\n", 'Q');
  printf("#define VK_R\t(%d)\n", 'R');
  printf("#define VK_S\t(%d)\n", 'S');
  printf("#define VK_T\t(%d)\n", 'T');
  printf("#define VK_U\t(%d)\n", 'U');
  printf("#define VK_V\t(%d)\n", 'V');
  printf("#define VK_W\t(%d)\n", 'W');
  printf("#define VK_X\t(%d)\n", 'X');
  printf("#define VK_Y\t(%d)\n", 'Y');
  printf("#define VK_Z\t(%d)\n", 'Z');
  printf("#define VK_NUMPAD0\t(%d)\n", VK_NUMPAD0);
  printf("#define VK_NUMPAD1\t(%d)\n", VK_NUMPAD1);
  printf("#define VK_NUMPAD2\t(%d)\n", VK_NUMPAD2);
  printf("#define VK_NUMPAD3\t(%d)\n", VK_NUMPAD3);
  printf("#define VK_NUMPAD4\t(%d)\n", VK_NUMPAD4);
  printf("#define VK_NUMPAD5\t(%d)\n", VK_NUMPAD5);
  printf("#define VK_NUMPAD6\t(%d)\n", VK_NUMPAD6);
  printf("#define VK_NUMPAD7\t(%d)\n", VK_NUMPAD7);
  printf("#define VK_NUMPAD8\t(%d)\n", VK_NUMPAD8);
  printf("#define VK_NUMPAD9\t(%d)\n", VK_NUMPAD9);
  printf("#define VK_MULTIPLY\t(%d)\n", VK_MULTIPLY);
  printf("#define VK_ADD\t(%d)\n", VK_ADD);
  printf("#define VK_SEPARATOR\t(%d)\n", VK_SEPARATOR);
  printf("#define VK_SUBTRACT\t(%d)\n", VK_SUBTRACT);
  printf("#define VK_DECIMAL\t(%d)\n", VK_DECIMAL);
  printf("#define VK_DIVIDE\t(%d)\n", VK_DIVIDE);
  printf("#define VK_F1\t(%d)\n", VK_F1);
  printf("#define VK_F2\t(%d)\n", VK_F2);
  printf("#define VK_F3\t(%d)\n", VK_F3);
  printf("#define VK_F4\t(%d)\n", VK_F4);
  printf("#define VK_F5\t(%d)\n", VK_F5);
  printf("#define VK_F6\t(%d)\n", VK_F6);
  printf("#define VK_F7\t(%d)\n", VK_F7);
  printf("#define VK_F8\t(%d)\n", VK_F8);
  printf("#define VK_F9\t(%d)\n", VK_F9);
  printf("#define VK_F10\t(%d)\n", VK_F10);
  printf("#define VK_F11\t(%d)\n", VK_F11);
  printf("#define VK_F12\t(%d)\n", VK_F12);
  printf("#define VK_F13\t(%d)\n", VK_F13);
  printf("#define VK_F14\t(%d)\n", VK_F14);
  printf("#define VK_F15\t(%d)\n", VK_F15);
  printf("#define VK_F16\t(%d)\n", VK_F16);
  printf("#define VK_F17\t(%d)\n", VK_F17);
  printf("#define VK_F18\t(%d)\n", VK_F18);
  printf("#define VK_F19\t(%d)\n", VK_F19);
  printf("#define VK_F20\t(%d)\n", VK_F20);
  printf("#define VK_F21\t(%d)\n", VK_F21);
  printf("#define VK_F22\t(%d)\n", VK_F22);
  printf("#define VK_F23\t(%d)\n", VK_F23);
  printf("#define VK_F24\t(%d)\n", VK_F24);

  printf("\n/* GetAsyncKeyState */\n");
  printf("#define VK_NUMLOCK\t(%d)\n", VK_NUMLOCK);
  printf("#define VK_SCROLL\t(%d)\n", VK_SCROLL);
  printf("#define VK_LSHIFT\t(%d)\n", VK_LSHIFT);
  printf("#define VK_LCONTROL\t(%d)\n", VK_LCONTROL);
  printf("#define VK_LMENU\t(%d)\n", VK_LMENU);
  printf("#define VK_RSHIFT\t(%d)\n", VK_RSHIFT);
  printf("#define VK_RCONTROL\t(%d)\n", VK_RCONTROL);
  printf("#define VK_RMENU\t(%d)\n", VK_RMENU);

  printf("\n/* ImmGetVirtualKey */\n");
  printf("#define VK_PROCESSKEY\t(%d)\n", VK_PROCESSKEY);

  printf("\n/* Keystroke Message Flags */\n");
  printf("#define KF_ALTDOWN\t(%d)\n", KF_ALTDOWN);
  printf("#define KF_DLGMODE\t(%d)\n", KF_DLGMODE);
  printf("#define KF_EXTENDED\t(%d)\n", KF_EXTENDED);
  printf("#define KF_MENUMODE\t(%d)\n", KF_MENUMODE);
  printf("#define KF_REPEAT\t(%d)\n", KF_REPEAT);
  printf("#define KF_UP\t(%d)\n", KF_UP);

  printf("\n/* GetKeyboardLayoutName */\n");
  printf("#define KL_NAMELENGTH\t(%d)\n", KL_NAMELENGTH);

  printf("\n/* WM_ACTIVATE message */\n");
  printf("#define WA_ACTIVE\t(%d)\n", WA_ACTIVE);
  printf("#define WA_CLICKACTIVE\t(%d)\n", WA_CLICKACTIVE);
  printf("#define WA_INACTIVE\t(%d)\n", WA_INACTIVE);

  printf("\n/* WM_ACTIVATE message */\n");
  printf("#define PWR_CRITICALRESUME\t(%d)\n", PWR_CRITICALRESUME);
  printf("#define PWR_SUSPENDREQUEST\t(%d)\n", PWR_SUSPENDREQUEST);
  printf("#define PWR_SUSPENDRESUME\t(%d)\n", PWR_SUSPENDRESUME);
  printf("#define PWR_FAIL\t(%d)\n", PWR_FAIL);
  printf("#define PWR_OK\t(%d)\n", PWR_OK);

  printf("\n/* WM_NOTIFYFORMAT message */\n");
  printf("#define NF_QUERY\t(%d)\n", NF_QUERY);
  printf("#define NF_REQUERY\t(%d)\n", NF_REQUERY);
  printf("#define NFR_ANSI\t(%d)\n", NFR_ANSI);
  printf("#define NFR_UNICODE\t(%d)\n", NFR_UNICODE);

  printf("\n/* WM_SIZING message */\n");
  printf("#define WMSZ_BOTTOM\t(%d)\n", WMSZ_BOTTOM);
  printf("#define WMSZ_BOTTOMLEFT\t(%d)\n", WMSZ_BOTTOMLEFT);
  printf("#define WMSZ_BOTTOMRIGHT\t(%d)\n", WMSZ_BOTTOMRIGHT);
  printf("#define WMSZ_LEFT\t(%d)\n", WMSZ_LEFT);
  printf("#define WMSZ_RIGHT\t(%d)\n", WMSZ_RIGHT);
  printf("#define WMSZ_TOP\t(%d)\n", WMSZ_TOP);
  printf("#define WMSZ_TOPLEFT\t(%d)\n", WMSZ_TOPLEFT);
  printf("#define WMSZ_TOPRIGHT\t(%d)\n", WMSZ_TOPRIGHT);

  printf("\n/* WM_MOUSEACTIVATE message */\n");
  printf("#define MA_ACTIVATE\t(%d)\n", MA_ACTIVATE);
  printf("#define MA_ACTIVATEANDEAT\t(%d)\n", MA_ACTIVATEANDEAT);
  printf("#define MA_NOACTIVATE\t(%d)\n", MA_NOACTIVATE);
  printf("#define MA_NOACTIVATEANDEAT\t(%d)\n", MA_NOACTIVATEANDEAT);

  printf("\n/* WM_SIZE message */\n");
  printf("#define SIZE_MAXHIDE\t(%d)\n", SIZE_MAXHIDE);
  printf("#define SIZE_MAXIMIZED\t(%d)\n", SIZE_MAXIMIZED);
  printf("#define SIZE_MAXSHOW\t(%d)\n", SIZE_MAXSHOW);
  printf("#define SIZE_MINIMIZED\t(%d)\n", SIZE_MINIMIZED);
  printf("#define SIZE_RESTORED\t(%d)\n", SIZE_RESTORED);

  printf("\n/* WM_NCCALCSIZE message */\n");
  printf("#define WVR_ALIGNTOP\t(%d)\n", WVR_ALIGNTOP);
  printf("#define WVR_ALIGNLEFT\t(%d)\n", WVR_ALIGNLEFT);
  printf("#define WVR_ALIGNBOTTOM\t(%d)\n", WVR_ALIGNBOTTOM);
  printf("#define WVR_ALIGNRIGHT\t(%d)\n", WVR_ALIGNRIGHT);
  printf("#define WVR_HREDRAW\t(%d)\n", WVR_HREDRAW);
  printf("#define WVR_VREDRAW\t(%d)\n", WVR_VREDRAW);
  printf("#define WVR_REDRAW\t(%d)\n", WVR_REDRAW);
  printf("#define WVR_VALIDRECTS\t(%d)\n", WVR_VALIDRECTS);

  printf("\n/* WM_NCHITTEST message */\n");
//  printf("#define HTORDER\t(%d)\n", HTORDER);
  printf("#define HTBOTTOM\t(%d)\n", HTBOTTOM);
  printf("#define HTBOTTOMLEFT\t(%d)\n", HTBOTTOMLEFT);
  printf("#define HTBOTTOMRIGHT\t(%d)\n", HTBOTTOMRIGHT);
  printf("#define HTCAPTION\t(%d)\n", HTCAPTION);
  printf("#define HTCLIENT\t(%d)\n", HTCLIENT);
  printf("#define HTERROR\t(%d)\n", HTERROR);
  printf("#define HTGROWBOX\t(%d)\n", HTGROWBOX);
  printf("#define HTHSCROLL\t(%d)\n", HTHSCROLL);
  printf("#define HTLEFT\t(%d)\n", HTLEFT);
  printf("#define HTMENU\t(%d)\n", HTMENU);
  printf("#define HTNOWHERE\t(%d)\n", HTNOWHERE);
  printf("#define HTREDUCE\t(%d)\n", HTREDUCE);
  printf("#define HTRIGHT\t(%d)\n", HTRIGHT);
  printf("#define HTSIZE\t(%d)\n", HTSIZE);
  printf("#define HTSYSMENU\t(%d)\n", HTSYSMENU);
  printf("#define HTTOP\t(%d)\n", HTTOP);
  printf("#define HTTOPLEFT\t(%d)\n", HTTOPLEFT);
  printf("#define HTTOPRIGHT\t(%d)\n", HTTOPRIGHT);
  printf("#define HTTRANSPARENT\t(%d)\n", HTTRANSPARENT);
  printf("#define HTVSCROLL\t(%d)\n", HTVSCROLL);
  printf("#define HTZOOM\t(%d)\n", HTZOOM);

  printf("\n/* Mouse messages */\n");
  printf("#define MK_CONTROL\t(%d)\n", MK_CONTROL);
  printf("#define MK_LBUTTON\t(%d)\n", MK_LBUTTON);
  printf("#define MK_MBUTTON\t(%d)\n", MK_MBUTTON);
  printf("#define MK_RBUTTON\t(%d)\n", MK_RBUTTON);
  printf("#define MK_SHIFT\t(%d)\n", MK_SHIFT);

  printf("\n/* WNDCLASS structure */\n");
  printf("#define CS_BYTEALIGNCLIENT\t(%d)\n", CS_BYTEALIGNCLIENT);
  printf("#define CS_BYTEALIGNWINDOW\t(%d)\n", CS_BYTEALIGNWINDOW);
  printf("#define CS_CLASSDC\t(%d)\n", CS_CLASSDC);
  printf("#define CS_DBLCLKS\t(%d)\n", CS_DBLCLKS);
  printf("#define CS_GLOBALCLASS\t(%d)\n", CS_GLOBALCLASS);
  printf("#define CS_HREDRAW\t(%d)\n", CS_HREDRAW);
  printf("#define CS_NOCLOSE\t(%d)\n", CS_NOCLOSE);
  printf("#define CS_OWNDC\t(%d)\n", CS_OWNDC);
  printf("#define CS_PARENTDC\t(%d)\n", CS_PARENTDC);
  printf("#define CS_SAVEBITS\t(%d)\n", CS_SAVEBITS);
  printf("#define CS_VREDRAW\t(%d)\n", CS_VREDRAW);
  printf("#define DLGWINDOWEXTRA\t(%d)\n", DLGWINDOWEXTRA);

  printf("\n/* ACCEL structure */\n");
  printf("#define FALT\t(%d)\n", FALT);
  printf("#define FCONTROL\t(%d)\n", FCONTROL);
  printf("#define FNOINVERT\t(%d)\n", FNOINVERT);
  printf("#define FSHIFT\t(%d)\n", FSHIFT);
  printf("#define FVIRTKEY\t(%d)\n", FVIRTKEY);

  printf("\n/* MENUITEMINFO structure */\n");
  printf("#define MIIM_CHECKMARKS\t(%d)\n", MIIM_CHECKMARKS);
  printf("#define MIIM_DATA\t(%d)\n", MIIM_DATA);
  printf("#define MIIM_ID\t(%d)\n", MIIM_ID);
  printf("#define MIIM_STATE\t(%d)\n", MIIM_STATE);
  printf("#define MIIM_SUBMENU\t(%d)\n", MIIM_SUBMENU);
  printf("#define MIIM_TYPE\t(%d)\n", MIIM_TYPE);
  printf("#define MFT_BITMAP\t(%#lxL)\n", MFT_BITMAP);
  printf("#define MFT_MENUBARBREAK\t(%#lxL)\n", MFT_MENUBARBREAK);
  printf("#define MFT_MENUBREAK\t(%#lxL)\n", MFT_MENUBREAK);
  printf("#define MFT_OWNERDRAW\t(%#lxL)\n", MFT_OWNERDRAW);
  printf("#define MFT_RADIOCHECK\t(%#lxL)\n", MFT_RADIOCHECK);
  printf("#define MFT_RIGHTJUSTIFY\t(%#lxL)\n", MFT_RIGHTJUSTIFY);
  printf("#define MFT_SEPARATOR\t(%#lxL)\n", MFT_SEPARATOR);
  printf("#define MFT_STRING\t(%#lxL)\n", MFT_STRING);
  printf("#define MFS_CHECKED\t(%#lxL)\n", MFS_CHECKED);
  printf("#define MFS_DEFAULT\t(%#lxL)\n", MFS_DEFAULT);
  printf("#define MFS_DISABLED\t(%#lxL)\n", MFS_DISABLED);
  printf("#define MFS_ENABLED\t(%#lxL)\n", MFS_ENABLED);
  printf("#define MFS_GRAYED\t(%#lxL)\n", MFS_GRAYED);
  printf("#define MFS_HILITE\t(%#lxL)\n", MFS_HILITE);
  printf("#define MFS_UNCHECKED\t(%#lxL)\n", MFS_UNCHECKED);
  printf("#define MFS_UNHILITE\t(%#lxL)\n", MFS_UNHILITE);

  printf("\n/* SERIALKEYS structure */\n");
  printf("#define SERKF_AVAILABLE\t(%d)\n", SERKF_AVAILABLE);
  printf("#define SERKF_INDICATOR\t(%d)\n", SERKF_INDICATOR);
  printf("#define SERKF_SERIALKEYSON\t(%d)\n", SERKF_SERIALKEYSON);

  printf("\n/* FILTERKEYS structure */\n");
  printf("#define FKF_AVAILABLE\t(%d)\n", FKF_AVAILABLE);
  printf("#define FKF_CLICKON\t(%d)\n", FKF_CLICKON);
  printf("#define FKF_FILTERKEYSON\t(%d)\n", FKF_FILTERKEYSON);
  printf("#define FKF_HOTKEYACTIVE\t(%d)\n", FKF_HOTKEYACTIVE);
  printf("#define FKF_HOTKEYSOUND\t(%d)\n", FKF_HOTKEYSOUND);
  printf("#define FKF_CONFIRMHOTKEY\t(%d)\n", FKF_CONFIRMHOTKEY);
  printf("#define FKF_INDICATOR\t(%d)\n", FKF_INDICATOR);

  printf("\n/* HELPINFO structure */\n");
  printf("#define HELPINFO_MENUITEM\t(%d)\n", HELPINFO_MENUITEM);
  printf("#define HELPINFO_WINDOW\t(%d)\n", HELPINFO_WINDOW);

  printf("\n/* WM_PRINT message */\n");
  printf("#define PRF_CHECKVISIBLE\t(%#lxL)\n", PRF_CHECKVISIBLE);
  printf("#define PRF_CHILDREN\t(%#lxL)\n", PRF_CHILDREN);
  printf("#define PRF_CLIENT\t(%#lxL)\n", PRF_CLIENT);
  printf("#define PRF_ERASEBKGND\t(%#lxL)\n", PRF_ERASEBKGND);
  printf("#define PRF_NONCLIENT\t(%#lxL)\n", PRF_NONCLIENT);
  printf("#define PRF_OWNED\t(%#lxL)\n", PRF_OWNED);

  printf("\n/* MapWindowPoints */\n");
  printf("#define HWND_DESKTOP\t((HWND)0)\n");

  printf("\n/* WM_SYSCOMMAND message */\n");
  printf("#define SC_CLOSE\t(%d)\n", SC_CLOSE);
  printf("#define SC_CONTEXTHELP\t(%d)\n", SC_CONTEXTHELP);
  printf("#define SC_DEFAULT\t(%d)\n", SC_DEFAULT);
  printf("#define SC_HOTKEY\t(%d)\n", SC_HOTKEY);
  printf("#define SC_HSCROLL\t(%d)\n", SC_HSCROLL);
  printf("#define SC_KEYMENU\t(%d)\n", SC_KEYMENU);
  printf("#define SC_MAXIMIZE\t(%d)\n", SC_MAXIMIZE);
  printf("#define SC_ZOOM\t(%d)\n", SC_ZOOM);
  printf("#define SC_MINIMIZE\t(%d)\n", SC_MINIMIZE);
  printf("#define SC_ICON\t(%d)\n", SC_ICON);
  printf("#define SC_MONITORPOWER\t(%d)\n", SC_MONITORPOWER);
  printf("#define SC_MOUSEMENU\t(%d)\n", SC_MOUSEMENU);
  printf("#define SC_MOVE\t(%d)\n", SC_MOVE);
  printf("#define SC_NEXTWINDOW\t(%d)\n", SC_NEXTWINDOW);
  printf("#define SC_PREVWINDOW\t(%d)\n", SC_PREVWINDOW);
  printf("#define SC_RESTORE\t(%d)\n", SC_RESTORE);
  printf("#define SC_SCREENSAVE\t(%d)\n", SC_SCREENSAVE);
  printf("#define SC_SIZE\t(%d)\n", SC_SIZE);
  printf("#define SC_TASKLIST\t(%d)\n", SC_TASKLIST);
  printf("#define SC_VSCROLL\t(%d)\n", SC_VSCROLL);

  printf("\n/* DM_GETDEFID message */\n");
  printf("#define DC_HASDEFID\t(%d)\n", DC_HASDEFID);

  printf("\n/* WM_GETDLGCODE message */\n");
  printf("#define DLGC_BUTTON\t(%d)\n", DLGC_BUTTON);
  printf("#define DLGC_DEFPUSHBUTTON\t(%d)\n", DLGC_DEFPUSHBUTTON);
  printf("#define DLGC_HASSETSEL\t(%d)\n", DLGC_HASSETSEL);
  printf("#define DLGC_RADIOBUTTON\t(%d)\n", DLGC_RADIOBUTTON);
  printf("#define DLGC_STATIC\t(%d)\n", DLGC_STATIC);
  printf("#define DLGC_UNDEFPUSHBUTTON\t(%d)\n", DLGC_UNDEFPUSHBUTTON);
  printf("#define DLGC_WANTALLKEYS\t(%d)\n", DLGC_WANTALLKEYS);
  printf("#define DLGC_WANTARROWS\t(%d)\n", DLGC_WANTARROWS);
  printf("#define DLGC_WANTCHARS\t(%d)\n", DLGC_WANTCHARS);
  printf("#define DLGC_WANTMESSAGE\t(%d)\n", DLGC_WANTMESSAGE);
  printf("#define DLGC_WANTTAB\t(%d)\n", DLGC_WANTTAB);

  printf("\n/* EM_SETMARGINS message */\n");
  printf("#define EC_LEFTMARGIN\t(%d)\n", EC_LEFTMARGIN);
  printf("#define EC_RIGHTMARGIN\t(%d)\n", EC_RIGHTMARGIN);
  printf("#define EC_USEFONTINFO\t(%d)\n", EC_USEFONTINFO);

  printf("\n/* LB_SETCOUNT message */\n");
  printf("#define LB_ERR\t(%d)\n", LB_ERR);
  printf("#define LB_ERRSPACE\t(%d)\n", LB_ERRSPACE);

  printf("\n/* CB_DIR message */\n");
//  printf("#define CB_OK\t(%d)\n", CB_OK);
  printf("#define CB_ERR\t(%d)\n", CB_ERR);
  printf("#define CB_ERRSPACE\t(%d)\n", CB_ERRSPACE);

  printf("\n/* WM_IME_CONTROL message */\n");
  printf("#define IMC_GETCANDIDATEPOS\t(%d)\n", IMC_GETCANDIDATEPOS);
  printf("#define IMC_GETCOMPOSITIONFONT\t(%d)\n", IMC_GETCOMPOSITIONFONT);
  printf("#define IMC_GETCOMPOSITIONWINDOW\t(%d)\n", IMC_GETCOMPOSITIONWINDOW);
//  printf("#define IMC_GETCONVERSIONMODE\t(%d)\n", IMC_GETCONVERSIONMODE);
//  printf("#define IMC_GETOPENSTATUS\t(%d)\n", IMC_GETOPENSTATUS);
//  printf("#define IMC_GETSENTENCEMODE\t(%d)\n", IMC_GETSENTENCEMODE);
  printf("#define IMC_GETSTATUSWINDOWPOS\t(%d)\n", IMC_GETSTATUSWINDOWPOS);
  printf("#define IMC_CLOSESTATUSWINDOW\t(%d)\n", IMC_CLOSESTATUSWINDOW);
  printf("#define IMC_OPENSTATUSWINDOW\t(%d)\n", IMC_OPENSTATUSWINDOW);
  printf("#define IMC_SETCANDIDATEPOS\t(%d)\n", IMC_SETCANDIDATEPOS);
  printf("#define IMC_SETCOMPOSITIONFONT\t(%d)\n", IMC_SETCOMPOSITIONFONT);
  printf("#define IMC_SETCOMPOSITIONWINDOW\t(%d)\n", IMC_SETCOMPOSITIONWINDOW);
//  printf("#define IMC_SETCONVERSIONMODE\t(%d)\n", IMC_SETCONVERSIONMODE);
//  printf("#define IMC_SETOPENSTATUS\t(%d)\n", IMC_SETOPENSTATUS);
//  printf("#define IMC_SETSENTENCEMODE\t(%d)\n", IMC_SETSENTENCEMODE);
  printf("#define IMC_SETSTATUSWINDOWPOS\t(%d)\n", IMC_SETSTATUSWINDOWPOS);

  printf("\n/* WM_IME_CONTROL message */\n");
  printf("#define IMN_CHANGECANDIDATE\t(%d)\n", IMN_CHANGECANDIDATE);
  printf("#define IMN_CLOSECANDIDATE\t(%d)\n", IMN_CLOSECANDIDATE);
  printf("#define IMN_CLOSESTATUSWINDOW\t(%d)\n", IMN_CLOSESTATUSWINDOW);
  printf("#define IMN_GUIDELINE\t(%d)\n", IMN_GUIDELINE);
  printf("#define IMN_OPENCANDIDATE\t(%d)\n", IMN_OPENCANDIDATE);
  printf("#define IMN_OPENSTATUSWINDOW\t(%d)\n", IMN_OPENSTATUSWINDOW);
  printf("#define IMN_SETCANDIDATEPOS\t(%d)\n", IMN_SETCANDIDATEPOS);
  printf("#define IMN_SETCOMPOSITIONFONT\t(%d)\n", IMN_SETCOMPOSITIONFONT);
  printf("#define IMN_SETCOMPOSITIONWINDOW\t(%d)\n", IMN_SETCOMPOSITIONWINDOW);
  printf("#define IMN_SETCONVERSIONMODE\t(%d)\n", IMN_SETCONVERSIONMODE);
  printf("#define IMN_SETOPENSTATUS\t(%d)\n", IMN_SETOPENSTATUS);
  printf("#define IMN_SETSENTENCEMODE\t(%d)\n", IMN_SETSENTENCEMODE);
  printf("#define IMN_SETSTATUSWINDOWPOS\t(%d)\n", IMN_SETSTATUSWINDOWPOS);
  printf("#define IMN_PRIVATE\t(%d)\n", IMN_PRIVATE);

  printf("\n/* STICKYKEYS structure */\n");
  printf("#define SKF_AUDIBLEFEEDBACK\t(%d)\n", SKF_AUDIBLEFEEDBACK);
  printf("#define SKF_AVAILABLE\t(%d)\n", SKF_AVAILABLE);
  printf("#define SKF_CONFIRMHOTKEY\t(%d)\n", SKF_CONFIRMHOTKEY);
  printf("#define SKF_HOTKEYACTIVE\t(%d)\n", SKF_HOTKEYACTIVE);
  printf("#define SKF_HOTKEYSOUND\t(%d)\n", SKF_HOTKEYSOUND);
  printf("#define SKF_INDICATOR\t(%d)\n", SKF_INDICATOR);
  printf("#define SKF_STICKYKEYSON\t(%d)\n", SKF_STICKYKEYSON);
  printf("#define SKF_TRISTATE\t(%d)\n", SKF_TRISTATE);
  printf("#define SKF_TWOKEYSOFF\t(%d)\n", SKF_TWOKEYSOFF);

  printf("\n/* MOUSEKEYS structure */\n");
  printf("#define MKF_AVAILABLE\t(%d)\n", MKF_AVAILABLE);
  printf("#define MKF_CONFIRMHOTKEY\t(%d)\n", MKF_CONFIRMHOTKEY);
  printf("#define MKF_HOTKEYACTIVE\t(%d)\n", MKF_HOTKEYACTIVE);
  printf("#define MKF_HOTKEYSOUND\t(%d)\n", MKF_HOTKEYSOUND);
  printf("#define MKF_INDICATOR\t(%d)\n", MKF_INDICATOR);
  printf("#define MKF_MOUSEKEYSON\t(%d)\n", MKF_MOUSEKEYSON);
  printf("#define MKF_MODIFIERS\t(%d)\n", MKF_MODIFIERS);
  printf("#define MKF_REPLACENUMBERS\t(%d)\n", MKF_REPLACENUMBERS);

  printf("\n/* SOUNDSENTRY structure */\n");
  printf("#define SSF_AVAILABLE\t(%d)\n", SSF_AVAILABLE);
  printf("#define SSF_SOUNDSENTRYON\t(%d)\n", SSF_SOUNDSENTRYON);
  printf("#define SSTF_BORDER\t(%d)\n", SSTF_BORDER);
  printf("#define SSTF_CHARS\t(%d)\n", SSTF_CHARS);
  printf("#define SSTF_DISPLAY\t(%d)\n", SSTF_DISPLAY);
  printf("#define SSTF_NONE\t(%d)\n", SSTF_NONE);
  printf("#define SSGF_DISPLAY\t(%d)\n", SSGF_DISPLAY);
  printf("#define SSGF_NONE\t(%d)\n", SSGF_NONE);
  printf("#define SSWF_CUSTOM\t(%d)\n", SSWF_CUSTOM);
  printf("#define SSWF_DISPLAY\t(%d)\n", SSWF_DISPLAY);
  printf("#define SSWF_NONE\t(%d)\n", SSWF_NONE);
  printf("#define SSWF_TITLE\t(%d)\n", SSWF_TITLE);
  printf("#define SSWF_WINDOW\t(%d)\n", SSWF_WINDOW);

  printf("\n/* ACCESSTIMEOUT structure */\n");
  printf("#define ATF_ONOFFFEEDBACK\t(%d)\n", ATF_ONOFFFEEDBACK);
  printf("#define ATF_TIMEOUTON\t(%d)\n", ATF_TIMEOUTON);

  printf("\n/* HIGHCONTRAST structure */\n");
  printf("#define HCF_AVAILABLE\t(%d)\n", HCF_AVAILABLE);
  printf("#define HCF_CONFIRMHOTKEY\t(%d)\n", HCF_CONFIRMHOTKEY);
  printf("#define HCF_HIGHCONTRASTON\t(%d)\n", HCF_HIGHCONTRASTON);
  printf("#define HCF_HOTKEYACTIVE\t(%d)\n", HCF_HOTKEYACTIVE);
  printf("#define HCF_HOTKEYAVAILABLE\t(%d)\n", HCF_HOTKEYAVAILABLE);
  printf("#define HCF_HOTKEYSOUND\t(%d)\n", HCF_HOTKEYSOUND);
  printf("#define HCF_INDICATOR\t(%d)\n", HCF_INDICATOR);

  printf("\n/* TOGGLEKEYS structure */\n");
  printf("#define TKF_AVAILABLE\t(%d)\n", TKF_AVAILABLE);
  printf("#define TKF_CONFIRMHOTKEY\t(%d)\n", TKF_CONFIRMHOTKEY);
  printf("#define TKF_HOTKEYACTIVE\t(%d)\n", TKF_HOTKEYACTIVE);
  printf("#define TKF_HOTKEYSOUND\t(%d)\n", TKF_HOTKEYSOUND);
  printf("#define TKF_TOGGLEKEYSON\t(%d)\n", TKF_TOGGLEKEYSON);

  printf("\n/* Installable Policy */\n");
  printf("#define PP_DISPLAYERRORS\t(%d)\n", PP_DISPLAYERRORS);

  printf("\n/* SERVICE_INFO structure */\n");
  printf("#define RESOURCEDISPLAYTYPE_DOMAIN\t(%d)\n", RESOURCEDISPLAYTYPE_DOMAIN);
  printf("#define RESOURCEDISPLAYTYPE_FILE\t(%d)\n", RESOURCEDISPLAYTYPE_FILE);
  printf("#define RESOURCEDISPLAYTYPE_GENERIC\t(%d)\n", RESOURCEDISPLAYTYPE_GENERIC);
  printf("#define RESOURCEDISPLAYTYPE_GROUP\t(%d)\n", RESOURCEDISPLAYTYPE_GROUP);
  printf("#define RESOURCEDISPLAYTYPE_SERVER\t(%d)\n", RESOURCEDISPLAYTYPE_SERVER);
  printf("#define RESOURCEDISPLAYTYPE_SHARE\t(%d)\n", RESOURCEDISPLAYTYPE_SHARE);

  printf("\n/* KEY_EVENT_RECORD structure */\n");
  printf("#define CAPSLOCK_ON\t(%d)\n", CAPSLOCK_ON);
  printf("#define ENHANCED_KEY\t(%d)\n", ENHANCED_KEY);
  printf("#define LEFT_ALT_PRESSED\t(%d)\n", LEFT_ALT_PRESSED);
  printf("#define LEFT_CTRL_PRESSED\t(%d)\n", LEFT_CTRL_PRESSED);
  printf("#define NUMLOCK_ON\t(%d)\n", NUMLOCK_ON);
  printf("#define RIGHT_ALT_PRESSED\t(%d)\n", RIGHT_ALT_PRESSED);
  printf("#define RIGHT_CTRL_PRESSED\t(%d)\n", RIGHT_CTRL_PRESSED);
  printf("#define SCROLLLOCK_ON\t(%d)\n", SCROLLLOCK_ON);
  printf("#define SHIFT_PRESSED\t(%d)\n", SHIFT_PRESSED);

  printf("\n/* MOUSE_EVENT_RECORD structure */\n");
  printf("#define FROM_LEFT_1ST_BUTTON_PRESSED\t(%d)\n", FROM_LEFT_1ST_BUTTON_PRESSED);
  printf("#define RIGHTMOST_BUTTON_PRESSED\t(%d)\n", RIGHTMOST_BUTTON_PRESSED);
  printf("#define FROM_LEFT_2ND_BUTTON_PRESSED\t(%d)\n", FROM_LEFT_2ND_BUTTON_PRESSED);
  printf("#define FROM_LEFT_3RD_BUTTON_PRESSED\t(%d)\n", FROM_LEFT_3RD_BUTTON_PRESSED);
  printf("#define FROM_LEFT_4TH_BUTTON_PRESSED\t(%d)\n", FROM_LEFT_4TH_BUTTON_PRESSED);
  printf("#define DOUBLE_CLICK\t(%d)\n", DOUBLE_CLICK);
  printf("#define MOUSE_MOVED\t(%d)\n", MOUSE_MOVED);

  printf("\n/* INPUT_RECORD structure */\n");
  printf("#define KEY_EVENT\t(%d)\n", KEY_EVENT);
  printf("#define MOUSE_EVENT\t(%d)\n", MOUSE_EVENT);
  printf("#define WINDOW_BUFFER_SIZE_EVENT\t(%d)\n", WINDOW_BUFFER_SIZE_EVENT);
  printf("#define MENU_EVENT\t(%d)\n", MENU_EVENT);
  printf("#define FOCUS_EVENT\t(%d)\n", FOCUS_EVENT);

  printf("\n/* BITMAPINFOHEADER structure */\n");
  printf("#define BI_RGB\t(%ldL)\n", BI_RGB);
  printf("#define BI_RLE8\t(%ldL)\n", BI_RLE8);
  printf("#define BI_RLE4\t(%ldL)\n", BI_RLE4);
  printf("#define BI_BITFIELDS\t(%ldL)\n", BI_BITFIELDS);

  printf("\n/* Extensions to OpenGL */\n");
  printf("\n/* ChoosePixelFormat */\n");
  printf("#define PFD_DRAW_TO_WINDOW\t(%#x)\n", PFD_DRAW_TO_WINDOW);
  printf("#define PFD_DRAW_TO_BITMAP\t(%#x)\n", PFD_DRAW_TO_BITMAP);
  printf("#define PFD_SUPPORT_GDI\t(%#x)\n", PFD_SUPPORT_GDI);
  printf("#define PFD_SUPPORT_OPENGL\t(%#x)\n", PFD_SUPPORT_OPENGL);
  printf("#define PFD_DOUBLEBUFFER\t(%#x)\n", PFD_DOUBLEBUFFER);
  printf("#define PFD_STEREO\t(%#x)\n", PFD_STEREO);
  printf("#define PFD_DOUBLEBUFFER_DONTCARE\t(%#x)\n", PFD_DOUBLEBUFFER_DONTCARE);
  printf("#define PFD_STEREO_DONTCARE\t(%#x)\n", PFD_STEREO_DONTCARE);
  printf("#define PFD_TYPE_RGBA\t(%d)\n", PFD_TYPE_RGBA);
  printf("#define PFD_TYPE_COLORINDEX\t(%d)\n", PFD_TYPE_COLORINDEX);
  printf("#define PFD_MAIN_PLANE\t(%d)\n", PFD_MAIN_PLANE);
  printf("#define PFD_OVERLAY_PLANE\t(%d)\n", PFD_OVERLAY_PLANE);
  printf("#define PFD_UNDERLAY_PLANE\t(%d)\n", PFD_UNDERLAY_PLANE);

  printf("\n/* wglUseFontOutlines */\n");
  printf("#define WGL_FONT_LINES\t(%d)\n", WGL_FONT_LINES);
  printf("#define WGL_FONT_POLYGONS\t(%d)\n", WGL_FONT_POLYGONS);

  printf("\n/* LAYERPLANEDESCRIPTOR structure */\n");
  /* umm...
  printf("#define LPD_SUPPORT_OPENGL\t(%#x)\n", LPD_SUPPORT_OPENGL);
  printf("#define LPD_SUPPORT_GDI\t(%#x)\n", LPD_SUPPORT_GDI);
  printf("#define LPD_DOUBLEBUFFER\t(%#x)\n", LPD_DOUBLEBUFFER);
  printf("#define LPD_STEREO\t(%#x)\n", LPD_STEREO);
  printf("#define LPD_SWAP_EXCHANGE\t(%#x)\n", LPD_SWAP_EXCHANGE);
  printf("#define LPD_SWAP_COPY\t(%#x)\n", LPD_SWAP_COPY);
  printf("#define LPD_TRANSPARENT\t(%#x)\n", LPD_TRANSPARENT);
  printf("#define LPD_SHARE_DEPTH\t(%#x)\n", LPD_SHARE_DEPTH);
  printf("#define LPD_SHARE_STENCIL\t(%#x)\n", LPD_SHARE_STENCIL);
  printf("#define LPD_SHARE_ACCUM\t(%#x)\n", LPD_SHARE_ACCUM);
  printf("#define LPD_TYPE_RGBA\t(%#x)\n", LPD_TYPE_RGBA);
  printf("#define LPD_TYPE_COLORINDEX\t(%#x)\n", LPD_TYPE_COLORINDEX);
  */

  printf("\n/* PIXELFORMATDESCRIPTOR structure */\n");
  printf("#define PFD_GENERIC_FORMAT\t(%#x)\n", PFD_GENERIC_FORMAT);
  printf("#define PFD_NEED_PALETTE\t(%#x)\n", PFD_NEED_PALETTE);
  printf("#define PFD_NEED_SYSTEM_PALETTE\t(%#x)\n", PFD_NEED_SYSTEM_PALETTE);
  /*  printf("#define PFD_SWAP_LAYER_BUFFERS\t(%#x)\n", PFD_SWAP_LAYER_BUFFERS); */
  printf("#define PFD_SWAP_COPY\t(%#x)\n", PFD_SWAP_COPY);
  printf("#define PFD_SWAP_EXCHANGE\t(%#x)\n", PFD_SWAP_EXCHANGE);

  /* End of definitions
     Do not add anything beyond this point */

  printf("\n#ifdef __cplusplus\n");
  printf("}\n");
  printf("#endif /* __cplusplus */\n");

  printf("\n#endif /* _GNU_H_WINDOWS32_DEFINES */\n");

  exit(0);
}



