/************************************************************************/
/* File		string.h						*/
/*									*/
/* Purpose	This C++ header file defines the String class. The	*/
/*		String class manages null-terminated strings. The	*/
/*		String class is implemented in string.cpp.		*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	0.0.0 (Prototype)					*/
/*									*/
/* Date		Sunday, April 28, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef STRING_H			// If not defined...
#define STRING_H			// Then process header file.

/* Include	The following header file is required by string.h.	*/

#include "standards.h"			// Our standards.

/* Class	This is the standard String class. The String class	*/
/*		provides a standard way to manage strings in a program.	*/
/*		(Implemented in string.cpp)				*/

class String
   {
      public:
         /* Constructors and destructors.				*/

         String();
         String(const char*);
         String(const String&);
         ~String();

         /* Operator overloading.					*/

         String& operator=(const char*);
         String& operator=(const String&);
	 String& operator+=(const char*);
	 String& operator+=(const String&);

         /* Query functions.						*/

         int Length(void) const;
         char* Data(void) const;
	 int Search_For_Character(const char) const;
         relation Compare(const char*) const;
         relation Compare(const String&) const;
         relation Case_Compare(const char*) const;
         relation Case_Compare(const String&) const;

         /* Manipulation functions.					*/

         void Convert_To_Upper_Case(void);
         void Convert_To_Lower_Case(void);

      private:
         int		itslength;
         char*		itsdata;
   };

#endif					// STRING_H
