/************************************************************************/
/* File		utilitymodule.h						*/
/*									*/
/* Purpose	This C++ header file defines the UtilityModule class.	*/
/*		The UtilityModule class provides a standard set of	*/
/*		routines that can be inherited by any library module	*/
/*		The UtilityModule class is implemented in the file	*/
/*		utilitymodule.cpp.					*/
/*									*/
/* Author	This C++ header file was written by Charles Henry	*/
/*		Schoonover for Padre Software. You can contact Charles	*/
/*		Henry Schoonover at charles@padresoftware.com.		*/
/*									*/
/* Owner	The contents of this C++ header file were written for	*/
/*		Padre Software. You can contact Padre Software at	*/
/*		webmaster@padresoftware.com.				*/
/*									*/
/* Version	0.0.0 (Prototype)					*/
/*									*/
/* Date		Sunday, April 28, 2002.					*/
/*									*/
/* Copyright	(C) 2002 by Padre Software Incorporated.		*/
/*		All rights are reserved.				*/
/*									*/
/*		Padre Software has released the source code in this	*/
/*		file to the public domain under the terms of the GNU	*/
/*		General Public License. (See the file COPYING).		*/
/*									*/
/*		This program is free software; you can redistribute it	*/
/*		and/or modify it under the terms of the GNU General	*/
/*		Public License as published by the Free Software	*/
/*		Foundation; either version 2 of the License, or (at	*/
/*		your option) any later version.				*/
/************************************************************************/

#ifndef UTILITYMODULE_H			// If not defined...
#define UTILITYMODULE_H			// Then process header file.

/* Headers	The following header is required by physicalos.h.	*/

#include "string++.h"			// String class.

/* Class	This is the standard utility module class. The standard	*/
/*		utility module class provides a standard interface for	*/
/*		C++ program modules. (Implemented in utilitymodule.cpp)	*/

class UtilityModule
   {
      public:
         UtilityModule();
	 ~UtilityModule();

	 void Report_Error(void);
	 void Reset_Error(void);
	 int Get_Error_Number(void) const;
	 int Get_OS_Error_Number(void) const;
	 void Get_Error_String(String&);
	 void Get_OS_Error_String(String&);
	 void Get_Error_Info_String(String&);
	 void Get_Complete_Error_String(String&);
	 void Set_Error_Number(const int);
	 void Set_OS_Error_Number(const int);
	 void Set_Error_Info_String(const String&);

      protected:
	 String		itsmodulename;
	 String		itserrorinfo;

	 int		itsoserror;
	 int		itserror;

	 int		itsmaxerror;
	 char**		itserrormessages;
   };

#endif					// UTILITYMODULE_H
