/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef _str2md5_h_
#define _str2md5_h_

#include <md5.h>

#define MD5_SIZE	16
#define MD5_ASCII_SIZE	32

/*
 * Compute the md5 key for <string> whose total length is <string_length>. The
 * resulting MD5 key is put in the <md5> key which must be able to contain exactly
 * 16 unsigned char.
 */
void str2md5(const char* string, int string_length, unsigned char* md5);
/*
 * Same as str2md5 but store in ascii instead of binary.
 */
void str2md5ascii(const char* string, int string_length, unsigned char* md5);
/*
 * Same as str2md5 but returns result stored in static variable.
 */
unsigned char* str2md5_simple(const char* string, int string_length);
/*
 * Same as str2md5ascii but returns result stored in static variable.
 */
unsigned char* str2md5ascii_simple(const char* string, int string_length);
/*
 * Convert a 32 char ascii hexa representation of an MD5 key from <str> into a binary
 * 16 char representation stored in <md5>.
 */
void ascii2md5(const char* str, unsigned char* md5);
/*
 * Convert a binary 16 char representation of an MD5 key from <md5> into an ascii
 * 32 char hexa representation stored in <str>.
 */
void md52ascii(const unsigned char* md5, char* str);

#endif /* _str2md5_h_ */

