/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef _mime_h
#define _mime_h

#include <webbase.h>

/*
 * Map extension to mime type
 */
char* mime_ext2mime(webbase_t* base, char* path, char* default_type);
/*
 * Return true if extension is accepted, false otherwise
 */
int mime_accept_ext(webbase_t* base, char* spec, char* path);
/*
 * Return true if mime type is accepted, false otherwise
 */
int mime_accept_type(webbase_t* base, char* spec, char* content_type);

#endif _mime_h
