/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>

#include <uri.h>
#include <salloc.h>
#include <md5str.h>
#include <file_exists.h>
#include <mkdirp.h>
#include <split.h>
#include <errno.h>

static int fileok(char* file, int file_length);

static void furi2md5(char* path)
{
  uri_t* uri = uri_alloc("/", 1);
  FILE* fp = fopen(path, "r");
#define BUFSIZE 50 * 1024
  char buffer[BUFSIZE];
  char* furi_md5 = 0;
  int furi_md5_size = 0;
  char* furi = 0;
  int furi_size = 0;
  char* dir = getenv("WLROOT");
  int dir_length = dir ? strlen(dir) : 0;
  const char* slash = dir ? "/" : "";

  if(fp == 0) {
    perror("");
    exit(1);
  }
  while(fgets(buffer, BUFSIZE, fp)) {
    /* Strip newline */
    int buffer_length = strlen(buffer) - 1;
    buffer[buffer_length] = '\0';
    if(uri_realloc(uri, buffer, buffer_length) == URI_CANNONICAL &&
       !(uri_info(uri) & URI_INFO_RELATIVE)) {
      char* from;
      char* to;

      uri_string(uri, &furi, &furi_size, URI_STRING_FURI_STYLE);
      from = smalloc(dir_length + strlen(furi) + 16);
      sprintf(from, "%s%s%s.store", (dir ? dir : ""), slash, furi);

      uri_string(uri, &furi_md5, &furi_md5_size, URI_STRING_FURI_STYLE|URI_STRING_FURI_MD5);
      to = smalloc(dir_length + strlen(furi_md5) + 16);
      sprintf(to, "%s%s%s.store", (dir ? dir : ""), slash, furi_md5);

      if(fileok(from, strlen(from)) && file_exists(from)) {
	/*
	 * Build directory
	 */
	{
	  char* slash = strrchr(to, '/');
	  if(!slash) {
	    fprintf(stderr, "could not find last / in %s\n", to);
	    exit(1);
	  }
	  *slash = '\0';
	  mkdirp(to, 0777);
	  *slash = '/';
	}
	/*
	 * Move file
	 */
	if(rename(from, to)) {
	  fprintf(stderr, "# failed mv %s %s ", from, to);
	  perror("");
	} else {
	  fprintf(stderr, "mv %s %s\n", from, to);
	}
      } else {
	/*
	 * Skip non existent files or file with name to
	 */
	fprintf(stderr, "# %s\n", from);
      }
      free(from);
      free(to);
    } else {
      fprintf(stderr, "%s not cannonical\n", buffer);
    }
  }
  fclose(fp);
}

static int fileok(char* file, int file_length)
{
  char** splitted;
  int count;
  int i;

  if(file_length == 0)
    return 0;

  split(file, file_length, &splitted, &count, '/', SPLIT_TRIM);

  for(i = 0; i < count; i++) {
    if(strlen(splitted[i]) >= MAXNAMLEN)
      return 0;
  }

  return 1;
}

int main(int argc, char** argv)
{
  if(argc != 2 || !file_exists(argv[1])) {
    fprintf(stderr, "usage: furi2md5 urllist\n\
Read URLs found in the file filelist, one at a time.\n\
For each URL, it builds a string containing\n\
the equivalent FURI path, as described in the uri library. It also\n\
builds a string containing the equivalent FURI_MD5. Then, the file\n\
pointed by the FURI is renamed into the file pointed by FURI_MD5.\n\
");
  } else {
    furi2md5(argv[1]);
  }
  return 0;
}
