/*
 *   Copyright (C) 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
//
// Simple dynamic loader. Assume that each loadable library follows
// the conventions:
//
// libfoo.la implements only one class whose base class is
// available to the main program.
//
// libfoo.la has a foo_init function.
//
// The foo_init function returns a pointer to a new object
// of the class implemented by libfoo.la.
//
#ifndef _WebbaseDl_h
#define _WebbaseDl_h

#include <WebbaseGetopt.h>
#include <hash.h>

#define WEBBASE_DL_OPTIONS	0x0040000

typedef void* (*webbasedl_init_function_t)();

class WebbaseDl : public WebbaseGetopt {
 public:
  WebbaseDl();
  virtual ~WebbaseDl();

  //
  // Designed to be a single instance object for a given program
  //
  static WebbaseDl* Instance();

  //
  // WebbaseGetopt virtuals
  //
  inline  int Flag() { return WEBBASE_DL_OPTIONS; }
  virtual struct option* Options();
  virtual int HandleOption(struct option* option);

  //
  // Load library <name>, cache function pointer and return it.
  // If <name> was already loaded, return the cached function pointer.
  //
  webbasedl_init_function_t Find(const char* name);
  //
  // Return function pointer if library loaded, otherwise return 0
  //
  webbasedl_init_function_t Loaded(const char* name);
  //
  // Load library <name>, return function pointer (backend of Find).
  //
  webbasedl_init_function_t Load(const char* name);

  //
  // Map library names to create object pointer
  //
  hash_t* name2function;
};

#endif /* _WebbaseDl_h */
