/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _hooks_h
#define _hooks_h

#include <webbase.h>
#include <webbase_url.h>
#include <WebbaseGetopt.h>

#define HOOK_MAX_RECORDS		20000000

class WebbaseHook : public WebbaseGetopt {
 public:
  WebbaseHook() { verbose = 0;  }
  virtual ~WebbaseHook() { }

  //
  // WebbaseGetopt virtuals
  //
  virtual struct option* Options();
  virtual int HandleOption(struct option* option);

  //
  // Hook interface
  //
  virtual int Init(webbase_t* base);
  virtual int Ok(webbase_url_t* webbase_url);
  virtual int Insert(webbase_url_t* webbase_url);
  virtual int InsertWatch();
  virtual int Update(webbase_url_t* webbase_url);
  virtual int Delete(webbase_url_t* webbase_url);
  virtual int DeleteId(int id, char* url, int url_length);
  virtual int RehookStart();
  virtual int RehookEnd();
  virtual int RebuildInit();
  virtual int RebuildStart();
  virtual int RebuildEnd();
  virtual void InfoSet(char* info);
  virtual void Server(int server);
  virtual void End();

  int verbose;
  webbase_t* base;
  int server_id;
};

#endif /* _hooks_h */
