/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#include <WebbaseHook.h>
#include <sqlutil.h>

struct option* WebbaseHook::Options()
{
  static struct option long_options[] = {
    {"verbose_hooks", 0, 0, 0},
    {0, 0, 0, 0}
  };

  return long_options;
}

int WebbaseHook::HandleOption(struct option* option)
{
  int found = 1;
  
  if(!strcmp(option->name, "verbose_hooks")) {
    verbose++;
  } else {
    found = 0;
  }

  return found;
}

int WebbaseHook::Init(webbase_t* base)
{
  WebbaseHook::base = base;
  return 1;
}

int WebbaseHook::Ok(webbase_url_t* webbase_url)
{
  if((webbase_url->w_info & WEBBASE_URL_INFO_CONTENT) &&
     webbase_url->w_content_length > 0 &&
     !webbase_url_robots_p(webbase_url))
    return 1;
  else
    return 0;
}

int WebbaseHook::Insert(webbase_url_t*)
{
  return 0;
}

int WebbaseHook::InsertWatch()
{
  return 0;
}

int WebbaseHook::Update(webbase_url_t*)
{
  return 0;
}

int WebbaseHook::Delete(webbase_url_t*)
{
  return 0;
}

int WebbaseHook::DeleteId(int, char*, int)
{
  return 0;
}

int WebbaseHook::RehookStart()
{
  return 1;
}

int WebbaseHook::RehookEnd()
{
  return 1;
}

int WebbaseHook::RebuildStart()
{
  //
  // Clear indexing indicators in the database
  //
  char query[256];

  sprintf(query, "update url set hookid = 0");
  if(verbose) fprintf(stderr, "%s\n", query);
  smysql_query(&base->mysql, query);

  return 1;
}

int WebbaseHook::RebuildEnd()
{
  return 1;
}

void WebbaseHook::InfoSet(char*)
{
}

void WebbaseHook::Server(int server_arg)
{
  server_id = server_arg;
}

void WebbaseHook::End()
{
}
