/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#include <timer.h>

static time_t time_base;

void time_register(time_t* timevar)
{
  if(timevar) {
    *timevar = time(0);
  } else {
    time_base = time(0);
  }
}

void time_show(char* message, time_t timevar)
{
  if(timevar == 0)
    timevar = time(0) - time_base;
  fprintf(stderr, "%s (%ldh:%ldm:%lds) \n", message, (timevar / 3600), ((timevar % 3600) / 60), (timevar % 60));
}
