/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 greeting.c - a container that shows a greeting to source installer

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "console.h"
#include "package_info.h"
#include "greeting.h"

GtkWidget* w_greeting[W_GREETING_N];

void greeting_create(void) {
  GtkWidget* tmp; 
  w_greeting[W_GREETING] = gtk_vbox_new(FALSE, bw);

  /*
  tmp = gtk_image_new_from_file(DATADIR "/images/logo.png");
  gtk_box_pack_start(GTK_BOX(w_greeting[W_GREETING]), tmp, TRUE, TRUE, 0);
  */

  tmp = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(tmp), "<big>GNU Source Installer</big>\n"
	       "<small>\nCopyright (c) 2005,2006,2007 Claudio Fontana</small>");

  gtk_label_set_justify(GTK_LABEL(tmp), GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(w_greeting[W_GREETING]), tmp, TRUE, TRUE, 0);

  tmp = gtk_label_new(NULL);
  gtk_label_set_markup(GTK_LABEL(tmp), "<small>"
    "This program is Free Software, and is licensed under the terms \n"
    "of the GPL (General Public License) as published by the FSF \n"
    "(Free Software Foundation); see the COPYING file that came with \n"
    "the package for more details.\n"
    "</small>");
  gtk_box_pack_start(GTK_BOX(w_greeting[W_GREETING]), tmp, TRUE, TRUE, 0);

}

void greeting_show(void) {
  if (!GTK_WIDGET_VISIBLE(w_greeting[W_GREETING]))
    gtk_widget_show_all(w_greeting[W_GREETING]);
  console_hide();
  package_info_hide();
  gui_update();
}

void greeting_hide(void) {
  if (GTK_WIDGET_VISIBLE(w_greeting[W_GREETING]))
    gtk_widget_hide_all(w_greeting[W_GREETING]);
}

