/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 status.c - display status and progress

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"

#include "status.h"

GtkWidget* w_status[W_STATUS_N];

static gdouble progress_todo;
static gdouble progress_done;
static gdouble progress_limit;
static gdouble progress_n;

void status_create(void) {
  GtkProgressBar* bar;
  bar = GTK_PROGRESS_BAR(w_status[W_STATUS] = gtk_progress_bar_new());
  
  /*
  gtk_progress_bar_set_pulse_step(bar, 0.05);
  */

  gtk_progress_bar_set_orientation(bar, GTK_PROGRESS_LEFT_TO_RIGHT);
  gtk_progress_bar_set_ellipsize(bar, PANGO_ELLIPSIZE_END);
}

void status_command(char* s) {
  gtk_progress_bar_set_text(GTK_PROGRESS_BAR(w_status[W_STATUS]), s);
}

void status_show(void) {
  if (!GTK_WIDGET_VISIBLE(w_status[W_STATUS]))
    gtk_widget_show_all(w_status[W_STATUS]);
}

void status_hide(void) {
  if (GTK_WIDGET_VISIBLE(w_status[W_STATUS]))
    gtk_widget_hide_all(w_status[W_STATUS]);
}

void status_reset(void) {
  gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(w_status[W_STATUS]), 0.0);
  status_todo(100);
}

void status_pulse(void) {
  /*
  gtk_progress_bar_pulse(GTK_PROGRESS_BAR(w_status[W_STATUS]));
  */
  gdouble diff;

  diff = progress_limit - progress_done;
  progress_done = progress_done + diff / progress_n;

  progress_n = progress_n + progress_n / 100;

  if (progress_done > progress_limit)
    progress_done = progress_limit;

  gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(w_status[W_STATUS]), 
				progress_done / progress_todo);
}

void status_todo(gdouble n) {
  progress_todo = n;
  progress_done = 0;
  progress_limit = 0;
  progress_n = 100;
}

void status_done(gdouble i, gdouble end) {
  progress_n = 100;
  progress_done = i;
  progress_limit = end;
  
  gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(w_status[W_STATUS]), 
				progress_done / progress_todo);
  gui_doevents(0);
}
