/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

   matcher.h - wrapper around the POSIX extended regex

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#ifndef SRCINST_REGEX_H
#define SRCINST_REGEX_H

typedef void *SRCINST_MATCH;
typedef void *SRCINST_REGEX;

/* initialize results before a regex execution, in order to store submatches */
SRCINST_MATCH srcinst_init_match(int nmatch);

/* use the following one to resize the match set */
void srcinst_resize_match(SRCINST_MATCH match, int nmatch);

/* fetch the I-th submatch in the MATCH set */
char *srcinst_get_match(SRCINST_MATCH match, int i);

/* fetch the length of the I-th submatch in the MATCH set */
int srcinst_get_match_len(SRCINST_MATCH match, int i);

/* fetch the start offset in string of the I-th submatch in the MATCH set */
int srcinst_get_match_offset(SRCINST_MATCH match, int i);

/* for each set initialized with srcinst_init_match, a corresponding free. */
void srcinst_free_match(SRCINST_MATCH match);

/* initialize and compile a regular expression.
   Pass additional flags to CFLAGS. -1=default:REG_EXTENDED | REG_NEWLINE */
SRCINST_REGEX srcinst_init_regex(char *pattern, int cflags);

/* run the regex. MATCH can be 0, in which case no submatches are stored. */
int srcinst_exec_regex(SRCINST_REGEX preg, char *string,
		       SRCINST_MATCH match);

/* for each srcinst_init_regex, call a corresponding free_regex, please. */
void srcinst_free_regex(SRCINST_REGEX);


#endif				/* SRCINST_REGEX_H */
