/* Source Installer, Copyright (c) 2005 Claudio Fontana

 srcparser.h - parsing utility functions

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef SRCINST_PARSER_H
#define SRCINST_PARSER_H

/* this struct represents parse information */

struct srcinst_parsed_data {
  char* key;			/* the valid keyword to be matched */
  void* variable;		/* the address of the variable that should be
				   modified when the key is detected */
  char* format;			/* the format string to use when assigning
				   a value to the variable */
};

/* load and parse a generic configuration file. The P parameter is a pointer
   to a generic structure to be filled, FILENAME is the configuration file,
   and through PARSE_F the specific parse function is passed. */

int srcinst_load_parse_file(void* p, char* filename, int (*parse_f)(void*, char*, char*));

/* this is an accessor function for srcinst_parsed_data. It returns the key. */
char* srcinst_get_parsed_data_key(struct srcinst_parsed_data* data, int i);

/* take a parsed DATA and assign to VARIABLE reading input string S according
    to FORMAT */
int srcinst_parse(struct srcinst_parsed_data* data, char* s);

#endif /* SRCINST_PARSER_H */

