/* Source Installer, Copyright (c) 2005 Claudio Fontana

   srcerror.c - custom error handling

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#include "src_stdinc.h"

static char* _error_strings[] = {
  0,
  "core", "heap", "regex",
  "lock", "action", "parser",
  "perm", "invalid", "missing",
  "intr"
};

void srcinst_error(int errcode, char* s, char* t) {
  if (errcode > 0 && errcode < SRCINST_ERR_N) {
    fprintf(stderr, "libsrcinst(%s): ERROR: %s", _error_strings[errcode], s);
    
    if (t) {
      fprintf(stderr, ": %s", t);
    }

    fprintf(stderr, "\n");
  }

  srcinst_exit(errcode);
}

void srcinst_warning(int errcode, char* s, char* t) {
  if (errcode > 0 && errcode < SRCINST_ERR_N) {
    fprintf(stderr, "libsrcinst(%s): WARNING: %s", _error_strings[errcode], s);
    
    if (t) {
      fprintf(stderr, ": %s", t);
    }

    fprintf(stderr, "\n");
  }
}
