Summary: script to organize ogg and mp3 files
Name: songanizer
Version: 0.8
Release: 1
URL: http://savannah.nognu.org/songanizer
Source0: %{name}-%{version}.tar.gz
License: GPL
Group: Applications/Multimedia
BuildRoot: %{_builddir}/%{name}-root

%description
Script to organize a directory containing ogg and mp3 files.

The biggest problem for me, during my efforts to organize music files,
was the choice of the directory structure. Should the directory
structure reflect the author or the genre or may be the album? I ended
up with the conclusion, that no ideal directory structure exists. So I
wanted different virtual directory structures to the same data. Thanks
to the symbolic links capability of the file systems I use (ext2,
ext3, ...) this dream has become reality!

The script gets a list of _data directories, in which the real ogg and
mp3 files reside. The script has to read informations like author,
album, genre, ... from these files and create parallel directory
structures, which just contain symbolic links (like pointers) to the
directories in which the real files live.

The goal is to create virtual directory structures, which give
different views of the data, without having redundant copies of
the files themselves.

%prep
%setup -q

%build

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p ${RPM_BUILD_ROOT}/usr/local/bin/
cp bin/songanizer ${RPM_BUILD_ROOT}/usr/local/bin/.

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/local/bin/songanizer
%doc AUTHORS ChangeLog COPYING NEWS README THANKS

%changelog
* Sat Nov 05 2005 Debarshi Ray <debarshi.ray@gmali.com>
- Changed the virtual directory structure creation algorithm. The structure for every option passed to songanizer is first created in a temporary directory. On completion of this heavy task, in a short operation, the structure is moved to its desired location.

* Fri Nov 04 2005 Debarshi Ray <debarshi.ray@gmail.com>
- A new switch(ie. --all) has been added to facilitate organization based on all the tags.

* Wed Nov 02 2005 Debarshi Ray <debarshi.ray@gmail.com>
- Replaced ls with find. Data directories can have multiple levels of subdirectoies within them.
- Now links point to individual files instead of directories.

* Fri Sep 16 2005 Debarshi Ray <debarshi.ray@gmail.com>
- Created an online manual page.

* Fri Aug 22 2003 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- Fixed problems if an album is contained in more than one data directory [bug #4877].

* Sun Aug 17 2003 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- Added support for multiple data directories.

* Wed Jul 16 2003 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- Initial build.

* Sat Dec 28 2002 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- Translated all texts into English.

* Thu Oct 10 2002 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- Created the generic function organizeOnBaseOfTag().
