@c  Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
@c  Permission is granted to copy, distribute and/or modify this document
@c  under the terms of the GNU Free Documentation License, Version 1.1
@c  or any later version published by the Free Software Foundation;
@c  with no Invariant Sections.

@c  $Id: helpfile-format.texi.m4,v 1.7.2.2 2002/02/17 22:42:35 tom Exp $

@c vim: set nolinebreak
m4_include(texidefinitions.m4)

@settitle Help files
@section  Help files

The source code for the online documentation is written in texinfo and
converted to plain html.

In addition to links to other help files, you can write links that
will start and configure an exercise if you click on it, like
ahref(solfege:/harmonic-intervall, this one).

Feel free to ask any questions if you want to write some documentation
for Solfege, I'll even give you a private crash course in texinfo via
email if that is needed...

@subsection The special @code{solfege:} links

@code{protocol:action/exercise/lessoncollection/lessonfile?configuration}

@table @code
@item protocol
Optional, if omitted, the links if to a html file.
One possible value: @code{solfege}.

@item action
Optional, possible values: @code{practise}, @code{config}
or @code{statistics}. If omitted, you will view the same part
of the exercise you used last time. If the exercise has not been
used in this session, you will see the practise page.

@item exercise
@code{chord, harmonic-intervall, melodic-intervall, sing-intervall,
    identify-scale, dictation, id-by-name,
    twelve-tone, sing-chord, id-tone, compare-intervalls, rhythm}

@item lessoncollection
Use the value @code{solfege} for files distributed with Solfege. Use
@code{user} for your own files stored in @code{$HOME/lessonfiles}.
(Optional, only used with lesson file based exercises.)
@item lessonfile
File name. (Optional, only used with lesson file based exercises.)

@item configuration
Optional. Semicolon-separated list of assignments. Example:
@example
highest_instrumnt=80; intervalls=[1, 2, 3, 4]
@end example
@end table


@subsection Listing of variables
Theses two can be used with all exercises that has the @emph{New question
automatically} option on the config page.

@table @code
@item new_question_automatically = true | false
@item seconds_Before_question = float
@end table

@subsubsection Chord
@table @code
@item highest_instrument, middle_instrument, lowest_instrument
integer 0-127

@item highest_instrument_velocity, middle_instrument_velocity, lowest_instrument_velocity
integer 0-127
@item override_default_instrument
boolean
@end table

@subsubsection Harmonic interval
@table @code
@item highest_instrument, lowest_instrument
integer 0-127

@item highest_instrument_velocity, lowest_instrument_velocity
integer 0-127

@item override_default_instrument
boolean

@item intervalls
list of integers, [1, 2, ... 15, 16]

@item highest_tone, lowest_tone
Notename like, @code{c}, @code{fis,},  or @code{d''}

@item new_question_automatically
boolean

@item seconds_before_new_question
float
@end table

@subsubsection Melodic interval, sing interval
@table @code
@item number_of_intervalls
integer

@item ask_for_intervalls_nn, where nn is 0 or greater
list of integers: [-16, -15 ... 15, 16]

@end table

@subsubsection Identify scale
@table @code
@item scales
list of scale types: ['ionian', 'dorian', 'phrygian', 'lydian',
'mixolydian', 'aeolian', 'lokrisk', 'harmonic_minor', 'melodic_minor']
@end table

@subsubsection Id by name, dictation, harmonic progression dictation
Only specifying lesson file. 

@subsubsection Id tone
@table @code
@item c_weight, cis_weight etc..
0..1000

@item one_chance_only
boolean

@item warning_sound
boolean

@item repeat_question
boolean
@end table

@subsection @code{solfegescript}

An experimental feature was added some time ago, so the documentation
will show the current key bindings even if the user customise the
program:
@example
<script type="text/solfegescript">
  get_string("chord/new_ak")
</script>
@end example

