"======================================================================
|
|   Smalltalk GUI inspector for CStruct derivatives
|
|   $Revision: 1.8.5$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

GenericInspector subclass:  #StructInspector
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Browser'
!

!StructInspector methodsFor: 'initializing'!

inspectMenu: listView
"Initialize menu for variable list pane"
    ^((PopupMenu new: listView label: '') selectors:
#(('Inspect' evalAndInspectResult: listView))
					  receiver: self
					  argument: listView ).
! !

!StructInspector methodsFor: 'private'!

currentVariableValue
    currentVariable == 0
	ifTrue: [ ^nil ].
    ^(theObject perform: currentVariable) value
!

currentVariable: obj
    "Cannot change!"
!

setInstanceVars: anObject
"Initialize instance variable, instVars, which governs display of
variable list pane."
    
    theObject := anObject.
    theObject inspectSelectorList do:
	[ :aKey | instVars add:  (Association key: aKey asString
					      value: aKey)].
! !

!StructInspector methodsFor: 'accessing'!

variable: assoc
"Set list selection to value of index.  Force a text view update"
    assoc key == 0
	ifTrue: [ currentVariable := 0 ]
	ifFalse: [currentVariable := (instVars at: assoc key) value].
    self changeState: #text.
    Primitive updateViews.
!

variableList
"Return list of vars from set of Associations stored in instVars"
    ^instVars collect: [ :each | each key ]
! !

! CStruct methodsFor: 'debugging' !

inspect
"Open a StructInspector window on self"
    StructInspector new openOn: self
!

inspect: pane
"Open a StructInspector window on self"
    StructInspector new openOn: self in: pane
! !
