"======================================================================
|
|   Socket wrapper class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne and Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

AbstractSocket subclass: #Socket
	  instanceVariableNames: ''
	  classVariableNames: 'Ports'
	  poolDictionaries: ''
	  category: 'Sockets-Streams'
!

Socket defaultImplementationClass: TCPSocketImpl!

!Socket class methodsFor: 'well known ports'!

portEcho           ^7!
portDiscard        ^9!
portSystat         ^11!
portDayTime        ^13!
portNetStat        ^15!
portFTP            ^21!
portTelnet         ^23!
portSMTP           ^25!
portTimeServer     ^37!
portDNS            ^42!
portWhois          ^43!
portGopher	   ^70!
portFinger         ^79!
portHTTP	   ^80!
portPOP3           ^110!
portNNTP           ^119!
portExecServer     ^512!
portLoginServer    ^513!
portCmdServer      ^514!
portReserved       ^1024!
portUserReserved   ^5000!

defaultPortAt: protocol
    ^Ports at: protocol
!

defaultPortAt: protocol ifAbsent: port
    ^Ports at: protocol ifAbsent: port
!

defaultPortAt: protocol put: port
    ^Ports at: protocol put: port
!

initialize
    Ports := Dictionary new
        at: 'ftp' put: 21;
        at: 'telnet' put: 23;
        at: 'smtp' put: 25;
        at: 'dns' put: 42;
        at: 'whois' put: 43;
        at: 'finger' put: 79;
        at: 'http' put: 80;
        at: 'pop3' put: 110;
        at: 'nntp' put: 119;
        yourself
! !

!Socket class methodsFor: 'instance creation'!

remote: ipAddressOrString port: remotePort
    ^self
        remote: ipAddressOrString
        port: remotePort
        local: nil
        port: 0
!

remote: ipAddressOrString port: remotePort local: ipAddress port: localPort
    | ipAddr |
    ipAddr := ipAddressOrString isString
        ifTrue: [ IPAddress byName: ipAddressOrString ]
        ifFalse: [ ipAddressOrString ].

    ((remotePort < 0) | (remotePort > 16rFFFF) |
    (localPort < 0) | (localPort > 16rFFFF)) 
        ifTrue: [ self error: 'port out of range' ].

    ^self new
        remote: ipAddressOrString
        port: remotePort
        local: ipAddress
        port: localPort
! !

!Socket methodsFor: 'accessing'!

address
    ^self remoteAddress
!

port
    ^self remotePort
!

remoteAddress
    ^self implementation remoteAddress
!

remotePort
    ^self implementation remotePort
!

soLinger
    ^self implementation soLinger
!

soLinger: linger
    ^self implementation soLinger: linger
!

soLingerOff
    ^self implementation soLinger: nil
!

tcpNoDelay
    ^self implementation tcpNoDelay
!

tcpNoDelay: tcpNoDelay
    ^self implementation tcpNoDelay: tcpNoDelay
! !

!Socket methodsFor: 'printing'!

printOn: aStream
    aStream
        print: self class;
        nextPutAll: '[local ';
        print: self localAddress;
        nextPut: $: ;
        print: self localPort;
        nextPutAll: ', remote ';
        print: self remoteAddress;
        nextPut: $: ;
        print: self remotePort;
        nextPut: $]
! !

!Socket methodsFor: 'private'!

remote: ipAddressOrString port: remotePort local: ipAddress port: localPort
    self implementation create.

    ipAddress isNil ifFalse: [
        self implementation bindTo: ipAddress port: localPort
    ].
    self implementation connectTo: ipAddressOrString port: remotePort
! !
