"======================================================================
|
|   ServerSocket wrapper class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne and Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

AbstractSocket subclass: #ServerSocket
	  instanceVariableNames: ''
	  classVariableNames: ''
	  poolDictionaries: ''
	  category: 'Sockets-Streams'
!

Socket defaultImplementationClass: TCPSocketImpl!

!Socket class methodsFor: 'instance creation'!

defaultQueueSize
    ^50
!

queueSize: backlog
    ^self port: 0 queueSize: backlog bindTo: nil
!

queueSize: backlog bindTo: ipAddress
    ^self port: 0 queueSize: backlog bindTo: ipAddress
!

port: anInteger
    ^self port: anInteger queueSize: self defaultQueueSize bindTo: nil
!

port: anInteger queueSize: backlog
    ^self port: anInteger queueSize: backlog bindTo: nil
!

port: anInteger queueSize: backlog bindTo: ipAddress
    (anInteger < 0) | (anInteger > 16rFFFF)
        ifTrue: [ self error: 'port out of range' ].

    ^self new
        port: anInteger queueSize: backlog bindTo: ipAddress
! !

!ServerSocket class methodsFor: 'accessing'!

address
    ^self localAddress
!

port
    ^self localPort
!

accept
    ^self basicAccept: Socket
!

basicAccept: socketClass
    | newImpl |
    newImpl := socketClass defaultImplementationClass.
    self implementation accept: newImpl.
    ^socketClass new: newImpl
! !

!ServerSocket methodsFor: 'private'!

port: anInteger queueSize: backlog bindTo: ipAddress
    self implementation create.

    ipAddress isNil ifFalse: [
        self implementation bindTo: ipAddress port: anInteger
    ].
    self implementation listen: backlog
! !
