"======================================================================
|
|   ReadBuffer class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

ReadStream subclass: #ReadBuffer
	   instanceVariableNames: 'fillBlock'
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Examples-Useful tools'
!

ReadBuffer comment: '
I''m a ReadStream that, when the end of the stream is reached,
evaluates an user defined block to try to get some more data.'!

!ReadBuffer methodsFor: 'buffer handling'!

atEnd
    | bytesRead |
    self basicAtEnd ifFalse: [ ^false ].
    fillBlock isNil ifTrue: [ ^false ].

    bytesRead := fillBlock value: collection value: collection size.
    ptr := 1.
    endPtr := bytesRead.
    ^bytesRead = 0
!

fillBlock: block
    "Set the block that fills the buffer. It receives a collection
    and the number of bytes to fill in it, and must return the number
    of bytes actually read"
    fillBlock := block
!

isFull
    "Answer whether the next input operation will force a buffer fill"
    ^self basicAtEnd not
! !
