"======================================================================
|
|   Abstract ContentHandler class
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Object subclass: #ContentHandler
	  instanceVariableNames: 'stream'
	  classVariableNames: 'FileExtensionMap FileTypeMap'
	  poolDictionaries: ''
	  category: 'Sockets-MIME'
!

ContentHandler class instanceVariableNames: 'validTypes'!

!ContentHandler class methodsFor: 'checking files'!

contentTypeFor: aFileName
    | posi |
    posi := aFileName findLast: [ :each | each = $. ].
    posi = 0 ifTrue: [ ^'application/x-unknown' ].

    ^FileExtensionMap
        at: (aFileName copyFrom: posi + 1 to: aFileName size)
        ifAbsent: [ 'application/x-unknown' ]
!

guessContentTypeFor: aPositionableStream
     | str ba |
     str := aPositionableStream next: 12.
     ba := str asByteArray.

     FileTypeMap do: [ :each |
        | ok |
        ok := true.
        (each at: 1) doWithIndex: [ :ch :index |
            ch isSymbol ifFalse: [
                ch isInteger
                    ifTrue:  [ ok := ((ba  at: index) = ch) | ok ]
                    ifFalse: [ ok := ((str at: index) = ch) | ok ]
            ]
        ].
        ok ifTrue: [ ^each at: 2 ]
    ].
    ^nil
!

classFor: mimeType
    self withAllSubclassesDo: [ :each |
        (each validTypes includes: mimeType) ifTrue: [ ^each ]
    ].
    ^self
! !

!ContentHandler class methodsFor: 'accessing'!

defaultFileExtensionMap
    ^#(	('aif' 'audio/x-aiff')
	('aiff' 'audio/x-aiff')
	('au' 'audio/basic')
	('snd' 'audio/basic')
	('gif' 'image/gif')
	('html' 'text/html')
	('htm' 'text/html')
	('jpe' 'image/jpeg')
	('jpeg' 'image/jpeg')
	('jpg' 'image/jpeg')
	('mov' 'movie/quicktime')
	('mpe' 'movie/mpeg')
	('mpeg' 'movie/mpeg')
	('mpg' 'movie/mpeg')
	('qt' 'movie/quicktime')
	('sgml' 'text/sgml')
	('sgm' 'text/sgml')
	('snd' 'audio/basic')
	('tiff' 'image/tiff')
	('tif' 'image/tiff')
	('wav' 'audio/x-wav'))
!

defaultFileTypeMap
    ^#(
        (($G  $I  $F  $8)                     'image/gif')
        (($#  $d  $e  $f)                     'image/x-bitmap')
        (($!  $   $X  $P  $M  $2)             'image/x-pixmap')
        (($I  $I  42   0)                     'image/tiff')
        (($M  $M   0  42)                     'image/tiff')
        ((137 $P  $N  $G  13  10 26 10)	      'image/png')
        (($B  $M)                             'image/x-win-bitmap')
        (($P  $K  3   4)                      'application/x-zip-compressed')
        ((255 216 255 224)                    'image/jpeg')
        ((255 216 255 232)                    'image/jpg')
        (($<  $!)                             'text/html')
        (($<  $h  $t  $m  $l)                 'text/html')
        (($<  $H  $T  $M  $L)                 'text/html')
        (($.  $s  $n  $d)                     'audio/basic')
        (($d  $n  $s  $.)                     'audio/basic')
        (($R  $I  $F  $F - - - - $W $A $V $E) 'audio/x-wav')
    )
!

contentType: type hasExtension: ext 
    ^FileExtensionMap at: ext put: type
!

contentType: type hasMagicData: data
    ^FileTypeMap add: (Array with: data with: type)
!

initialize
    FileExtensionMap := Dictionary new.
    FileTypeMap := self defaultFileTypeMap asOrderedCollection.
    self defaultFileExtensionMap do: [ :each |
        FileExtensionMap at: (each at: 1) put: (each at: 2)
    ]
!

validTypes
    ^validTypes isNil
        ifTrue: [ #() ]
        ifFalse: [ validTypes ]
!

registerContentType: contentType
    validTypes isNil ifTrue: [ validTypes := OrderedCollection new ].
    validTypes add: contentType
!

registerContentTypes: contentType
    validTypes isNil ifTrue: [ validTypes := OrderedCollection new ].
    validTypes addAll: contentType
! !

!ContentHandler class methodsFor: 'instance creation'!

on: stream
    ^self new initialize: stream
! !

!ContentHandler methodsFor: 'retrieving contents'!

contents
    ^stream contents
!

initialize: aStream
    stream := aStream
! !

ContentHandler registerContentTypes: #(
    'application/octet-stream'
    'application/x-unknown'
    'text/english'
    'text/plain')
!