"======================================================================
|
|   BLOX progress widget
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"

 
"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file LICENSE.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

PackageLoader fileInPackage: 'Blox'!

BExtended subclass: #ProgressWidget
    instanceVariableNames: 'label rectangle value'
    classVariableNames: ''
    poolDictionaries: ''
    category: 'Graphics-Examples'!

!ProgressWidget class methodsFor: 'starting'!

open
    | window widget |
    window := BWindow new.
    window width: 300 height: 100.

    widget := self new: window.
    widget x: 5 y: 5 width: 290 height: 90.
    widget value: 0.5 .

    widget 
        onMouseMoveEvent: 1
        send: #value:
        to: [ :pnt | widget value: pnt x / widget widthAbsolute ].

    window map.

    (Smalltalk hasFeatures: #Browser)
	ifFalse: [ Blox dispatchEvents: window ].
! !

!ProgressWidget methodsFor: 'accessing'!

value
    ^value
!

value: newValue
    value := newValue.
    rectangle corner x: self value * self primitive widthAbsolute.
    label text: (value * 100) asInteger printString, '%'.
    label color: (self value > 0.5 ifTrue: [ 'white' ] ifFalse: [ 'black' ]).

    rectangle redraw.
! !

!ProgressWidget methodsFor: 'private - gui'!

newPrimitive
    | canvas |
    value := 0.

    canvas := BCanvas new: self parent.
    canvas onResizeSend: #resize: to: self.
    canvas effect: #sunken.

    rectangle := BRectangle new: canvas.
    rectangle origin: 0 @ 0 corner: 0 @ canvas height.
    rectangle color: 'blue'.
    rectangle outlineColor: ''.
    rectangle create.

    label := BEmbeddedText new: canvas.
    label origin: 0 @ 0 corner: canvas width @ canvas height.
    label color: 'black'.
    label create.

    ^canvas
!

resize: newSize
    rectangle corner: (self value @ 1) * newSize.
    label corner: newSize.
    
    rectangle redraw.
    label redraw.
! !

