" Smalltalk Toolkit for the X Protocol

 (w) Ulf Dambacher 960601

"
Object subclass: #Watchdog
       instanceVariableNames: 'actionBlock relax ok delay'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'debugging aids'
!

Watchdog comment: 'I am used to watch for system hangups'!

!Watchdog class methodsFor: 'all'!

new
    ^super new initialize
!

do: aBlock
    ^ self new do: aBlock; watch.
! !

!Watchdog methodsFor: 'all'!

initialize
    semaphore _ Semaphore new.
    relax _ true.
    delay _ Delay forSeconds: 60.
    ok _ ValueHolder null.		"Anything that answers #value"
!

relax
    relax _ true.
!

do: aBlock
    actionBlock _ aBlock.
!

ok
    ok _ true.
!

watch
    relax _ false.
    ok _ false.
    [ [ delay wait. relax ] whileFalse: [
	 ok ifFalse: actionBlock.
	 ok _ false.
    ] forkAt: Processor lowIOPriority.
!

checkAfterSeconds: value
    delay _ Delay forSeconds: value
! !
