"======================================================================
|
|   Smalltalk in Smalltalk compiler constant definitions
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Smalltalk at: #VMByteCodeNames put: 
#(
    ( PushReceiverVariable	0)
    ( PushTemporaryVariable	16 )
    ( PushLitConstant		32 )
    ( PushLitVariable		64 )
    ( PopReceiverVariable	96 )
    ( PopTemporaryVariable	104 )
    ( PushSpecial		112 )
    ( PushNil    		115 )
    ( PushZero   		117 )
    ( ReturnSpecial		120 )
    ( ReturnSelf		120 )
    ( ReturnMethodStackTop	124 )
    ( ReturnBlockStackTop	125 )
    ( BigLiteral		126 )
    ( PushIndexed		128 )
    ( StoreIndexed		129 )
    ( PopStoreIndexed		130 )
    ( SendSelector1ExtByte	131 )
    ( SendSelector2ExtByte	132 )
    ( SendSuper1ExtByte		133 )
    ( SendSuper2ExtByte		134 )
    ( PopStackTop		135 )
    ( DupStackTop		136 )
    ( PushActiveContext		137 )
    ( OuterVar     		138 )
    ( Nop		     	139 )
    ( ReplaceSelf	     	140 )
    ( ReplaceOne	    	141 )
    ( ReplaceIndexed	   	142 )
    ( JumpShort			144 )
    ( PopJumpFalseShort		152 )
    ( JumpLong			160 )
    ( PopJumpTrue		168 )
    ( PopJumpFalse		172 )
    ( SendSpecial		176 )
    ( BlockCopyColonSpecial	200 )
    ( SendSelectorShort		208 )
)!


| dict |
dict := Dictionary new: VMByteCodeNames size * 2 "allow hashing to work".
VMByteCodeNames do: 
    [ :defn | dict at: (defn at: 1) put: (defn at: 2) ].
VMByteCodeNames := dict.
!

Smalltalk at: #VMOtherConstants put: 
#( (ReceiverIndex 0)
   (TrueIndex 1)
   (FalseIndex 2)
   (NilIndex 3)
   (LiteralMinusOneIndex 4)
   (LiteralZeroIndex 5)
   (LiteralOneIndex 6)
   (LiteralTwoIndex 7)

   (PushLiteral 0)
   (PushVariable 64)
   (StoreVariable 128)
   (PopStoreVariable 192)

   (ReceiverLocation 0)
   (TemporaryLocation 64)
   (LiteralConstantLocation 128)
   (LiteralVariableLocation 192)
)!

| dict |
dict := Dictionary new: VMOtherConstants size * 2 "allow hashing to work".
VMOtherConstants do: 
    [ :defn | dict at: (defn at: 1) put: (defn at: 2) ].
VMOtherConstants := dict.
!

| array dict |

array _
#(  ( +            0 )
    ( -            1 )
    ( <            2 )
    ( >            3 )
    ( <=           4 )
    ( >=           5 )
    ( =            6 )
    ( ~=           7 )
    ( *            8 )
    ( /            9 )
    ( \\          10 )
    ( bitShift:   12 )
    ( //          13 )
    ( bitAnd:     14 )
    ( bitOr:      15 )
    ( at:         16 )
    ( at:put:     17 )
    ( size        18 )
    ( next        19 )
    ( nextPut:    20 )
    ( atEnd       21 )
    ( ==          22 )
    ( class       23 )
    ( blockCopy:temporaries:  24 )
    ( value       25 )
    ( value:      26 )
    ( do:         27 )
    ( new         28 )
    ( new:        29 )
    ( isNil	  30 )
    ( notNil	  31 )
).

dict := Dictionary new: array size * 2 "allow hashing to work".
array do: 
    [ :defn | dict at: (defn at: 1) put: (defn at: 2) ].

VMOtherConstants at: #VMSpecialMethods put: dict.
!    

| array dict |
array _
#( ('self'           0)
   ('true'           1)
   ('false'          2)
   ('nil'            3)
   ('thisContext'   25)

   ('super'         -1)

   (-1               4)
   ( 0               5)
   ( 1               6)
   ( 2               7)
).

dict := Dictionary new: array size * 2. "allow hashing to work"
array do: 
    [ :defn | dict at: (defn at: 1) put: (defn at: 2) ].
VMOtherConstants at: #VMSpecialIdentifiers put: dict.
!    

VMOtherConstants at: #VMBlockSelectors put: (Array
    with: #whileTrue:
    with: #whileFalse:   ).

VMOtherConstants at: #VMLoopSelectors put: (Array
    with: #timesRepeat:
    with: #to:do:
    with: #to:by:do:     ).

VMOtherConstants at: #VMBoolSelectors put: ((Set new: 12)
    add: #ifTrue:                       ;
    add: #ifTrue:ifFalse:               ;
    add: #ifFalse:                      ;
    add: #ifFalse:ifTrue:               ;
    add: #and:                          ;
    add: #or:                           ;
    yourself)
!

