/***********************************************************************
 *
 *	Local definitions of C functions for GNU Smalltalk 
 *
 *	$Revision: 1.6.2$
 *	$Date: 1999/08/31 11:23:18$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 ***********************************************************************/

/* This is usually an automatically generated file - this version
  is here so that you can compile GST under WinNT without using the
  extra-winning Cygnus port of bash, make and other GNU tools. Running
  configure will overwrite this file substituting it with one without any
  loadable module; to recreate it use the modules script:

  		make clean	# if necessary
  		./modules blox
  		make
 */

#include "gst.h"

/* #undef USE_BLOX */		/* BLOX stuff is down in blox */
/* #undef USE_TCP */		/* TCP stuff is down in blox */

#define CFUNC(smalltalk, c)	{ extern void c(); defineCFunc(smalltalk, c); }
#define CALL(c)			{ extern void c(); c(); }

void
initUserCFuncs()
{
#ifdef USE_GDBM
  #include "gdbm/cfuncs.h"
#endif
#ifdef USE_BLOX
  #include "blox/cfuncs.h"
#endif
#ifdef USE_TCP
  #include "tcp/cfuncs.h"
#endif
}
