"======================================================================
|
|   Basic Blox tests.  Use like `Gui test: Gui labelTest!'
|
|   $Revision: 1.6.2$
|   $Date: 1999/08/31 11:23:18$
|   $Author: pb$
|
 ======================================================================"

 

"======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

!Gui class methodsFor: 'testing'!

test: block
    | win |
    Blox debug: true.

    win := BWindow new: 'test'.
    block value: win.

    win map.
    Blox dispatchEvents: win
! !

!Gui class methodsFor: 'testing single controls'!

callbackTest
    | cont dlg sure |

    ^[ :win |
        win callback: [
            cont := BTransientWindow new: 'BLOX test' in: win.
            dlg := BDialog new: cont label: 'Are you sure?'.
            dlg addButton: 'Yes' receiver: [ sure := true ] message: #value.
            dlg addButton: 'No' receiver: [ sure := false ] message: #value.
            dlg loop.
            sure
        ]   message: #value.
    ]
!

canvasTest
    | ctl |
    ^[ :win |
        ctl := BCanvas new: win.
        ctl width: 100 height: 100.
        ctl backgroundColor: 'gray35'.

        win width: 220 height: 220.
        win map.

        "p := ctl widthAbsolute @ ctl heightAbsolute. p printNl."
        self drawInCanvas: ctl width: 200 @ 200.
    ]
!

drawInCanvas: ctl width: p
    | status rect poly |
    poly := (BPolyline new: ctl)
        closed: true;
        color: 'blue';
        outlineColor: 'LemonChiffon';
        points: (self points: p coords: #((0.1 0.1) (0.5 0.2) (0.9 0.9) (0.5 0.8)));
        create.

    (BLine new: ctl)
        origin: p * 0.1 corner: p * 0.9;
        color: 'Magenta';
        cap: #round;
        width: 8;
        create.

    rect := (BRectangle new: ctl)
        origin: p * 0.45 extent: p * 0.1;
        color: 'yellow';
        outlineColor: 'Magenta';
        width: 2;
        create.

    (BSpline new: ctl)
        closed: false;
        points: (self points: p coords: 
            #((0.05 0.05) (0.05 0.05)
              (0.05 0.95) (0.95 0.95)
              (0.95 0.95) (0.95 0.05)
              (0.05 0.05) (0.05 0.05)
              (0.05 0.25) (0.05 0.25)));  "Trick to get the bevel-styled join"
        join: #bevel;			  "at the top-left corner too"
        color: 'ForestGreen';
        width: 8;
        create.

    (BArc new: ctl)
        origin: p * (0.2 @ 0.8) corner: p * (0.8 @ 1);
        outlineColor: 'gray75';
        from: p * (0.2 @ 0.9);
        to: p * (0.5 @ 0.8);
        create.

    (BArc new: ctl)
        origin: p * (0.2 @ 0) corner: p * (0.8 @ 0.2);
        outlineColor: 'gray75';
        startAngle: 270;
        endAngle: 360;
        create.

    status := 0.
    poly onMouseDoubleEvent: 1 send: #value: to: [ :pnt |
        status := status + 1.
        status = 1 ifTrue: [ poly raise ].
        status = 2 ifTrue: [ poly lower ].
        status = 3 ifTrue: [
            (BEmbeddedText new: ctl)
                color: 'Cyan';
                text: 'Smalltalk is great';
                font: 'Helvetica 12';
                center: p / 2 extent: p x @ (p y / 10);
                create.
            rect remove.
        ]
    ]
!

points: p coords: coords

    ^coords collect: [ :each |
        p * ((each at: 1) @ (each at: 2))
    ]
!

containerTest

    | ctl cont |
    ^[ :win :vertical |
        win label: vertical printString.
        cont := BContainer new: win.
        cont setVerticalLayout: vertical.
        ctl := BLabel new: cont label: 'label'.
        vertical ifFalse: [ ctl height: 50 ] ifTrue: [ ctl width: 50 ].
        ctl := BButton new: cont label: 'button'.
        vertical ifFalse: [ ctl height: 50 ] ifTrue: [ ctl width: 50 ] ]
!

dialogTest1

    | cont dlg |
    ^[ :win |
        cont := BTransientWindow new: 'transient' in: win.
        dlg := BDialog new: cont label: 'dialog test'.
        dlg addButton: 'OK' receiver: self message: #itemChosen.
        dlg addButton: 'Cancel' receiver: self message: #yourself.
        
        win map.
        dlg loop ]
!

dialogTest2

    | cont dlg |
    ^[ :win |
        cont := BTransientWindow new: 'transient' in: win.
        dlg := BDialog new: cont label: 'dialog test' prompt: 'default'.
        dlg addButton: 'OK' receiver: self message: #pickMeHarder.
        dlg addButton: 'Cancel' receiver: self message: #yourself.
        
        win map.
        dlg loop ]
!

editTest
    ^[ :win |
        BLabel new: win label: 'Enter whatever you want:'.
        (BEdit  new: win) x: 0 y:  50; width: 100; heightPixels: 20.
        win width: 200; height: win height / 2.
    ]
!

eventTest
    | event events x y key ascii mouse |
    ^[ :win |
        mouse := [ :pnt |
            x label: pnt x printString.
            y label: pnt y printString ].

        win width: 400 height: 200.
        (event := BLabel new: win label: '') x:   0 y:  0; width: 200; heightPixels: 20.
        (x := BLabel new: win label: '')     x: 200 y:  0; width:  50; heightPixels: 20.
        (y := BLabel new: win label: '')     x: 250 y:  0; width:  50; heightPixels: 20.
        (key := BLabel new: win label: '')   x: 300 y:  0; width:  50; heightPixels: 20.
        (ascii := BLabel new: win label: '') x: 350 y:  0; width:  50; heightPixels: 20.

        (BText new: win)
            yPixels: 20;
            heightOffset: -20;

            "This is a test, so to save space I'm using blocks. This is not
             good programming practice, as it leads to huge methods."
            onAsciiKeyEventSend: #value:
                to: [ :char | event label: 'key'. ascii label: (String with: char) ];

            onKeyEventSend: #value:
                to: [ :keyPressed | event label: 'ascii'. key label: keyPressed ];

            onKeyEvent: 'Return' send: #beep to: Blox;

            onMouseDownEvent: 1 send: #value:
                to: [ :pnt | mouse value: pnt. event label: 'down' ];

            onMouseMoveEvent: 1 send: #value:
                to: [ :pnt | mouse value: pnt. event label: 'move' ];

            onMouseUpEvent:   1 send: #value:
                to: [ :pnt | mouse value: pnt. event label: 'up' ];

            onMouseDoubleEvent: 1 send: #value:
                to: [ :pnt | mouse value: pnt. event label: 'double' ];

            onMouseTripleEvent: 1 send: #value:
                to: [ :pnt | mouse value: pnt. event label: 'triple' ];

            onMouseEnterEventSend: #value to: [ event label: 'enter' ];

            onMouseLeaveEventSend: #value to: [ event label: 'leave' ].
    ]
!

formTest

    | cont |
    ^[ :win |
        cont := BForm new: win.
        (BLabel new: cont label: 'label') width: 100 height: 50.
        (BButton new: cont label: 'button') y: 50; width: 100 height: 50 ]
!

formattingTest
    ^[ :win | (BText new: win)
        insertAtEnd: 'Trying edit box widgets' attribute: BTextAttributes red;
        insertAtEnd: ' strikeout ' attribute: BTextAttributes strikeout;
        insertAtEnd: ' red again ' attribute: BTextAttributes red;
        insertAtEnd: ' now cyan ' attribute: (BTextAttributes new foregroundColor: 'DarkCyan');
        insertAtEnd: ' now background ' attribute: (BTextAttributes yellow backgroundColor: 'DarkSlateBlue');
        insertAtEnd: ' font ' attribute: (BTextAttributes underline font: 'Helvetica 24')
    ]
!

textEventsTest
    | attrs bindings dlg cont text |
    ^[ :win | 
        win width: win width * 2.

        (bindings := BTextBindings new)
            onMouseEnterEventSend: #value to: [ text cursor: #hand2 ];
            onMouseLeaveEventSend: #value to: [ text cursor: #arrow ];

            onMouseUpEvent: 1 send: #value: to: [ :pnt |
                cont := BTransientWindow new: 'BLOX test' in: win.
		dlg := BDialog new: cont label: 'You clicked on me'.
		dlg addButton: 'ok' receiver: self message: #yourself.
		dlg loop ].
        
        attrs := BTextAttributes new
            underline; center; blue;
            font: 'Helvetica 18';
            events: bindings.

        (text := BText new: win)
            cursor: #arrow;
            insertAtEnd: 'Click on me!' attribute: attrs; nl;
            insertAtEnd: 'and not on me' attribute: BTextAttributes center
    ]
!

imageTest
    | image |
    ^[ :win | 
        image := BImage new: win image: self validImageFile.
        
        image onMouseMoveEvent: 1 send: #value:
            to: [ :pnt | image gamma: (0.2 max: pnt x / 100) ].

        win width: image imageWidth height: image imageHeight
    ]
!

validImageFile
    ^FileStream
        open: Directory kernel, '/../blox/bear.gif' mode: FileStream read
!

labelTest

    ^[ :win |
        win width: 400.
        (BLabel new: win label: '*** a ''ridge'' blue label ***')
            effect: #ridge;
            x: 40;
            y: 50;
            yOffset: -20;
            width: 320;
            heightPixels: 40;
            backgroundColor: 'LightSkyBlue';
            font: 'Helvetica 18'.
    ]
!

listboxTest

    ^[ :win | (BList new: win)
        xPixels: 2;
        yPixels: 2;
        width: 100 height: 100;
        widthOffset: -4;
        heightOffset: -4;
        contents: #('test 1' 'test 2' 'test 3' 'test 4' 'test 5' 'test 6') ]
!

textTest

    ^[ :win | (BText new: win)
        contents: 'Trying edit box widgets
this line is long - this line is long - this line is long - this line is long.' ]
! !

!Gui class methodsFor: 'testing prompters'!

fileDialogTest

    | text file fileName |

    ^[ :win | 
        win width: 500.
        text := (BText new: win)
            font: 'Courier 9'.

        fileName := BDialog
            chooseFileToOpen: win
            label: 'Open a file'
            default: nil
            defaultExtension: 'st'
            types: #(
               ('Smalltalk files'  '.st')
               ('Text Files'       '.txt' '.diz')
               ('C source files'   '.c' '.h')).
       
        file := FileStream open: fileName mode: 'r'
           ifFail: [ ReadStream on: '***FILE COULD NOT BE OPENED' copy ].

        text contents: file contents.
        file close
    ]
!

colorDialogTest

    | label color |
    ^[ :win |
        win width: 400.
        label := (BLabel new: win label: '*** this is gray (yet) ***')
            effect: #groove;
            x: 40;
            y: 50;
            yOffset: -20;
            width: 320;
            heightPixels: 40;
            font: 'Helvetica 18'.
        
        color := BDialog
            chooseColor: win
            label: 'Choose a color!'
            default: 'SteelBlue'.
            
        label
            label: 'but now it isn''t anymore';
            backgroundColor: color ]
! !

!Gui class methodsFor: 'testing menus'!

menuTest
    ^[ :win | self createTestMenuBar: win ]
!

createTestMenuBar: win
    | bar |
    bar := BMenuBar new: win.

    self createFirstMenu: bar.
    self createSecondMenu: bar.
!

createFirstMenu: bar
    | menu menuItem |
    menu := BMenu new: bar label: 'foo'.
    menuItem := BMenuItem new: menu label: 'a one'.

    menuItem callback: Gui message: 'itemChosen'.

    menuItem := BMenuItem new: menu label: 'and a two'.
    menuItem := BMenuItem new: menu label: 'and away'.
    menuItem := BMenuItem new: menu label: 'we go'.

    bar add: menu.
!

createSecondMenu: bar
    | menu menuItem |
    menu := BMenu new: bar label: 'bar'.

    menuItem := BMenuItem new: menu label: 'testme '.
    menuItem callback: Gui message: 'pickMeHarder'.

    menuItem := BMenuItem new: menu.
    menuItem := BMenuItem new: menu label: 'don''t try me'.
    menuItem := BMenuItem new: menu label: 'i do nothing'.
    menuItem := BMenuItem new: menu.
    menuItem := BMenuItem new: menu label: 'abc'.
    
    bar add: menu.
    menuItem label: 'cba - changed my mind'.
    menuItem := BMenuItem new: menu label: 'added on the fly'.
!

itemChosen
    'Picked me!!!' printNl.
!

pickMeHarder
    'Pick me harder' printNl.
! !

| tests |

Transcript nextPutAll: 'Available tests'; nl.
tests := OrderedCollection new.
Gui class selectors do: [ :sel |
    ('*Test*' match: sel) & sel argumentCount = 0
        ifTrue: [ tests add: sel asString ]
].
tests asSortedCollection do: [ :each |
    Transcript nextPutAll: '    '; print: each; nl
]

!
