"File View.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Gui subclass:  #View
        instanceVariableNames: 'data parentView childViews'
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!View class methodsFor: 'instance creation'!

new: aString in: view
| aView |
    aView := self new. aView parentView: view.
    ^aView
!!

!View methodsFor: 'initialize-delete'!

remove
    data := nil.
    childViews isNil ifFalse: [
        childViews do: [ :view | view remove]
    ].
    parentView := childViews := nil.
!!

!View methodsFor: 'change management'!

canChangeState
    | aCollection |
    aCollection := OrderedCollection new.
    self rootView collectPrimitives: aCollection.
    aCollection do: [ :view | (view ~~ self) ifTrue: [view canUpdate ifFalse: [^false]]].
    ^true.
!

collectPrimitives: aCollection
"Note that this test is a necessary but not a sufficient condition of a
Primitive View -- a partially created window can have a Manager which has
no children"
     childViews notNil
        ifTrue: [childViews do: [ :view | view collectPrimitives: aCollection]]
        ifFalse: [ aCollection add: self].
!

canUpdate
"Default is to return true"
    ^true
!!

!View methodsFor: 'accessing'!

data
"Return view's data object"
    ^data
!!

!View methodsFor: 'display'!

beep
"Beep once -- usually called when some user error is detected"
    Blox beep
!!

!View methodsFor: 'childViews and parentViews'!

childViews
"Return the view's collection of childViews"
    ^childViews
!

parentView
"Return view's parentView.  If view is a rootView, nil is returned "
    ^parentView
!

parentView: aView
"Set parentView to aView"
    parentView := aView
!

rootView
"Return rootView in view's hierarchy"
    parentView isNil
        ifTrue: [ ^self ].
    ^parentView rootView
!!
