"File TopLevel.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Manager subclass:  #TopLevelShell
        instanceVariableNames: 'menu menuBar'
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!TopLevelShell class methodsFor: 'instance creation'!

new: aLabel
"Initialize TopLevelShell"      
    | view |
    view := self new initialize: aLabel.
    BrowserMain shell isNil ifFalse: [BrowserMain shell data addWindow: view].
    ^view.
!!

!TopLevelShell methodsFor: 'initialize'!

initialize: aLabel
    blox := BWindow new: aLabel
!

menu
    ^menu
!

menuBar
    menuBar isNil ifTrue: [ menuBar := BMenuBar new: self blox ].
    ^menuBar
!

menu: aMenu
    menu := aMenu.
    self menuBar add: aMenu blox.
!

data: aData
"Even though this view is not properly a data view, the data view 
is associated with a TopLevelShell to support change control. When a 
user attempts to close the window, the close method which is invoked can 
communicate this to the data objects's views by sending a message to the data 
object associated with it."
    data := aData.
!!

!TopLevelShell methodsFor: 'closing'!

close
"This method is invoked from the callback which is activated when the
user closes a window.  Each view is sent an canUpdate message.  If
there is some information which has been cached and not incorporated
into the data object (modified text which has not been compiled), this
method will inform the callback by returning nil.  If the window can
be closed, the top level widget is returned.  The widget value is
needed so that the view's supporting widget hierarchy can be disposed
properly"
    self canClose
	ifTrue: [self remove. BrowserMain shell data removeWindow: self. ^true ].
    ^false.
!

canClose
    | aCollection |
    aCollection := OrderedCollection new.
    self rootView collectPrimitives: aCollection.
    aCollection do: [ :view | view canUpdate ifFalse: [^false]].
    ^true.
!!

!TopLevelShell methodsFor: 'displaying'!

display
    self blox map.
!!
