"File TextMenu.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

PopupMenu subclass:  #TextMenu
        instanceVariableNames: ''
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!TextMenu methodsFor: 'initializing'!

createMenu: view label: title using: orderedSel
    blox := BPopupMenu new: (view blox) label: title.
    orderedSel do:
        [ :pair | (pair size > 1 and: [ self localMenuItem: (pair at: 2)])  
                ifTrue: [blox addMenuItemFor: pair notifying: self ]
                ifFalse: [blox addMenuItemFor: pair notifying: data]].  
        ^self.  
!!

!TextMenu methodsFor: 'blue button menu items'!

accept
"Ask the data object whether it can be changed from the view"
        ( data changeRequestFrom: view )
"If affirmative, let the view execute the menu action associated with 
accept-menu option"
                ifTrue: [ view accept: (view blox contents) ].
!

cancel
        view cancel.
!

clear
        view blox replaceSelection: ''.
!

copy
        Blox clipboard: view blox getSelection.
!

cut
        self copy.
        self clear.
!

doIt
        | text |
        text := (view blox getSelection).
        text isNil ifTrue: [Blox beep. ^false].
        Behavior evaluate: text.
!

find
        | prompter |
        prompter := Prompter message: 'Search...' in: view.
        prompter response ~= '' 
                ifTrue: [view blox searchString: prompter response].  
!

inspect
"Open an inspector on the result of the evaluation of the selected Smalltalk expression"
        | obj text|
        text := (view blox getSelection).
        text isNil ifTrue: [Blox beep. ^false].
        obj := (Behavior  evaluate:  text ifError: [:fname :lineNo :errorString | 
                view displayErrorAtCursor: errorString. ^nil ]).
        obj inspect.
!

line
"Prompt user to enter a line number.  If a valid number, attempt
to scroll to entered line number"
        | prompter alert |
        prompter := Prompter message: 'Goto line...' in: view.
        prompter response ~= '' 
            ifTrue: [
                prompter response do: [ :ch |
                    ch isDigit ifFalse: [^Blox beep]
                ].
                ((view blox gotoLine: (prompter response asInteger) end: false) ~= 0 )
                    ifFalse: [Blox beep]
            ]. 
!

paste
    | clip |
    clip := Blox clipboard.
    clip isEmpty
        ifFalse: [view blox replaceSelection: clip].
!

printIt
"Display and select result of evaluation of selected expression to right of
selection"
        | pos text aStream |
        text := view blox getSelection.
        text isNil ifTrue: [Blox beep. ^false].
        aStream := WriteStream on: (String new: 0).
        (Behavior  evaluate:  text ifError: [:fname :lineNo :errorString | 
                errorString ]) printOn: aStream.
        view blox insertTextSelection: aStream contents.
!

close
        | tv |
        tv := view topView blox.
        view topView close ifTrue: [tv destroy].
!

undo
        'not implemented' printNl.
!!

!TextMenu methodsFor: 'performing'!

localMenuItem: selector
"If selector is implemented by TextMenu, return true"
        ^#(undo cut copy paste clear line find accept cancel doIt printIt inspect close) 
                includes: selector.
!!

!TextMenu methodsFor: 'private'!

formatCode: code
"This method is used in conjunction with the implementation of accept.  To 
force the parser to evaluate (accept) a string, an exclamation is appended to 
the string (code).  The result is returned"
        | wordArray lastToken |
    wordArray := (TokenStream on: code) contents.
        lastToken := wordArray at: wordArray size.
        ((lastToken at: lastToken size) ~= '!') ifTrue: [^(code , '!')].
        ^code.
!!
