"File Load.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

"Smalltalk blox+browser initialization script"

| verbose |

Transcript nl; nextPutAll: 'Initializing system -- be patient...'; nl.

verbose := FileStream verbose: true.

(Smalltalk includesKey: #BrowserMain)
    ifTrue: [ (Smalltalk at: #BrowserMain) close ].


"Place holders for some global objects"
#(Primitive			  Inspector
  DictionaryInspector		  StructInspector
  BrowserShell			  BrowserMain
  ClassHierarchyBrowser		  Prompter
  ModalDialog			  MethodSetBrowser)
    do: [ :each | Smalltalk at: each ifAbsentPut: [ nil ] ].

#(
"Load our dependancy system and graphics kernel"
  'blox/GuiData.st'
  'blox/View.st'
  'blox/Manager.st'
  'blox/Form.st'
  'blox/RadioForm.st'
  'blox/TopLevel.st'
  'blox/Primitive.st'
  'blox/PList.st'
  'blox/PText.st'
  'blox/PRadioBtn.st'
  'blox/Menu.st'
  'blox/ModalDialog.st'
  'blox/Prompter.st'

"View classes"
  'blox/BrowShell.st'
  'blox/BrowserMain.st'
  'blox/ClassBrow.st'
  'blox/Inspector.st'
  'blox/DictInspect.st'
  'blox/StrcInspect.st'
  'blox/MethSetBrow.st'

"Load files that support Steve's walkback inspector"
  'blox/StkInspect.st'
  'blox/CtxtInspect.st'
  'blox/ErrInspect.st'
) do: [ :file | FileStream fileIn: Directory kernel, '/../', file ].

FileStream verbose: verbose!

Collection removeSelector: #inspect ifAbsent: [ ].
SequenceableCollection removeSelector: #inspect ifAbsent: [ ]!
