
"File BrowShell.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

TopLevelShell subclass:  #BrowserShell
        instanceVariableNames: ''
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Browser'
!

!BrowserShell class methodsFor: 'browsing'!

openWorksheet: label
    ^(self
        openWorksheet: label
        withText: (String with: Character nl)) value
!

openWorksheet: label withText: startText
    "Open a worksheet window."
    | worksheet textView | 
    worksheet := self new: label.
    worksheet addChildView: ((textView := PText new: worksheet)
       menuInit: ((PopupMenu new: textView label: '') selectors: 
      #(('Cut' gstCut) ('Copy' gstCopy) ('Paste' gstPaste) 
       () ('Clear' gstClear) () ('Line...' line)  ('Find...' find) 
       () ('Do it' eval) ('Print it' evalAndPrintResult) ('Inspect' evalAndInspectResult) 
       () ('Senders' senders) ('Implementors' implementors)
       () ('Close' close))
       receiver: textView
       argument: nil);
       textMsg: #text;
       canBeDirty: false;
       yourself).

    textView blox contents: startText.

    worksheet blox x: 0.
    worksheet blox y: 75.

    worksheet blox height: 175.
    worksheet blox width: 300.
    worksheet blox map.
    ^worksheet -> textView blox
! !


!BrowserShell methodsFor: 'initialize'!

initialize: aLabel
    super initialize: aLabel.

    self menu: ((Menu new: self label: 'Smalltalk') selectors:
        #(('Worksheet' openWorksheet) ('Browser' openBrowser)
         () ('Save image' saveImage) ('Garbage collect' garbageCollect) 
         () ('Quit...' quit)) 
                                                      receiver: self
                                                      argument: nil).

    self blox callback: self message: #destroyed
!!

!BrowserShell methodsFor: 'callback messages'!

destroyed
    BrowserMain removeWindow: self.
    ^true
!

garbageCollect
    "Force a full garbage collection in order to dispose of all unreferenced 
     instances"
    Smalltalk compact
!

openWorksheet
    self class openWorksheet: 'Worksheet'
!

openBrowser
    ClassHierarchyBrowser new openOn: nil.
!

quit
"Quit Smalltalk browser"
    | exit |
    BrowserMain checkExit ifFalse: [^self beep].
    exit := false.
    ModalDialog new message: 'Save image before quitting?' in: BrowserMain shell;
        addButton: 'Yes' message: [self saveImage. exit := true];
        addButton: 'No' message: [exit := true];
        addButton: 'Cancel' message: [];
        display: BrowserMain shell.
    exit ifFalse: [^false].
    BrowserMain shell release.
    Blox terminateMainLoop.
    ^true
!

saveImage
    BrowserMain saveImage
!!
