/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: poc_macros.h,v 1.2 2001/08/18 16:16:54 henning Exp $ */

#ifndef _POC_MACROS_H_
#define _POC_MACROS_H_

#ifdef DEBUG
#include <stdio.h>
#include <ctype.h>

#define PRINT_ARRAY(b,size) {                                             \
  int z;                                                                  \
  printf("DEBUG: array %s, size %i\n  ", #b "[]", size);                  \
  for (z = 1; z < size + 1; z++) {                                        \
    printf("%02x ", b[z - 1]);                                            \
    if (!(z % 16)) printf("\n  ");                                        \
  }                                                                       \
  printf("\n");                                                           \
  for (z = 1; z < size + 1; z++) {                                        \
    if ((isgraph(b[z - 1])) || (b[z - 1] == ' ')) {                       \
       printf("%c", b[z - 1]);                                            \
    } else {                                                              \
       printf("#");                                                       \
    }                                                                     \
    if (!(z % 16)) printf("\n");                                          \
  } printf("\n");                                                         \
}
#endif


/*
 * These are taken from the PAM module (_pam_macros.h)
 */

/* Good policy to strike out passwords with some characters not just
   free the memory */

#define overwrite_buffer(x) {                                                 \
  register char *__xx__;                                                      \
  if ((__xx__=(x)))                                                           \
    while (*__xx__)                                                           \
      *__xx__++ = '\0';                                                       \
}

/*
 * Don't just free it, forget it too.
 */

#define drop_mbuffer(x) {                                                     \
  if (x) {                                                                    \
    free(x);                                                                  \
    x = NULL;                                                                 \
  }                                                                           \
}


#endif /* _POC_MACROS_H_ */
