/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 * 
 * This file is part of POC.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: misc.c,v 1.4 2001/08/18 16:13:50 henning Exp $ */

#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <config.h>

#include "cardinfo.h"
#include "poc_types.h"

/******************************************************************************
 *
 * Function    : print_err
 *
 * Description : This function is used to output error messages.
 *
 * Input       : [1] message (char)
 *               (variable input number)
 *
 * Return      : nothing is returned.
 *
 *****************************************************************************/
void 
print_err(const char * const message, ...) {
  va_list argptr;
  
  va_start(argptr, message);
  vprintf(message, argptr);
  va_end(argptr);

  fflush(stdout);  
}

/******************************************************************************
 *
 * Function    : check_buffer
 *
 * Description : This function checks whether 'buffer' contains something else
 *               than printable characters and PASSWORD/DESCRIPTION tags.
 *
 * Input       : [1] buffer (char)
 *                   Buffer which will checked.
 *               [2] data_size (u16)
 *                   Number of bytes in 'buffer'.
 *
 * Return      : 1 (buffer contains non-printable characters), 0 (ok)
 *
 *****************************************************************************/
bool
check_buffer(const char * const buffer, const u16 data_size) {
  int i;

  for (i = 0; i < data_size; i++)
    if (!isprint(buffer[i]))
      if (((u8) buffer[i] != DESCRIPTION) && ((u8)buffer[i] != PASSWORD))
	return(1); /* Non-printable character found. Or not 0x80,0x81. */
  
  return(0);
}
