/*
 * GNU POC (passwords on card) - manage passwords on smartcards
 * Copyright (C) 2001 Henning Koester <henning@crackinghacking.de>
 *
 * Please report bugs to bug-poc@gnu.org
 *
 * This file is part of POC.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: blowfish.h,v 1.3 2001/08/18 16:05:43 henning Exp $ */

#ifndef _BLOWFISH_H_
#define _BLOWFISH_H_

#include "poc_types.h"

#define blowfish_encrypt encrypt_block

#define BLOWFISH_ROUNDS 16

typedef struct {
    u32 s0[256];
    u32 s1[256];
    u32 s2[256];
    u32 s3[256];   
    u32 p[BLOWFISH_ROUNDS+2];
} BLOWFISH_context;

void  bf_setkey( BLOWFISH_context *c, u8 *key, unsigned keylen );
void encrypt_block( BLOWFISH_context *bc, u8 *outbuf, u8 *inbuf );
void blowfish_wipe( BLOWFISH_context *bc );

#endif /*_BLOWFISH_H_*/
