/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/*
 * Name          : pips/src/pipsWritePnmValue.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   pipsWritePnmValue (file, imgType, data)
 *
 *   FILE* file       IS   Stream for the image data
 *   int imgType      IS   One of the image types, recognized by pips
 *   void* data       IS   Pointer to one data value to store
 * 
 * Description   : 
 *
 *   Writes one data value from 'data' to the named stream. The used
 *   Format depends on 'imgType'
 *   It returns 0 on success and EOF on failure
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int pipsWritePnmValue (FILE *file, int imgType, char *data)

#else

pipsWritePnmValue (file, imgType, data)
    FILE *file;
    int imgType;
    char *data;

#endif
{
  switch (imgType) {
    case PipsPbmAscii :
      return (fprintf (file, "%1d ", data[0] < 127));
    case PipsPgmAscii :
      return (fprintf (file, "%3d ", data[0]));
    case PipsPpmAscii :
      return (fprintf (file, "%3d %3d %3d ",
                       data[0], data[1], data[2]));
    case PipsPbmRaw   :
      return (EOF);  /* still unsupported */
    case PipsPgmRaw   :
      return (fwrite (data, 1, 1, file));
      break;
    case PipsPpmRaw   :
      return (fwrite (data, 3, 1, file));
      break;
  } /* end switch */

  return (PipsOk);
} /* end pipsWritePnmValue */


/* end pipsWritePnmValue.c */

