/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/*
 * Name          : pips/src/pipsWritePnmHeader.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 * pipsWritePnmHeader (file, imgType, width, height)
 *   FILE *file       IS   Stream for the image data (must be open)
 *   int imgType      IS   Type of image
 *   *width  IS   The width of the image
 *   *height IS   The height of the image
 *
 * Description   : 
 *
 *   Writes a pnm header to the named stream, which must be open,
 *   leaving the file pointer at the proper position for the data.
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int pipsWritePnmHeader (FILE *file, int imgType, long width, long height)

#else

pipsWritePnmHeader (file, imgType, width, height)
    FILE *file;
    int imgType;
    long width;
    long height;

#endif
{
  int result = 0;    /* Return of fprintf, either 0 or EOF */

  result += fprintf (file,"P%1d\n", imgType);
  result += fprintf (file,"# CREATOR: pips, version %s\n", PipsVersion);
  result += fprintf (file,"%3d %3d\n", width, height);

/*
 * There is no number of colours in pbm files
 */
  if ((imgType != PipsPbmAscii) && (imgType != PipsPbmRaw))
    result += fprintf (file,"255\n");

  return ((result == 0) ? 0 : EOF);
} /* end pipsWritePnmHeader */


/* end pipsWritePnmHeader.c */

